window.game={"compiled":"{\"title\":\"The Archivist and the Revolution\",\"author\":\"Autumn Chen\",\"content\":\"\",\"scenes\":{\"prevScene\":{\"id\":\"prevScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"prevTopScene\":{\"id\":\"prevTopScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"jumpScene\":{\"id\":\"jumpScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"backSpecialScene\":{\"id\":\"backSpecialScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"returnScene\":{\"id\":\"returnScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_1.a_11\":{\"id\":\"a_1.a_11\",\"options\":[{\"id\":\"@a_1.a_12\",\"title\":\"A- was different before.\"},{\"id\":\"@a_1.call\",\"title\":\"Call A-.\"}],\"content\":{\"content\":\"A- is a doctor these days. He works for one of the corporate hospitals in the central spires. He'll probably have money, at least, although whether he would be willing to spend it on you is an open question.\",\"type\":\"paragraph\"}},\"a_2.boredom\":{\"id\":\"a_2.boredom\",\"goTo\":[{\"id\":\"a_2.lx_square\"}],\"content\":{\"content\":\"You are meeting with A- to relieve your boredom.\",\"type\":\"paragraph\"}},\"a_3.i_know\":{\"id\":\"a_3.i_know\",\"goTo\":[{\"id\":\"a_3.i_know_2\"}],\"content\":{\"content\":\"\\\"I know.\\\"\",\"type\":\"paragraph\"}},\"a_call.who_was\":{\"id\":\"a_call.who_was\",\"options\":[{\"id\":\"@a_call.answer\",\"title\":\"Answer the call.\"},{\"id\":\"@a_call.ignore_call\",\"title\":\"Ignore the call.\"}],\"content\":{\"content\":\"He was your former partner, eight years ago, and used to live as a lavernean. He, K- and you used to be the closest of friends and lovers, or something like that, until pressures in the medical field forced A- to choose between living openly as a lavernean and having a high-paying career. He chose the latter. You broke up. K- still has a grudge.\",\"type\":\"paragraph\"}},\"archives.archive_choices\":{\"id\":\"archives.archive_choices\",\"options\":[{\"id\":\"@archives.war\",\"title\":\"The War\"},{\"id\":\"@archives.city\",\"title\":\"The City\"},{\"id\":\"@archives.cataclysm\",\"title\":\"The Cataclysm\"},{\"id\":\"@archives.uprising\",\"title\":\"The Uprising\"},{\"id\":\"@archives.laverneans\",\"title\":\"The Laverneans\"},{\"id\":\"@main\",\"title\":\"Back\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"credits.game_over\":{\"id\":\"credits.game_over\",\"viewIf\":{\"$code\":\"return ((Q['started'] || 0)===1);\"},\"gameOver\":true,\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"credits\":{\"id\":\"credits\",\"type\":\"scene\",\"title\":\"Credits\",\"options\":[{\"id\":\"@one\",\"title\":\"Start game\"},{\"id\":\"@credits.game_over\",\"title\":\"End game.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-1\",\"content\":\"The Archivist and the Revolution\"},\" is the final refinement of various story ideas that have been simmering in my head for over 10 years. Like all of my stories, this is nothing more than a hodgepodge of my interests, obsessions, and neuroses.\"]},{\"type\":\"paragraph\",\"content\":\"Written by Autumn Chen.\"},{\"type\":\"paragraph\",\"content\":[\"Coded using \",{\"type\":\"magic\",\"content\":\"<a href=\\\"https://github.com/aucchen/dendry\\\">dendry</a>\"},\", originally by Ian Millington with heavy modifications from the author.\"]},{\"type\":\"paragraph\",\"content\":\"Images:\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"monitor_dithered.png\"},\": modified from https://commons.wikimedia.org/wiki/File:Belinea-monitor19crt.jpg\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"monitor_2_dithered.png\"},\": modified from https://commons.wikimedia.org/wiki/File:HP_Ultra_VGA_1280_text_mode_%E2%80%A2_3.jpg\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"monitor_3_dithered.png\"},\": modified from https://commons.wikimedia.org/wiki/File:Kfc_ck1428g_monitor_observe.jpg\"]},{\"type\":\"paragraph\",\"content\":\"All other images by the author. The backgrounds were edited from photographs using GIMP filters and dithering with ImageMagick.\"},{\"type\":\"heading\",\"content\":\"Acknowledgments\"},{\"type\":\"paragraph\",\"content\":\"Thanks to Arlo @magiciansvoyage, Jinx @lapinlunairegames, Travis Moy, and Zoe M. for their testing, discussions, and amazing feedback.\"},{\"type\":\"heading\",\"content\":\"Science\"},{\"type\":\"paragraph\",\"content\":\"There are a number of real-world papers referenced in the story from the field of DNA data storage.\"},{\"type\":\"quotation\",\"content\":\"Shipman, S., Nivala, J., Macklis, J. et al. CRISPR–Cas encoding of a digital movie into the genomes of a population of living bacteria. Nature 547, 345–349 (2017). https://doi.org/10.1038/nature23017\"},{\"type\":\"quotation\",\"content\":\"Yim, S.S., McBee, R.M., Song, A.M. et al. Robust direct digital-to-biological data storage in living cells. Nat Chem Biol 17, 246–253 (2021). https://doi.org/10.1038/s41589-020-00711-4\"},{\"type\":\"paragraph\",\"content\":\"This is a work of fiction; none of the technologies described in the story are intended to be scientifically accurate.\"},{\"type\":\"heading\",\"content\":\"Inspirations and Related Works\"},{\"type\":\"paragraph\",\"content\":\"Games:\"},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"howling dogs\"},\" by Porpentine\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"SPY INTRIGUE\"},\" by furkle\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Bee\"},\" by Emily Short\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Solarium\"},\" by Anya Johanna DeNiro\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Get Your Gun, Dragonfly\"},\" by Palimrya\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Neo Cab\"},\" by Chance Agency\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Computerfriend\"},\" by Kit Riemer\"]},{\"type\":\"paragraph\",\"content\":\"Books:\"},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Oryx and Crake\"},\" by Margaret Atwood\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Summer Fun\"},\" by Jeanne Thornton\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Little Fish\"},\" by Casey Plett\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Small Beauty\"},\" by Jia Qing Wilson Yang\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Manhunt\"},\" by Gretchen Felker-Martin\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"magic\",\"content\":\"<a href=\\\"https://bostonreview.net/articles/charlie-jane-anders-dont-press-charges-and-i-wont-sue/\\\">\\\"Don't Press Charges and I Won't Sue\\\" by Charlie Jane Anders</a>\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Web Media:\"},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Homestuck\"},\" by Andrew Hussie\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"magic\",\"content\":\"<a href=\\\"https://archiveofourown.org/works/33158965/chapters/82319554\\\"><i>Glow, Worm</i> by alysongreaves</a>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Music: The unofficial soundtrack is \",{\"type\":\"magic\",\"content\":\"<a href=\\\"https://open.spotify.com/playlist/4X9RQqkMnikpfSzG4Cxq3i\\\">here</a>\"},\".\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Mydata\"},\" and others by Katie Dey\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"Transangelic Exodus\"},\" and others by Ezra Furman\"]}]},\"dreams.dream_1\":{\"id\":\"dreams.dream_1\",\"options\":[{\"id\":\"@main\",\"title\":\"Wake up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"This is a dream. Or perhaps it is a memory.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"You are living in a faraway land, in a far away time. Instead of the metal ceiling there is a hazy sky. Instead of the macroalgal trees there are genuine plants, photosynthesizing under a non-simulated sun.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"You are younger, no more than 20. Your body feels familiar, with all the same proportions. Except you walk with the confidence that you are beautiful.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"A person walks to you.\"}}]},\"ending_alone\":{\"id\":\"ending_alone\",\"type\":\"scene\",\"title\":\"End\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_6\",\"content\":[{\"type\":\"paragraph\",\"content\":\"So you are alone once more.\"},{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 6/9\"}}]},\"ending_hospital.still_job\":{\"id\":\"ending_hospital.still_job\",\"goTo\":[{\"id\":\"ending_hospital.archives_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Can I keep my job?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes. Of course you can keep your job.\\\" She sighs. \\\"I'll try to find you something more permanent and less subject to scrutiny.\\\"\"}]},\"ending_k.no_love\":{\"id\":\"ending_k.no_love\",\"goTo\":[{\"id\":\"ending_k.power_of\"}],\"content\":{\"content\":\"\\\"No, I don't, in fact.\\\"\",\"type\":\"paragraph\"}},\"endings\":{\"id\":\"endings\",\"type\":\"scene\",\"title\":\"End.\",\"options\":[{\"id\":\"@credits\",\"title\":\"Credits and inspirations\"},{\"id\":\"@credits.game_over\",\"title\":\"End game.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"eviction.homeless\":{\"id\":\"eviction.homeless\",\"options\":[{\"id\":\"@eviction.find_a\",\"title\":\"Visit A-.\"},{\"id\":\"@eviction.find_k\",\"title\":\"Visit K-.\"},{\"id\":\"@eviction.find_maa\",\"title\":\"Visit the Mutual Aid Alliance.\"},{\"id\":\"@eviction.liana\",\"title\":\"Liana Xu will save you.\"},{\"id\":\"@eviction.fuck\",\"title\":\"There is nothing you can do.\"}],\"content\":{\"content\":\"You are homeless now, or something like that. You have no phone, and no money to pay for phone call. The one saving grace is that your transit pass remains active.\",\"type\":\"paragraph\"}},\"food.food_options\":{\"id\":\"food.food_options\",\"options\":[{\"id\":\"@food.takeout\",\"title\":\"Purchase some cooked food.\"},{\"id\":\"@food.cook\",\"title\":\"Buy ingredients for cooking and make your own meals.\"},{\"id\":\"@food.scrounge\",\"title\":\"Scrounge for snacks, leftovers, and so on.\"},{\"id\":\"@food.cook_new\",\"title\":\"Cook with the ingredients you have.\"},{\"id\":\"@food.starve\",\"title\":\"Starve.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"illness.tea\":{\"id\":\"illness.tea\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You are still well enough to make a cup of green tea. The warmth fills your body. The taste is pleasantly bitter. You feel less ill, at least for a while.\"},{\"type\":\"paragraph\",\"content\":\"But it will return. It always returns.\"}]},\"illness_2.death\":{\"id\":\"illness_2.death\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"(CW: death, suicidal ideation)\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['cw_enabled'] || 0)) !== 0);\"}}]},\"maxVisits\":1,\"options\":[{\"id\":\"@illness_2.liana\",\"title\":\"What would Liana Xu do?\"},{\"id\":\"@illness_2.pills\",\"title\":\"Take medicine.\"},{\"id\":\"@illness_2.rice\",\"title\":\"Drink rice porridge.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"For a moment you realize that you are terrified of death. You imagine the concept of oblivion, of nonexistence, of the fact that one day you will \",{\"type\":\"emphasis-1\",\"content\":\"no longer be\"},\", that there exists an entire universe and future that will continue without you, that you will never encounter. You remember your friends dying; some of them sought comfort in the idea of an \",{\"type\":\"emphasis-1\",\"content\":\"ending\"},\". You do not. Or rather, the desire to end the suffering fought against the terror of nonexistence, and the terror has always won.\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"K- believed (believes?) in God, and in some kind of life after death. Does she experience the same terror?\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['k_path'] || 0) > 0);\"}}]},\"countVisitsMax\":1},\"introspect\":{\"id\":\"introspect\",\"type\":\"scene\",\"title\":\"Introspect\",\"subtitle\":\"Thinking has never helped before, but maybe now is different.\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_1.past\":{\"id\":\"k_1.past\",\"maxVisits\":1,\"countVisitsMax\":1,\"options\":[{\"id\":\"@k_1.child\",\"title\":\"You and K- had a child, once.\"},{\"id\":\"@k_1.call\",\"title\":\"Make the call.\"}],\"content\":{\"content\":\"Back when it was still legal, you and K- were married. That was six years ago. She was your first love, or something like that. After A- left, it was just the two of you. It was an interesting era.\",\"type\":\"paragraph\"}},\"k_2.year\":{\"id\":\"k_2.year\",\"subtitle\":\"You saw her on a trolley.\",\"goTo\":[{\"id\":\"k_2.anyway\"}],\"content\":{\"content\":\"It was over a year ago when you last physically saw her. The Archives are physically located in the university district, not so far from K-'s labs, and you were heading there for a meeting. You almost did not recognize her, and she either didn't recognize you or pretended not to.\",\"type\":\"paragraph\"}},\"k_bad.didnt_want\":{\"id\":\"k_bad.didnt_want\",\"onArrival\":[{\"$code\":\"Q['k_path'] = -1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, but, I don't think I can do this...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"Well, whatever. S- is fine by himself. I was thinking, just maybe... nevermind.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She hangs up.\"}]},\"k_call.who_is\":{\"id\":\"k_call.who_is\",\"options\":[{\"id\":\"@k_call.answer\",\"title\":\"Answer the call.\"},{\"id\":\"@k_call.ignore\",\"title\":\"Ignore the call.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Back when it was still legal, you and K- were married. That was six years ago. She was your first love, or something like that.\"},{\"type\":\"paragraph\",\"content\":\"Back when it was still legal, you and K- had a child. It was for his safety that you and K- had separated. That was what you told yourself.\"},{\"type\":\"paragraph\",\"content\":\"Today she works as a scientist in one of the government labs, and lives with S-, her (and your?) child.\"}]},\"k_generic.k_s\":{\"id\":\"k_generic.k_s\",\"title\":\"K- has another late-night experiment...\",\"maxVisits\":1,\"tags\":[\"k_generic\"],\"options\":[{\"id\":\"@k_generic.of_course_go\",\"title\":\"Of course, you go there to see S-.\"}],\"content\":{\"content\":\"K- has another late-night experiment tonight. She asks if you can stay at her apartment tonight until she returns, to help cook and take care of S-.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"main.end_of_day\":{\"id\":\"main.end_of_day\",\"title\":\"You're too tired to do anything else.\",\"viewIf\":{\"$code\":\"return (((((((Q['day_major'] || 0) >= 1) || ((Q['day_minor'] || 0) >= 1)) || ((Q['stress'] || 0) > 10)) || ((Q['loneliness'] || 0) > 10))) && (((Q['stress'] || 0) < (Q['stress_threshold'] || 0))));\"},\"onArrival\":[{\"$code\":\"Q['day'] = (Q['day'] || 0) + 1;\\nQ['rent_due'] = (Q['rent_due'] || 0) - 1;\\nQ['food'] = (Q['food'] || 0) - 1;\\nQ['medicine'] = (Q['medicine'] || 0) - 1;\\nQ['got_food_today'] = 0;\\nQ['got_medicine_today'] = 0;\\nQ['went_out_today'] = 0;\\nQ['day_entertainment'] = 0;\\nQ['daily_k'] = 0;\\nQ['daily_a'] = 0;\"}],\"goTo\":[{\"id\":\"main.eod_check\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"medicine.med_options\":{\"id\":\"medicine.med_options\",\"options\":[{\"id\":\"@medicine.buy\",\"title\":\"Refill at the pharmacy.\"},{\"id\":\"@medicine.ask_k\",\"title\":\"Ask K-.\"},{\"id\":\"@medicine.ask_a\",\"title\":\"Ask A-.\"},{\"id\":\"@medicine.none\",\"title\":\"Go without.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"mutual_aid.checklist\":{\"id\":\"mutual_aid.checklist\",\"options\":[{\"id\":\"@mutual_aid.mask\",\"title\":\"Mask.\"},{\"id\":\"@mutual_aid.clothes\",\"title\":\"Attire.\"},{\"id\":\"@mutual_aid.voice\",\"title\":\"Voice.\"},{\"id\":\"@mutual_aid.just_go\",\"title\":\"Just go.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"mutual_aid_2\":{\"id\":\"mutual_aid_2\",\"type\":\"scene\",\"title\":\"Mutual Aid\",\"subtitle\":\"A regular visit\",\"viewIf\":{\"$code\":\"return (((((Q['mutual_aid_seen'] || 0) >= 1) && ((((Q['day'] || 0)===10) || ((Q['day'] || 0)===17)))) && (((Q['stress'] || 0) < (Q['stress_threshold'] || 0)))) && ((Q['day_minor'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['food'] = (Q['food'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\\nQ['mutual_aid_seen'] = (Q['mutual_aid_seen'] || 0) + 1;\"}],\"tags\":[\"minor\"],\"frequency\":400,\"newPage\":true,\"setBg\":\"images/city_dithered.png\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"You visit the Mutual Aid Alliance's food distribution area at the park. You get free food. R- and L- are here, and you make a brief conversation. It is a productive use of your time, more so than usual.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"You talk to R- and L- about how you might help the Alliance. They tell you that they still do not have anything for you to do, but they give you more information on the Alliance's activities, and how to contact them.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['support_mutual_aid'] || 0) > 0);\"}}]}},\"notes.notes_main\":{\"id\":\"notes.notes_main\",\"title\":\"Other notes\",\"options\":[{\"id\":\"@notes.people\"},{\"id\":\"@notes.history\"},{\"id\":\"@main\",\"title\":\"Do something else.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"one.watch\":{\"id\":\"one.watch\",\"maxVisits\":1,\"options\":[{\"id\":\"@one.listen\",\"title\":\"Listen.\"},{\"id\":\"@one.remember\",\"title\":\"Remember.\"}],\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"The light outside the window was bright and artificial, emanating from a poor simulacrum of the sun hanging on the metal ceiling above. Rows of green and violet macroalgal trees emulated an ancient streetscape, the scene completed by the humans walking by. It was the equivalent of midday in the city without a sun.\"}},\"countVisitsMax\":1},\"online_montage.cn\":{\"id\":\"online_montage.cn\",\"title\":\"CityNet\",\"subtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"An update on the present situation. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"A form of self-harm. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"CW: slurs\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['montage_progress'] || 0) <= 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['montage_progress'] || 0) > 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]},\"maxChoices\":3,\"viewIf\":{\"$code\":\"return (((((Q['day_minor'] || 0)===0) && ((Q['montage_progress'] || 0) > 0)) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['montage_progress'] = (Q['montage_progress'] || 0) + 1;\\nQ['numb'] = 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\"}],\"tags\":[\"minor\"],\"newPage\":true,\"options\":[{\"id\":\"#montage\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"What are the headlines of the day? \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"CityNet has been painful to read ever since the anti-echo-chamber policies following the Uprising blocked the use of filtering systems or private groups. It has only become worse, although for some reason you still feel compelled to read. A compulsion, or a habit.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['montage_progress'] || 0) <= 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['montage_progress'] || 0) > 3);\"}}]}},\"postgame_credits\":{\"id\":\"postgame_credits\",\"type\":\"scene\",\"title\":\"Post-game notes\",\"viewIf\":{\"$code\":\"return ((Q['started'] || 0)===1);\"},\"content\":[{\"type\":\"heading\",\"content\":\"Endings\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Completed Endings:\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Unreached Endings:\"}}]},\"recollections\":{\"id\":\"recollections\",\"type\":\"scene\",\"title\":\"Recollections\",\"subtitle\":\"An assemblage of memories.\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ritual.even_death\":{\"id\":\"ritual.even_death\",\"options\":[{\"id\":\"@ritual.graveyard\",\"title\":\"The graveyard is a poor use of land for a city as cramped as this.\"},{\"id\":\"@ritual.scratch\",\"title\":\"Scratch at the gravestone some more.\"},{\"id\":\"@ritual.bowl\",\"title\":\"Put the paper into the metal bowl.\"}],\"content\":{\"content\":\"You are in front of Lily's gravestone, a small brown brick in a field of gray lichen. The name carved on the stone is illegible from years of scratches. Above the scratches, deepening grooves mark her real name.\",\"type\":\"paragraph\"}},\"anxiety.not_just\":{\"id\":\"anxiety.not_just\",\"options\":[{\"id\":\"@anxiety.pathetic\",\"title\":\"You are fucking pathetic.\"},{\"id\":\"@anxiety.shouldnt\",\"title\":\"You should not even be alive.\"},{\"id\":\"@anxiety.so_tired\",\"title\":\"You cannot think.\"},{\"id\":\"@anxiety.call_for_help\",\"title\":\"Call for help.\"}],\"content\":{\"content\":\"You are laying on your side, in the bed. Your body aches, but you cannot move. Your eyes close and open, close and open. You are hungry and your head throbs with every beat of your slowly-failing heart. The world feels dark.\",\"type\":\"paragraph\"}},\"data.view_0\":{\"id\":\"data.view_0\",\"title\":\"DNA data recovery\",\"subtitle\":\"Your paid job.\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['data_seen'] = (Q['data_seen'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\\nQ['day_data_seen'] = 0;\\nQ['data_day'] = (Q['day'] || 0);\"}],\"viewIf\":{\"$code\":\"return ((((((Q['day_major'] || 0)===0) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['data_seen'] || 0)===0)) && ((Q['day'] || 0) < 20)) && ((Q['has_contract'] || 0)===1));\"},\"maxChoices\":5,\"tags\":[\"major\"],\"frequency\":500,\"setBg\":\"images/monitor_3_dithered.png\",\"options\":[{\"id\":\"#data\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"In the middle of the 21st century, when many believed (accurately) that civilization's collapse was imminent, a group of scientists undertook a mission to preserve human knowledge. They transcribed what they considered as the most important pieces of human knowledge into DNA, and transfected the DNA into specially engineered strains of E. coli and other bacteria. These strains were designed to outcompete existing bacterial populations, and to replicate and preserve the data-storage DNA plasmids with minimal mutations. The scientists then released their creations into the wild, via probiotic supplements among other means.\"},{\"type\":\"paragraph\",\"content\":\"Today, it is estimated that 10% of E. coli populations in still-populated areas are used for DNA storage, as the technology was used repeatedly over the years, discovered and lost and discovered again.\"},{\"type\":\"paragraph\",\"content\":\"Your job as DNA Data Archivist is to take the sequenced DNA datasets, the strings of A, T, G, and C, and turn them into human-readable information. You're pretty good at this, although it didn't stop the casualization of your employment.\"},{\"type\":\"paragraph\",\"content\":\"The computer turns on, and the CRT monitor flickers to life. You open your e-mail. There are new data recovery and archival requests.\"},{\"type\":\"paragraph\",\"content\":\"There is also a message from C-, your coworker-turned supervisor.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Hi Em,\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Sorry about the job title change. You're still a valuable contributor to our team, although your output has slid recently. We believe that a more flexible position will be better for both your interests and ours. You don't have to work yourself beyond your physical or mental means. Just do what you can.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Best, C-.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The datasets available to an archivist contractor are randomly selected from a pool of available undecoded datasets, their priorities determined by some obscure and opaque algorithm.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['data_seen'] || 0)===1);\"}}]}},\"ending_a.a_rom\":{\"id\":\"ending_a.a_rom\",\"options\":[{\"id\":\"@ending_a.dont_leave\",\"title\":\"\\\"Don't leave your wife for me...\\\"\"},{\"id\":\"@ending_a.family\",\"title\":\"\\\"I don't want to break up your family....\\\"\"},{\"id\":\"@ending_a.where_run_away\",\"title\":\"\\\"Where would we run away?\\\"\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I was thinking... Maybe we could start a new life.\\\"\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"She moves closer to you on the bench, and holds your hand in hers. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"She sits on the bed next to you, and holds your hand in hers. \",\"predicate\":1},\" \\\"Maybe we could just run away from all of this.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['evicted'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['evicted'] || 0)===0);\"}}]}},\"ending_liana.drink\":{\"id\":\"ending_liana.drink\",\"options\":[{\"id\":\"@ending_liana.liana_1\",\"title\":\"You?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You drink.\"},{\"type\":\"paragraph\",\"content\":\"Instantly, you feel different. Better. You are not so tired any more.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. This place has certainly gotten worse since I was last here.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You do not recognize her at first. She does not look like the statues or the portraits, or even the tiny distorted image you found in the Archives. Instead she looks like...\"}]},\"k_4.go_there\":{\"id\":\"k_4.go_there\",\"options\":[{\"id\":\"@k_4.you_okay\",\"title\":\"\\\"Are you okay?\\\"\"},{\"id\":\"@k_4.water\",\"title\":\"Give her some water or something.\"},{\"id\":\"@k_4.tea\",\"title\":\"Make tea.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Okay, I'll be there.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You rush to K-'s apartment, as fast as you can, which is still 30 minutes by trolley. You climb up the stairs to her second floor apartment. S- opens the door.\"},{\"type\":\"paragraph\",\"content\":\"K- sits catatonic in front of the TV. Her eyes are open. She is muttering to herself, unintelligible words.\"}]},\"root.start\":{\"id\":\"root.start\",\"options\":[{\"id\":\"@one\",\"title\":\"Start game\"},{\"id\":\"@credits\",\"title\":\"Credits and inspirations\"},{\"id\":\"@root.enable_cw\",\"title\":\"Enable content warnings.\"},{\"id\":\"@root.disable_cw\",\"title\":\"Disable content warnings.\"}],\"content\":{\"type\":\"heading\",\"content\":\"The Archivist and the Revolution\"}},\"s_1.no_idea\":{\"id\":\"s_1.no_idea\",\"options\":[{\"id\":\"@s_1.not_parent\",\"title\":\"You are not cut out to be a parent.\"},{\"id\":\"@s_1.one_night\",\"title\":\"It is just for one night.\"},{\"id\":\"@s_1.maybe_fine\",\"title\":\"Maybe... maybe it will turn out fine.\"}],\"content\":{\"content\":\"Half-forgotten memories of his first few years float through your mind. But those years were nothing like now. He is older. He is conscious and can think and can judge and will remember all the ways in which you have failed and will fail him.\",\"type\":\"paragraph\"}},\"status.old\":{\"id\":\"status.old\",\"options\":[{\"id\":\"@backSpecialScene\",\"title\":\"Back\"}],\"content\":{\"content\":\"The Archivist is watching and listening.\",\"type\":\"paragraph\"}},\"a_generic.a_good\":{\"id\":\"a_generic.a_good\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['a_path'] = (Q['a_path'] || 0) + 1;\"}],\"options\":[{\"id\":\"@a_generic.is_date\",\"title\":\"This could be a date.\"},{\"id\":\"@a_generic.what_is\",\"title\":\"You have no idea what this is.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You make the call. A- answers, and says in somewhat coded language (she must not be alone) that she can give you the money if you meet in person. And you meet, at the same isolated corner of the park by the frozen river.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I just wanted to see you,\\\" she says. You hold hands and walk and let your bodies touch, as if this were a date.\"}]},\"k_3.wait_for_k\":{\"id\":\"k_3.wait_for_k\",\"options\":[{\"id\":\"@k_3.sure_meet\",\"title\":\"\\\"Sure, let's meet.\\\"\"},{\"id\":\"@k_3.no_meet\",\"title\":\"\\\"Sorry, I'm busy...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"S- has school today,\\\" she says. \\\"I don't have work in the day. Mind if I come back here afterwards? We still haven't caught up.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Meanwhile S- has slid off the bed, and has gone to the bathroom.\"}]},\"entertainment.game_1\":{\"id\":\"entertainment.game_1\",\"content\":{\"content\":\"You play a relatively recent game (from the current century). It is a text-based management game about surviving the Wilderness as a small Wanderer group, dealing with food, nanoplagues, and the like.\",\"type\":\"paragraph\"}},\"a_1.a_12\":{\"id\":\"a_1.a_12\",\"options\":[{\"id\":\"@a_1.a_13\",\"title\":\"The two of you were...\"},{\"id\":\"@a_1.call\",\"title\":\"Call A-.\"}],\"content\":{\"content\":\"A- was... someone different before. At one time, she was a lavernean like you, until the waves of anti-nonbinary purges hit the medical field. He could not part with his job and his relative life of normalcy, so he crossed back over. Maybe it was a surrender, or maybe it was a survival strategy. Either way, his path was not an option available to you.\",\"type\":\"paragraph\"}},\"a_2.repayment\":{\"id\":\"a_2.repayment\",\"goTo\":[{\"id\":\"a_2.lx_square\"}],\"content\":{\"content\":\"You are meeting with A- out of a sense of obligation.\",\"type\":\"paragraph\"}},\"a_3.of_course\":{\"id\":\"a_3.of_course\",\"goTo\":[{\"id\":\"a_3.i_know_2\"}],\"content\":{\"content\":\"\\\"Of course I know.\\\"\",\"type\":\"paragraph\"}},\"a_call.ignore_call\":{\"id\":\"a_call.ignore_call\",\"options\":[{\"id\":\"@main\",\"title\":\"Ignore for real.\"},{\"id\":\"@a_call.answer\",\"title\":\"Answer it.\"}],\"content\":{\"content\":\"Are you sure you wish to ignore the call?\",\"type\":\"paragraph\"}},\"archives.war\":{\"id\":\"archives.war\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"dreams.dream_2\":{\"id\":\"dreams.dream_2\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_hospital.not_your_fault\":{\"id\":\"ending_hospital.not_your_fault\",\"goTo\":[{\"id\":\"ending_hospital.archives_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's not your fault.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"It kind of is. I should've known how sick you really were.\\\"\"}]},\"ending_k.love_bad\":{\"id\":\"ending_k.love_bad\",\"goTo\":[{\"id\":\"ending_k.power_of\"}],\"content\":{\"content\":\"\\\"Love doesn't stand a chance against the police state.\\\"\",\"type\":\"paragraph\"}},\"eviction.find_a\":{\"id\":\"eviction.find_a\",\"viewIf\":{\"$code\":\"return ((Q['a_path'] || 0) >= 3);\"},\"options\":[{\"id\":\"@eviction.you_want_to_die\",\"title\":\"You want to die.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"A- is most likely at work right now. So you wait until night in the park before traveling to her Central District apartment. You do not fit in here. It is only due to your luck that no one called security.\"},{\"type\":\"paragraph\",\"content\":\"It is her wife who opens the door.\"}]},\"food.takeout\":{\"id\":\"food.takeout\",\"subtitle\":{\"content\":[\"$\",{\"type\":\"insert\",\"insert\":0},\"-\",{\"type\":\"insert\",\"insert\":1},\", lasts 1-4 days.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return ((Q['takeout_cost'] || 0) - 5);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return ((Q['takeout_cost'] || 0) + 20);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['stress'] || 0) <= ((5 * (Q['stress_threshold'] || 0)) / 6));\"},\"viewIf\":{\"$code\":\"return ((Q['money'] || 0) >= ((Q['takeout_cost'] || 0) + 20));\"},\"unavailableSubtitle\":\"You don't have the energy for this.\",\"options\":[{\"id\":\"@food.takeout_2\",\"title\":\"Do it.\"},{\"id\":\"@food.food_options\",\"title\":\"Do something else.\"}],\"content\":{\"content\":\"Buying takeout was your preferred option, back when you had a job. The downside is the cost, and that you could be seen. The upside is lower energy expenditures.\",\"type\":\"paragraph\"}},\"illness.water\":{\"id\":\"illness.water\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You drink some lukewarm water, and it makes you feel less ill, at least for a while.\"},{\"type\":\"paragraph\",\"content\":\"But it will return. It always returns.\"}]},\"illness_2.liana\":{\"id\":\"illness_2.liana\",\"viewIf\":{\"$code\":\"return ((Q['l_seen'] || 0) >= 2);\"},\"maxVisits\":1,\"options\":[{\"id\":\"@illness_2.pills\",\"title\":\"She would tell you to take some medicine.\"},{\"id\":\"@illness_2.rice\",\"title\":\"She would tell you to drink some rice porridge.\"},{\"id\":\"@illness_2.power\",\"title\":\"She would tell you that your mind is strong enough to push you through this.\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"Liana Xu was, if the diaries are not in fact a hoax, \",{\"type\":\"emphasis-1\",\"content\":\"like you\"},\". Did the lavernean-equivalents of her era also experience the illness, or other illnesses? Did early posthumans have non-biomedical methods to treat chronic illnesses, for times when modern medicine was out of reach? Or would they simply invent new medicines? What did she eat? What did she drink? The diaries give few clues to these very basic facts.\"]},\"countVisitsMax\":1},\"k_1.child\":{\"id\":\"k_1.child\",\"viewIf\":{\"$code\":\"return ((state.visits['k_1.past'] || 0)===1);\"},\"maxVisits\":1,\"countVisitsMax\":1,\"options\":[{\"id\":\"@k_1.call\",\"title\":\"Make the call.\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"Back when it was still legal, you and K- had a child, back before the Ruling Party labeled women like you (\",{\"type\":\"emphasis-1\",\"content\":\"they did not call you women or even laverneans\"},\") as a danger to women and children. S- is seven years old now. It was for his safety that you and K- had separated. That was what you told yourself.\"]}},\"k_2.months\":{\"id\":\"k_2.months\",\"subtitle\":\"She called you about a professional problem.\",\"goTo\":[{\"id\":\"k_2.anyway\"}],\"content\":{\"content\":\"The last conversation between the two of you was purely professional. She asked about using the Archives' DNA sequencer; the one in her lab was broken. You connected her to C-, your coworker (now supervisor), and that was the end. She didn't say anything about herself, and you didn't ask.\",\"type\":\"paragraph\"}},\"k_bad.sorry_my_bad\":{\"id\":\"k_bad.sorry_my_bad\",\"viewIf\":{\"$code\":\"return ((Q['k_bad'] || 0) < 2);\"},\"onArrival\":[{\"$code\":\"Q['k_day'] = ((Q['day'] || 0) - 1);\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, my bad. Can we meet tomorrow? Or another day?\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"Fine. Do you want to take care of S- tomorrow night?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Great! I'll see you then...\\\"\"}]},\"k_call.ignore\":{\"id\":\"k_call.ignore\",\"options\":[{\"id\":\"@k_call.answer\",\"title\":\"Answer it.\"},{\"id\":\"@k_call.ignore_2\",\"title\":\"Ignore it.\"}],\"content\":{\"content\":\"Are you sure you wish to ignore the call?\",\"type\":\"paragraph\"}},\"k_generic.of_course_go\":{\"id\":\"k_generic.of_course_go\",\"options\":[{\"id\":\"@k_generic.sure_80\",\"title\":\"\\\"Thank you.\\\"\"},{\"id\":\"@k_generic.keep_money\",\"title\":\"\\\"Keep the money.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Of course, you go there to see S-. He seems to be happy to see you (or is he just pretending for your or K-'s benefit?). He hugs you with a broad smile on his face.\"},{\"type\":\"paragraph\",\"content\":\"You make the usual rice and beans porridge. For some reason, it is easier to cook for others than it is to cook for yourself. You draw upon reserves of energy you never knew you had. As before, S- says he wants burgers, but K- told you to not indulge him this time. He grumbles a little, but seems happy to eat.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, I can pay you,\\\" says K-, after she returns. \\\"Is $80 okay?\\\"\"}]},\"main.eod_check\":{\"id\":\"main.eod_check\",\"onArrival\":[{\"$code\":\"if (Q.day_major > 1) {\\n    Q.stress += 1;\\n}\\nQ.day_major = 0;\\nQ.day_minor = 0;\\nQ.numb = 0;\\nfor (var i = 0; i < 21; i++) {\\n    Q['name_' + i] = window.randomName();\\n}\\nconsole.log('eod_check_2');\\nQ.main_notes = ' ';\\nif (Q.rent == 0) {\\n    Q.main_notes += '<p>Rent is due today. It will be automatically be deducted from your account at the end of the day.</p>';\\n}\\nif (Q.k_path == 1 && Q.day == Q.k_day + 2) {\\n    Q.main_notes += '<p>You promised K- that you would meet her today.</p>';\\n}\\nif ((Q.day == 3 || Q.day == 10 || Q.day == 17) && !Q.mutual_aid_seen) {\\n    Q.main_notes += '<p>You see a flyer that has been slid under your door. \\\"Mutual Aid Alliance hosting free community meals weekly at Moses Park.\\\" Below is a black-and-white picture of figures serving soup, and a time and an address. It is not too late. You can still go.</p>';\\n}\\n// if you haven't viewed DNA in a few days, C- sends you a message.\\nif (Q.day == Q.data_day + 3) {\\n    Q.main_notes += \\\"<p>You receive a message from C-, your supervisor at the Archives: <code>Hey Em, I hope you realize that you still need to do your job. I understand you're suffering from chronic fatigue, but so are many of us, and we're still working. Just one DNA dataset every few days. That's all you need. Worst case, we'll have no choice but to decertify you. But it probably won't come to that, would it?</code></p>\\\";\\n}\\nif (Q.day == Q.data_day + 5) {\\n    Q.main_notes += \\\"<p>You receive a message from C-, your supervisor: <code>Hey Em, there are some things you should know. We pulled a lot of stops to let you just keep this job as a contractor. When your output is low, your profile gets more scrutiny. When your profile gets scrutiny, they discover the discrepancies in your record. And when those discrepancies are discovered... well, you know the rest. I sincerely hope it doesn't come to that.</code></p>\\\";\\n}\\nif (Q.day == Q.data_day + 8) {\\n    Q.main_notes += \\\"<p>You receive a message from C-, your supervisor: <code>Hey Em, they've started checking your personal files. I'm really sorry to say this, but your contract has been terminated. I've tried to stop them from looking too deeply, and I don't know if it worked. Be careful, Em. There's not much I can do, but I wish you all the best.</code></p> <p>Well then. You no longer have any sort of employment, not even as a contractor. And you are likely unemployable for obvious reasons. Life is great.</p>\\\";\\n    Q.has_contract = 0;\\n}\\n// TODO: Also, C- sends you a message if you have yet to see Liana's files.\\n// set daily dialogue here.\\nif (Q.stress <= Q.stress_threshold/2) {\\n    // nonrandom lol\\n    Q.day_random += 1;\\n    if (Q.day >= Q.low_anxiety_day_dialogues.length) {\\n        Q.day_random = Math.floor(Math.random()*Q.low_anxiety_day_dialogues.length);\\n    }\\n    Q.day_dialogue = Q.low_anxiety_day_dialogues[Q.day_random];\\n} else if (Q.stress <= Q.stress_threshold - 4) {\\n    Q.day_random = Math.floor(Math.random()*Q.day_dialogues.length);\\n    Q.day_dialogue = Q.day_dialogues[Q.day_random];\\n} else {\\n    Q.day_random = Math.floor(Math.random()*Q.high_stress_day_dialogues.length);\\n    Q.day_dialogue = Q.high_stress_day_dialogues[Q.day_random];\\n}\\nQ.afternoon_random = Math.floor(Math.random()*Q.afternoon_dialogues.length);\\nQ.afternoon_dialogue = Q.afternoon_dialogues[Q.afternoon_random];\\n// TODO: Rubberbanding ???\\nif (Q.day <6 && Q.stress > 10) {\\n}\\nif (Q.day >10 && Q.stress < 10) {\\n}\\n\\n// set goto scene\\nif (Q.day >= 20) {\\n    Q.next_day_scene_queue.push(\\\"anxiety\\\");\\n}\\nif (Q.with_s == 1) {\\n    console.log('with s');\\n    Q.next_day_scene_queue.push(\\\"k_3\\\");\\n}\\nif (Q.food <= 0) {\\n    console.log('food missing');\\n    Q.next_day_scene_queue.push(\\\"food\\\");\\n}\\nif (Q.rent_due <= 0) {\\n    console.log('rent missing');\\n    Q.next_day_scene_queue.push(\\\"main.rent_collection\\\");\\n}\\nif (Q.medicine <= 0) {\\n    console.log('medicine missing');\\n    Q.next_day_scene_queue.push(\\\"medicine\\\");\\n}\\nif (Q.k_path == 1 && Q.day > Q.k_day + 2) {\\n    Q.next_day_scene_queue.push(\\\"k_bad\\\");\\n}\\nif (Q.next_day_scene_queue.length > 0) {\\n    Q.next_day_scene = Q.next_day_scene_queue.shift();\\n    console.log('next day scene: ' + Q.next_day_scene);\\n} else {\\n    Q.next_day_scene = \\\"main\\\";\\n}\\nconsole.log('eod_check_end');\"}],\"setBg\":\"black\",\"goToRef\":[{\"id\":\"next_day_scene\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"medicine.buy\":{\"id\":\"medicine.buy\",\"subtitle\":\"$50, lasts 7 days\",\"chooseIf\":{\"$code\":\"return ((Q['stress'] || 0) <= ((Q['stress_threshold'] || 0) - 5));\"},\"viewIf\":{\"$code\":\"return ((Q['money'] || 0) >= 50);\"},\"unavailableSubtitle\":\"You don't have the energy for this.\",\"onArrival\":[{\"$code\":\"Q.post_trolley = window.randomSelect(['medicine.pharmacy_1', 'medicine.pharmacy_2']);\"}],\"maxChoices\":1,\"options\":[{\"id\":\"#trolley\"}],\"content\":{\"content\":\"All it takes is a visit to the pharmacy, a 20-minute trolley ride away.\",\"type\":\"paragraph\"}},\"mutual_aid.mask\":{\"id\":\"mutual_aid.mask\",\"goTo\":[{\"id\":\"mutual_aid.checklist\"}],\"onArrival\":[{\"$code\":\"Q['ma_checklist'] = (Q['ma_checklist'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"You are wearing a respirator partly for the nanoplagues, partly to hide your facial features.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"notes.people\":{\"id\":\"notes.people\",\"title\":\"People\",\"goTo\":[{\"id\":\"notes.notes_main\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"A-\"},\": \",{\"type\":\"conditional\",\"content\":\"A lover, once, along with K-. He is a doctor for an elite corporate hospital. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"A lover, once. A friend now, perhaps, or something more. She is a doctor for an elite corporate hospital. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"A lover, once, and perhaps now, too. She is a doctor for an elite corporate hospital. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"K-\"},\": \",{\"type\":\"conditional\",\"content\":\"A lover, once, along with A-. A friend, perhaps. You were married, once. She works as a scientist in one of the government research labs. \",\"predicate\":3},{\"type\":\"conditional\",\"content\":\"You were once married, but you are unsure of the current status of your relationship. She works as a scientist in one of the government research labs, and is the parent of S-. \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"S-\"},\": \",{\"type\":\"conditional\",\"content\":\"A child. K-'s child with you. \",\"predicate\":5},{\"type\":\"conditional\",\"content\":\"He is far more kind than you deserve. \",\"predicate\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"C-\"},\": A colleague. Your boss at the Archives, despite being 10 years your junior. \",{\"type\":\"conditional\",\"content\":\"She must have sympathized with the Uprising.. \",\"predicate\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"R-: A leader of the Mutual Aid Alliance. \",\"predicate\":8},\" \",{\"type\":\"conditional\",\"content\":\"Rosa Camacho was a participant in the Uprising. \",\"predicate\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"L-: A leader of the Mutual Aid Alliance. \",\"predicate\":10},\" \",{\"type\":\"conditional\",\"content\":\"Leon Zhou was a participant in the Uprising. \",\"predicate\":11},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Liana Xu: A founding mother of the arcology. A posthuman leader during the war, she was nevertheless sympathetic to the plight of the baseline humans, and collaborated after the Treaty in order to construct this Arcology (among others) as a refuge for baseline humans. \",{\"type\":\"conditional\",\"content\":\"She was also possibly the pre-war version of a lavernean, although no one would likely believe such claims.\",\"predicate\":12}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_path'] || 0) <= 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['a_path'] || 0) >= 2) && ((Q['a_loved'] || 0) <= 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['a_path'] || 0) >= 3) && ((Q['a_loved'] || 0) > 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['k_path'] || 0) <= 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['k_path'] || 0) >= 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['k_path'] || 0) <= 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['k_path'] || 0) > 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['r_processed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['mutual_aid_seen'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['r_seen'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['mutual_aid_seen'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['r_seen'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['l_seen'] || 0) >= 2);\"}}]}},\"one.listen\":{\"id\":\"one.listen\",\"maxVisits\":1,\"options\":[{\"id\":\"@one.watch\",\"title\":\"Watch.\"},{\"id\":\"@one.remember\",\"title\":\"Remember.\"}],\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"The apartment was poorly soundproofed. The highway rumbled in the distance like a never-ending roll of thunder, while the trolley clanged nearby. Nearer still, there was the sound of ventilation infrastructure. Angry human voices. Pounding on the walls. Not heard were nonhuman animals; there was no need for those anymore.\"}},\"countVisitsMax\":1},\"online_montage.cn1\":{\"id\":\"online_montage.cn1\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"New Hamilton district evacuated indefinitely due to increased radiation leakage.\"},\"tags\":[\"montage\"],\"maxVisits\":1,\"countVisitsMax\":1,\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN (official): New Hamilton sector evacuated indefinitely due to increased radiation leakage. At least 20,000 displaced; residents seeking shelter throughout the city.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fuck this.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": god last fucking thing we need is more \\\"refugees\\\".\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": why didn't they move out earlier? everyone new it was gonna fail. idiots.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": lol\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":4},\": great, more tents clogging up the parks. my kids can't even go two steps without stepping over trash\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":5},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":6},\": \"]},\"\"]},{\"type\":\"paragraph\",\"content\":\"You read, but you aren't reading. You're not feeling anything at all.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_4'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_5'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_6'] || 0);\"}}]}},\"ritual.graveyard\":{\"id\":\"ritual.graveyard\",\"options\":[{\"id\":\"@ritual.scratch\",\"title\":\"Scratch at the gravestone some more.\"},{\"id\":\"@ritual.bowl\",\"title\":\"Put the paper into the metal bowl.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"After the Cataclysm, after the former inhabitants of the surface platform evacuated to the undercity, they attempted to reconstruct their old lifeways. Their customary funerary rites required burying remains in the earth, so they appropriated a patch of dirt to serve as a cemetary. You would have thought that they realized the inefficiency of burials after hundreds of years of arcology life.\"},{\"type\":\"paragraph\",\"content\":\"Then again, the fact that you are performing this ritual is a sign of your own poor use of time and space and exposure budget.\"}]},\"anxiety.pathetic\":{\"id\":\"anxiety.pathetic\",\"options\":[{\"id\":\"@anxiety.call_for_help\",\"title\":\"Call for help.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Pathetic\\\" is the singular term that defines your existence. You cannot do anything properly. You are incapable of survival in this world. You are lazy and incompetent and self-centered and so fucking self-pitying.\"},{\"type\":\"paragraph\",\"content\":\"Your head hurts, more so than usual. It is hard to breathe.\"}]},\"data.view\":{\"id\":\"data.view\",\"title\":\"DNA data recovery\",\"subtitle\":{\"content\":[\"Your paid job. \",{\"type\":\"conditional\",\"content\":\"You have a message from the Archives about your last assignment.\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['prev_data_type'] || 0) != 0);\"}}]},\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['data_seen'] = (Q['data_seen'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\\nQ['day_data_seen'] = 0;\\nQ['data_day'] = (Q['day'] || 0);\"}],\"viewIf\":{\"$code\":\"return ((((((Q['day_major'] || 0)===0) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['data_seen'] || 0) >= 1)) && ((Q['has_contract'] || 0)===1)) && ((Q['day'] || 0) < 20));\"},\"goTo\":[{\"id\":\"data.archivist_check\"}],\"setJump\":\"data.view_display\",\"tags\":[\"major\"],\"frequency\":500,\"setBg\":\"images/monitor_3_dithered.png\",\"content\":{\"content\":\"You open your e-mail. There are new data recovery and archival requests.\",\"type\":\"paragraph\"}},\"ending_a.dont_leave\":{\"id\":\"ending_a.dont_leave\",\"goTo\":[{\"id\":\"ending_a.a_sighs\"}],\"content\":{\"content\":\"\\\"Don't leave your wife for me.\\\"\",\"type\":\"paragraph\"}},\"ending_liana.liana_1\":{\"id\":\"ending_liana.liana_1\",\"options\":[{\"id\":\"@ending_liana.life_story\",\"title\":\"Your life story flashes before your eyes.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-1\",\"content\":\"She looks like you.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. I'm Xu Yingmei, or Liana if you'd like.\\\" She pronounces her last name strangely, like no one else you had ever heard except in the data recording. \\\"I'm almost surprised you recognized me. The statues don't look anything like this, right?\\\" She laughs. Her voice sounds like a more practiced version of yours.\"},{\"type\":\"paragraph\",\"content\":\"She looks about your age, a thin and taller than average woman wearing pre-war clothing (blue trousers, a pastel-toned striped sweater), with messy long black hair and glasses. She is not wearing a respirator. Her face looks... like the one you see in the mirror. Less gaunt, more fleshy, better toned, but still, almost the same face.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You're my clone, with all the same genetic material. I was curious how I would have turned out under different circumstances. Would I have transitioned in a different world? And well, you helped to provide some evidence on a few of my hypotheses. It makes sense, doesn't it?\\\"\"}]},\"k_4.you_okay\":{\"id\":\"k_4.you_okay\",\"options\":[{\"id\":\"@k_4.hug_her\",\"title\":\"Hug her?\"},{\"id\":\"@k_4.water\",\"title\":\"Give her some water or something.\"},{\"id\":\"@k_4.tea\",\"title\":\"Make tea.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Are you okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"She turns to look at you. \\\"No I'm fucking not okay. What do you think?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Mom is talking to you,\\\" says S-. \\\"Wow.\\\"\"}]},\"root.enable_cw\":{\"id\":\"root.enable_cw\",\"viewIf\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['cw_enabled'] = 1;\"}],\"options\":[{\"id\":\"@one\",\"title\":\"Start game\"},{\"id\":\"@credits\",\"title\":\"Credits and inspirations\"},{\"id\":\"@root.enable_cw\",\"title\":\"Enable content warnings.\"},{\"id\":\"@root.disable_cw\",\"title\":\"Disable content warnings.\"}],\"content\":{\"content\":\"Content warnings enabled.\",\"type\":\"paragraph\"}},\"s_1.not_parent\":{\"id\":\"s_1.not_parent\",\"goTo\":[{\"id\":\"s_1.s_hungry\"}],\"content\":{\"content\":\"Women are supposed to have maternal instincts. Women (GNT women, not that anyone would use the term) are supposed to instinctively know what to do when faced with their long-separated child of 7 years who has been suddenly dropped on them with barely a warning. How can you be allowed to be a woman like this?\",\"type\":\"paragraph\"}},\"status.new\":{\"id\":\"status.new\",\"options\":[{\"id\":\"@backSpecialScene\",\"title\":\"Back\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Your name is Em, and you are alive, for now.\"},{\"type\":\"paragraph\",\"content\":[\"Stress: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"heading\",\"content\":\"Cost of living\"},{\"type\":\"paragraph\",\"content\":[\"Cash on hand: $\",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Rent: $\",{\"type\":\"insert\",\"insert\":2},\" due in \",{\"type\":\"insert\",\"insert\":3},\" day\",{\"type\":\"conditional\",\"content\":\"s \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Food: \",{\"type\":\"insert\",\"insert\":5},\" days remaining\"]},{\"type\":\"heading\",\"content\":\"Contacts\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"A—\"},\": \",{\"type\":\"conditional\",\"content\":\"A lover, once. A friend, perhaps. \",\"predicate\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"K—\"},\": \",{\"type\":\"conditional\",\"content\":\"A lover, once. A friend, perhaps. \",\"predicate\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"S—\"},\": \",{\"type\":\"conditional\",\"content\":\"A child. Your child. \",\"predicate\":8},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"L—\"},\": \",{\"type\":\"conditional\",\"content\":\"A colleague. \",\"predicate\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"M—\"},\":\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"T—\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"R—\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Liana Yingmei Xu\"},\": \"],\"predicate\":10},\" \",{\"type\":\"conditional\",\"content\":\"From her diaries, she seems so familiar...\",\"predicate\":11}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['stress'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['money'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent_due'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rent_due'] || 0) != 1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['food'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['k'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['s'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['l'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['liana'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['liana'] || 0) >= 1) && ((Q['liana'] || 0) <= 2));\"}}]}},\"status\":{\"id\":\"status\",\"type\":\"scene\",\"title\":\"Status\",\"newPage\":true,\"isSpecial\":true,\"goTo\":[{\"id\":\"status.old\",\"predicate\":{\"$code\":\"return ((Q['introduced'] || 0)===0);\"}},{\"id\":\"status.new\",\"predicate\":{\"$code\":\"return ((Q['introduced'] || 0)===1);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_generic.is_date\":{\"id\":\"a_generic.is_date\",\"content\":{\"content\":\"This could be a date.\",\"type\":\"paragraph\"}},\"k_3.go_to_school\":{\"id\":\"k_3.go_to_school\",\"options\":[{\"id\":\"@k_3.sure_meet\",\"title\":\"\\\"Sure, let's meet.\\\"\"},{\"id\":\"@k_3.i_guess_meet\",\"title\":\"\\\"I suppose...\\\"\"},{\"id\":\"@k_3.no_meet\",\"title\":\"\\\"Sorry, I'm busy...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So, S-, do you want to go to school now?\\\"\"},{\"type\":\"paragraph\",\"content\":\"He nods, groggily, and slides off the bed, grabbing his clothes before going to the bathroom.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I don't have work in the day,\\\" says K-. \\\"Mind if I come back here afterwards? We still haven't caught up.\\\"\"}]},\"entertainment.game_2\":{\"id\":\"entertainment.game_2\",\"content\":{\"content\":\"You play a game recovered from the archives, from the pre-war era. It is a text-based game about high school dating and the drama involved therein.\",\"type\":\"paragraph\"}},\"a_1.a_13\":{\"id\":\"a_1.a_13\",\"options\":[{\"id\":\"@a_1.call\",\"title\":\"Call A-.\"}],\"content\":{\"content\":\"The two of you were... dating. Yes. That would be an accurate description. She loved you, and you loved her. Back when she was like you. A-, K-, and you were in a mutual relationship together, before A- left. You hear he has a new family now, a new wife and children. K- has never forgiven him. Have you?\",\"type\":\"paragraph\"}},\"a_2.love\":{\"id\":\"a_2.love\",\"onArrival\":[{\"$code\":\"Q['a_romance'] = (Q['a_romance'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"a_2.lx_square\"}],\"content\":{\"content\":\"You are meeting with A- because you still have feelings for him, or something like that.\",\"type\":\"paragraph\"}},\"a_3.before_meet\":{\"id\":\"a_3.before_meet\",\"options\":[{\"id\":\"@a_3.yourself_or_me\",\"title\":\"\\\"You are at greater danger than me.\\\"\"},{\"id\":\"@a_3.why_you_r\",\"title\":[\"\\\"Why are \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\" doing this?\\\"\"]},{\"id\":\"@a_3.why_you\",\"title\":[\"\\\"Why are \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\" doing this?\\\"\"]},{\"id\":\"@a_3.my_life\",\"title\":\"\\\"You don't understand what it's like.\\\"\"},{\"id\":\"@a_3.need_money\",\"title\":\"\\\"I'm here because I need the money.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You should have thought about this before coming here.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I did. And what about you? Is this a risk you're willing to take?\\\"\"}]},\"a_call.answer\":{\"id\":\"a_call.answer\",\"onArrival\":[{\"$code\":\"Q['a_path'] = 1;\\nQ['a_day'] = (Q['day'] || 0);\"}],\"options\":[{\"id\":\"@a_call.how_know\",\"title\":\"\\\"How did you know?\\\"\"},{\"id\":\"@a_call.pay_rent\",\"title\":\"\\\"You can help me pay rent...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Hello, Em?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hi.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I heard you've been having trouble with rent. Is there anything I can do to help?\\\"\"}]},\"archives.city\":{\"id\":\"archives.city\",\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"On the Ruling Party\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Bella X.\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Abstract: \"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<hr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"The War in the City\"}}]},\"dreams.cannot_sleep\":{\"id\":\"dreams.cannot_sleep\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You cannot fall asleep.\"},{\"type\":\"paragraph\",\"content\":\"Think about A- Think about K- Think about DNA data Think about Liana Xu\"}]},\"dreams\":{\"id\":\"dreams\",\"type\":\"scene\",\"title\":\"Dreams\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_hospital.okay\":{\"id\":\"ending_hospital.okay\",\"goTo\":[{\"id\":\"ending_hospital.archives_c\"}],\"content\":{\"content\":\"\\\"Okay...\\\"\",\"type\":\"paragraph\"}},\"ending_k.maybe_love\":{\"id\":\"ending_k.maybe_love\",\"goTo\":[{\"id\":\"ending_k.power_of\"}],\"content\":{\"content\":\"\\\"Maybe. I don't know.\\\"\",\"type\":\"paragraph\"}},\"eviction.you_want_to_die\":{\"id\":\"eviction.you_want_to_die\",\"options\":[{\"id\":\"@eviction.go_outside\",\"title\":\"\\\"Can we go outside to talk?\\\", she says to you and his wife simultaneously.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Hello, Em.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hi.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"A- is inside, if you're looking for him.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay. Sorry.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No worries. Is something wrong?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No. I'm... I'm fine.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Then, A- emerges, still wearing a suit. She (he?) looks over you from head to toe.\"}]},\"food.takeout_2\":{\"id\":\"food.takeout_2\",\"maxChoices\":1,\"onArrival\":[{\"$code\":\"Q['days_starved'] = 0;\"}],\"setBg\":\"images/windows_filtered_dithered.png\",\"options\":[{\"id\":\"#takeout\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"illness.rice\":{\"id\":\"illness.rice\",\"chooseIf\":{\"$code\":\"return ((Q['days_starved'] || 0)===0);\"},\"unavailableSubtitle\":\"You don't have enough food.\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Cooking rice takes too much out of you, even as you skip the addition of beans and the step of washing the rice.\"},{\"type\":\"paragraph\",\"content\":\"Nevertheless, you finish cooking. The rice porridge is warm and filling, and you feel less ill, at least for a while. Your headaches ease.\"},{\"type\":\"paragraph\",\"content\":\"But it will return. It always returns.\"}]},\"illness_2.pills\":{\"id\":\"illness_2.pills\",\"viewIf\":{\"$code\":\"return ((Q['medicine'] || 0) > 1);\"},\"content\":[{\"type\":\"paragraph\",\"content\":\"You still have a small stash of expired over-the-counter painkillers. They are apparently still effective. As the medicine takes effect, your body slowly returns to a certain equilibrium, and your terror thins.\"},{\"type\":\"paragraph\",\"content\":\"But it will return. It always returns.\"}]},\"k_1.call\":{\"id\":\"k_1.call\",\"options\":[{\"id\":\"@k_1.past\",\"title\":\"You and K- were married once.\"},{\"id\":\"@k_1.child\",\"title\":\"You and K- had a child, once.\"},{\"id\":\"@k_1.dial\",\"title\":\"Dial.\"}],\"content\":{\"content\":\"You are holding the handset. Her phone number is written on a note stuck to your refrigerator door.\",\"type\":\"paragraph\"}},\"k_2.weeks\":{\"id\":\"k_2.weeks\",\"subtitle\":\"She was on CityNet.\",\"goTo\":[{\"id\":\"k_2.anyway\"}],\"content\":{\"content\":\"It was a CityNet article about the latest nanoplague variant. She was the \\\"University scientist\\\" quoted (most likely out-of-context) in an article that was an odd mixture of irrational fearmongering and minimization. The comments all excoriated her, of course. That was the last reminder you had of her existence.\",\"type\":\"paragraph\"}},\"k_bad.sorry_sick\":{\"id\":\"k_bad.sorry_sick\",\"viewIf\":{\"$code\":\"return (((Q['illness_seen'] || 0) > 0) && ((Q['k_bad'] || 0) < 3));\"},\"onArrival\":[{\"$code\":\"Q['k_day'] = (Q['day'] || 0);\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, I was sick,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Not a contagious illness, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No. I've just been like this for a while...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"Do you think you'll be fine to take care of S- the day after tomorrow?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes, I should be.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Great! I'll see you then.\\\"\"}]},\"k_bad\":{\"id\":\"k_bad\",\"type\":\"scene\",\"title\":\"K- calls.\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['k_bad'] = (Q['k_bad'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_bad.didnt_want\",\"title\":\"\\\"Sorry, but, I don't think I can...\\\"\"},{\"id\":\"@k_bad.sorry_my_bad\",\"title\":\"\\\"Sorry, my bad. Can we meet tomorrow?\\\"\"},{\"id\":\"@k_bad.sorry_sick\",\"title\":\"\\\"Sorry, I was sick.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You receive a call from K-.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I thought we were going to meet last night. Where were you?\\\"\"}]},\"k_call.ignore_2\":{\"id\":\"k_call.ignore_2\",\"content\":{\"content\":\"You do not answer the call, leaving you alone with your thoughts.\",\"type\":\"paragraph\"}},\"k_generic.sure_80\":{\"id\":\"k_generic.sure_80\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 80;\"}],\"content\":{\"content\":\"\\\"Thank you.\\\"\",\"type\":\"paragraph\"}},\"main.rent_collection\":{\"id\":\"main.rent_collection\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q.additional_rent = Q.base_rent + 100;\\nQ.base_rent = Q.additional_rent;\\nQ.grocery_cost += 10;\\nQ.takeout_cost += 5;\\nQ.old_rent = Q.rent;\\nQ.fees = 50 + Math.ceil(Math.random()*50);\\nQ.total_rent = Q.rent + Q.fees;\\nQ.paid_full = 0;\\nif (Q.money < Q.total_rent) {\\n    Q.money = 0;\\n    Q.rent = Q.total_rent - Q.money;\\n    Q.missed_rent += 1;\\n    Q.rent += 50;\\n    Q.stress += 1;\\n} else {\\n    Q.money -= Q.total_rent;\\n    Q.rent = 0;\\n    Q.paid_full = 1;\\n}\\nQ.rent += Q.additional_rent;\\nQ.rent_due = 7;\"}],\"goTo\":[{\"id\":\"eviction\",\"predicate\":{\"$code\":\"return ((Q['missed_rent'] || 0) >= 2);\"}}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"Your rent and additional costs were automatically deducted from your account. The rent was $\",{\"type\":\"insert\",\"insert\":1},\" and fees plus utilities were $\",{\"type\":\"insert\",\"insert\":2},\". You have $\",{\"type\":\"insert\",\"insert\":3},\" remaining. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":[\"The rent due was $\",{\"type\":\"insert\",\"insert\":5},\" and the fees were $\",{\"type\":\"insert\",\"insert\":6},\". Unfortunately, you did not have enough to cover the total amount due. All money in your account was automatically deducted, and the remaining balance was rolled over into the next rent payment, with an additional fee of $50. If you miss the next payment, then you will be evicted. \"],\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"They are increasing rent to absurd levels, most likely for the purpose of evicting you from this building. There are many people who would like to live here, people with more money than you, and not enough apartments for everyone. Thus, the evictions. \",\"predicate\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Next bill: \",{\"type\":\"insert\",\"insert\":8},\" due in \",{\"type\":\"insert\",\"insert\":9},\" days.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['paid_full'] || 0)===1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_rent'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['fees'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['money'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['paid_full'] || 0)===0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_rent'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['fees'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['additional_rent'] || 0) > 500);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent_due'] || 0);\"}}]}},\"medicine.ask_k\":{\"id\":\"medicine.ask_k\",\"subtitle\":\"Would she share?\",\"viewIf\":{\"$code\":\"return ((Q['k_path'] || 0) >= 3);\"},\"maxVisits\":1,\"options\":[{\"id\":\"@medicine.ask_k_2\",\"title\":\"Ask her.\"},{\"id\":\"@medicine.med_options\",\"title\":\"Do something else.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Like you, she has a prescription for \\\"early menopause\\\", although the justification of her prescription is more conventional.\"},{\"type\":\"paragraph\",\"content\":\"Would she be willing to share, though?\"}],\"countVisitsMax\":1},\"mutual_aid.clothes\":{\"id\":\"mutual_aid.clothes\",\"goTo\":[{\"id\":\"mutual_aid.checklist\"}],\"onArrival\":[{\"$code\":\"Q['ma_checklist'] = (Q['ma_checklist'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"A long grey skirt. A blue puffy jacket. Sensible shoes.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"notes.history\":{\"id\":\"notes.history\",\"title\":\"History\",\"options\":[{\"id\":\"@notes.posthuman_war\"},{\"id\":\"@notes.arcology\"},{\"id\":\"@notes.cataclysm\"},{\"id\":\"@notes.uprising\"},{\"id\":\"@notes.notes_main\"},{\"id\":\"@main\",\"title\":\"Do something else.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"one.remember\":{\"id\":\"one.remember\",\"options\":[{\"id\":\"@one.5_years_ago\",\"title\":\"5 years ago.\"},{\"id\":\"@one.10_years_ago\",\"title\":\"10 years ago.\"},{\"id\":\"@one.500_years_ago\",\"title\":\"500 years ago.\"},{\"id\":\"@one.out\",\"title\":\"Stop dissociating.\"}],\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"The Archivist remembered. Memories, real and imagined, flowed forth like a wellspring.\"}}},\"online_montage.cn2\":{\"id\":\"online_montage.cn2\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Stealth transvestite teacher found indoctrinating students in gender ideology.\"},\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"CW: transphobia, slurs\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]},\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 1;\"}],\"countVisitsMax\":1,\"tags\":[\"montage\"],\"options\":[{\"id\":\"@online_montage.cn2_2\",\"title\":\"It makes you strangely pleased to see her.\"},{\"id\":\"@online_montage.cn2_1\",\"title\":\"This is your future.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Stealth transvestite teacher found indoctrinating students in gender ideology. Video: (link)\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": pedophile\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": none of these people should be allowed near children.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": this is why our educational system is failing\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": this is what feminists want\"]},\"\"]},{\"type\":\"attribution\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":4},\": dont blame this garbage on feminists. we all know that men can't be women.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":5},\": update: it killed itself\"]},\"\"]},{\"type\":\"attribution\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":6},\": good\"]},\"\"]},{\"type\":\"attribution\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":7},\": thank god\"]},\"\"]},{\"type\":\"attribution\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":8},\": while i abhor the loss of life, the teaching of biological falsehoods to the most vulnerable must have real consequences.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":\"@Tinu-Lee: are you people serious? do you have zero compassion for a woman who just died?\"},\"\"]},{\"type\":\"attribution\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":9},\": \\\"woman\\\"\"]},\"\"]},{\"type\":\"attribution\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":10},\": i have sympathey for the fact that he was lead astray from the sacred path of humanity into the demonic embrase of transhumanism\"]},\"\"]},{\"type\":\"paragraph\",\"content\":\"You watch the video. It is an elementary school classroom, shot from what seems to be a hidden security camera. The teacher is a well-dressed woman most likely in her late thirties or forties, similar to you. \\\"I am a girl now, but when I was born, they thought I was a boy,\\\" she says. The students are staring at her. The video cuts off right there.\"},{\"type\":\"paragraph\",\"content\":\"You knew many laverneans, but you did not know her; she must have been stealth in the days before the Uprising.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_4'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_5'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_6'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_7'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_7'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"ritual.scratch\":{\"id\":\"ritual.scratch\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['ritual_scratched'] = 1;\"}],\"options\":[{\"id\":\"@ritual.bowl\",\"title\":\"Put the paper into the bowl.\"},{\"id\":\"@ritual.tradition\",\"title\":\"The tradition continues.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"With a key you deepen the grooves of her true name, and add new scratches to her \\\"legal\\\" name. Since she never had dignity in life, the least you could do was give her some modicum of dignity in death.\"},{\"type\":\"paragraph\",\"content\":\"Her family was the most supportive family of all the laverneans and elliotians you had ever encountered. Still they buried her under the name they had chosen, and not the name she chose.\"}],\"countVisitsMax\":1},\"anxiety.shouldnt\":{\"id\":\"anxiety.shouldnt\",\"options\":[{\"id\":\"@anxiety.call_for_help\",\"title\":\"Call for help.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You should not even be alive. You should have died 10 years ago, at the Cataclysm. You should have died five years ago at the Uprising with all of your comrades. You're a fucking coward.\"},{\"type\":\"paragraph\",\"content\":\"Your head hurts, more so than usual. It is hard to breathe.\"}]},\"data.view_display\":{\"id\":\"data.view_display\",\"maxChoices\":5,\"options\":[{\"id\":\"#data\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.family\":{\"id\":\"ending_a.family\",\"goTo\":[{\"id\":\"ending_a.a_sighs\"}],\"content\":{\"content\":\"\\\"I don't want to break up your family.\\\"\",\"type\":\"paragraph\"}},\"ending_liana.life_story\":{\"id\":\"ending_liana.life_story\",\"goTo\":[{\"id\":\"ending_liana.questions_1\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"Your life flashes before your eyes. You were born an orphan, and was raised a ward of the state. You knew nothing about your birth parents, save their last name, and you had no living relatives. The most likely conclusion was that you were born to nomads. But you never checked the records; you never cared about your origin story. \",{\"type\":\"emphasis-1\",\"content\":\"Her story makes sense.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"This is my favourite body,\\\" she continues. \\\"It's what I would have looked like without any of the surgeries. We really do look alike, don't we, Emmeline Hsu?\\\"\"},{\"type\":\"paragraph\",\"content\":\"She pronounces your last name differently than you had ever heard. It sounds exactly like the way she pronouced her own.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I suppose you have questions,\\\" she says, smiling, with an inviting arm gesture. \\\"Feel free to ask.\\\"\"}]},\"k_4.hug_her\":{\"id\":\"k_4.hug_her\",\"goTo\":[{\"id\":\"k_4.thanks\"}],\"onArrival\":[{\"$code\":\"Q['k_romance'] = (Q['k_romance'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The endorphins released by physical contact will help her. Right?\"},{\"type\":\"paragraph\",\"content\":\"So you hug her.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks. The endorphins released by physical contact are really helping me right now.\\\"\"}]},\"root.disable_cw\":{\"id\":\"root.disable_cw\",\"viewIf\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['cw_enabled'] = 0;\"}],\"options\":[{\"id\":\"@one\",\"title\":\"Start game\"},{\"id\":\"@credits\",\"title\":\"Credits and inspirations\"},{\"id\":\"@root.enable_cw\",\"title\":\"Enable content warnings.\"},{\"id\":\"@root.disable_cw\",\"title\":\"Disable content warnings.\"}],\"content\":{\"content\":\"Content warnings disabled.\",\"type\":\"paragraph\"}},\"s_1.one_night\":{\"id\":\"s_1.one_night\",\"goTo\":[{\"id\":\"s_1.s_hungry\"}],\"content\":{\"content\":\"It is just for a single night.\",\"type\":\"paragraph\"}},\"a_generic.what_is\":{\"id\":\"a_generic.what_is\",\"content\":{\"type\":\"paragraph\",\"content\":[\"You have no idea what \",{\"type\":\"emphasis-1\",\"content\":\"this\"},\" is.\"]}},\"k_3.sure_meet\":{\"id\":\"k_3.sure_meet\",\"options\":[{\"id\":\"@k_3.k_3_meet\",\"title\":\"K- returns.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sure, let's meet. Later.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- makes a thin smile. \\\"That's great.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Once S- is ready, the two of them leave. You are only left alone for approximately 30 minutes before K- returns, during which time you lay on the bed, mind entranced in the past.\"}]},\"entertainment.game_3\":{\"id\":\"entertainment.game_3\",\"content\":{\"content\":\"You play a game recovered from the archives, from the 3rd century. It is a political simulator that features loose stand-ins of the factions of that era, with virtually incomprehensible politics.\",\"type\":\"paragraph\"}},\"a_1.call\":{\"id\":\"a_1.call\",\"options\":[{\"id\":\"@a_1.dial\",\"title\":\"Dial the number.\"},{\"id\":\"@a_1.forget_it\",\"title\":\"Forget it.\"}],\"content\":{\"content\":\"You are holding the phone handset. A-'s number is written on a note on your fridge. Call in case you have a medical emergency, he had said. Or just if you want to talk. He wanted to remain in contact, and in your good graces, for whatever reason, despite the fact that you have no way to reciprocate his generosity, and many ways to drag him down.\",\"type\":\"paragraph\"}},\"a_2.lx_square\":{\"id\":\"a_2.lx_square\",\"options\":[{\"id\":\"@a_2.too_old\",\"title\":\"\\\"Aren't you too old to wear striped thigh highs?\\\"\"},{\"id\":\"@a_2.scared\",\"title\":\"\\\"Aren't you scared to be like this in public?\\\"\"},{\"id\":\"@a_2.stare\",\"title\":\"Just stare.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Seeing A- gives you a shock. He is... well, he is dressed like a lavernean stereotype, like one of the pre-war photos found in the Archives, in addition to bleached blonde hair (you cannot tell if it is a wig) and a thorough application of makeup. At least he is wearing a respirator.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, Em.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Oh. She is using the girlmode voice, too.\"}]},\"a_3.need_money\":{\"id\":\"a_3.need_money\",\"options\":[{\"id\":\"@a_3.transactional\",\"title\":\"\\\"All relationships are transactional...\\\"\"},{\"id\":\"@a_3.some_positive\",\"title\":\"\\\"I have some positive feelings for you...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I'm here because I need the money.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- looks wounded. \\\"Oh. Is this why you're talking to me? And I thought you still had at least some positive feelings here.\\\"\"}]},\"a_call.how_know\":{\"id\":\"a_call.how_know\",\"options\":[{\"id\":\"@a_call.thats_creepy\",\"title\":\"\\\"That's creepy.\\\"\"},{\"id\":\"@a_call.pay_rent\",\"title\":\"\\\"You can help me pay rent...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"How did you know I've been having trouble?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, I've been following your profile on the Archives' CityNet page. Your profile was removed, so I guessed that you've been fired.\\\"\"}]},\"archives.cataclysm\":{\"id\":\"archives.cataclysm\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_hospital.archives_c\":{\"id\":\"ending_hospital.archives_c\",\"options\":[{\"id\":\"@ending_hospital.ending_c\",\"title\":\"\\\"Yes, I'll continue working here.\\\"\"},{\"id\":\"@ending_hospital.working\",\"title\":\"You don't have any other options, do you?\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"\\\"I hope you continue working with the Archives, despite everything,\\\" she continues. \\\"I don't think we're \",{\"type\":\"emphasis-1\",\"content\":\"that\"},\" evil. What we're doing is important, and more importantly, interesting.\\\"\"]}},\"ending_k.worry_a\":{\"id\":\"ending_k.worry_a\",\"viewIf\":{\"$code\":\"return ((Q['k_knows_a_affair'] || 0) > 0);\"},\"options\":[{\"id\":\"@ending_k.love_bad\",\"title\":\"\\\"Love doesn't stand a chance against the police state.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Aren't you worried about A-?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What, that you'll run off with her?\\\" She laughs. \\\"Well, in your darkest hour you came to me instead, right? Isn't that a sign more than any that the power of love is real?\\\"\"}]},\"eviction.go_outside\":{\"id\":\"eviction.go_outside\",\"options\":[{\"id\":\"@eviction.where_else\",\"title\":\"\\\"Where else can I go?\\\"\"},{\"id\":\"@eviction.where_fuck\",\"title\":\"\\\"Where the fuck else can I go?\\\"\"},{\"id\":\"@eviction.redistribute\",\"title\":[{\"type\":\"emphasis-1\",\"content\":\"You need to redistribute their wealth\"},\" is a thought you have.\"]}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Can we go outside to talk?\\\", she says to you and his wife simultaneously.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. Sure.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You leave the apartment complex, still carrying your suitcase. A- leads you to a small, secluded garden.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Tell me how bad it is,\\\" A- says. Her voice shifts in pitch and resonance when she is alone with you.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I was evicted.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's terrible.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It is.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- is not looking at you. \\\"You shouldn't have come here.\\\"\"}]},\"food.takeout_do_1\":{\"id\":\"food.takeout_do_1\",\"title\":\"Takeout\",\"tags\":[\"takeout\"],\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - ((Q['takeout_cost'] || 0) + 10);\\nQ['food'] = (Q['food'] || 0) + 2;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The trolleys have broken down today, so you visit the nearest walkable restaurant. It is more expensive than you would like.\"},{\"type\":\"paragraph\",\"content\":\"It costs $35 for food to last 2 days.\"}]},\"illness.why\":{\"id\":\"illness.why\",\"options\":[{\"id\":\"@illness.tea\",\"title\":\"Drink some tea.\"},{\"id\":\"@illness.water\",\"title\":\"Drink some water.\"},{\"id\":\"@illness.rice\",\"title\":\"Drink some rice porridge.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"No doctor has been able to diagnose you, not that they tried very much. Nothing was revealed by the standard battery of tests. The single doctor who made an attempt told you to discontinue your hormone treatments (it did not succeed). The more doctors you see, the more likely they are to discover the biomedical discrepancies of your birth, so you have not asked again.\"},{\"type\":\"paragraph\",\"content\":\"Perhaps it began with your nanoplague infections. Or perhaps it began earlier, during the Uprising when you were kept awake by explosions in your neighborhood. Or earlier still - an accident of your genetics? A mutation, or an inheritance from your never-seen biological ancestors? You will likely never know.\"}]},\"illness\":{\"id\":\"illness\",\"type\":\"scene\",\"title\":\"The illness\",\"viewIf\":{\"$code\":\"return ((((Q['stress'] || 0) >= ((Q['stress_threshold'] || 0) / 2)) && ((Q['illness_seen'] || 0)===0)) && ((Q['day_major'] || 0)===0));\"},\"frequency\":1000,\"priority\":10,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['illness_seen'] = 1;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"tags\":[\"major\"],\"options\":[{\"id\":\"@illness.tea\",\"title\":\"Drink some tea.\"},{\"id\":\"@illness.water\",\"title\":\"Drink some water.\"},{\"id\":\"@illness.rice\",\"title\":\"Drink some rice porridge.\"},{\"id\":\"@illness.why\",\"title\":\"Why are you like this?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The illness waxes and wanes by its own inscrutable schedule. One day you are feeling as functional as any other human, and the next you cannot stay awake for more than five hours.\"},{\"type\":\"paragraph\",\"content\":\"Today is one of the bad days, when your body is sapped of seemingly all energy. You cough. The pressure in your cranium builds. You feel dizzy and nauseous and you have the urge to vomit.\"}],\"countVisitsMax\":1},\"illness_2.rice\":{\"id\":\"illness_2.rice\",\"chooseIf\":{\"$code\":\"return ((Q['days_starved'] || 0)===0);\"},\"unavailableSubtitle\":\"You do not have enough food.\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Cooking rice takes too much out of you, even as you skip the addition of beans and the step of washing the rice.\"},{\"type\":\"paragraph\",\"content\":\"Nevertheless, you finish cooking. The rice porridge is warm and filling, and you feel less ill, at least for a while. Your body slowly returns to a certain equilibrium, and your terror thins.\"},{\"type\":\"paragraph\",\"content\":\"But it will return. It always returns.\"}]},\"k_1.dial\":{\"id\":\"k_1.dial\",\"options\":[{\"id\":\"@k_1.past\",\"title\":\"You and K- were married once.\"},{\"id\":\"@k_1.child\",\"title\":\"You and K- had a child, once.\"},{\"id\":\"@k_1.dial_2\",\"title\":\"Just dial the digits.\"}],\"content\":{\"content\":\"Right. You are going to call her.\",\"type\":\"paragraph\"}},\"k_2.anyway\":{\"id\":\"k_2.anyway\",\"options\":[{\"id\":\"@k_2.anticipation\",\"title\":\"Anyway, you are at the park. Waiting.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_call.answer\":{\"id\":\"k_call.answer\",\"options\":[{\"id\":\"@k_call.yes_take\",\"title\":\"\\\"Fine...\\\"\"},{\"id\":\"@k_call.no_take\",\"title\":\"\\\"I don't know, sorry...\\\"\"},{\"id\":\"@k_call.why_now\",\"title\":\"\\\"Why are you asking me?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You answer the call.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hello, Em?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I need you to take care of S- tomorrow, overnight. I'm going to be staying in the lab until morning. Do you think you can make it?\\\" A pause. \\\"Don't worry. I'll pay you.\\\"\"}]},\"k_generic.k_household\":{\"id\":\"k_generic.k_household\",\"title\":\"K- just needs some household chores done.\",\"maxVisits\":1,\"tags\":[\"k_generic\"],\"options\":[{\"id\":\"@k_generic.of_course_clean\",\"title\":\"Of course, you help her.\"}],\"content\":{\"content\":\"K- apparently has a messy house again. She asks if you can come over to help clean up. So you go over to her apartment.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"main.game_over\":{\"id\":\"main.game_over\",\"gameOver\":true,\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"main\":{\"id\":\"main\",\"type\":\"scene\",\"title\":\"Main\",\"newPage\":true,\"maxChoices\":7,\"onArrival\":[{\"$code\":\"if (Q.next_day_scene_queue.length > 0) {\\n    Q.has_next_day = 1;\\n    Q.next_day_scene = Q.next_day_scene_queue.shift();\\n} else {\\n    Q.has_next_day = 0;\\n}\\nif (Q.day_major >= 1) {\\n    Q.main_notes = \\\"\\\";\\n}\"}],\"goToRef\":[{\"id\":\"next_day_scene\",\"predicate\":{\"$code\":\"return ((Q['has_next_day'] || 0) > 0);\"}}],\"options\":[{\"id\":\"#major\"},{\"id\":\"#minor\"},{\"id\":\"@main.end_of_day\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":[\"Day \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Cash on hand: $\",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Rent: $\",{\"type\":\"insert\",\"insert\":2},\" (+ $50-100 in utilities, fees, etc.) due in \",{\"type\":\"insert\",\"insert\":3},\" day\",{\"type\":\"conditional\",\"content\":\"s \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Food: \",{\"type\":\"insert\",\"insert\":5},\" day\",{\"type\":\"conditional\",\"content\":\"s \",\"predicate\":6},\" remaining\"]},{\"type\":\"paragraph\",\"content\":[\"Medicine: \",{\"type\":\"insert\",\"insert\":7},\" day\",{\"type\":\"conditional\",\"content\":\"s \",\"predicate\":8},\" remaining\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Your apartment is on the third floor of a six-story building, and has a floor area of approximately 15 square metres. There is a bed, a desk, and a small kitchen area with an electric stove and a refrigerator. You are lucky. There is everything you need to live in here. \",\"predicate\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":11},\" \"],\"predicate\":10},\" \",{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":13},\" \"],\"predicate\":12},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"magic\",\"content\":\"<script>$('#main_notes').append($(window.dendryUI.dendryEngine.state.qualities.main_notes)); if (window.dendryUI.dendryEngine.state.qualities.has_next_day == 0) { window.dendryUI.setBg('images/room1_filtered_dithered.png'); } </script> <div id=\\\"main_notes\\\"></div>\"}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['day'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['money'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent_due'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rent_due'] || 0) != 1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['food'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['food'] || 0) != 1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['medicine'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['medicine'] || 0) != 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['day'] || 0)===0) && ((Q['day_major'] || 0)===0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['day_major'] || 0)===0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['day_dialogue'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['day_major'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['afternoon_dialogue'] || 0);\"}}]}},\"medicine.ask_k_2\":{\"id\":\"medicine.ask_k_2\",\"options\":[{\"id\":\"@medicine.buy\",\"title\":\"Refill at the pharmacy.\"},{\"id\":\"@medicine.none\",\"title\":\"Go without.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You make the call.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Look, I barely have enough for myself. Sorry, but I don't have anything to spare right now.\\\"\"}]},\"mutual_aid.voice\":{\"id\":\"mutual_aid.voice\",\"goTo\":[{\"id\":\"mutual_aid.checklist\"}],\"onArrival\":[{\"$code\":\"Q['ma_checklist'] = (Q['ma_checklist'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"Unfortunately, you could never successfully modulate the resonance of your voice. You will just have to talk as minimally as possible.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"notes.posthuman_war\":{\"id\":\"notes.posthuman_war\",\"title\":\"The Posthuman War\",\"goTo\":[{\"id\":\"notes.history\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The worst war in the history of humanity thus far. The war was between the \\\"posthumans\\\", or humans enhanced with cybernetic and biological modifications, and the \\\"baseline humans\\\", which included all humans who rejected these modifications. Both sides used coercion to recruit others to their side; the posthumans had developed infectious nanoplagues in order to convert baseline humans to a posthuman physiology, with varying degrees of success and failure. Nuclear and biological weapons were used, and over half the human population of the Earth perished.\"},{\"type\":\"paragraph\",\"content\":\"The war ended in the Treaty which cleaved humanity into two; the posthumans were to leave for outer space, while the baselines had full control of Earth. The posthumans would also help the baselines live in the radically changed environment by constructing vast arcology habitats for the remaining inhabitants.\"},{\"type\":\"paragraph\",\"content\":\"This was five hundred years ago (although some heterodox historians claim it was three hundred years ago). History is commonly divided into the pre-war and post-war epochs; years are named AT for \\\"After Treaty\\\".\"}]},\"one.5_years_ago\":{\"id\":\"one.5_years_ago\",\"goTo\":[{\"id\":\"one.500_years_ago\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"online_montage.cn2_2\":{\"id\":\"online_montage.cn2_2\",\"content\":{\"content\":\"They have not exterminated all of you yet. There are still more laverneans in the woodwork, more women like you hiding out there, surviving. You feel less alone.\",\"type\":\"paragraph\"}},\"ritual.bowl\":{\"id\":\"ritual.bowl\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['ritual_burnt'] = 1;\"}],\"options\":[{\"id\":\"@ritual.scratch\",\"title\":\"Scratch at the gravestone some more.\"},{\"id\":\"@ritual.tradition\",\"title\":\"The tradition continues.\"}],\"content\":{\"content\":\"You put the scraps of newsprint into a ceramic bowl behind Lily's grave marker, and light the matches into the bowl. The papers slowly char and curl into licks of flame.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"anxiety.so_tired\":{\"id\":\"anxiety.so_tired\",\"options\":[{\"id\":\"@anxiety.call_for_help\",\"title\":\"Call for help.\"},{\"id\":\"@anxiety.no_help\",\"title\":\"No one will save you.\"}],\"content\":{\"content\":\"You are too tired to think. Your brain is a block of ice resting uselessly in your cranium. And it hurts, more so than usual. It is hard to even breathe.\",\"type\":\"paragraph\"}},\"data.back\":{\"id\":\"data.back\",\"goTo\":[{\"id\":\"main\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.a_sighs\":{\"id\":\"ending_a.a_sighs\",\"options\":[{\"id\":\"@ending_a.rebound\",\"title\":\"\\\"So I'm just your rebound?\\\"\"},{\"id\":\"@ending_a.where_run_away\",\"title\":\"\\\"Where would we run away?\\\"\"}],\"content\":{\"content\":\"A- sighs. \\\"It might as well be broken already. We've... not had the best relationship recently. We were thinking about divorce anyway.\\\"\",\"type\":\"paragraph\"}},\"ending_liana.questions_1\":{\"id\":\"ending_liana.questions_1\",\"options\":[{\"id\":\"@ending_liana.i_\",\"title\":\"\\\"I...\\\"\"},{\"id\":\"@ending_liana.tired_too\",\"title\":\"\\\"Are you tired all the time, too?\\\"\"},{\"id\":\"@ending_liana.first_time\",\"title\":\"\\\"Is this the first time you've done this?\\\"\"},{\"id\":\"@ending_liana.what_learn\",\"title\":\"\\\"What did you learn?\\\"\"},{\"id\":\"@ending_liana.plant_diaries\",\"title\":\"\\\"Did you plant the diaries in the Archives?\\\"\"},{\"id\":\"@ending_liana.i_dont_believe\",\"title\":\"\\\"I don't believe you.\\\"\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_4.water\":{\"id\":\"k_4.water\",\"goTo\":[{\"id\":\"k_4.thanks\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You pour a cup of hot water. K- drinks.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks.\\\"\"}]},\"root.game_over\":{\"id\":\"root.game_over\",\"viewIf\":{\"$code\":\"return ((Q['started'] || 0)===1);\"},\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"root\":{\"id\":\"root\",\"type\":\"scene\",\"title\":\"Root Scene\",\"newPage\":true,\"goTo\":[{\"id\":\"main\",\"predicate\":{\"$code\":\"return ((Q['started'] || 0)===1);\"}},{\"id\":\"root.start\",\"predicate\":{\"$code\":\"return ((Q['started'] || 0)===0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.maybe_fine\":{\"id\":\"s_1.maybe_fine\",\"goTo\":[{\"id\":\"s_1.s_hungry\"}],\"content\":{\"content\":\"Maybe it will turn out fine.\",\"type\":\"paragraph\"}},\"a_generic.just_like_before\":{\"id\":\"a_generic.just_like_before\",\"goTo\":[{\"id\":\"a_generic.k_q\",\"predicate\":{\"$code\":\"return (((Q['k_path'] || 0) >= 3) && ((Q['a_knows_k'] || 0)===0));\"}}],\"options\":[{\"id\":\"@a_generic.need_more\",\"title\":\"\\\"I need more money.\\\"\"},{\"id\":\"@a_generic.nothing_like_before\",\"title\":\"\\\"It's nothing like before.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's just like before, isn't it?\\\", she says. \\\"Just like when we were...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She is silent for a moment.\"}]},\"k_3.i_guess_meet\":{\"id\":\"k_3.i_guess_meet\",\"options\":[{\"id\":\"@k_3.k_3_meet\",\"title\":\"K- returns.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I suppose...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- makes a thin smile. \\\"That's great.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Once S- is ready, the two of them leave. You are only left alone for approximately 30 minutes before K- returns, during which time you lay on the bed, mind entranced in the past.\"}]},\"entertainment.game_4\":{\"id\":\"entertainment.game_4\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"You play a now-banned, formerly controversial game developed during the Uprising. It is a role playing game about a militarized polycule that does battle against the Guards and security forces, gaining experience as they kill more enemies. It was praised for having excellent lavernean representation, not a surprise given its development team, who are now mostly known to have died in the Uprising.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"You wonder if you could encode this game in DNA.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['games_played'] || 0)===1);\"}}]}},\"a_1.forget_it\":{\"id\":\"a_1.forget_it\",\"options\":[{\"id\":\"@a_1.dial\",\"title\":\"Dial the number.\"},{\"id\":\"@main\",\"title\":\"Forget about calling him, for real this time.\"}],\"content\":{\"content\":\"Maybe you have never forgiven him. Have you? Or is there some other reason\",\"type\":\"paragraph\"}},\"a_2.too_old\":{\"id\":\"a_2.too_old\",\"options\":[{\"id\":\"@a_2.not_deviant\",\"title\":\"\\\"I'm not a deviant.\\\"\"},{\"id\":\"@a_2.i_am_boring\",\"title\":\"\\\"I'm sorry for being so boring.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Aren't you too old to wear striped thigh highs in public?\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- laughs. \\\"What? I'm barely 40. That's not that old, is it? Anyway, what's the point of being a deviant if you're going to be boring all the time?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You are all too conscious of your plain gray skirt and baggy blue jacket.\"}]},\"a_3.transactional\":{\"id\":\"a_3.transactional\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\"}],\"options\":[{\"id\":\"@a_3.yes_it_did\",\"title\":\"\\\"Yes, it did.\\\"\"},{\"id\":\"@a_3.need_more\",\"title\":\"\\\"I need more money, actually.\\\"\"},{\"id\":\"@a_3.why\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"All relationships are transactional. Love is a product of the mutually beneficial exchange of resources.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- smirks. \\\"Then if I pay you to love me, you would love me?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You shrug. \\\"The resources come first. The emotions can develop later. So... yes.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Here's a hundred dollars, then.\\\" She is half-joking, or something like that. \\\"Did your love for me increase?\\\"\"}]},\"a_call.thats_creepy\":{\"id\":\"a_call.thats_creepy\",\"options\":[{\"id\":\"@a_call.dont_want_help\",\"title\":\"\\\"Actually, I don't want your help.\\\"\"},{\"id\":\"@a_call.pay_rent\",\"title\":\"\\\"You can help me pay rent...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"That's creepy.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry. But can I still help?\\\"\"}]},\"archives.uprising\":{\"id\":\"archives.uprising\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_hospital.working\":{\"id\":\"ending_hospital.working\",\"goTo\":[{\"id\":\"ending_hospital.ending_c\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_k.power_of\":{\"id\":\"ending_k.power_of\",\"options\":[{\"id\":\"@ending_k.more_like_it\",\"title\":\"\\\"That's more like it.\\\"\"},{\"id\":\"@ending_k.not_good_enough\",\"title\":\"\\\"That's not good enough...\\\"\"},{\"id\":\"@ending_k.easy_for_you\",\"title\":\"\\\"Easy for you to say.\\\"\"},{\"id\":\"@ending_k.what_about_job\",\"title\":\"\\\"What about quitting your job?\\\"\"}],\"content\":{\"content\":\"\\\"Okay, fine. Maybe you don't believe in the power of love, but what about the power of probability? Based on a sample of households in similar situations to us, there is a less than 10% chance of being affected by state persecution. We'll be fine. S- will be fine.\\\"\",\"type\":\"paragraph\"}},\"eviction.redistribute\":{\"id\":\"eviction.redistribute\",\"options\":[{\"id\":\"@eviction.where_else\",\"title\":\"\\\"Where else can I go?\\\"\"},{\"id\":\"@eviction.where_fuck\",\"title\":\"\\\"Where the fuck else can I go?\\\"\"}],\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-1\",\"content\":\"You need to redistribute their wealth\"},\" is a thought you have, but it is not useful in the short term.\"]}},\"food.takeout_do_2\":{\"id\":\"food.takeout_do_2\",\"title\":\"Takeout\",\"tags\":[\"takeout\"],\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - (Q['takeout_cost'] || 0);\\nQ['food'] = (Q['food'] || 0) + 2;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You take the trolleys to visit your favourite restaurant near the university.\"},{\"type\":\"paragraph\",\"content\":\"It costs $20 for enough food to last 2 days.\"}]},\"illness_2.power\":{\"id\":\"illness_2.power\",\"content\":{\"content\":\"No. Liana would never tell you \\\"mind over matter\\\" or some pointless cliche like that. But maybe... maybe it can work, just this once. But only once.\",\"type\":\"paragraph\"}},\"illness_2\":{\"id\":\"illness_2\",\"type\":\"scene\",\"title\":\"The Illness\",\"subtitle\":\"An inexorable progression.\",\"viewIf\":{\"$code\":\"return (((((Q['stress'] || 0) >= ((4 * (Q['stress_threshold'] || 0)) / 5)) && ((Q['illness_seen'] || 0)===1)) && ((Q['day_minor'] || 0)===0)) && ((Q['day_major'] || 0)===0));\"},\"frequency\":1000,\"priority\":10,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['illness_seen'] = 2;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 2;\"}],\"tags\":[\"major\"],\"options\":[{\"id\":\"@illness_2.death\",\"title\":\"It is a fear of death.\"},{\"id\":\"@illness_2.liana\",\"title\":\"What would Liana Xu do?\"},{\"id\":\"@illness_2.pills\",\"title\":\"Take medicine.\"},{\"id\":\"@illness_2.rice\",\"title\":\"Drink rice porridge.\"}],\"content\":{\"content\":\"The illness continues to progress. It seems to be getting worse. Your mind is in a state of fear, but of what, you can only begin to conceptualize.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"k_1.dial_2\":{\"id\":\"k_1.dial_2\",\"options\":[{\"id\":\"@k_1.dial_3\",\"title\":\"Make the call.\"},{\"id\":\"@k_1.quit\",\"title\":\"Fuck it. You will not do this today.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"You simulate the likely outcomes of your call. Worst case: she says fuck you and doesn't talk to you again. No, that is wrong. Worst case: she realizes that you have regressed to the mental state of a broken woman-child and calls you out for all of your flaws. You abandoned her. You abandoned your child. She was the victim, and you are the villain, yet another example of how \",{\"type\":\"emphasis-1\",\"content\":\"women\"},\" like you deserve to be ostracized.\"]},{\"type\":\"paragraph\",\"content\":\"If that happened, death would be your best option.\"}]},\"k_2.anticipation\":{\"id\":\"k_2.anticipation\",\"options\":[{\"id\":\"@k_2.check_respirator\",\"title\":\"Check your respirator.\"},{\"id\":\"@k_2.check_outfit\",\"title\":\"Check your outfit.\"},{\"id\":\"@k_2.check_surroundings\",\"title\":\"Check your surroundings.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Founders Square was dedicated to Liana Xu, a posthuman and one of the founders of this city. It acts as the central square. It was a 30-minute trip by trolley, and presently you are sitting on a bench.\"},{\"type\":\"paragraph\",\"content\":\"You have not been able to do much of anything today, your mind so preoccupied on your meeting with K- and S-.\"}]},\"k_call.yes_take\":{\"id\":\"k_call.yes_take\",\"onArrival\":[{\"$code\":\"Q['k_path'] = 1;\\nQ['k_day'] = ((Q['day'] || 0) - 1);\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Fine, I can take care of him...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Great! I'll see you tomorrow in Founders Square at 5PM.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She hangs up. You are left alone with your thoughts once more.\"}]},\"k_generic.of_course_clean\":{\"id\":\"k_generic.of_course_clean\",\"options\":[{\"id\":\"@k_generic.sure_60\",\"title\":\"\\\"Thank you.\\\"\"},{\"id\":\"@k_generic.keep_money\",\"title\":\"\\\"Keep the money.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Of course, you help her. For whatever reason, it is easier to clean someone else's house than it is to clean your own. You draw upon reserves of energy you never knew you had for the purpose of sweeping the floor. Clumps of K-'s coarse black hair and S-'s fine hair lay strewn all over. By the time you are done, the rooms look rather more presentable.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, I can pay you,\\\" says K-. \\\"Is $60 okay?\\\"\"}]},\"medicine.ask_a\":{\"id\":\"medicine.ask_a\",\"subtitle\":\"Would she be willing?\",\"viewIf\":{\"$code\":\"return ((Q['a_path'] || 0) >= 2);\"},\"options\":[{\"id\":\"@medicine.ask_a_2\",\"title\":\"Ask her.\"},{\"id\":\"@medicine.med_options\",\"title\":\"Do something else.\"}],\"content\":{\"content\":\"A- is a doctor. She likely has access to medicine.\",\"type\":\"paragraph\"}},\"mutual_aid.just_go\":{\"id\":\"mutual_aid.just_go\",\"viewIf\":{\"$code\":\"return ((Q['ma_checklist'] || 0) >= 3);\"},\"options\":[{\"id\":\"@mutual_aid.want_food\",\"title\":\"\\\"I just need food...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The address on the flyer leads to a public park in the Erie District. There is a crowd already gathered. At least dozens of people mill about the lichen-covered ground. Volunteers stand behind tables, stirring vats of rice soup. At least it is not algal mush.\"},{\"type\":\"paragraph\",\"content\":\"You must have looked out of place, because a man in a volunteer's uniform shouts at you. \\\"Hey! We can help you here.\\\" He points towards a table. \\\"Do you need food, medicine, anything else?\\\"\"},{\"type\":\"paragraph\",\"content\":[\"He is most likely an elliotian. And you can tell that he \",{\"type\":\"emphasis-1\",\"content\":\"recognized\"},\" you immediately. It has been a while since this sort of occurrence; you do not know if said occurrence has changed the parameters of this social interaction.\"]}]},\"notes.arcology\":{\"id\":\"notes.arcology\",\"title\":\"The Arcology\",\"goTo\":[{\"id\":\"notes.history\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The Arcology is your home. There are others like it on Earth, but none have been in contact for the past ten years, ever since the Cataclysm. It is a sealed city with a population of over ten million, built on top of a previous trans-national metropolitan area that spanned a wide waterway. Half of the city has been abandoned since the Cataclysm, resulting in increased crowding in the remaining portions of the city.\"},{\"type\":\"paragraph\",\"content\":\"The Arcology's history is a tangled mess of theories and competing threads. There are even debates on how many years has passed since its construction. In some ways its history is even less studied and less known than the pre-war history of the united humanity. Only in the past decades, with the rediscovery of DNA storage, has its history begun to be unraveled.\"}]},\"one.10_years_ago\":{\"id\":\"one.10_years_ago\",\"goTo\":[{\"id\":\"one.500_years_ago\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"online_montage.cn2_1\":{\"id\":\"online_montage.cn2_1\",\"content\":{\"type\":\"paragraph\",\"content\":[\"They're talking about \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\", or \",{\"type\":\"emphasis-1\",\"content\":\"people like you\"},\". This is your fate if your gender history is discovered.\"]}},\"ritual.tradition\":{\"id\":\"ritual.tradition\",\"viewIf\":{\"$code\":\"return (((Q['ritual_scratched'] || 0)===1) && ((Q['ritual_burnt'] || 0)===1));\"},\"options\":[{\"id\":\"@ritual.others\",\"title\":\"Visit the other graves.\"},{\"id\":\"@ritual.think_about_lily\",\"title\":\"Think about Lily.\"}],\"content\":{\"content\":\"You have cobbled together your rituals out of the fragments of long-dead cultures. Traditions long forgotten. Peoples long gone. A history alienated from you by hundreds of years and the end of the world. Their memories going up in flame in the metal bowl, like the afterlife money. You should have five days of mourning. You should be wearing a funeral shroud. Lily should have a mausoleum with terra cotta guards to accompany her into the afterlife to protect her from evil...\",\"type\":\"paragraph\"}},\"anxiety.call_for_help\":{\"id\":\"anxiety.call_for_help\",\"options\":[{\"id\":\"@anxiety.a_helps\"},{\"id\":\"@anxiety.k_helps\"},{\"id\":\"@anxiety.c_helps\"},{\"id\":\"@anxiety.l_helps\"},{\"id\":\"@anxiety.no_help\",\"title\":\"No one.\"}],\"content\":{\"content\":\"Who can you even call?\",\"type\":\"paragraph\"}},\"data.file\":{\"id\":\"data.file\",\"options\":[{\"id\":\"@data.s\",\"title\":\"Class A: High-priority scientific or technical information.\"},{\"id\":\"@data.l\",\"title\":\"Class B: Literature.\"},{\"id\":\"@data.d\",\"title\":\"Class C: Personal or private information.\"},{\"id\":\"@data.o\",\"title\":\"Class D: Official government documents.\"},{\"id\":\"@data.m\",\"title\":\"Class E: Miscellaneous.\"},{\"id\":\"@data.keep\",\"title\":\"On second thought, you'll keep it for yourself.\"},{\"id\":\"@data.discard\",\"title\":\"On second thought, you'll discard it.\"}],\"content\":{\"content\":\"How do you wish to file the retrieved dataset?\",\"type\":\"paragraph\"}},\"ending_a.rebound\":{\"id\":\"ending_a.rebound\",\"options\":[{\"id\":\"@ending_a.where_run_away\",\"title\":\"\\\"Where would we run away?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So I'm just your rebound?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Don't put it like that!\\\"\"}]},\"ending_liana.i_\":{\"id\":\"ending_liana.i_\",\"goTo\":[{\"id\":\"ending_liana.want_to_go\"}],\"onArrival\":[{\"$code\":\"Q['liana_qs'] = (Q['liana_qs'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"\\\"I...\\\" You cannot say anything. You do not know what to say. A part of you wants to cry. Another part wants to laugh.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"k_4.tea\":{\"id\":\"k_4.tea\",\"goTo\":[{\"id\":\"k_4.thanks\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"She has concentrated tea powder. You boil a pot of hot water, and mix the tea. K- drinks.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks.\\\"\"}]},\"s_1.s_hungry\":{\"id\":\"s_1.s_hungry\",\"options\":[{\"id\":\"@s_1.food_home\",\"title\":\"\\\"We have food at home.\\\"\"},{\"id\":\"@s_1.no_food_no_money\",\"title\":\"\\\"We do not have food at home, and we do not have enough money to go out to eat.\\\"\"},{\"id\":\"@s_1.go_burgers\",\"title\":\"\\\"Alright. Let's go.\\\"\"},{\"id\":\"@s_1.why_burgers\",\"title\":\"\\\"Why do you want burgers?\\\"\"},{\"id\":\"@s_1.burgers_propaganda\",\"title\":\"\\\"The humble so-called 'burger' is a piece of the Ruling Party's propaganda campaign to legitimize their rule via continuity with the American Empire.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I'm hungry,\\\" he says. \\\"Can we get burgers?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Burgers are not a part of your typical diet; your typical meals consist of rice and beans porridge. But perhaps you could visit a restaurant.\"}]},\"a_generic.need_more\":{\"id\":\"a_generic.need_more\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\"}],\"options\":[{\"id\":\"@a_generic.not_enough\",\"title\":\"\\\"That's not enough.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I need more money for rent.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, sure. Here's another 100.\\\"\"}]},\"k_3.no_meet\":{\"id\":\"k_3.no_meet\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, I'm too busy today.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's fine. Just fine I guess.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- and S- leave.\"}]},\"entertainment.tv_1\":{\"id\":\"entertainment.tv_1\",\"content\":{\"content\":\"Now playing is a film about a woman who disguises herself as a man to join the Guards during the Uprising. The villain is a lavernean with cartoonishly exaggerated features and a constantly visible bulge.\",\"type\":\"paragraph\"}},\"a_1.dial\":{\"id\":\"a_1.dial\",\"options\":[{\"id\":\"@a_1.call_2\",\"title\":\"This is fine.\"},{\"id\":\"@a_1.back\",\"title\":\"No. Do something else. Anything but this.\"}],\"content\":{\"content\":\"Right. Dial the numbers. Make the call. It is fine. You parted amicably. He never banished you from his new life, even after the Uprising. You met his wife. She didn't hate you, probably.\",\"type\":\"paragraph\"}},\"a_2.not_deviant\":{\"id\":\"a_2.not_deviant\",\"options\":[{\"id\":\"@a_2.hypocrite\",\"title\":\"\\\"Hypocrite.\\\"\"},{\"id\":\"@a_2.are_you_still\",\"title\":\"\\\"So, are you still a...?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You shrug, and look away from her. \\\"I don't like to think of myself as a deviant. That's just reactionary propaganda.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She laughs again. \\\"Hey, I'm reclaiming it! If they're going to call us monsters no matter what we do, what's the point of pretending to be respectable?\\\" You cringe at the reference to now-outdated discourse, even though you started it.\"}]},\"a_3.yes_it_did\":{\"id\":\"a_3.yes_it_did\",\"options\":[{\"id\":\"@a_3.why\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Yes, it did.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- laughs. \\\"God, if only it were so easy.\\\"\"}]},\"a_call.dont_want_help\":{\"id\":\"a_call.dont_want_help\",\"options\":[{\"id\":\"@a_call.dont_want_2\",\"title\":\"\\\"Yes, I'm sure.\\\"\"},{\"id\":\"@a_call.pay_rent\",\"title\":\"\\\"You can help me pay rent...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Actually, I don't want your help.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure? Don't worry about me. I have enough money to help you.\\\"\"}]},\"archives.laverneans\":{\"id\":\"archives.laverneans\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"archives\":{\"id\":\"archives\",\"type\":\"scene\",\"title\":\"Archives\",\"subtitle\":\"Your own historical archives.\",\"goTo\":[{\"id\":\"archives.archive_choices\"}],\"content\":{\"content\":\"You keep your own archives on a magdisk. It is a collection of notes and writings on various topics that you have appended to over the past 20 years. Most of it is utterly banal.\",\"type\":\"paragraph\"}},\"ending_hospital.ending_c\":{\"id\":\"ending_hospital.ending_c\",\"achievement\":\"ending_4\",\"options\":[{\"id\":\"@ending_hospital.ending_c_epilogue\",\"title\":\"End.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Yes, I'll continue working here.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Great! You know you're one of the best DNA archivists we have, right? To be fair we only have about five, including us, but...\\\" C- shakes her head. \\\"Just, take it easy, okay? I'll try to not send you to the hospital anymore.\\\"\"}]},\"ending_k.what_about_job\":{\"id\":\"ending_k.what_about_job\",\"viewIf\":{\"$code\":\"return ((Q['k_path'] || 0) >= 4);\"},\"options\":[{\"id\":\"@ending_k.move_in\",\"title\":\"\\\"Fine. I'll move in with you.\\\"\"},{\"id\":\"@ending_k.move_in_evicted\",\"title\":\"\\\"I'll move in with you.\\\"\"},{\"id\":\"@ending_k.no_move_in\",\"title\":\"\\\"Sorry, but I can't do it.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What about quitting your job? Will you still have enough money?\\\"\"},{\"type\":\"paragraph\",\"content\":[\"\\\"As it turns out, I could just make a horizontal transfer to a normal division with only a 10% pay cut. It's bad, but not \",{\"type\":\"emphasis-1\",\"content\":\"that\"},\" bad. And if this one turns out to be horrible too, well, we'll see once we get there. So it'll be fine. Take a chance.\\\"\"]}]},\"eviction.where_else\":{\"id\":\"eviction.where_else\",\"goTo\":[{\"id\":\"eviction.a_where\"}],\"content\":{\"content\":\"\\\"Where else can I go?\\\"\",\"type\":\"paragraph\"}},\"food.cook\":{\"id\":\"food.cook\",\"subtitle\":{\"content\":[\"$\",{\"type\":\"insert\",\"insert\":0},\"-\",{\"type\":\"insert\",\"insert\":1},\", lasts 2-7 days.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return ((Q['grocery_cost'] || 0) - 25);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return ((Q['grocery_cost'] || 0) + 5);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['stress'] || 0) <= ((3 * (Q['stress_threshold'] || 0)) / 4));\"},\"viewIf\":{\"$code\":\"return ((Q['money'] || 0) >= ((Q['grocery_cost'] || 0) + 5));\"},\"unavailableSubtitle\":\"You don't have the energy for this.\",\"options\":[{\"id\":\"@food.cook_2\",\"title\":\"Do it.\"},{\"id\":\"@food.food_options\",\"title\":\"Do something else.\"}],\"content\":{\"content\":\"Perhaps a visit to the grocery store is in order. You could buy a supply of shelf-stable products to cook for yourself. The downside is the effort of walking and carrying the groceries, and that you could be seen.\",\"type\":\"paragraph\"}},\"k_1.quit\":{\"id\":\"k_1.quit\",\"content\":[{\"type\":\"paragraph\",\"content\":\"No. This will not turn out well. You had better save your energy for another time.\"},{\"type\":\"paragraph\",\"content\":\"Except there is no more energy to be saved. Your head spins. Your mouth aches from clenching your jaw. A half-eaten meal churns in your stomach, ready to be expelled. You are tired.\"}]},\"k_2.check_respirator\":{\"id\":\"k_2.check_respirator\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['k2_checks'] = (Q['k2_checks'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_2.check_outfit\",\"title\":\"Check your outfit.\"},{\"id\":\"@k_2.check_surroundings\",\"title\":\"Check your surroundings.\"},{\"id\":\"@k_2.wait_for_k\",\"title\":\"You finally see her.\"}],\"content\":{\"content\":\"Idly, you touch your respirator with your gloved fingers. Your glasses are not fogging up, so the fit must still be adequate. You are the only person wearing a respirator here, as usual, but most others do not need to hide their face as you do.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"k_call.no_take\":{\"id\":\"k_call.no_take\",\"options\":[{\"id\":\"@k_call.yes_take\",\"title\":\"\\\"Fine, I can take care of him...\\\"\"},{\"id\":\"@k_call.no_take_2\",\"title\":\"\\\"Sorry, I can't...\\\"\"},{\"id\":\"@k_call.why_now\",\"title\":\"\\\"Why are you asking me?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't know, sorry...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure? I'll pay you a hundred dollars. It'll be fine. S- misses you. He wants to see you.\\\"\"}]},\"k_generic.sure_60\":{\"id\":\"k_generic.sure_60\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 60;\"}],\"content\":{\"content\":\"\\\"Thank you.\\\"\",\"type\":\"paragraph\"}},\"medicine.ask_a_2\":{\"id\":\"medicine.ask_a_2\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 50;\"}],\"options\":[{\"id\":\"@medicine.buy\",\"title\":\"Refill at the pharmacy.\"},{\"id\":\"@medicine.none\",\"title\":\"Don't bother. Just go without.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You make the call.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, it's a controlled substance so I can't just grab some, but I can give you money to buy your prescription. Is that okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure...\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- has given you $50.\"}]},\"mutual_aid.want_food\":{\"id\":\"mutual_aid.want_food\",\"options\":[{\"id\":\"@mutual_aid.take_food\",\"title\":\"Take the food, and then see R-.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I just need food...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure, go on ahead!\\\" He smiles. \\\"Take what you need. By the way, you look familiar. Do you happen to know R-, by any chance?\\\"\"},{\"type\":\"paragraph\",\"content\":[\"In fact, you did know R-. \",{\"type\":\"conditional\",\"content\":\"You even saw her in one of the DNA datasets. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"You remember her from CityNet before the Uprising; she was somewhat popular among lavernean circles. She was an acquaintance, not exactly a friend, and you fully expected that she would hate you for your choices. \",\"predicate\":1},\" You did not know that she survived.\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Kind of,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Great! She's one of the people organizing this. I'm sure she would love to see you, but first take some food. My name is L-, by the way.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hi, L-.\\\"\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rosa_seen'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rosa_seen'] || 0)===0);\"}}]}},\"notes.cataclysm\":{\"id\":\"notes.cataclysm\",\"title\":\"The Cataclysm\",\"goTo\":[{\"id\":\"notes.history\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The Cataclysm was when the dome that had protected the city's surface failed. Entities from the wastelands outside had infiltrated in, half-living monsters created by both sides towards the end of the Posthuman War. A less visible but greater threat were the nanoplagues, engineered diseases also created by both sides near the end of the War. Most large non-human animals died. Communications and transportation outside an approximately 100km radius was also severed for unknown reasons possibly related to the dome's failure.\"},{\"type\":\"paragraph\",\"content\":\"You and most others evacuated to the undercity, the space under the old city platform, directly adjacent to the Earth. Despite the lower quality of the housing stock, rent was substantially increased following the evacuation.\"}]},\"one.500_years_ago\":{\"id\":\"one.500_years_ago\",\"maxVisits\":1,\"options\":[{\"id\":\"@one.out\",\"title\":\"Stop dissociating.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-1\",\"content\":\"The memories blur together in the Archivist's mind, five hundred years of this city's history twisted into one knot of fictitious time. Wars. Cataclysms. Uprisings. The construction and puncture of the dome. Birds falling out of the sky. Coup announcements on the radio. Fires in the streets. Evacuations downwards. Isolated facts resolve themselves without context. There are no more non-human mammals. The surface is irradiated. Population down twenty percent. No entrance or exit.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"And none of this matters.\"}],\"countVisitsMax\":1},\"online_montage.cn3\":{\"id\":\"online_montage.cn3\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Male prostitute attacks Guards after found to have been impersonating a woman.\"},\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"CW: transphobia, slurs\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 1;\"}],\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"options\":[{\"id\":\"@online_montage.cn3_v\",\"title\":\"Bella, her name was.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Male prostitute attacks Guards after found to have been impersonating a woman. Video: (link)\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": glad that fag got what was coming to him.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": lmao idiots can't tell apart real women\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": all real women detest men who pretend to be women.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": long live the guards!!!\"]},\"\"]},{\"type\":\"paragraph\",\"content\":\"From one second of the video, you realize that you knew her. She was a lavernean, like you.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}}]}},\"ritual.think_about_lily\":{\"id\":\"ritual.think_about_lily\",\"options\":[{\"id\":\"@ritual.others\",\"title\":\"Visit the other graves.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Lily was an acquaintance, not a friend. She worked in a shop and did sex work on the side. You did not know her well; she was an omnipresence on CityNet before the anti-radicalization policies, but you had only spoken face-to-face a handful of times at political events.\"},{\"type\":\"paragraph\",\"content\":\"She died before the Uprising. She would have almost certainly thought you a traitor for submitting yourself to the authoritarian capitalist patriarchal system.\"}]},\"anxiety.a_no_answer\":{\"id\":\"anxiety.a_no_answer\",\"options\":[{\"id\":\"@anxiety.k_helps\"},{\"id\":\"@anxiety.c_helps\"},{\"id\":\"@anxiety.l_helps\"},{\"id\":\"@anxiety.no_help\",\"title\":\"No one is going to help.\"}],\"content\":{\"content\":\"A- doesn't answer. Of fucking course.\",\"type\":\"paragraph\"}},\"data.s\":{\"id\":\"data.s\",\"unavailableSubtitle\":\"Definitely not.\",\"onArrival\":[{\"$code\":\"Q.chosen_data_types.push('science');\"}],\"goTo\":[{\"id\":\"data.data_filed\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.where_run_away\":{\"id\":\"ending_a.where_run_away\",\"options\":[{\"id\":\"@ending_a.no_other_options\",\"title\":\"You have no other options but to trust her.\"},{\"id\":\"@ending_a.leap_of_faith\",\"title\":\"Take the leap of faith.\"},{\"id\":\"@ending_a.kiss_a\",\"title\":\"Kiss her, sealing the deal.\"},{\"id\":\"@ending_a.no_can_do\",\"title\":\"You can't do this.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Where would we run away? There's nowhere to go...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I don't know. The city is a big place. I'm sure we can find somewhere. Worst case, I'll pretend to be a man again and you can be my new girlfriend.\\\"\"}]},\"ending_liana.want_to_go\":{\"id\":\"ending_liana.want_to_go\",\"goTo\":[{\"id\":\"ending_liana.go_questions\"}],\"content\":{\"content\":\"\\\"How about this,\\\" Liana continues. \\\"How about you come with me? We can leave this sorry place and go to space, to join the rest of our civilization. You can become a new person. You can become posthuman if you'd like, or stay baseline, but that might be hard. Leave it all behind. Save your life. Screw this city.\\\"\",\"type\":\"paragraph\"}},\"k_4.thanks\":{\"id\":\"k_4.thanks\",\"options\":[{\"id\":\"@k_4.no_idea\",\"title\":\"You have no idea what she is talking about.\"},{\"id\":\"@k_4.comfort\",\"title\":\"But you want to comfort her.\"},{\"id\":\"@k_4.must_comfort\",\"title\":\"How do you comfort her, exactly?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Finally she turns off the monitor, and faces you.\"},{\"type\":\"paragraph\",\"content\":\"\\\"We were doing an experiment in the lab,\\\" she begins. \\\"Do you know what really happened in the Cataclysm?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You probably know more than me...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"The entity attacks and nanoplagues and infiltrations were just the start of it. It wasn't a natural occurrence. The Guards, and the security forces, and...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"There's all sorts of shit going on here. If I don't do the experiments I'll be fired and blacklisted and starve. And if I do the experiments, I'll be complicit in murder and the perpetuation of the current fucked-up-ness. Am I willing to quit my job and get blacklisted from every future job? No, because the next person will do the same thing and he isn't even gonna have a second thought!\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"And you know what I did? I tried praying to God of all things. Well guess what, God isn't fucking listening! He isn't fucking helping!\\\"\"},{\"type\":\"paragraph\",\"content\":\"She is crying. You hand her a tissue. \\\"Thanks.\\\"\"}]},\"s_1.burgers_propaganda\":{\"id\":\"s_1.burgers_propaganda\",\"maxVisits\":1,\"options\":[{\"id\":\"@s_1.food_home\",\"title\":\"\\\"We have food at home.\\\"\"},{\"id\":\"@s_1.no_food_no_money\",\"title\":\"\\\"We do not have food at home, and we do not have enough money to go out to eat.\\\"\"},{\"id\":\"@s_1.go_burgers\",\"title\":\"\\\"Alright. Let's go.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"The humble so-called 'burger' is a piece of the Ruling Party's propaganda campaign to legitimize their rule via continuity with the American Empire.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, um... sorry. I was talking to myself.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Aren't you a grown-up?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Supposedly.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Great. He thinks you're a loser. An accurate assessment, but a painful one nevertheless.\"}],\"countVisitsMax\":1},\"a_generic.not_enough\":{\"id\":\"a_generic.not_enough\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 200;\"}],\"options\":[{\"id\":\"@a_generic.walk_ends\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"That's not enough.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh? How expensive is your rent, really?\\\"\"},{\"type\":\"paragraph\",\"content\":[\"\\\"It's $\",{\"type\":\"insert\",\"insert\":0},\" per week.\\\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Per week? Wow. I've never heard of anyone being charged per week. Fine. Here's two hundred. I'm not made of money, you know.\\\"\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"It is still not enough, unfortunately, but you do not press her.\",\"predicate\":1}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['money'] || 0) < ((Q['rent'] || 0) - 200));\"}}]}},\"k_3.k_3_meet\":{\"id\":\"k_3.k_3_meet\",\"newPage\":true,\"options\":[{\"id\":\"@k_3.why_asking\",\"title\":\"\\\"Why are you asking?\\\"\"},{\"id\":\"@k_3.bored\",\"title\":\"\\\"Are you bored already?\\\"\"},{\"id\":\"@k_3.its_fine\",\"title\":\"\\\"It's fine.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You do not remember when you gave K- the keys to your apartment, but it was well prior to this encounter. The two of you had set a heartbeat system during your first nanoplague scare, in which if you did not send a message to her for three days, she would go to your apartment and check if you were still alive. That was four years ago.\"},{\"type\":\"paragraph\",\"content\":\"She enters your room without knocking.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm back.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I can tell.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sits on the bed, just barely missing your arm.\"},{\"type\":\"paragraph\",\"content\":\"\\\"So. How's life?\\\"\"}]},\"entertainment.tv_2\":{\"id\":\"entertainment.tv_2\",\"content\":{\"content\":\"There is a speech by a Ruling Party politician. \\\"We are the true heirs of the American Empire... We will not repeat the decadence and so-called toleration that led to the transhumanist order...\\\" You tune out.\",\"type\":\"paragraph\"}},\"a_1.back\":{\"id\":\"a_1.back\",\"content\":{\"content\":\"You can't do this. You can't make the call.\",\"type\":\"paragraph\"}},\"a_2.hypocrite\":{\"id\":\"a_2.hypocrite\",\"options\":[{\"id\":\"@a_2.are_you_still\",\"title\":\"\\\"So, are you still a...?\\\"\"},{\"id\":\"@a_2.what_do\",\"title\":\"\\\"What do you want to do?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Hypocrite.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She finally sits down next to you, and gives you a wistful expression. \\\"We're all just trying to live. We do what we have to, even if it isn't what we want to. But sometimes there are moments when we can, you know.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A lull in the conversation. The two of you stare at each other, A- smiling, you making who knows what facial expression.\"}]},\"a_3.need_more\":{\"id\":\"a_3.need_more\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\"}],\"options\":[{\"id\":\"@a_3.even_more\",\"title\":\"\\\"I need even more than this, actually.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I need more money, actually.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Alright. Here's another 100.\\\"\"}]},\"a_call.dont_want_2\":{\"id\":\"a_call.dont_want_2\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Yes, I'm sure. I don't want your help.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Okay. Well, I still really want to see you again. So if you change your mind or if you want to hang out, just let me know.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- hangs up, leaving you alone with your thoughts.\"}]},\"ending_hospital.ending_c_epilogue\":{\"id\":\"ending_hospital.ending_c_epilogue\",\"goTo\":[{\"id\":\"endings\"}],\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":\"Unfortunately, you still have a host of other troubles. Your illness will return. Your rent is still rising, with the eventual goal of your eviction.\"},{\"type\":\"paragraph\",\"content\":\"But those are problems for another day. At least you still have a job, and at least one human with concern for your well-being. Maybe C- can help with rent.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 4/9\"}}]},\"ending_hospital\":{\"id\":\"ending_hospital\",\"type\":\"scene\",\"newPage\":true,\"setBg\":\"black\",\"options\":[{\"id\":\"@ending_hospital.still_job\",\"title\":\"\\\"Can I keep my job?\\\"\"},{\"id\":\"@ending_hospital.not_your_fault\",\"title\":\"\\\"It's not your fault.\\\"\"},{\"id\":\"@ending_hospital.okay\",\"title\":\"\\\"Okay...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You awake in a hospital, in an unfamiliar bed, dressed in a blue gown, IV drip from your wrist. The window is dark. The interior lights are too bright.\"},{\"type\":\"paragraph\",\"content\":\"C- is here. It is the first time you have seen her since... since before your illness. She is more than ten years younger than you, and looks the part.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, Em. Sorry you got sick. I guess it's partly my fault for pushing you.\\\"\"}]},\"ending_k.more_like_it\":{\"id\":\"ending_k.more_like_it\",\"options\":[{\"id\":\"@ending_k.move_in\",\"title\":\"\\\"Fine. I'll move in with you.\\\"\"},{\"id\":\"@ending_k.move_in_evicted\",\"title\":\"\\\"I'll move in with you.\\\"\"},{\"id\":\"@ending_k.no_move_in\",\"title\":\"\\\"Sorry, but I can't do it.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"That's more like it.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- smiles. \\\"I knew you would believe in reason. You and I both believe in the power of the cost-benefit analysis.\\\"\"}]},\"eviction.where_fuck\":{\"id\":\"eviction.where_fuck\",\"goTo\":[{\"id\":\"eviction.a_where\"}],\"content\":{\"content\":\"\\\"Where the fuck else can I go?\\\"\",\"type\":\"paragraph\"}},\"food.cook_2\":{\"id\":\"food.cook_2\",\"maxChoices\":1,\"onArrival\":[{\"$code\":\"Q.post_trolley = window.randomSelect(['food.cook_2_1', 'food.cook_2_2', 'food.cook_2_3']);\\nQ.days_starved = 0;\"}],\"setBg\":\"images/windows_filtered_dithered.png\",\"options\":[{\"id\":\"#trolley\"}],\"content\":{\"content\":\"The nearest grocery store is a 20-minute trolley ride away.\",\"type\":\"paragraph\"}},\"k_1.dial_3\":{\"id\":\"k_1.dial_3\",\"options\":[{\"id\":\"@k_1.its_em\",\"title\":\"\\\"It's Em...\\\"\"},{\"id\":\"@k_1.k\",\"title\":\"\\\"K-?...\\\"\"},{\"id\":\"@k_1.hi\",\"title\":\"\\\"Hello...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You dial the digits on your touch-tone phone. It connects.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hello?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Her voice is familiar, still coarse and flat.\"}]},\"k_2.check_outfit\":{\"id\":\"k_2.check_outfit\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['k2_checks'] = (Q['k2_checks'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_2.check_respirator\",\"title\":\"Check your respirator.\"},{\"id\":\"@k_2.check_surroundings\",\"title\":\"Check your surroundings.\"},{\"id\":\"@k_2.wait_for_k\",\"title\":\"You finally see her.\"}],\"content\":{\"content\":\"You are wearing your standard leaving-your-apartment outfit: a long gray tweed skirt, a thick blue jacket that is too warm for the perpetual 16-degree climate but adequately conceals your body shape, and a respirator, with glasses and your unruly long hair hiding the rest of your face. Very little of your skin is visible, as is intended.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"k_call.no_take_2\":{\"id\":\"k_call.no_take_2\",\"onArrival\":[{\"$code\":\"Q['a_path'] = -1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, I can't take care of him...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Well. Okay then. I guess I'll talk to you later.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She hangs up. You are left alone with your thoughts once more.\"}]},\"k_generic.keep_money\":{\"id\":\"k_generic.keep_money\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Keep the money.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Well, okay.\\\"\"}]},\"medicine.none\":{\"id\":\"medicine.none\",\"subtitle\":\"You will be fine, probably.\",\"onArrival\":[{\"$code\":\"Q['medicine'] = 2;\\nQ['stress'] = (Q['stress'] || 0) + 3;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Fortunately, you have already undergone bottom surgery, so you are unlikely to experience physical masculinization. Unfortunately, hormone deprivation increases the risk of osteoporosis, and it seems to have the effect of making you feel worse in various difficult-to-describe ways that physicians do not acknowledge. And there are the medications for dealing with your persistent nanoplague symptoms that you still need to pick up.\"},{\"type\":\"paragraph\",\"content\":\"No matter. You will live.\"}]},\"mutual_aid.take_food\":{\"id\":\"mutual_aid.take_food\",\"onArrival\":[{\"$code\":\"Q['food'] = (Q['food'] || 0) + 2;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"options\":[{\"id\":\"@mutual_aid.name\",\"title\":\"\\\"How did you know my name?\\\"\"},{\"id\":\"@mutual_aid.hi_r\",\"title\":\"\\\"Hi, R-.\\\"\"},{\"id\":\"@mutual_aid.datasets\",\"title\":\"\\\"I read your DNA diaries.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You take a bowl of rice porridge. They did not add beans in it as you do, so the nutritional value is reduced. Nevertheless, it tastes better than the variety you make - smoother, more watery.\"},{\"type\":\"paragraph\",\"content\":\"As you finish eating, R- and L- approach, walking together. R- is a tall and broad woman with a head of curly black hair and an intense facial expression she seems to be desperately trying to soften.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hello, Emmeline Hsu,\\\" R- says.\"}]},\"notes.uprising\":{\"id\":\"notes.uprising\",\"title\":\"The Uprising\",\"goTo\":[{\"id\":\"notes.history\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The origin for the Uprising always lied in the Laverneans. Anti-nonbinary and anti-GSM policies had been gradually increasing, but the catalyst was a coup by the Guards (a paramilitary group and the de facto armed wing of the Ruling Party). The Uprising was launched on a broad anti-Ruling Party and pro-democracy platform, but the bulk of the armed participants were from various lavernean cliques and their immediate allies, who for the first time were somewhat unified towards a single goal. Even the other nonbinary cliques were divided on participation.\"},{\"type\":\"paragraph\",\"content\":\"In retrospect, the Uprising was a total failure, and accomplished the opposite of its goals.\"},{\"type\":\"paragraph\",\"content\":\"The casualties were a few hundred Guards and a handful of regular police and military on one hand, and thousands killed in reprisals on revolutionary holdouts and any lavernean who happened to be visible enough. Images of tall and imposing laverneans clad in fetish-gear-cum-improvised-body-armor with rifles slung on their backs terrified the masses, and provided the definitive images of the Uprising and the justification for the elimination of its participants, and more broadly speaking, the lavernean population as a whole.\"}]},\"one.out\":{\"id\":\"one.out\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['introduced'] = 1;\\n\\n// change style to show boxes around choices.\"}],\"options\":[{\"id\":\"@one.no_longer\",\"title\":\"You are not even an Archivist any more.\"}],\"content\":{\"content\":\"The past does not exist. Only the present is real.\",\"type\":\"paragraph\"}},\"online_montage.cn3_v\":{\"id\":\"online_montage.cn3_v\",\"options\":[{\"id\":\"@online_montage.cn3_v2\",\"title\":\"Keep watching.\"}],\"content\":{\"content\":\"She was your friend, once, until she started hating you (there were many such cases). She was a graduate student in history, once. She went to the same doctor as you, once. Like you, she tried to ride out the Uprising in safety rather than take part. And now she's dead and you're somehow still alive.\",\"type\":\"paragraph\"}},\"ritual.others\":{\"id\":\"ritual.others\",\"options\":[{\"id\":\"@ritual.why\",\"title\":\"Why did you survive while they did not?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Out of the Laverneans you knew before the Uprising, most have passed, and the others are missing.\"},{\"type\":\"paragraph\",\"content\":\"Lily. Luna. Eve. Chloe. Emily. You write their names on scraps of paper and toss them into the bowl of flames. You scratch at the false names on their tombstones. No one is here. No one to see you stalk the graveyard like a ghost.\"}]},\"anxiety.a_answer\":{\"id\":\"anxiety.a_answer\",\"options\":[{\"id\":\"@ending_a\",\"title\":\"She saves your life.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"A- answers.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, Em, I'm coming there right now.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- arrives alone. She sets up an IV drip, and forces water down your throat. You are feeling slightly better, enough to see that she is wearing her blue doctor's scrubs.\"},{\"type\":\"paragraph\",\"content\":\"\\\"The nanoplague sucks, doesn't it?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah,\\\" you cough out.\"}]},\"data.l\":{\"id\":\"data.l\",\"unavailableSubtitle\":\"Definitely not.\",\"onArrival\":[{\"$code\":\"Q.chosen_data_types.push('literature');\"}],\"goTo\":[{\"id\":\"data.data_filed\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.no_other_options\":{\"id\":\"ending_a.no_other_options\",\"viewIf\":{\"$code\":\"return ((Q['evicted'] || 0)===1);\"},\"options\":[{\"id\":\"@ending_a.end_r\",\"title\":\"End.\"}],\"content\":{\"content\":\"Your other option is homelessness. \\\"Let's do it,\\\" you say.\",\"type\":\"paragraph\"}},\"ending_liana.go_questions\":{\"id\":\"ending_liana.go_questions\",\"options\":[{\"id\":\"@ending_liana.why_go\",\"title\":\"\\\"Why?\\\"\"},{\"id\":\"@ending_liana.dont_deserve\",\"title\":\"\\\"I don't deserve this.\\\"\"},{\"id\":\"@ending_liana.what_about\",\"title\":\"\\\"What about my loved ones?\\\"\"},{\"id\":\"@ending_liana.make_better\",\"title\":\"\\\"Why don't you help us here?\\\"\"},{\"id\":\"@ending_liana.ready_to_go\",\"title\":\"You're ready to go.\"},{\"id\":\"@ending_liana.stay\",\"title\":\"You don't want to go.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_4.no_idea\":{\"id\":\"k_4.no_idea\",\"options\":[{\"id\":\"@k_4.help_her\",\"title\":\"Carry her to bed.\"},{\"id\":\"@k_4.cook\",\"title\":\"Cook something.\"},{\"id\":\"@k_4.clean\",\"title\":\"Clean up the apartment.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Uh, I don't know what you are talking about...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's fine. I don't expect you to. I wonder how many of my coworkers are having conversations like this. If they had any morals they sure as fuck didn't show it! Fuck science, by the way. Best case is, you do something cool and the funding gets canceled and it never sees the light of day. Worst case is, they make you do fucked up shit and...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- has fallen on the floor. You share a glance with S-.\"}]},\"s_1.food_home_1\":{\"id\":\"s_1.food_home_1\",\"options\":[{\"id\":\"@s_1.begin_cooking\",\"title\":\"Begin cooking.\"}],\"content\":{\"content\":\"\\\"Alright. Fine.\\\" He goes back to sitting on the bed, but not before taking a random book from your bookshelf.\",\"type\":\"paragraph\"}},\"a_generic.nothing_like_before\":{\"id\":\"a_generic.nothing_like_before\",\"options\":[{\"id\":\"@a_generic.need_more\",\"title\":\"\\\"I need more money.\\\"\"},{\"id\":\"@a_generic.walk_ends\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's nothing like before.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"I suppose so. The past might as well be a fiction at this point.\\\"\"}]},\"k_3.why_asking\":{\"id\":\"k_3.why_asking\",\"options\":[{\"id\":\"@k_3.dont_remember\",\"title\":\"\\\"I don't remember.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why are you asking?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's something to talk about, I guess.\\\" She takes your hand in hers, and begins rubbing it. \\\"What did we even talk about back when we were living together?\\\"\"}]},\"entertainment.tv_3\":{\"id\":\"entertainment.tv_3\",\"content\":{\"content\":\"There is a show about a group of nanite-powered superheroes who save the city from entity attacks and terrorists. It claims to be based on a true story, set approximately ten years ago. You wonder if and how the Cataclysm will be covered here, but not enough to keep watching the program.\",\"type\":\"paragraph\"}},\"a_1.call_2\":{\"id\":\"a_1.call_2\",\"options\":[{\"id\":\"@a_1.hi\",\"title\":\"\\\"Hi...\\\"\"},{\"id\":\"@a_1.em\",\"title\":\"\\\"It's me, Em...\\\"\"},{\"id\":\"@a_1.a_\",\"title\":\"\\\"A-...?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"This is fine. You dial the numbers. You hold the handset to your ear and mouth.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hello?\\\"\"}]},\"a_2.i_am_boring\":{\"id\":\"a_2.i_am_boring\",\"onArrival\":[{\"$code\":\"Q['a_romance'] = (Q['a_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@a_2.what_do\",\"title\":\"\\\"What do you want to do?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You shrug, and look away from her. \\\"I'm sorry for being such a boring person.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She laughs again. \\\"I don't think you're boring! You seem the same as before. I think the grandma look suits you. It's cute.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh...\\\"\"},{\"type\":\"paragraph\",\"content\":\"A lull in the conversation. The two of you stare at each other, A- smiling, you making who knows what facial expression. You glance away.\"}]},\"a_3.even_more\":{\"id\":\"a_3.even_more\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\"}],\"options\":[{\"id\":\"@a_3.why\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I need even more than this, actually.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- smiles. \\\"Well, you're certainly easy to deal with.\\\"\"}]},\"a_call.pay_rent\":{\"id\":\"a_call.pay_rent\",\"options\":[{\"id\":\"@a_call.100\",\"title\":\"$100 to cover rent.\"},{\"id\":\"@a_call.200\",\"title\":\"$200 more to cover rent.\"},{\"id\":\"@a_call.300\",\"title\":\"$300 for rent.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You can help me pay rent...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Right. How much do you need?\\\"\"}]},\"ending_k.not_good_enough\":{\"id\":\"ending_k.not_good_enough\",\"options\":[{\"id\":\"@ending_k.why_like_this\",\"title\":\"\\\"Why are you like this?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"That's not good enough.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Come on. Do a cost-benefit analysis. Less than ten percent chance of being fucked over. And what's the chance that your life will get worse if you keep on living like this? What are you going to do?\\\"\"}]},\"eviction.a_where\":{\"id\":\"eviction.a_where\",\"goTo\":[{\"id\":\"ending_a\"}],\"content\":{\"content\":\"\\\"Sorry. I guess here is as good as anywhere right now...\\\"\",\"type\":\"paragraph\"}},\"food.trolley_1\":{\"id\":\"food.trolley_1\",\"title\":\"The trolley is mostly empty when you board.\",\"tags\":[\"trolley\"],\"goToRef\":[{\"id\":\"post_trolley\"}],\"content\":{\"content\":\"The trolley is mostly empty when you board.\",\"type\":\"paragraph\"}},\"k_1.its_em\":{\"id\":\"k_1.its_em\",\"goTo\":[{\"id\":\"k_1.em_2\"}],\"content\":{\"content\":\"\\\"Um, it's me, Em...\\\"\",\"type\":\"paragraph\"}},\"k_2.check_surroundings\":{\"id\":\"k_2.check_surroundings\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['k2_checks'] = (Q['k2_checks'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_2.check_respirator\",\"title\":\"Check your respirator.\"},{\"id\":\"@k_2.check_outfit\",\"title\":\"Check your outfit.\"},{\"id\":\"@k_2.wait_for_k\",\"title\":\"You finally see her.\"}],\"content\":{\"content\":\"There are no immediate threats in the vicinity. The plaza is sparser than usual at this time of day, just elderly men and women milling about the statue of Liana Xu, and refugees sitting on their mattresses in the fenced encampment. No police, no Guards, and no one looking in your direction.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"k_call.why_now\":{\"id\":\"k_call.why_now\",\"maxVisits\":1,\"options\":[{\"id\":\"@k_call.talk_to_c\",\"title\":\"\\\"You talk to C-?\\\"\"},{\"id\":\"@k_call.better_way\",\"title\":\"\\\"Is there better way we could have gotten back in touch?\\\"\"},{\"id\":\"@k_call.yes_take\",\"title\":\"\\\"Fine...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why are you asking me now? We haven't talked in...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Forever, yes, I know. But... I was just talking to C-, and I heard that you were in trouble. I wanted to get back in touch somehow.\\\"\"}],\"countVisitsMax\":1},\"k_generic.smells_like_a\":{\"id\":\"k_generic.smells_like_a\",\"viewIf\":{\"$code\":\"return (((Q['a_encounter'] || 0)===1) && ((Q['k_knows_a_affair'] || 0)===0));\"},\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Hey. You smell like A-.\\\"\"},{\"type\":\"paragraph\",\"content\":\"TODO: if you've had an encounter with A-, she makes a comment on it.\"}]},\"k_generic\":{\"id\":\"k_generic\",\"type\":\"scene\",\"title\":\"Call K-.\",\"subtitle\":\"Ask her if there is anything you could do...\",\"viewIf\":{\"$code\":\"return (((((Q['k_path'] || 0) >= 4) && ((Q['daily_k'] || 0)===0)) && ((Q['day'] || 0) >= ((Q['k_day'] || 0) + 2))) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0))));\"},\"onArrival\":[{\"$code\":\"Q['daily_k'] = 1;\\nQ['k_day'] = (Q['day'] || 0);\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['k_path'] = (Q['k_path'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"maxChoices\":1,\"maxVisits\":2,\"tags\":[\"minor\"],\"options\":[{\"id\":\"#k_generic\"}],\"content\":{\"content\":\"You call K-, and ask if there is anything you could do to help her (and perhaps for money), such as perhaps taking care of S-. She says yes; you can visit her apartment.\",\"type\":\"paragraph\"},\"countVisitsMax\":2},\"medicine.pharmacy_1\":{\"id\":\"medicine.pharmacy_1\",\"title\":\"Just a brief visit...\",\"tags\":[\"pharmacy\"],\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - 50;\\nQ['medicine'] = (Q['medicine'] || 0) + 7;\"}],\"content\":{\"content\":\"The pharmacy is combined with the grocery store. It is a relatively easy trip. You go there, pick up your prescription and some OTCs, and leave.\",\"type\":\"paragraph\"}},\"mutual_aid.name\":{\"id\":\"mutual_aid.name\",\"goTo\":[{\"id\":\"mutual_aid.wondering\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"How did you know my name?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"CityNet, remember? Everyone said you were an assimilationist bourgeois asshole, but I thought you had some good points. In the end you weren't even wrong.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Sorry. I forgot.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Don't go on CityNet,\\\" L- interjects. \\\"It's horrible these days.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Don't worry about it,\\\" R- says. \\\"How are you liking the Mutual Aid Alliance so far?\\\"\"}]},\"notes.laverneans\":{\"id\":\"notes.laverneans\",\"title\":\"Laverneans\",\"goTo\":[{\"id\":\"notes.history\"}],\"content\":{\"content\":\"Laverneans: that is, you and your people. A subtype of nonbinary humans. Women and vaguely woman-affiliated people who were put into the male box at birth. Named after a popular pre-war figure discovered in the archives who was considered your foremother (historians disagree on whether they should be considered to be in the same category as a lavernean). Formerly A-. Not K-. Your lot are considered by the state to be degenerates, terrorists, sexual deviants, rioters, violent criminals, perverts, etc., and have mostly been removed from visible public life.\",\"type\":\"paragraph\"}},\"notes\":{\"id\":\"notes\",\"type\":\"scene\",\"title\":\"Notes\",\"subtitle\":\"A recollection of facts.\",\"goTo\":[{\"id\":\"notes.notes_main\"}],\"content\":{\"content\":\"A collection of disconnected facts that comprise your knowledge of this world.\",\"type\":\"paragraph\"}},\"one.no_longer\":{\"id\":\"one.no_longer\",\"options\":[{\"id\":\"@one.out_2\",\"title\":\"You were laid off.\"}],\"content\":{\"content\":\"You are no longer an Archivist, as of approximately one day ago.\",\"type\":\"paragraph\"}},\"online_montage.cn3_v2\":{\"id\":\"online_montage.cn3_v2\",\"options\":[{\"id\":\"@online_montage.cn3_1\",\"title\":\"The Guard was her boyfriend, and she thought he would protect her.\"},{\"id\":\"@online_montage.cn3_2\",\"title\":\"Her Guard client was found out by his comrades, and they killed her.\"},{\"id\":\"@online_montage.cn3_3\",\"title\":\"Her Guard client decided to kill her for the fun of it.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You keep on watching the video.\"},{\"type\":\"paragraph\",\"content\":\"Bella is wearing a tiny red dress and high heels and more makeup than you had ever seen on her (she used to call it a tool of the patriarchy). Her screams are screams of anguish, emotional more than physical pain, and her expression is one of betrayal, you imagine. The Guards have their signature boyish smiles (they do not wear respirators as a sign of fearlessness towards the nanoplague), and they easily deflect her flails and kicks as they twist her arms behind her back and push her to the floor. One of them moves to stomp on her head. The video cuts off.\"},{\"type\":\"paragraph\",\"content\":\"You imagine various scenarios.\"}]},\"ritual.why\":{\"id\":\"ritual.why\",\"options\":[{\"id\":\"@ritual.alive\",\"title\":\"You are alive, and you hope to stay that way.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Why did you survive while they did not? Is it that you had something they lacked? Is it pure chance, the gods of probability smiling upon you?\"},{\"type\":\"paragraph\",\"content\":\"The Uprising turned out to be a winnowing. Who would have thought that a rebellion by a minority with virtually zero support or sympathy from majority groups would succeed? The fighters are all dead or imprisoned for life. Only the pathetic ones remain. The ones who faded away into the woodwork like you, or the ones who shed their identity like A-.\"}]},\"anxiety.k_helps\":{\"id\":\"anxiety.k_helps\",\"title\":\"Call K-.\",\"viewIf\":{\"$code\":\"return (((Q['k_path'] || 0) >= 3) || ((Q['k_encounter'] || 0)===1));\"},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) - 5;\"}],\"options\":[{\"id\":\"@anxiety.k_better\",\"title\":\"She saves your life.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Yes. You can call K-. She answers.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh my fucking God, are you okay? I'm heading there right now!\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- comes alone. \\\"Here. Drink some water.\\\" She almost forces a container of warm water to your mouth. \\\"I'll make some tea. And rice porridge.\\\"\"}]},\"data.d\":{\"id\":\"data.d\",\"unavailableSubtitle\":\"Definitely not.\",\"onArrival\":[{\"$code\":\"Q.chosen_data_types.push('personal');\"}],\"goTo\":[{\"id\":\"data.data_filed\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.leap_of_faith\":{\"id\":\"ending_a.leap_of_faith\",\"options\":[{\"id\":\"@ending_a.end_r\",\"title\":\"End.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Let's do it,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"She smiles, and holds you near her chest.\"}]},\"ending_liana.why_go\":{\"id\":\"ending_liana.why_go\",\"title\":\"\\\"Why?\\\"\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['liana_qs_2'] = (Q['liana_qs_2'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"ending_liana.go_questions\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Why what?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Why do... all of this? Come down to Earth and make a clone of yourself and then watch me and then...\\\"\"},{\"type\":\"paragraph\",\"content\":\"Liana shrugs. \\\"As an experiment, I suppose. When you've been alive for as long as we have, we get bored. Of course this is not my only body. Of course this is only a small fragment of my consciousness you're talking to.\\\"\"}],\"countVisitsMax\":1},\"k_4.help_her\":{\"id\":\"k_4.help_her\",\"options\":[{\"id\":\"@k_4.cook\",\"title\":\"Cook something.\"},{\"id\":\"@k_4.clean\",\"title\":\"Clean up the apartment.\"}],\"content\":{\"content\":\"Unfortunately, you are not physically strong enough to move her.\",\"type\":\"paragraph\"}},\"s_1.food_home_2\":{\"id\":\"s_1.food_home_2\",\"onArrival\":[{\"$code\":\"Q['s1_knows_cook_rice'] = 1;\"}],\"options\":[{\"id\":\"@s_1.every_day\",\"title\":\"\\\"I cook rice every day too.\\\"\"},{\"id\":\"@s_1.go_burgers\",\"title\":\"\\\"Alright. Let's go get burgers.\\\"\"},{\"id\":\"@s_1.burgers_propaganda\",\"title\":\"\\\"The humble so-called 'burger' is a piece of the Ruling Party's propaganda campaign to legitimize their rule via continuity with the American Empire.\\\"\"}],\"content\":{\"content\":\"\\\"Can we still go get burgers?\\\", he asks. \\\"I never get to go out. Mom just makes rice every day.\\\"\",\"type\":\"paragraph\"}},\"a_generic.k_q\":{\"id\":\"a_generic.k_q\",\"viewIf\":{\"$code\":\"return (((Q['a_knows_k'] || 0)===0) && ((Q['k_path'] || 0) >= 3));\"},\"options\":[{\"id\":\"@a_generic.havent_seen\",\"title\":\"\\\"I haven't seen her,\\\" you lie.\"},{\"id\":\"@a_generic.she_is_good\",\"title\":\"\\\"She is doing well.\\\" You are unsure if it is a lie.\"},{\"id\":\"@a_generic.hates_you\",\"title\":\"\\\"She hates you.\\\"\"}],\"content\":{\"content\":\"\\\"So, how is K- doing these days?\\\", she suddenly asks.\",\"type\":\"paragraph\"}},\"k_3.bored\":{\"id\":\"k_3.bored\",\"options\":[{\"id\":\"@k_3.dont_remember\",\"title\":\"\\\"I don't remember.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Are you bored already?\\\"\"},{\"type\":\"paragraph\",\"content\":\"She shrugs. Idly she takes your hand in hers, and begins rubbing it. \\\"What did we even talk about back when we were living together?\\\"\"}]},\"entertainment.book_1\":{\"id\":\"entertainment.book_1\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_1.hi\":{\"id\":\"a_1.hi\",\"goTo\":[{\"id\":\"a_1.call_3\"}],\"content\":{\"content\":\"\\\"Hi...\\\"\",\"type\":\"paragraph\"}},\"a_2.are_you_still\":{\"id\":\"a_2.are_you_still\",\"options\":[{\"id\":\"@a_2.pronouns\",\"title\":\"\\\"What pronouns should I use?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So, um, are you still a, um...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I don't know,\\\" she replies. \\\"I don't think it matters right now.\\\"\"}]},\"a_3.some_positive\":{\"id\":\"a_3.some_positive\",\"options\":[{\"id\":\"@a_3.why\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Well, I have some positive feelings for you...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"A nonzero amount of positive feelings?\\\" She snickers.\"}]},\"a_call.100\":{\"id\":\"a_call.100\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\\nQ['a_money'] = 1;\"}],\"goTo\":[{\"id\":\"a_call.money_finish\"}],\"content\":{\"content\":\"\\\"I just need Just 100 dollars.\\\"\",\"type\":\"paragraph\"}},\"ending_k.easy_for_you\":{\"id\":\"ending_k.easy_for_you\",\"options\":[{\"id\":\"@ending_k.why_like_this\",\"title\":\"\\\"Why are you like this?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Easy for you to say. You're a woman and I'm a degenerate.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"Look, if you start seeing yourself the way they told you to see yourself, they've already won. Think about it like a cost-benefit analysis. There's a less than ten percent chance of being fucked over. And what's the chance that your life will get worse if you keep on living like this? What are you going to do?\\\"\"}]},\"eviction.find_k\":{\"id\":\"eviction.find_k\",\"viewIf\":{\"$code\":\"return ((Q['k_path'] || 0) >= 3);\"},\"options\":[{\"id\":\"@ending_k\",\"title\":\"\\\"You deserve better than this,\\\" she says.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You have no idea when K- is out of work these days, so you visit her apartment when S- is probably out of school. But K- opens the door.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh my God, Em, come in! Let me guess: you've been evicted?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Christ. Sorry.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She prepares some tea. You drink.\"}]},\"food.trolley_2\":{\"id\":\"food.trolley_2\",\"title\":\"A man accosts you on the trolley.\",\"tags\":[\"trolley\"],\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 1;\"}],\"goToRef\":[{\"id\":\"post_trolley\"}],\"content\":{\"content\":\"A man on the trolley attempts to strike up a conversation with you. He sits next to you so that his legs touch yours. He is bare-faced, and you perceive droplets of saliva as he speaks. You cannot comprehend the words. You smile and nod. \\\"Speak up! I can't hear you!\\\" he shouts. Fortunately, he does not restrict your exit. You debark at the next stop, and walk the rest of the way.\",\"type\":\"paragraph\"}},\"k_1.k\":{\"id\":\"k_1.k\",\"goTo\":[{\"id\":\"k_1.em_2\"}],\"content\":{\"content\":\"\\\"Um, K-?\\\"\",\"type\":\"paragraph\"}},\"k_2.wait_for_k\":{\"id\":\"k_2.wait_for_k\",\"viewIf\":{\"$code\":\"return ((Q['k2_checks'] || 0) >= 2);\"},\"options\":[{\"id\":\"@k_2.you_too\",\"title\":\"\\\"I've been fine.\\\"\"},{\"id\":\"@k_2.stare_k\",\"title\":\"Stare at K-.\"},{\"id\":\"@k_2.stare_s\",\"title\":\"Stare at S-.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"K- appears with S- in tow, hand-in-hand. She has a downcast look about her as she strides up to you and sits on the bench.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You look cautious as always,\\\" she says to you. \\\"Have you been okay?\\\"\"}]},\"k_call.talk_to_c\":{\"id\":\"k_call.talk_to_c\",\"maxVisits\":1,\"options\":[{\"id\":\"@k_call.better_way\",\"title\":\"\\\"Is there better way we could have gotten back in touch?\\\"\"},{\"id\":\"@k_call.yes_take\",\"title\":\"\\\"Fine, I can take care of him...\\\"\"},{\"id\":\"@k_call.no_take\",\"title\":\"\\\"I don't know, sorry...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You talk to C-?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, our lab and hers share some reagents sometimes.\\\"\"}],\"countVisitsMax\":1},\"medicine.pharmacy_2\":{\"id\":\"medicine.pharmacy_2\",\"title\":\"Just a brief visit...\",\"tags\":[\"pharmacy\"],\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - 50;\\nQ['medicine'] = (Q['medicine'] || 0) + 3;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"content\":{\"content\":\"There are shortages at the pharmacy. Your prescription hormones are out; all they can give you are some substances that are supposed to be a substitute, but are much less effective and more likely to cause harmful side effects. They are the same price, of course.\",\"type\":\"paragraph\"}},\"medicine\":{\"id\":\"medicine\",\"type\":\"scene\",\"title\":\"Medicine\",\"goTo\":[{\"id\":\"medicine.med_options\"}],\"newPage\":true,\"content\":{\"content\":\"You are out of medicine. What are you going to do?\",\"type\":\"paragraph\"}},\"mutual_aid.hi_r\":{\"id\":\"mutual_aid.hi_r\",\"goTo\":[{\"id\":\"mutual_aid.wondering\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Hi, R-.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"How are you liking the Mutual Aid Alliance so far?\\\"\"}]},\"one.out_2\":{\"id\":\"one.out_2\",\"options\":[{\"id\":\"@one.recover_data\",\"title\":\"You make money by recovering data from DNA.\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Due to budget cuts, you have been laid off, but in their graciousness, the Archives have decided that you could remain as a freelance contractor, paid piecemeal for the documents that you successfully recover. More pressing than the loss of your dignified title is the loss of income. Your rent is due - $\",{\"type\":\"insert\",\"insert\":0},\" in five days, and your last paycheck did not arrive. You have exactly $\",{\"type\":\"insert\",\"insert\":1},\" to your name, which also must cover food, medicine, and all other living expenses.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rent'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['money'] || 0);\"}}]}},\"online_montage.cn3_1\":{\"id\":\"online_montage.cn3_1\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Maybe the Guard was her boyfriend. Maybe she thought he would have protected her. Obviously, he didn't. Maybe she even thought he loved her. She was never so naive, but who knows.\"},{\"type\":\"paragraph\",\"content\":\"Anyway, it doesn't fucking matter. She's dead.\"}]},\"ritual.alive\":{\"id\":\"ritual.alive\",\"content\":{\"content\":\"You are alive, for better or for worse.\",\"type\":\"paragraph\"}},\"ritual\":{\"id\":\"ritual\",\"type\":\"scene\",\"title\":\"The Ritual\",\"subtitle\":\"An excursion...\",\"viewIf\":{\"$code\":\"return ((((((Q['ritual_done'] || 0)===0) && ((Q['day'] || 0) >= 3)) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0)))) && ((Q['day'] || 0) < 20)) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0)));\"},\"onArrival\":[{\"$code\":\"Q['ritual_done'] = 1;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"frequency\":300,\"tags\":[\"major\"],\"newPage\":true,\"options\":[{\"id\":\"@ritual.even_death\",\"title\":\"Even after death you are not free.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You read about this ritual in one of the pre-war DNA datasets, the practice of a culture so far removed from you as to be virtually alien. It was a grieving ritual, or a funerary rite, or a celebration of the ancestors. Something like that.\"},{\"type\":\"paragraph\",\"content\":\"The ingredients are hard to come by, so instead of joss paper you use scraps of cellulosic newsprint, and instead of incense sticks you use long matches. The joss paper is supposed to represent money to accompany the deceased into the afterlife, to pay their rent in heaven or something like that.\"}]},\"anxiety.k_better\":{\"id\":\"anxiety.k_better\",\"goTo\":[{\"id\":\"ending_k\"}],\"newPage\":true,\"content\":{\"type\":\"paragraph\",\"content\":[\"You eat. You drink. You're feeling, if not \",{\"type\":\"emphasis-1\",\"content\":\"good\"},\" exactly, less terrible.\"]}},\"data.o\":{\"id\":\"data.o\",\"onArrival\":[{\"$code\":\"Q.chosen_data_types.push('document');\"}],\"goTo\":[{\"id\":\"data.data_filed\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.kiss_a\":{\"id\":\"ending_a.kiss_a\",\"options\":[{\"id\":\"@ending_a.end_r\",\"title\":\"End.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You kiss her, to seal the deal, or something like that.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Does this mean a yes?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You kiss her again. She smiles, and holds you near her chest.\"}]},\"ending_liana.dont_deserve\":{\"id\":\"ending_liana.dont_deserve\",\"title\":\"\\\"I don't deserve this.\\\"\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['liana_qs_2'] = (Q['liana_qs_2'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"ending_liana.go_questions\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't deserve this.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You do deserve this, though. You deserve to be loved. You deserve to be free. You deserve everything in the world. You don't deserve to be slowly dying in this hovel. And anyway, who's to say what anyone deserves?\\\"\"}],\"countVisitsMax\":1},\"k_4.comfort\":{\"id\":\"k_4.comfort\",\"goTo\":[{\"id\":\"k_4.must_comfort\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.every_day\":{\"id\":\"s_1.every_day\",\"options\":[{\"id\":\"@s_1.gray_mush\",\"title\":\"\\\"I didn't always eat rice...\\\"\"},{\"id\":\"@s_1.mom_taught\",\"title\":\"\\\"Your mom taught me how to cook rice.\\\"\"},{\"id\":\"@s_1.begin_cooking\",\"title\":\"Begin cooking.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I cook rice every day too,\\\" you say. \\\"Sometimes with beans though.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. You and mom are like the same person.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"We are, aren't we?\\\" You sigh. S- takes a random book from your shelf and sits back on the bed.\"}]},\"a_generic.havent_seen\":{\"id\":\"a_generic.havent_seen\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I haven't seen her,\\\" you lie.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's too bad.\\\"\"}]},\"k_3.its_fine\":{\"id\":\"k_3.its_fine\",\"options\":[{\"id\":\"@k_3.dont_remember\",\"title\":\"\\\"I don't remember.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's fine.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Still not much for small talk?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, not really.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Idly she takes your hand in hers, and begins rubbing it. \\\"What did we even talk about back when we were living together?\\\"\"}]},\"entertainment.reminisce\":{\"id\":\"entertainment.reminisce\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_1.em\":{\"id\":\"a_1.em\",\"goTo\":[{\"id\":\"a_1.call_3\"}],\"content\":{\"content\":\"\\\"It's me, Em...\\\"\",\"type\":\"paragraph\"}},\"a_2.pronouns\":{\"id\":\"a_2.pronouns\",\"onArrival\":[{\"$code\":\"Q['a_romance'] = (Q['a_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@a_2.what_do\",\"title\":\"\\\"What do you want to do?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What pronouns should I use for you? Like, in my interior monologue.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. Seriously? That's what you're concerned about?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, it's important for future historians and archivists if I were to write this down.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow.\\\" She rolls her eyes with a smirk. \\\"I literally do not care.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"So is 'she' fine?\\\"\"},{\"type\":\"paragraph\",\"content\":\"She shrugs. \\\"Whatever. Nerd.\\\"\"}]},\"a_3.why\":{\"id\":\"a_3.why\",\"title\":\"\\\"Why are you doing this?\\\"\",\"goTo\":[{\"id\":\"a_3.love_choices\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why are you doing this?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"If it isn't abundantly clear already, I'm still in love with you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"For some reason, there is a part of you that wants to laugh, because this scenario feels straight out of a drama, were it not for the fact of your identities.\"}]},\"a_call.200\":{\"id\":\"a_call.200\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 200;\\nQ['a_money'] = 1;\"}],\"goTo\":[{\"id\":\"a_call.money_finish\"}],\"content\":{\"content\":\"\\\"I need 200 dollars to cover rent.\\\"\",\"type\":\"paragraph\"}},\"ending_k.why_like_this\":{\"id\":\"ending_k.why_like_this\",\"options\":[{\"id\":\"@ending_k.move_in\",\"title\":\"\\\"Fine. I'll move in with you.\\\"\"},{\"id\":\"@ending_k.move_in_evicted\",\"title\":\"\\\"I'll move in with you.\\\"\"},{\"id\":\"@ending_k.no_move_in\",\"title\":\"\\\"Sorry, but I can't do it.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why are you so optimistic? You weren't like this before...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I've been thinking about some things since that last incident. And I increasingly think I was wrong and irrational to abandon hope. If you're ungenerous you could call it an elaborate act of self-deception, but now I believe that maybe, you have to lie to yourself a little. Maybe you should try it.\\\"\"}]},\"eviction.fuck\":{\"id\":\"eviction.fuck\",\"viewIf\":{\"$code\":\"return (((Q['k_path'] || 0) < 3) && ((Q['a_path'] || 0) < 3));\"},\"setBg\":\"black\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_8\",\"content\":[{\"type\":\"paragraph\",\"content\":\"There is nothing you can do, but join the destitute masses in the shantytowns packed in the dark corners of the city. Maybe you can create a life there; many people do. There are many laverneans among the houseless. They still live somehow, so perhaps you could too. They also have a very high death rate, so perhaps you will die soon.\"},{\"type\":\"paragraph\",\"content\":\"You do the probability calculations in your head. They are not favourable.\"},{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 8/9\"}}]},\"food.trolley_3\":{\"id\":\"food.trolley_3\",\"title\":\"A man accosts you on the trolley.\",\"viewIf\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 1;\\nQ['money'] = (Q['money'] || 0) + 20;\"}],\"tags\":[\"trolley\"],\"goToRef\":[{\"id\":\"post_trolley\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"A man sits next to you on the trolley. You do not look at him, but he is wearing a mask. \\\"Wearing a skirt doesn't make you a real lady,\\\" he whispers into your ear while placing his hand on your bottom. You freeze. \",{\"type\":\"emphasis-1\",\"content\":\"How the fuck did he tell?\"},\" \\\"But I don't care. I always liked you people. I was rooting for you guys in the war. Shame what happened.\\\"\"]},{\"type\":\"paragraph\",\"content\":\"As soon as you can move, you do, and walk the rest of the way. You notice that there is a $20 bill in your pocket.\"}]},\"k_1.hi\":{\"id\":\"k_1.hi\",\"goTo\":[{\"id\":\"k_1.em_2\"}],\"content\":{\"content\":\"\\\"Hello...\\\"\",\"type\":\"paragraph\"}},\"k_2.stare_k\":{\"id\":\"k_2.stare_k\",\"maxVisits\":1,\"options\":[{\"id\":\"@k_2.you_too\",\"title\":\"\\\"I've been fine.\\\"\"},{\"id\":\"@k_2.stare_s\",\"title\":\"Stare at S-.\"}],\"content\":{\"content\":\"K- is wearing black trousers and a gray blazer over a white blouse. Her hair is longer and messier than it used to be, falling over her mask. Her face is locked in an intense expression, but she is not making eye contact with you, instead glaring in your general vicinity.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"k_call.better_way\":{\"id\":\"k_call.better_way\",\"maxVisits\":1,\"options\":[{\"id\":\"@k_call.talk_to_c\",\"title\":\"\\\"You talk to C-?\\\"\"},{\"id\":\"@k_call.yes_take\",\"title\":\"\\\"Fine, I can take care of him...\\\"\"},{\"id\":\"@k_call.no_take\",\"title\":\"\\\"I don't know, sorry...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Is there a better way we could have gotten back in touch?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, is it wrong that I had to come up with an excuse to see you that I believed you would respond positively to? I didn't know if you still cared about me, so I guessed that you would care about S- more.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh...\\\"\"}],\"countVisitsMax\":1},\"k_call\":{\"id\":\"k_call\",\"type\":\"scene\",\"title\":\"A call from K-.\",\"viewIf\":{\"$code\":\"return ((((((Q['day_minor'] || 0)===0) && ((Q['k_path'] || 0)===0)) && ((Q['day'] || 0) >= 8)) && ((Q['stress'] || 0) > ((3 * (Q['stress_threshold'] || 0)) / 5))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0)));\"},\"onArrival\":[{\"$code\":\"Q['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 2;\"}],\"maxVisits\":1,\"frequency\":500,\"priority\":10,\"tags\":[\"minor\"],\"options\":[{\"id\":\"@k_call.answer\",\"title\":\"Answer the call.\"},{\"id\":\"@k_call.who_is\",\"title\":\"K- was your...\"},{\"id\":\"@k_call.ignore\",\"title\":\"Ignore the call.\"}],\"content\":{\"content\":\"You receive a call from K-.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"mutual_aid.datasets\":{\"id\":\"mutual_aid.datasets\",\"viewIf\":{\"$code\":\"return ((Q['r_seen'] || 0) > 0);\"},\"options\":[{\"id\":\"@mutual_aid.c_rev\",\"title\":\"\\\"I did not know she was on our side...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I read your DNA diaries.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, really? Cassie told us the state didn't have the means to read them.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Wait... \\\"C-? C- is my boss.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh wow. Everything's really connected, huh?\\\"\"}]},\"one.recover_data\":{\"id\":\"one.recover_data\",\"options\":[{\"id\":\"@one.alternatively\",\"title\":\"Alternatively, you could beg and cajole people for support...\"}],\"content\":{\"content\":\"You make money by recovering data from organic storage media. It is a relatively easy job: they send you the raw DNA reads, you use your scripts to convert them to a human-readable format, and then you file them with the Archives. For each file recovered, you are paid some amount of money; the payscale is rather opaque.\",\"type\":\"paragraph\"}},\"online_montage.cn3_2\":{\"id\":\"online_montage.cn3_2\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Men who secretly fuck women like you know what they're looking for, or not looking for. And they're usually not looking for someone of your anatomical configuration. The danger arises when the man's friends discover your history.\"},{\"type\":\"paragraph\",\"content\":\"Anyway, it doesn't fucking matter. She's dead.\"}]},\"anxiety.c_helps\":{\"id\":\"anxiety.c_helps\",\"viewIf\":{\"$code\":\"return (((Q['data_seen'] || 0) >= 5) && ((Q['has_contract'] || 0)===1));\"},\"title\":\"Call C-.\",\"options\":[{\"id\":\"@anxiety.ambulance\",\"title\":\"You are awoken by the wailing of an ambulance.\"}],\"content\":{\"content\":\"In an act of desperation, you manage to crawl out of bed and to the computer in order to send an e-mail to C-. You do not wait for a reply before collapsing.\",\"type\":\"paragraph\"}},\"data.m\":{\"id\":\"data.m\",\"onArrival\":[{\"$code\":\"Q.chosen_data_types.push('misc');\"}],\"goTo\":[{\"id\":\"data.data_filed\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.no_can_do\":{\"id\":\"ending_a.no_can_do\",\"chooseIf\":{\"$code\":\"return ((Q['evicted'] || 0)===0);\"},\"unavailableSubtitle\":\"You do not have any other options.\",\"options\":[{\"id\":\"@ending_alone\",\"title\":\"End.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No. I can't do this.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Are you sure?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You nod.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, then. I'll get out of here.\\\"\"}]},\"ending_liana.what_about\":{\"id\":\"ending_liana.what_about\",\"title\":\"\\\"What about my loved ones?\\\"\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['liana_qs_2'] = (Q['liana_qs_2'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"ending_liana.go_questions\"}],\"viewIf\":{\"$code\":\"return (((Q['k_path'] || 0) >= 2) || ((Q['a_path'] || 0) >= 2));\"},\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What about my loved ones?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You mean K- and A-? They'll... well, unfortunately we cannot take them along. Sorry. It's enough of a risk taking you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Can I still see them?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I don't know. Maybe you'll be able to see them again, in another world, in another life.\\\"\"}],\"countVisitsMax\":1},\"k_4.must_comfort\":{\"id\":\"k_4.must_comfort\",\"options\":[{\"id\":\"@k_4.cook\",\"title\":\"Cook something.\"},{\"id\":\"@k_4.clean\",\"title\":\"Clean up the apartment.\"}],\"content\":{\"content\":\"How do you comfort her, exactly? Are you going to tell her that everything will be okay when it obviously will not be?\",\"type\":\"paragraph\"}},\"s_1.no_food_no_money\":{\"id\":\"s_1.no_food_no_money\",\"viewIf\":{\"$code\":\"return (((Q['food'] || 0)===0) && ((Q['money'] || 0) <= 10));\"},\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Well, um, we don't have food at home, and we don't have enough money to go out to eat. So...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"We can go to our house. We have food there.\\\"\"},{\"type\":\"paragraph\",\"content\":\"WARNING: This route should never be accessible.\"}]},\"a_generic.she_is_good\":{\"id\":\"a_generic.she_is_good\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"She is doing well.\\\" You are unsure if it is a lie.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, that's good. And S-. Oh, he was so cute.\\\"\"}]},\"k_3.k_gf\":{\"id\":\"k_3.k_gf\",\"options\":[{\"id\":\"@k_3.talking_with_a\",\"title\":\"\\\"I've been talking with A-...\\\"\"},{\"id\":\"@k_3.honest_no\",\"title\":{\"content\":[\"\\\"No.\\\" \",{\"type\":\"conditional\",\"content\":\"(A lie? Or is it?)\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_loved'] || 0) > 0);\"}}]}},{\"id\":\"@k_3.of_course\",\"title\":\"\\\"Lots!\\\" (joke)\"},{\"id\":\"@k_3.what_about_you\",\"title\":\"\\\"What about you?\\\"\"}],\"content\":{\"content\":\"\\\"Hey, I was wondering, did you ever have another girlfriend or partner after we, you know?\\\"\",\"type\":\"paragraph\"}},\"entertainment.reminisce_1\":{\"id\":\"entertainment.reminisce_1\",\"content\":[{\"type\":\"paragraph\",\"content\":\"There was a better time 500\"},{\"type\":\"paragraph\",\"content\":\"You imagine the world of 500 years ago, the immediate pre-war era.\"},{\"type\":\"paragraph\",\"content\":\"You imagine the world of the posthumans. What kind of civilization have they created in outer space? What are their stations and their houses? Do they still look human? Are their minds still recognizably human in any way?\"},{\"type\":\"paragraph\",\"content\":\"Immediately after the war, the\"},{\"type\":\"paragraph\",\"content\":\"You can live in your mind forever.\"}]},\"a_1.a_\":{\"id\":\"a_1.a_\",\"goTo\":[{\"id\":\"a_1.call_3\"}],\"content\":{\"content\":\"\\\"A-...?\\\"\",\"type\":\"paragraph\"}},\"a_2.scared\":{\"id\":\"a_2.scared\",\"options\":[{\"id\":\"@a_2.not_deviant\",\"title\":\"\\\"I'm not a deviant.\\\"\"},{\"id\":\"@a_2.i_am_boring\",\"title\":\"\\\"I'm sorry for being so boring.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, aren't you scared to be like this in public?\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- laughs. \\\"What, you think I don't pass?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You have to admit, she passes better than you ever did, even towering over you at her 185 centimetres. Her body is at least visibly endowed, unlike yours. Her antiquated fashion evokes curiosity rather than disgust.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Besides,\\\" she continues, \\\"what's the point of being a deviant if you're going to be so boring all the time?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You are all too conscious of your plain gray skirt and baggy blue jacket.\"}]},\"a_3.love_choices\":{\"id\":\"a_3.love_choices\",\"options\":[{\"id\":\"@a_3.laugh\",\"title\":\"Laugh.\"},{\"id\":\"@a_3.married\",\"title\":\"\\\"You're married...\\\"\"},{\"id\":\"@a_3.i_love_you_too\",\"title\":\"\\\"I love you too...\\\"\"},{\"id\":\"@a_3.still_love_money\"},{\"id\":\"@a_3.love_k\"},{\"id\":\"@a_3.mistake\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_call.300\":{\"id\":\"a_call.300\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 300;\\nQ['a_money'] = 1;\"}],\"goTo\":[{\"id\":\"a_call.money_finish\"}],\"content\":{\"content\":\"\\\"I need 300 dollars for rent.\\\"\",\"type\":\"paragraph\"}},\"ending_k.no_move_in\":{\"id\":\"ending_k.no_move_in\",\"chooseIf\":{\"$code\":\"return ((Q['evicted'] || 0)===0);\"},\"goTo\":[{\"id\":\"ending_alone\"}],\"unavailableSubtitle\":\"You do not have any other options.\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, but... I can't do it.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's fine.\\\" She says these words, but is obviously not fine.\"}]},\"eviction.find_maa\":{\"id\":\"eviction.find_maa\",\"viewIf\":{\"$code\":\"return (((Q['support_mutual_aid'] || 0) > 0) && ((Q['mutual_aid_seen'] || 0) > 1));\"},\"options\":[{\"id\":\"@eviction.maa_end\",\"title\":\"The Uprising lives on.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The Mutual Aid Alliance might help you. R- and L- might help you. You find your way to R- and L-'s hideout, a part of the city considered too infested by nanoplagues to live. R- opens the door for you.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Emmeline! You look absolutely terrible!\\\"\"},{\"type\":\"paragraph\",\"content\":\"You tell her the story of your eviction. She tells you she has a place to stay here, in the safehouse or hideout or whatever they call it. She tells you that she will try to find technical work for you to do, something that uses your computer or archiving skills for the benefit of the permanent revolution.\"}]},\"food.trolley_4\":{\"id\":\"food.trolley_4\",\"title\":\"The trolley is mostly empty when you board.\",\"tags\":[\"trolley\"],\"goToRef\":[{\"id\":\"post_trolley\"}],\"content\":{\"content\":\"The trolley is mostly empty when you board. There are posters here: advertisements for high-interest loans, property investment schemes, multi-level marketing opportunities.\",\"type\":\"paragraph\"}},\"k_1.em_2\":{\"id\":\"k_1.em_2\",\"options\":[{\"id\":\"@k_1.job\",\"title\":\"\\\"I lost my job...\\\"\"},{\"id\":\"@k_1.homeless\",\"title\":\"\\\"I might be homeless soon...\\\"\"},{\"id\":\"@k_1.just_talk\",\"title\":\"\\\"I just wanted to see how you and S- were doing...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Em? Is that you? Fuck, why did you decide to call now of all times?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Of course, you can't talk freely on the phone. Who knows who is listening.\"}]},\"k_2.stare_s\":{\"id\":\"k_2.stare_s\",\"maxVisits\":1,\"options\":[{\"id\":\"@k_2.you_too\",\"title\":\"\\\"I've been fine.\\\"\"},{\"id\":\"@k_2.hi_s\",\"title\":\"\\\"Hi, S-.\\\"\"}],\"content\":{\"content\":\"S- is looking at you, smiling (he is not wearing a mask). You almost can't bear to look at him, but you force yourself to try to hold his gaze. He is older, obviously, and taller, obviously, but still so utterly recognizable.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"mutual_aid.c_rev\":{\"id\":\"mutual_aid.c_rev\",\"goTo\":[{\"id\":\"mutual_aid.wondering\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I did not know she was on the revolutionary side.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah, well, I never heard back from her after it all went down. Guess she sold out too. ... Anyway, how are you liking the Mutual Aid Alliance so far?\\\"\"}]},\"one.alternatively\":{\"id\":\"one.alternatively\",\"options\":[{\"id\":\"@main\",\"title\":\"Continue...\"}],\"content\":{\"content\":\"Alternatively, there are exactly two people whom you can cajole and beg for support. You did not exactly part on the best of terms with either, but perhaps they would be amenable.\",\"type\":\"paragraph\"}},\"one\":{\"id\":\"one\",\"type\":\"scene\",\"title\":\"Scene One\",\"newPage\":true,\"viewIf\":{\"$code\":\"return ((Q['started'] || 0)===0);\"},\"setBg\":\"images/windows_filtered_dithered.png\",\"onArrival\":[{\"$code\":\"Q.started = 1;\\n    // basic stats\\n    Q.money = 100;\\n    Q.rent = 350;\\n    Q.base_rent = 350;\\n    Q.food = 2;\\n    Q.rent_due = 5;\\n    Q.missed_rent = 0;\\n    Q.medicine = 7;\\n    Q.medicine_cost = 50;\\n    Q.grocery_cost = 50;\\n    Q.takeout_cost = 20;\\n    Q.has_contract = 1;\\n    Q.stress = 0;\\n    Q.stress_threshold = 25;\\n    // relationships\\n    Q.liana_introduced = 0;\\n    Q.a_path = 0;\\n    Q.a_romance = 0;\\n    Q.a_loved = 0;\\n    Q.k_path = 0;\\n    Q.k_romance = 0;\\n    Q.with_s = 0;\\n    Q.r_path = 0;\\n    Q.rosa_seen = 0;\\n    Q.mutual_aid_seen = 0;\\n    // data\\n    Q.key3 = 1;\\n    Q.key7 = 1;\\n    Q.key13 = 1;\\n    Q.key17 = 1;\\n    Q.key19 = 1;\\n    Q.key23 = 1;\\n    Q.key29 = 1;\\n    Q.key31 = 1;\\n    Q.key49 = 1;\\n    Q.key101 = 1;\\n    Q.key121 = 1;\\n    Q.prev_data = [];\\n    Q.correct_data_types = [];\\n    Q.chosen_data_types = [];\\n    // data archives (em's collection)\\n    Q.data_archives = [];\\n    Q.data_scenes = [];\\n    // how many of each data type has been seen\\n    Q.w_seen = 0;\\n    Q.d_seen = 0;\\n    Q.s_seen = 0;\\n    Q.f_seen = 0;\\n    Q.l_seen = 0;\\n    Q.r_seen = 0;\\n    Q.r_processed = 0;\\n    Q.r_warned = 0;\\n    Q.hoax_processed = 0;\\n    Q.hoax_warned = 0;\\n    Q.type_payments = {\\n        'misc': 30,\\n        'science': 60,\\n        'literature': 50,\\n        'personal': 40,\\n        'social': 40,\\n        'document': 40,\\n        'obscene': 10,\\n        'hoax': 10,\\n        'secret': 80, // secret = secrets from the war\\n        'liana': 100,\\n    };\\n    Q.main_notes = ' ';\\n    Q.day_random = 0;\\n    // low-anxiety, high-anxiety\\n    Q.low_anxiety_day_dialogues = [\\n        \\\"It is a constant 15 degrees in the undercity. Your apartment is 15 square metres. It is 15:00 right now. It has been 10 years since the Cataclysm, and five since the Uprising. 15. You rotate the number in your mind.\\\",\\n        \\\"Trolleys and people trudge along the street beneath your window. The city's circulatory system. Looking closer, you see cracks in the third-century concrete, exposing pre-war cobblestone. Patches of missing surface. After the Cataclysm, sourcing raw materials for routine maintenance has become difficult if not impossible.\\\",\\n        \\\"The light outside is burning bright. The thin walls are far from soundproof, so you hear the clanging of the trolley and the voices of people inside and outside your building. You cannot fall back asleep.\\\",\\n        \\\"It is a luxury that you are allowed this private space. It is a luxury that you have the space to carry out your degenerate activities such as \\\\\\\"using the washroom\\\\\\\".\\\",\\n        \\\"Dishes are beginning to pile up in your sink. Washing dishes makes your arms tired, which has led to broken dishes and spilled food. Thus, you only wash dishes when you are at your most energetic, which is not right now.\\\",\\n        \\\"You are tired when you wake up, but not more so than usual. You are still alive.\\\",\\n        \\\"There is nothing you particularly desire to do today.\\\",\\n        \\\"You are tired, slighty more so than usual.\\\",\\n    ];\\n    Q.day_dialogues = [\\n        \\\"You are so, so tired.\\\",\\n        \\\"It is hard to carry yourself out of bed in the morning. Afternoon. Whatever.\\\",\\n        \\\"You lie in bed for hours, thinking of nothing in particular, until your unfortunate biological necessities force you out. You are so, so tired.\\\",\\n        \\\"You wake up with your stomach aching. It is likely that the previous day's diet was inadequate.\\\",\\n        \\\"You awake with a pulsing headache. The probability that you are currently dying is low, but elevated.\\\",\\n        \\\"You awake to pounding on the walls of your apartment, accompanied by shouting. It stops, but you cannot fall back asleep.\\\",\\n        \\\"You awake feeling more tired than you felt last night.\\\",\\n        \\\"The city is a body and it is breaking down.\\\"\\n    ];\\n    // High anxiety is more than 20\\n    Q.high_stress_day_dialogues = [\\n        \\\"You wake up with a dull, aching pain throughout your body. Everything hurts.\\\",\\n        \\\"You are awake, for better or for worse.\\\",\\n        \\\"You are a body and you are a machine and you are breaking down.\\\",\\n    ];\\n    Q.day_dialogue = Q.low_anxiety_day_dialogues[0];\\n    Q.afternoon_dialogues = [\\n        \\\"The lights outside are dimming, their colors shifting from white to yellow and orange. The shadows darken. You are so, so tired.\\\",\\n        \\\"You are so, so tired.\\\",\\n        \\\"You are too tired to do anything else today.\\\",\\n        \\\"Your only desire is to lie down, but you still cannot fall asleep.\\\",\\n        \\\"It is too loud in here. Voices shouting. Trolley clanging.\\\",\\n        \\\"The lights outside are dimming. You should sleep, perhaps.\\\",\\n        \\\"Loud music and voices filters through the walls. There must be a \\\\\\\"party\\\\\\\" going on. You have never enjoyed parties.\\\",\\n        \\\"Someone is watching television in the apartment, with the volume far too high.\\\",\\n        \\\"Someone is playing music far too loudly. The bass beats shake the walls.\\\",\\n    ];\\n    Q.high_stress_afternoon_dialogues = [];\\n    Q.afternoon_dialogue = Q.afternoon_dialogues[0];\\n    Q.next_day_scene = \\\"main\\\";\\n    Q.next_day_scene_queue = [];\\n    Q.has_next_day = 0;\\n    Q.data_day = 0; // the last day you used data\\n    for (var i = 0; i < 21; i++) {\\n        Q['name_' + i] = window.randomName();\\n    }\\n    console.log('Initialized.');\"}],\"tags\":[\"top\"],\"options\":[{\"id\":\"@one.watch\",\"title\":\"Watch.\"},{\"id\":\"@one.listen\",\"title\":\"Listen.\"},{\"id\":\"@main\",\"title\":\"Main (skip)\"}],\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"The Archivist watched. The Archivist listened.\"}}},\"online_montage.cn3_3\":{\"id\":\"online_montage.cn3_3\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Bella once said that the sociological role of the laverneans was to serve as an acceptable outlet for society to enact its libidinal urges for violence. Or something like that. You don't remember.\"},{\"type\":\"paragraph\",\"content\":\"Anyway, it doesn't fucking matter. She's dead.\"}]},\"anxiety.ambulance\":{\"id\":\"anxiety.ambulance\",\"options\":[{\"id\":\"@anxiety.dont_want_ambulance\",\"title\":\"No. You do not want this.\"},{\"id\":\"@anxiety.cannot_refuse\",\"title\":\"But you cannot refuse.\"}],\"content\":{\"content\":\"You are awoken by the wailing of an ambulance. The paramedics open the door. They drag you out, check your heartbeat.\",\"type\":\"paragraph\"}},\"data.data_filed\":{\"id\":\"data.data_filed\",\"goTo\":[{\"id\":\"data.post_data\"}],\"content\":{\"content\":\"You have filed the dataset.\",\"type\":\"paragraph\"}},\"ending_a.a_friend\":{\"id\":\"ending_a.a_friend\",\"options\":[{\"id\":\"@ending_a.what_mean\",\"title\":\"\\\"What does that mean?\\\"\"}],\"content\":{\"content\":\"\\\"I can keep you alive, for now.\\\"\",\"type\":\"paragraph\"}},\"ending_liana.make_better\":{\"id\":\"ending_liana.make_better\",\"title\":\"\\\"Why don't you help us here?\\\"\",\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['liana_qs_2'] = (Q['liana_qs_2'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"ending_liana.go_questions\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why don't you help us here? You could save the city.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm not going to be breaking the terms of the Treaty. Did you forget about that already?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Yes; the Treaty that ended the Posthuman War prevented either side from directly interfering with the other. But...\"},{\"type\":\"paragraph\",\"content\":\"\\\"Doesn't my existence already break the Treaty?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Liana grins. \\\"There's a loophole, if you read it carefully. Actually, I was hoping that your existence might have catalyzed a chain of events that would save the city. If anyone could do it, it would be a clone of the city's founder, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry I failed you, then.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No worries. I didn't expect much.\\\"\"}],\"countVisitsMax\":1},\"k_4.cook\":{\"id\":\"k_4.cook\",\"options\":[{\"id\":\"@k_4.eat\",\"title\":\"The porridge is ready.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"There are no more groceries left in the refrigerator, but K- has a large supply of high-quality white, brown, and glutinous rice, mung beans, red beans, lentils, and even some dried dates. It must have been expensive. You wash a mixture of rice and various beans in a pot, fill it to the marking with water, add more sugar than usual, and put it into the pressure cooker. This can hardly be considered cooking, but it will do, for now.\"},{\"type\":\"paragraph\",\"content\":\"S- is reading a picture book on the couch. You sit next to K- as the rice is cooking. She places her hand on yours, and squeezes. You squeeze back.\"}]},\"s_1.go_burgers\":{\"id\":\"s_1.go_burgers\",\"viewIf\":{\"$code\":\"return ((Q['money'] || 0) >= 30);\"},\"options\":[{\"id\":\"@s_1.walking\",\"title\":\"The nearest restaurant is within walking distance.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Alright. Let's go. To get burgers.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You swallow your small act of legitimizing regime propaganda. It's for S-. It's all for the smile on his face.\"}]},\"a_generic.hates_you\":{\"id\":\"a_generic.hates_you\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"She still hates you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's too bad.\\\"\"}]},\"k_3.talking_with_a\":{\"id\":\"k_3.talking_with_a\",\"viewIf\":{\"$code\":\"return ((Q['a_path'] || 0) >= 3);\"},\"onArrival\":[{\"$code\":\"Q['k_knows_a_talking'] = 1;\"}],\"goTo\":[{\"id\":\"k_3.stops_talking\"}],\"options\":[{\"id\":\"@k_3.a_loved\",\"title\":\"\\\"We kind of are together.\\\"\"},{\"id\":\"@k_3.a_not_loved\",\"title\":\"\\\"We're not actually together, I think.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I've been talking with A- again...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, don't tell me you've gotten back with him. This will not end well.\\\"\"}]},\"entertainment.archives\":{\"id\":\"entertainment.archives\",\"onArrival\":[{\"$code\":\"// Script here\\nvar archiveTitles = Q.data_archives;\\nvar archiveContent = Q.data_scenes;\\nvar displayContent = document.createElement('div');\\ndisplayContent.id = 'archives';\\nfor (var i = 0; i < archiveTitles.length; i++) {\\n    var title = document.createElement('p');\\n    title.textContent = archiveTitles[i];\\n    displayContent.appendChild(title);\\n    var data = window.dendryUI.dendryEngine._makeDisplayContent(archiveContent[i], true);\\n    var data_div = document.createElement('div');\\n    data_div.innerHTML = window.dendryUI.contentToHTML.convert(data);\\n    displayContent.append(data_div);\\n}\\nvar hr = document.getElementById('read-marker');\\nhr.after(displayContent);\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_1.call_3\":{\"id\":\"a_1.call_3\",\"onArrival\":[{\"$code\":\"Q['a_path'] = 1;\"}],\"options\":[{\"id\":\"@a_1.job\",\"title\":\"\\\"I lost my job...\\\"\"},{\"id\":\"@a_1.homeless\",\"title\":\"\\\"I'm about to be homeless...\\\"\"},{\"id\":\"@a_1.talk\",\"title\":\"\\\"I missed you too...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh my God, Em, is that you? Wow, thanks for calling! It's been so long! I missed you!\\\" A pause. \\\"What's happening?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Of course, you are not to speak freely on the phone. You don't know who is listening.\"}]},\"a_2.stare\":{\"id\":\"a_2.stare\",\"options\":[{\"id\":\"@a_2.not_deviant\",\"title\":\"\\\"I'm not a deviant.\\\"\"},{\"id\":\"@a_2.i_am_boring\",\"title\":\"\\\"I'm sorry for being so boring.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You just stare, too shocked to say anything. Her entire aesthetic appears ripped out of a pre-war photograph of the precursors to laverneans (they called themselves something different then). Respectable historians say that the pre-war gender minorities saw themselves as neither men nor women and thus have no commonality with today's laverneans, but laverneans themselves know better.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you going to stop staring or what?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. It's just that...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What, you think I look weird?\\\" A- laughs. \\\"What's the point of being a deviant if you're going to be so boring all the time?\\\"\"},{\"type\":\"paragraph\",\"content\":\"She stares at your plain gray skirt and baggy blue jacket.\"}]},\"a_3.love_k\":{\"id\":\"a_3.love_k\",\"title\":\"\\\"I wonder what K- would think...\\\"\",\"viewIf\":{\"$code\":\"return (((Q['k_path'] || 0) >= 3) && ((Q['k_romance'] || 0) >= 2));\"},\"onArrival\":[{\"$code\":\"Q['a_knows_k'] = 1;\"}],\"options\":[{\"id\":\"@a_3.idk_hate\",\"title\":\"\\\"I don't know.\\\"\"},{\"id\":\"@a_3.havent_asked\",\"title\":\"\\\"I haven't asked.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I wonder what K- would think...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, you've talked to K- recently?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"Does she still hate me?\\\"\"}]},\"a_call.money_finish\":{\"id\":\"a_call.money_finish\",\"options\":[{\"id\":\"@a_call.okay_see\",\"title\":\"\\\"Okay...\\\"\"},{\"id\":\"@a_call.maybe_see\",\"title\":\"\\\"Maybe...\\\"\"},{\"id\":\"@a_call.precondition\",\"title\":\"\\\"Is that a condition for the money?\\\"\"}],\"content\":{\"content\":\"\\\"Sure, anything for you,\\\" A- says. \\\"Anyway, could we possibly meet again soon? I really want to see you again.\\\"\",\"type\":\"paragraph\"}},\"ending_k.move_in\":{\"id\":\"ending_k.move_in\",\"viewIf\":{\"$code\":\"return ((Q['evicted'] || 0)===0);\"},\"options\":[{\"id\":\"@ending_k.k_epilogue\",\"title\":\"End.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Fine. I'll move in with you.\\\"\"},{\"type\":\"paragraph\",\"content\":[\"K- wraps her arms around you, almost tackling you to the bed\",{\"type\":\"conditional\",\"content\":\", and plants kisses on your face \",\"predicate\":0},\". \\\"I knew it,\\\" she says. \\\"I knew you'd see reason. Come on. We can start packing right now.\\\"\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_romance'] || 0) >= 3);\"}}]}},\"eviction.maa_end\":{\"id\":\"eviction.maa_end\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_9\",\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 9/9\"}}]},\"food.cook_2_1\":{\"id\":\"food.cook_2_1\",\"title\":\"The trip is uneventful.\",\"tags\":[\"cooking\"],\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - (Q['grocery_cost'] || 0);\\nQ['food'] = (Q['food'] || 0) + 5;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"options\":[{\"id\":\"@main\",\"title\":\"You are tired.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"When you arrive at the store, the shelves are devoid of rice, flour, and bread, as well as long-lasting shelf-stable products in general. There must have been panic buying over the latest news of nanoplagues or strikes or equipment failures or sabotage or terrorism or...\"},{\"type\":\"paragraph\",\"content\":\"However, there is a decent supply of perishables. Fresh fruits and vegetables straight from the farms, with supposedly minimal contamination.\"},{\"type\":\"paragraph\",\"content\":\"It costs $55 for enough food to last five days.\"}]},\"k_1.job\":{\"id\":\"k_1.job\",\"goTo\":[{\"id\":\"k_1.need_money\"}],\"content\":{\"content\":\"\\\"Um, I just lost my job, and...\\\"\",\"type\":\"paragraph\"}},\"k_2.you_too\":{\"id\":\"k_2.you_too\",\"options\":[{\"id\":\"@k_2.no_choice\",\"title\":\"You don't have a choice, do you?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I've been fine,\\\" you say as a reflex.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. Whatever.\\\" She sighs. \\\"Look, I have to stay at the lab overnight for an experiment, and I need someone to watch S-. I'll pay you 100 dollars for your time, plus extra for his food and water. Is that okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- has always been this direct.\"}]},\"mutual_aid.wondering\":{\"id\":\"mutual_aid.wondering\",\"options\":[{\"id\":\"@mutual_aid.idk_maa\",\"title\":\"\\\"I don't know. I just got here.\\\"\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"online_montage.cn4\":{\"id\":\"online_montage.cn4\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Opposition party leader: 'gender and sexual minorities deserve human rights'\"},\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"CW: homophobia, transphobia, slurs\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Opposition party leader: \\\"gender and sexual minorities deserve human rights\\\"\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": pedos\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": party of freaks and pedos\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": hang the fuckers\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": they literally have more rights than ever. fags need to stop shoving it in our faces.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":4},\": enjoy getting zero votes.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":5},\": every single woman knows that males do not have a right to impersonate women.\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_4'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_5'] || 0);\"}}]}},\"anxiety.dont_want_ambulance\":{\"id\":\"anxiety.dont_want_ambulance\",\"goTo\":[{\"id\":\"anxiety.cannot_refuse\"}],\"content\":{\"content\":\"No. You do not want this. Doctors are cruel and vile beings. Any medical interaction risks a chance for the discovery of your biomedical and bureaucratic discrepancies. The best outcome is that they will mistreat you; the worst outcome is that you will be referred to the Guards, to be made an example of.\",\"type\":\"paragraph\"}},\"data.keep\":{\"id\":\"data.keep\",\"onArrival\":[{\"$code\":\"Q.correct_data_types.pop();\\nvar last_data = Q.prev_data.pop();\\nQ.data_archives.push(last_data);\\n// wiki\\nQ.data_scenes.push(window.dendryUI.game.scenes['data.' + last_data + '_'].content);\\nconsole.log('data added');\"}],\"goTo\":[{\"id\":\"data.post_data\"}],\"content\":{\"content\":\"You keep the dataset for yourself, without filing it with the Archives.\",\"type\":\"paragraph\"}},\"ending_a.what_mean\":{\"id\":\"ending_a.what_mean\",\"options\":[{\"id\":\"@ending_a.coward\",\"title\":\"Coward.\"},{\"id\":\"@ending_a.no_choices_f\",\"title\":\"You have no other options.\"},{\"id\":\"@ending_a.not_so_bad\",\"title\":\"This doesn't sound so bad.\"},{\"id\":\"@ending_a.cant_do_this\",\"title\":\"You cannot do this.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What does that mean?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'll pay for an apartment for you, and give you enough to live on for a couple of months. You can buy takeout and medicine. I can help you find a job, too. But it can't be forever. And I don't think I should see you so often. It's... unsafe.\\\"\"}]},\"ending_liana.ready_to_go\":{\"id\":\"ending_liana.ready_to_go\",\"title\":\"You're ready to go.\",\"goTo\":[{\"id\":\"ending_liana.go_2\"}],\"viewIf\":{\"$code\":\"return ((Q['liana_qs_2'] || 0) >= 2);\"},\"content\":{\"content\":\"\\\"I'm ready. Let's go.\\\"\",\"type\":\"paragraph\"}},\"k_4.clean\":{\"id\":\"k_4.clean\",\"options\":[{\"id\":\"@k_4.k_gets_up\",\"title\":\"K- has gotten up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The apartment is messy, almost as messy as yours. Socks and clothes lay strewn about the living room, along with empty wrappers and clumps of long black hair. You find a broom and dustpan, and begin sweeping.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Can I help?\\\" asks S-.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Um, just move all the clothes out of the way.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Together the two of you clean the living room floor, until it looks almost suitable for human habitation. Then you begin folding the clothes.\"}]},\"s_1.walking\":{\"id\":\"s_1.walking\",\"options\":[{\"id\":\"@s_1.let_s\",\"title\":\"Get whatever S- is getting.\"},{\"id\":\"@s_1.regular_burger\",\"title\":\"Get the most normal item on the menu.\"},{\"id\":\"@s_1.random_burger\",\"title\":\"Get something random.\"},{\"id\":\"@s_1.no_burger\",\"title\":\"Nothing for you.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You check your jacket and your mask. The hour is getting late; the lights have turned a dull orange, and there are few people on the streets. S- is holding your hand. You walk quickly, deliberately.\"},{\"type\":\"paragraph\",\"content\":\"This is not a restaurant you ordinarily visit, due to its high prices and promulgation of regime propaganda. But it is the only burger restaurant within a kilometre of your domicile. Its menu is unfamiliar, a jumble of strange words and anachronistic ingredient names that only have meaning for those born less than 20 years ago or more than 500 years ago - what is the meaning of a \\\"Whopper\\\", exactly? What is a \\\"Mac\\\"? You are partly to blame for this due to your discovery of historical cultural artifacts which then diffused into mainstream consciousness and thus...\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, I'm ready,\\\" says S-. \\\"Can we order now?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Oh. Right. You are here to get food. Burgers.\"}]},\"a_generic.walk_ends\":{\"id\":\"a_generic.walk_ends\",\"title\":\"A- has to go.\",\"content\":{\"content\":\"You arrive back on the main road. A- has to go somewhere (she will not tell you where she is going or what she is doing). And you are going home again.\",\"type\":\"paragraph\"}},\"k_3.a_loved\":{\"id\":\"k_3.a_loved\",\"viewIf\":{\"$code\":\"return ((Q['a_loved'] || 0) > 0);\"},\"onArrival\":[{\"$code\":\"Q['k_knows_a_loved'] = 1;\"}],\"goTo\":[{\"id\":\"k_3.stops_talking\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"We kind of are together.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Gross. Have you fucked?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. I don't smell him on you. So is he like, your sugar daddy now or something?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"She's...\\\" You do not know what to say to that.\"}]},\"entertainment.tv\":{\"id\":\"entertainment.tv\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"A form of self-harm.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['tv_seen'] || 0) >= 2);\"}}]},\"onArrival\":[{\"$code\":\"Q['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['tv_seen'] = (Q['tv_seen'] || 0) + 1;\\nQ['numb'] = 1;\"}],\"goTo\":[{\"id\":\"entertainment.tv_1\"},{\"id\":\"entertainment.tv_2\"},{\"id\":\"entertainment.tv_3\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_1.job\":{\"id\":\"a_1.job\",\"goTo\":[{\"id\":\"a_1.money\"}],\"content\":{\"content\":\"\\\"Um, I just lost my job...\\\"\",\"type\":\"paragraph\"}},\"a_2.what_do\":{\"id\":\"a_2.what_do\",\"options\":[{\"id\":\"@a_2.okay_shopping\",\"title\":\"\\\"Let's go grocery shopping.\\\"\"},{\"id\":\"@a_2.no_shopping\",\"title\":\"\\\"I'd rather go home.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So, what do you want to do?\\\" you ask, after staring at each others' eyes for far too long. Somehow it feels like the two of you are students meeting for the first time again.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Let's go shopping,\\\" she replies. \\\"Is there anything you'd like? Don't worry, I'll pay.\\\"\"}]},\"a_3.idk_hate\":{\"id\":\"a_3.idk_hate\",\"goTo\":[{\"id\":\"a_3.love_k_2\"}],\"content\":{\"content\":\"\\\"I don't know.\\\"\",\"type\":\"paragraph\"}},\"a_call.precondition\":{\"id\":\"a_call.precondition\",\"options\":[{\"id\":\"@a_call.okay_see\",\"title\":\"\\\"Okay...\\\"\"},{\"id\":\"@a_call.maybe_see\",\"title\":\"\\\"Maybe...\\\"\"},{\"id\":\"@a_call.idk_see\",\"title\":\"\\\"I don't know...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Is that a condition for the money?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, of course not!\\\" An audible sigh. \\\"I just want to see you. Is it okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"It doesn't feel right to refuse.\"}]},\"ending_k.move_in_evicted\":{\"id\":\"ending_k.move_in_evicted\",\"viewIf\":{\"$code\":\"return ((Q['evicted'] || 0)===1);\"},\"options\":[{\"id\":\"@ending_k.k_epilogue\",\"title\":\"End.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Of course I'll move in with you.\\\"\"},{\"type\":\"paragraph\",\"content\":[\"K- wraps her arms around you, almost tackling you to her bed\",{\"type\":\"conditional\",\"content\":\", and plants kisses on your face \",\"predicate\":0},\". \\\"Thank you.\\\" She looks at your suitcase. \\\"Let's start unpacking.\\\"\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_romance'] || 0) >= 3);\"}}]}},\"eviction.liana\":{\"id\":\"eviction.liana\",\"viewIf\":{\"$code\":\"return ((Q['l_seen'] || 0) >= 3);\"},\"options\":[{\"id\":\"@ending_liana.drink\",\"title\":\"Drink.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Liana Xu will help you. You know this. You are sure of this, for some reason, despite the irrationality of it all. She will save you from all of this.\"},{\"type\":\"paragraph\",\"content\":\"As these thoughts run through your mind, a hooded figure approaches you, and grabs you by the wrist. \\\"Go back in. We have to talk privately. You'll be fine,\\\" they say.\"},{\"type\":\"paragraph\",\"content\":\"The figure pull you back into your apartment, unlocking the door without your assistance.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Here. Drink this.\\\"\"}]},\"eviction\":{\"id\":\"eviction\",\"type\":\"scene\",\"title\":\"Evicted!\",\"setBg\":\"images/city_dithered.png\",\"onArrival\":[{\"$code\":\"Q['evicted'] = 1;\"}],\"options\":[{\"id\":\"@eviction.homeless\",\"title\":\"You are homeless now, or something like that.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"The message is automated: \",{\"type\":\"emphasis-3\",\"content\":\"Due to your non-payment of rent, we are sorry to inform you that we have initiated eviction proceedings against you. Security services are on their way to assist you in moving out of these premises as soon as possible.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"You are out of the apartment long before security arrives. You carry out your computer in a suitcase, packed with whatever clothes you can save in time.\"}]},\"food.cook_2_2\":{\"id\":\"food.cook_2_2\",\"title\":\"The trip is uneventful.\",\"tags\":[\"cooking\"],\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - (Q['grocery_cost'] || 0);\\nQ['supply'] = (Q['supply'] || 0) + 2;\\nQ['food'] = (Q['food'] || 0) + 5;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"options\":[{\"id\":\"@main\",\"title\":\"You are tired.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"When you arrive at the store, the shelves are devoid of fresh fruits and produce. There must have been technical incidents at the farms or the transportation system or the refrigeration or maybe there has been sabotage (your comrades or the reactionaries?) or perhaps delivery strikes or anti-plant nanoplagues or...\"},{\"type\":\"paragraph\",\"content\":\"However, there is enough rice to last for a while yet, as well as an adequate supply of legumes.\"},{\"type\":\"paragraph\",\"content\":\"It costs $50 for enough food to last five days.\"}]},\"k_1.homeless\":{\"id\":\"k_1.homeless\",\"goTo\":[{\"id\":\"k_1.need_money\"}],\"content\":{\"content\":\"\\\"I might be homeless soon, and...\\\"\",\"type\":\"paragraph\"}},\"k_2.hi_s\":{\"id\":\"k_2.hi_s\",\"options\":[{\"id\":\"@k_2.no_choice\",\"title\":\"You don't have a choice, do you?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Hi, S-,\\\" you say, waving at him and trying your best to convey a smile through your PPE.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hi, mama.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, Aunt Em, remember?\\\" K- corrects him.\"},{\"type\":\"paragraph\",\"content\":\"S- frowns. \\\"Oh. Sorry.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Now K- turns to you. \\\"Can you take care of him tonight? I have to stay at the lab overnight.\\\" Then, whispering: \\\"I'll pay you 100 dollars for every night he stays with you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- has always been this direct.\"}]},\"mutual_aid.idk_maa\":{\"id\":\"mutual_aid.idk_maa\",\"options\":[{\"id\":\"@mutual_aid.join_why\",\"title\":\"\\\"Do you really think it will work?\\\"\"},{\"id\":\"@mutual_aid.join_no\",\"title\":\"\\\"No...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't know. I just got here.\\\"\"},{\"type\":\"paragraph\",\"content\":\"R- smiles, and sits next to you. \\\"More of us survived the Uprising than you might think. There are a lot of us here, just trying to do what we can, hiding until it's safe to reemerge. I was hoping you could join us.\\\"\"}]},\"online_montage.cn5\":{\"id\":\"online_montage.cn5\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"University scientists: nanoplague infection level 'at highest extent in years'\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: University scientist: nanoplague infection level \\\"at highest extent in years\\\".\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": they've been saying this every year.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": university professors want to control your life and poison your children.\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}}]}},\"anxiety.cannot_refuse\":{\"id\":\"anxiety.cannot_refuse\",\"options\":[{\"id\":\"@ending_hospital\",\"title\":\"You awake in a hospital.\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"But you cannot refuse. You cannot speak. You can hardly move. You are in and out of consciousness as they insert an IV drip. You hear fragments of words. Medical terms, most likely wrong. Have they \",{\"type\":\"emphasis-1\",\"content\":\"recognized\"},\" you for the degenerate that you are?\"]}},\"data.discard\":{\"id\":\"data.discard\",\"onArrival\":[{\"$code\":\"Q.correct_data_types.pop();\\nQ.prev_data.pop();\"}],\"goTo\":[{\"id\":\"data.post_data\"}],\"content\":{\"content\":\"You delete the dataset. There is no use for it.\",\"type\":\"paragraph\"}},\"ending_a.coward\":{\"id\":\"ending_a.coward\",\"options\":[{\"id\":\"@ending_a.no_choices_f\",\"title\":\"You have no other options.\"},{\"id\":\"@ending_a.not_so_bad\",\"title\":\"This doesn't sound so bad.\"},{\"id\":\"@ending_a.cant_do_this\",\"title\":\"You cannot do this.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Coward.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes. I am.\\\" She sighs.\"}]},\"ending_liana.go_2\":{\"id\":\"ending_liana.go_2\",\"goTo\":[{\"id\":\"ending_liana.liana_end\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Great! You don't need any of your things. Everything you have here, we can easily replicate. I have an easy route out of the city. Just follow me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You follow her. For the first time in your life, you are free.\"}]},\"k_4.k_apology\":{\"id\":\"k_4.k_apology\",\"options\":[{\"id\":\"@k_4.yes_money\",\"title\":\"\\\"Yes, I still need it...\\\"\"},{\"id\":\"@k_4.no_money\",\"title\":\"\\\"No. Keep it.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"By the way, sorry for snapping at you about A-,\\\" she says. \\\"Do whatever you want. Just... stay safe.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Do you still need money? I can give you some right now.\\\"\"}]},\"s_1.let_s\":{\"id\":\"s_1.let_s\",\"goTo\":[{\"id\":\"s_1.order_2\"}],\"onArrival\":[{\"$code\":\"Q['s_1_meal'] = \\\"kids\\\";\\nQ['money'] = (Q['money'] || 0) - 20;\\nQ['food'] = (Q['food'] || 0) + 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"S- orders a kid's meal. \\\"Um, two kid's meals,\\\" you say. You are worried for a moment, but the server takes your order without a second glance. S- looks at you strangely. It costs $20 in total.\"},{\"type\":\"paragraph\",\"content\":\"The kid's meal contains one \\\"hamburger\\\", which is a flavored algae patty between two bread buns with some leavy vegetables and unidentified sauces. There is a toy; it's a plastic figure of characters from the most recent iteration of an action movie franchise. You and S- have gotten different characters. You give him yours.\"}]},\"a_generic.rent_q\":{\"id\":\"a_generic.rent_q\",\"title\":\"\\\"How are you doing with rent?\\\", she asks.\",\"viewIf\":{\"$code\":\"return ((Q['missed_rent'] || 0) > 0);\"},\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_3.a_not_loved\":{\"id\":\"k_3.a_not_loved\",\"viewIf\":{\"$code\":\"return ((Q['a_loved'] || 0) <= 0);\"},\"options\":[{\"id\":\"@k_3.stops_talking\",\"title\":\"She stops talking.\"},{\"id\":\"@k_3.but_talking\",\"title\":\"\\\"But we've been talking a lot...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"We're not actually together, I think.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Good.\\\"\"}]},\"entertainment.game\":{\"id\":\"entertainment.game\",\"onDeparture\":[{\"$code\":\"Q['games_played'] = (Q['games_played'] || 0) + 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['numb'] = 1;\"}],\"goTo\":[{\"id\":\"entertainment.game_1\",\"predicate\":{\"$code\":\"return ((Q['games_played'] || 0) >= 1);\"}},{\"id\":\"entertainment.game_2\",\"predicate\":{\"$code\":\"return ((Q['games_played'] || 0) >= 1);\"}},{\"id\":\"entertainment.game_3\",\"predicate\":{\"$code\":\"return ((Q['games_played'] || 0) >= 1);\"}},{\"id\":\"entertainment.game_4\"},{\"id\":\"entertainment.game_4\",\"predicate\":{\"$code\":\"return ((Q['games_played'] || 0)===0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"entertainment\":{\"id\":\"entertainment\",\"type\":\"scene\",\"title\":\"Entertain yourself\",\"subtitle\":\"A psychological necessity.\",\"tags\":[\"minor\"],\"viewIf\":{\"$code\":\"return (((((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0))) && ((Q['day_entertainment'] || 0)===0)) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['day_entertainment'] = 1;\\nQ['entertainment_count'] = (Q['entertainment_count'] || 0) + 1;\\nQ['numb'] = 1;\"}],\"newPage\":true,\"setBg\":\"images/monitor_dithered.png\",\"options\":[{\"id\":\"@entertainment.game\",\"title\":\"Play a game.\"},{\"id\":\"@entertainment.tv\",\"title\":\"Watch TV.\"},{\"id\":\"@entertainment.archives\",\"title\":\"Read your saved files.\"},{\"id\":\"@notes\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_1.homeless\":{\"id\":\"a_1.homeless\",\"goTo\":[{\"id\":\"a_1.money\"}],\"content\":{\"content\":\"\\\"So, I'm about to be homeless because I just lost my job and I can't cover rent...\\\"\",\"type\":\"paragraph\"}},\"a_2.no_shopping\":{\"id\":\"a_2.no_shopping\",\"onArrival\":[{\"$code\":\"Q['a_romance'] = (Q['a_romance'] || 0) - 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, I'd rather go home.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Okay. Well, see you later.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. Goodbye.\\\"\"}]},\"a_3.havent_asked\":{\"id\":\"a_3.havent_asked\",\"goTo\":[{\"id\":\"a_3.love_k_2\"}],\"content\":{\"content\":\"\\\"I haven't asked.\\\"\",\"type\":\"paragraph\"}},\"a_call.okay_see\":{\"id\":\"a_call.okay_see\",\"options\":[{\"id\":\"@a_call.done\",\"title\":\"A- hangs up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's great! Maybe we could meet up at Founders Square again, and wander around the city just like the old days.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah, maybe.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, call me if you want to meet up, or if you need anything else!\\\"\"}]},\"ending_k.k_epilogue\":{\"id\":\"ending_k.k_epilogue\",\"newPage\":true,\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_2\",\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":[\"You move in with K-. \",{\"type\":\"conditional\",\"content\":\"You did not have much in the way of possessions, so the move was rather easy. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"You continue with your work as a contractor for the Archives. Since your work is more flexible than K-'s, you have become S-'s primary caretaker. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"You are unemployed, perhaps permanently, so you have become S-'s primary caretaker. \",\"predicate\":2},\" Being a primary caretaker is not such a negative experience. You have gotten to a comfortable rapport with him; he trusts you and listens to you, perhaps more than you deserve. Because of him, you have been learning to cook meals besides rice porridge and simple stir-fries. You even know how to make burgers from scratch now. S- was so happy.\"]},{\"type\":\"paragraph\",\"content\":\"Life goes on, for better or for worse. You still fear for your life, and for S-'s life, every time you leave the apartment, but finally it feels survivable. Love, as they say, is the most powerful weapon in the revolutionist's arsenal, and you have it in ample quantities.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 2/9\"}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['evicted'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['has_contract'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['has_contract'] || 0)===0);\"}}]}},\"ending_k\":{\"id\":\"ending_k\",\"type\":\"scene\",\"title\":\"Ending\",\"options\":[{\"id\":\"@ending_k.no_love\",\"title\":\"\\\"No, I don't, in fact.\\\"\"},{\"id\":\"@ending_k.love_bad\",\"title\":\"\\\"Love doesn't stand a chance against the police state.\\\"\"},{\"id\":\"@ending_k.maybe_love\",\"title\":\"\\\"Maybe. I don't know.\\\"\"},{\"id\":\"@ending_k.worry_a\",\"title\":\"\\\"Aren't you worried about A-?\\\"\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"\\\"\",{\"type\":\"conditional\",\"content\":\"You deserve better than this hovel. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"You deserve better than this. \",\"predicate\":1},\" Stay with me. It'll be like before.\\\" Her smile is broader than you've seen in a while.\"]},{\"type\":\"paragraph\",\"content\":\"\\\"But... Don't you worry about S- being taken away? We're going to be living illegally.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"As long as we love each other, anything is possible. Don't you believe in the power of love, Em?\\\" She is smirking.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['evicted'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['evicted'] || 0)===1);\"}}]}},\"food.cook_2_3\":{\"id\":\"food.cook_2_3\",\"title\":\"The trip is uneventful.\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) - (Q['grocery_cost'] || 0);\\nQ['food'] = (Q['food'] || 0) + 2;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"options\":[{\"id\":\"@main\",\"title\":\"You are tired.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"When you arrive at the store, the only food item available is algae paste, better known as \\\"gray mush\\\". It is unappetizing, but you have no other option.\"},{\"type\":\"paragraph\",\"content\":\"It costs $25 for two days of food.\"}]},\"k_1.just_talk\":{\"id\":\"k_1.just_talk\",\"options\":[{\"id\":\"@k_1.job\",\"title\":\"\\\"I lost my job...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I just wanted to see how you and S- were doing...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Really? Is that it? I don't recall you having a history of curiosity about our personal status.\\\" Her sigh is audible. \\\"Fuck, what is the real reason?\\\"\"}]},\"k_2.no_choice\":{\"id\":\"k_2.no_choice\",\"onArrival\":[{\"$code\":\"Q['has_s'] = 1;\"}],\"options\":[{\"id\":\"@k_2.cry\",\"title\":\"If you were physiologically capable of crying, you would be doing so now.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, sure,\\\" you say, and try to smile with your eyes. \\\"Yeah, I can take care of him. For tonight.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"She's gonna take care of you,\\\" K- says. \\\"Be nice to Mama, I mean Aunt Em, okay, S-?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay!\\\"\"}]},\"mutual_aid.join_why\":{\"id\":\"mutual_aid.join_why\",\"maxVisits\":1,\"options\":[{\"id\":\"@mutual_aid.join_no\",\"title\":\"\\\"No...\\\"\"},{\"id\":\"@mutual_aid.infiltration\",\"title\":\"\\\"Aren't you worried about infiltrators?\\\"\"},{\"id\":\"@mutual_aid.join_alright\",\"title\":\"\\\"Alright... what can I do to help?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Do you really think it will work?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"The Mutual Aid Alliance is a work in progress.\\\" R- laughs, and L- puts his arm around her. \\\"But we're trying desperately to not repeat the mistakes of the Uprising. For one, we aren't going to put laverneans or our issues at the center. That was a big part of why the Uprising failed.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, it's hard to gain support when people already hate you, isn't it?\\\" says L-. \\\"Shameful behaviour from the other nonbinaries.\\\" He chuckles.\"},{\"type\":\"paragraph\",\"content\":\"\\\"We're going to go slow,\\\" continues R-. \\\"We'll build up power first, build up a support base through direct action and politics where possible. We won't be brash. Maybe it will take generations.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"And what next?\\\" you ask.\"},{\"type\":\"paragraph\",\"content\":\"\\\"When our turn comes, we will make no excuses for the terror,\\\" R- mutters. It is a quote from somewhere, you recall from the periphery of your memory.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You're gonna scare her!\\\" L- laughs, and punches R- in the arm.\"}],\"countVisitsMax\":1},\"online_montage.cn6\":{\"id\":\"online_montage.cn6\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Shortage of rare earth minerals continues.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Shortage of rare earth minerals continues. Electronics industry association asks consumers to recycle their obsolete devices.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": why can't they just dig up more. can't be that hard.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": this is happening and TRANSVESTITES are still pretending to be oppressed.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": you can pry my X101 from my cold, dead hands.\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}}]}},\"anxiety.no_help\":{\"id\":\"anxiety.no_help\",\"options\":[{\"id\":\"@anxiety.k_helps\"},{\"id\":\"@anxiety.c_helps\"},{\"id\":\"@anxiety.l_arrives\",\"title\":\"There is a knock on the door.\"},{\"id\":\"@anxiety.ending_alone\",\"title\":\"You are alone, in the end.\"}],\"content\":{\"content\":\"No one will save you. You will die here, on this bed, in this apartment, in this decrepit city. You will die, and your memory will be erased and overwritten and you didn't even leave behind any microbial DNA archives...\",\"type\":\"paragraph\"}},\"data.post_data\":{\"id\":\"data.post_data\",\"options\":[{\"id\":\"@data.post_data_2\",\"title\":\"Look at more datasets.\"},{\"id\":\"@data.back\",\"title\":\"Stop looking at datasets.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_a.no_choices_f\":{\"id\":\"ending_a.no_choices_f\",\"viewIf\":{\"$code\":\"return ((Q['evicted'] || 0)===1);\"},\"options\":[{\"id\":\"@ending_a.end_r_2\",\"title\":\"End\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Your other option is homelessness.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Fine,\\\" you say.\"}]},\"ending_liana.liana_end\":{\"id\":\"ending_liana.liana_end\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_1\",\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 1/9\"}}]},\"k_4.still_money\":{\"id\":\"k_4.still_money\",\"options\":[{\"id\":\"@k_4.yes_money\",\"title\":\"\\\"Yes, I still need it...\\\"\"},{\"id\":\"@k_4.no_money\",\"title\":\"\\\"No. Keep it.\\\"\"}],\"content\":{\"content\":\"\\\"By the way, Em, do you still need money? I can give you some right now.\\\"\",\"type\":\"paragraph\"}},\"s_1.regular_burger\":{\"id\":\"s_1.regular_burger\",\"goTo\":[{\"id\":\"s_1.order_2\"}],\"onArrival\":[{\"$code\":\"Q['s_1_meal'] = \\\"burger\\\";\\nQ['money'] = (Q['money'] || 0) - 25;\\nQ['food'] = (Q['food'] || 0) + 1;\"}],\"content\":{\"content\":\"You order a \\\"hamburger\\\", which is a flavored algae patty between two bread buns with some leafy vegetables and unidentified sauces, and S- orders a kid's meal, which is the same thing but smaller. It costs $25 in total.\",\"type\":\"paragraph\"}},\"a_generic.a_goto_end\":{\"id\":\"a_generic.a_goto_end\",\"goTo\":[{\"id\":\"ending_a\"}],\"content\":{\"content\":\"You are back at the same park by the frozen river.\",\"type\":\"paragraph\"}},\"k_3.but_talking\":{\"id\":\"k_3.but_talking\",\"goTo\":[{\"id\":\"k_3.stops_talking\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"But we've been talking a lot...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh my God, is he still into you for some reason?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I guess.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"So, is he like, your sugar daddy now?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"She's...\\\" You do not know what to say to that.\"}]},\"a_1.money\":{\"id\":\"a_1.money\",\"options\":[{\"id\":\"@a_1.100\",\"title\":\"$100 to cover rent.\"},{\"id\":\"@a_1.200\",\"title\":\"$200 more to cover rent.\"},{\"id\":\"@a_1.300\",\"title\":\"$300 for rent.\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"\\\"I am \",{\"type\":\"emphasis-1\",\"content\":\"so\"},\" sorry! I thought it might be something like that. Of course I can help. How much do you need?\\\"\"]}},\"a_2.okay_shopping\":{\"id\":\"a_2.okay_shopping\",\"options\":[{\"id\":\"@a_2.take_hand\",\"title\":\"Take her hand.\"},{\"id\":\"@a_2.just_get_up\",\"title\":\"Just get up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Let's go grocery shopping,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay. I was thinking more along the lines of clothes, but I suppose sustenance is more important.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She smiles, stands up, and offers her hand to you.\"}]},\"a_3.love_k_2\":{\"id\":\"a_3.love_k_2\",\"options\":[{\"id\":\"@a_3.married\",\"title\":\"\\\"You're married...\\\"\"},{\"id\":\"@a_3.i_love_you_too\",\"title\":\"\\\"I love you too...\\\"\"},{\"id\":\"@a_3.still_love_money\"},{\"id\":\"@a_3.mistake\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's... nice. I guess.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She is silent for a moment. \\\"This... well, I haven't changed my mind. I still love you. If you want to get back together with K- at the same time, I don't mind; I won't get jealous. And if she's jealous, well, that's on her.\\\"\"}]},\"a_call.maybe_see\":{\"id\":\"a_call.maybe_see\",\"options\":[{\"id\":\"@a_call.done\",\"title\":\"A- hangs up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, maybe,\\\" you say. \\\"I'm...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, it's fine,\\\" he says. \\\"I understand if you don't want to see me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's not that, it's... just...\\\" You don't know what to say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, then, just call me if you want to meet up, or if you need anything else.\\\"\"}]},\"food.cook_new\":{\"id\":\"food.cook_new\",\"chooseIf\":{\"$code\":\"return ((Q['supply'] || 0) > 0);\"},\"subtitle\":\"You have some cooking supplies.\",\"onArrival\":[{\"$code\":\"Q['supply'] = (Q['supply'] || 0) - 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\\nQ['food'] = (Q['food'] || 0) + 2;\\nQ['days_starved'] = 0;\"}],\"unavailableSubtitle\":\"You don't have any supplies.\",\"content\":{\"content\":\"You cook using some of the supplies that you have. You make a vegetable and tofu stir fry, which will last you for all of today.\",\"type\":\"paragraph\"}},\"k_1.need_money\":{\"id\":\"k_1.need_money\",\"options\":[{\"id\":\"@k_1.yes_meet\",\"title\":\"\\\"Sure...\\\"\"},{\"id\":\"@k_1.idk_meet\",\"title\":\"\\\"I'm not sure...\\\"\"},{\"id\":\"@k_1.need_money_now\",\"title\":\"\\\"I need the money right now...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"...And you need money? Fuck.\\\" Her sigh is audible. \\\"God, okay, look, I'm a non-tenured scientist on a contingent contract, and I have a kid. How much disposable income do you think I have?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm sorry... forget-\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No. Look...\\\" A pause. \\\"There's one thing you could do to help me out, and I'll pay you. I have to work overnight in two days. Can you take care of S- then?\\\"\"}]},\"k_2.cry\":{\"id\":\"k_2.cry\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 50;\"}],\"options\":[{\"id\":\"@s_1\",\"title\":\"Home again.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"If your hormone-deprived body were physiologically capable of crying, you would be doing so at this time. Instead, you nod, and let S- take your hand.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'll come by your apartment tomorrow afternoon. You still live there, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You nod.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Here's 50 dollars, by the way. Buy some food.\\\"\"},{\"type\":\"paragraph\",\"content\":\"S- leads you up to your feet. K- waves the two of you goodbye, and heads back to the trolley stop. You head to a different trolley stop.\"}]},\"k_2\":{\"id\":\"k_2\",\"type\":\"scene\",\"title\":\"Meeting K-\",\"subtitle\":\"5PM, Founders Square\",\"viewIf\":{\"$code\":\"return (((((((Q['k_path'] || 0)===1) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0)))) && ((Q['daily_k'] || 0) <= 0)) && ((Q['day'] || 0)===((Q['k_day'] || 0) + 2))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['k_path'] = (Q['k_path'] || 0) + 1;\\nQ['daily_k'] = 1;\"}],\"tags\":[\"major\"],\"newPage\":true,\"frequency\":1000,\"setBg\":\"images/windows_filtered_dithered.png\",\"options\":[{\"id\":\"@k_2.year\",\"title\":\"At least a year.\"},{\"id\":\"@k_2.months\",\"title\":\"A few months.\"},{\"id\":\"@k_2.weeks\",\"title\":\"Just a few weeks.\"}],\"content\":{\"content\":\"How long has it been since you last saw her?\",\"type\":\"paragraph\"}},\"mutual_aid.join_no\":{\"id\":\"mutual_aid.join_no\",\"maxVisits\":1,\"options\":[{\"id\":\"@main\",\"title\":\"You are free to leave.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No, sorry... I can't do it.\\\"\"},{\"type\":\"paragraph\",\"content\":\"R- looks into your eyes. \\\"That's what I thought you would say. It's fine. We hold these gatherings every week. You can come if you want free food.\\\"\"}],\"countVisitsMax\":1},\"online_montage.cn7\":{\"id\":\"online_montage.cn7\",\"title\":\"Seven homeless encampments removed from public square by police and Guards.\",\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Seven homeless encampments removed from public square by police and Guards.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": good\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": long live the guards!!!\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": they should be sent to live outside!!!\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":4},\": Why can't they get jobs like the rest of us? WHy do they want special treatment?\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_4'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}}]}},\"anxiety.l_helps\":{\"id\":\"anxiety.l_helps\",\"viewIf\":{\"$code\":\"return ((Q['l_seen'] || 0) >= 5);\"},\"title\":\"Liana Xu will help.\",\"options\":[{\"id\":\"@anxiety.l_arrives\",\"title\":\"There is a knock on the door.\"}],\"content\":{\"content\":\"Liana Xu will help you. You know this. You are sure of this, for some reason, despite the irrationality of it all. She will save you from all of this.\",\"type\":\"paragraph\"}},\"data.pre_view_display\":{\"id\":\"data.pre_view_display\",\"goTo\":[{\"id\":\"data.view_display\"}],\"content\":{\"content\":\"You are getting tired, but you push through. There are still more datasets to decode.\",\"type\":\"paragraph\"}},\"ending_a.not_so_bad\":{\"id\":\"ending_a.not_so_bad\",\"options\":[{\"id\":\"@ending_a.end_r_2\",\"title\":\"End\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"This does not sound like such a bad life.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Fine,\\\" you say.\"}]},\"ending_liana.stay\":{\"id\":\"ending_liana.stay\",\"title\":\"You don't want to go.\",\"viewIf\":{\"$code\":\"return ((Q['liana_qs_2'] || 0) >= 2);\"},\"options\":[{\"id\":\"@ending_liana.sure_stay\",\"title\":\"\\\"I'm sure.\\\"\"},{\"id\":\"@ending_liana.not_ready\",\"title\":\"\\\"I'm not ready to make a decision.\\\"\"},{\"id\":\"@ending_liana.actually_go\",\"title\":\"\\\"Actually, I'd rather go.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't want to go. I want to stay here.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure?\\\"\"}]},\"k_4.yes_money\":{\"id\":\"k_4.yes_money\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\"}],\"goTo\":[{\"id\":\"k_4.are_you_okay\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Yes, I need it... Sorry.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, it's fine. Here's a hundred.\\\"\"}]},\"s_1.random_burger\":{\"id\":\"s_1.random_burger\",\"goTo\":[{\"id\":\"s_1.regular_burger\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_generic.a_bad\":{\"id\":\"a_generic.a_bad\",\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You make the call, but she does not respond. Nothing.\"},{\"type\":\"paragraph\",\"content\":\"Oh well. It was worth a try.\"}]},\"a_generic\":{\"id\":\"a_generic\",\"type\":\"scene\",\"title\":\"Call A-.\",\"subtitle\":{\"content\":[\"You need money, maybe \",{\"type\":\"conditional\",\"content\":\"(or maybe you just want to talk to her) \",\"predicate\":0},\"...\"],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_loved'] || 0) > 0);\"}}]},\"viewIf\":{\"$code\":\"return ((((((Q['a_path'] || 0) >= 3) && ((Q['daily_a'] || 0)===0)) && ((Q['day'] || 0) >= ((Q['a_day'] || 0) + 2))) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0)))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0)));\"},\"onArrival\":[{\"$code\":\"Q['daily_a'] = 1;\\nQ['a_day'] = (Q['day'] || 0);\\nQ['a_path'] = (Q['a_path'] || 0) + 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"a_generic.a_good\",\"predicate\":{\"$code\":\"return (((Q['a_loved'] || 0) >= 1) && ((Q['a_path'] || 0) < 5));\"}},{\"id\":\"a_generic.a_bad\",\"predicate\":{\"$code\":\"return ((Q['a_loved'] || 0) <= 0);\"}},{\"id\":\"a_generic.a_goto_end\",\"predicate\":{\"$code\":\"return ((Q['a_path'] || 0) >= 4);\"}}],\"tags\":[\"minor\"],\"content\":{\"content\":\"You call A-...\",\"type\":\"paragraph\"}},\"k_3.honest_no\":{\"id\":\"k_3.honest_no\",\"goTo\":[{\"id\":\"k_3.stops_talking\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's what I guessed.\\\" She sighs. \\\"We never technically broke up, did we? It was a temporary separation for the purpose of safety? Until things got better?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You do not know what to say to that.\"}]},\"a_1.100\":{\"id\":\"a_1.100\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\\nQ['a_money'] = 1;\"}],\"goTo\":[{\"id\":\"a_1.money_finish\"}],\"content\":{\"content\":\"\\\"I just need Just 100 dollars.\\\"\",\"type\":\"paragraph\"}},\"a_2.take_hand\":{\"id\":\"a_2.take_hand\",\"goTo\":[{\"id\":\"a_2.shopping\"}],\"onArrival\":[{\"$code\":\"Q['a_romance'] = (Q['a_romance'] || 0) + 1;\"}],\"content\":{\"content\":\"You take her hand.\",\"type\":\"paragraph\"}},\"a_3.kiss_1\":{\"id\":\"a_3.kiss_1\",\"viewIf\":{\"$code\":\"return ((Q['kissed_a'] || 0)===1);\"},\"options\":[{\"id\":\"@a_3.yourself_or_me\",\"title\":\"\\\"You are at greater danger than me.\\\"\"},{\"id\":\"@a_3.why_you_r\",\"title\":[\"\\\"Why are \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\" doing this?\\\"\"]}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Neither of you are wearing masks, and no one else can be seen. So you lean into her. Guide her hands to your waist. Let her pull you closer. Your lips touch for a moment, before letting go.\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's what I was talking about,\\\" she says. \\\"It's... it's dangerous for us to do this. Are you sure you want to?\\\"\"}]},\"a_call.idk_see\":{\"id\":\"a_call.idk_see\",\"options\":[{\"id\":\"@a_call.done\",\"title\":\"A- hangs up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, I don't know,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's fine,\\\" he says. \\\"I understand if you don't want to see me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's not that, it's... just...\\\" You don't know what to say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, then, just call me if you want to meet up, or if you need anything else.\\\"\"}]},\"food.scrounge\":{\"id\":\"food.scrounge\",\"chooseIf\":{\"$code\":\"return ((Q['scrounged'] || 0)===0);\"},\"subtitle\":\"Free, lasts 1-2 days.\",\"unavailableSubtitle\":\"You don't have any more food left.\",\"onArrival\":[{\"$code\":\"Q['scrounged'] = 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\\nQ['food'] = (Q['food'] || 0) + 1;\"}],\"content\":{\"content\":\"You scrounge around for some food. A package of gray mush. A small bowl of leftover rice. A package of fried algae. It is enough, for now.\",\"type\":\"paragraph\"}},\"k_1.yes_meet\":{\"id\":\"k_1.yes_meet\",\"onArrival\":[{\"$code\":\"Q['k_path'] = 1;\\nQ['k_day'] = (Q['day'] || 0);\"}],\"options\":[{\"id\":\"@k_1.hangup\",\"title\":\"A thread of hope.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sure...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Good. Can we meet at 5PM the day after tomorrow at Founders Square? I'll bring S- then.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"See you then.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She hangs up.\"}]},\"mutual_aid.infiltration\":{\"id\":\"mutual_aid.infiltration\",\"maxVisits\":1,\"options\":[{\"id\":\"@mutual_aid.join_no\",\"title\":\"\\\"No...\\\"\"},{\"id\":\"@mutual_aid.join_alright\",\"title\":\"\\\"Alright... what can I do to help?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Aren't you worried about infiltrators?\\\"\"},{\"type\":\"paragraph\",\"content\":\"R- shrugs. \\\"Of course. But I don't believe you're an infiltrator. Or would you be, if you were paid well enough?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No... I don't know. I never thought about it.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"See, that's an honest answer. Besides, I don't think any of the current security forces can stop using slurs for long enough to recruit a lavernean.\\\"\"}],\"countVisitsMax\":1},\"online_montage.cn8\":{\"id\":\"online_montage.cn8\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Overall life expectancy at 65, 2% decline from previous year.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Overall life expectancy at 65, 2% decline from previous year. Experts blame nanoplagues, moral degeneracy.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": lmao\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": fuckers need to stop eating so much\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":3},\": lazy bums dont wanna get jobs\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_3'] || 0);\"}}]}},\"anxiety.l_arrives\":{\"id\":\"anxiety.l_arrives\",\"viewIf\":{\"$code\":\"return ((Q['l_seen'] || 0) >= 3);\"},\"goTo\":[{\"id\":\"ending_liana\"}],\"newPage\":true,\"content\":{\"content\":\"There is a knock on the door, before the sound of a key turning. It opens.\",\"type\":\"paragraph\"}},\"data.end_data\":{\"id\":\"data.end_data\",\"content\":{\"content\":\"Unfortunately, you are too tired to look at any more datasets.\",\"type\":\"paragraph\"}},\"ending_a.cant_do_this\":{\"id\":\"ending_a.cant_do_this\",\"chooseIf\":{\"$code\":\"return ((Q['evicted'] || 0)===0);\"},\"unavailableSubtitle\":\"You do not have any other options.\",\"content\":{\"content\":\"\\\"Sorry, but, I can't do this.\\\"\",\"type\":\"paragraph\"}},\"ending_liana.not_ready\":{\"id\":\"ending_liana.not_ready\",\"title\":\"\\\"I'm not ready to make a decision.\\\"\",\"goTo\":[{\"id\":\"ending_liana.em_stays\"}],\"viewIf\":{\"$code\":\"return ((Q['liana_qs_2'] || 0) >= 2);\"},\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I'm not ready to make a decision. I just... don't know if I want to stay or go, yet.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hmm.\\\" Liana purses her lips. \\\"Alright. I will return. But let me help you first, in the meantime.\\\"\"}]},\"k_4.no_money\":{\"id\":\"k_4.no_money\",\"options\":[{\"id\":\"@k_4.are_you_okay\",\"title\":\"\\\"Are you going to be okay?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No. Keep it.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes.\\\"\"}]},\"s_1.no_burger\":{\"id\":\"s_1.no_burger\",\"onArrival\":[{\"$code\":\"Q['s_1_meal'] = \\\"none\\\";\\nQ['money'] = (Q['money'] || 0) - 10;\"}],\"options\":[{\"id\":\"@s_1.back_home\",\"title\":\"You go back home.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"S- orders a kid's meal. \\\"Nothing for me,\\\" you say. It costs $10 in total.\"},{\"type\":\"paragraph\",\"content\":\"S- looks at you. \\\"Are you not hungry?\\\", he asks.\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, I'm fine,\\\" you say, not entirely truthfully.\"},{\"type\":\"paragraph\",\"content\":\"S- eats outside, as you watch. \\\"I can't eat if you watch me,\\\" he says, and you look away.\"}]},\"k_3.of_course\":{\"id\":\"k_3.of_course\",\"goTo\":[{\"id\":\"k_3.honest_no\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh, of course! Lots of partners!\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Really?\\\"\"}]},\"a_1.200\":{\"id\":\"a_1.200\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 200;\\nQ['a_money'] = 1;\"}],\"goTo\":[{\"id\":\"a_1.money_finish\"}],\"content\":{\"content\":\"\\\"I need 200 dollars to cover rent.\\\"\",\"type\":\"paragraph\"}},\"a_2.just_get_up\":{\"id\":\"a_2.just_get_up\",\"goTo\":[{\"id\":\"a_2.shopping\"}],\"content\":{\"content\":\"You just get up, ignoring her offer.\",\"type\":\"paragraph\"}},\"a_3.i_know_2\":{\"id\":\"a_3.i_know_2\",\"options\":[{\"id\":\"@a_3.yourself_or_me\",\"title\":\"\\\"You are at greater danger than me.\\\"\"},{\"id\":\"@a_3.why_you_r\",\"title\":[\"\\\"Why are \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\" doing this?\\\"\"]},{\"id\":\"@a_3.why_you\",\"title\":[\"\\\"Why are \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\" doing this?\\\"\"]},{\"id\":\"@a_3.my_life\",\"title\":\"\\\"You don't understand what it's like.\\\"\"}],\"content\":{\"content\":\"\\\"And is it a risk you're willing to take?\\\"\",\"type\":\"paragraph\"}},\"a_call.done\":{\"id\":\"a_call.done\",\"content\":{\"content\":\"A- hangs up, leaving you alone with your thoughts. At least you are slightly further from total destitution.\",\"type\":\"paragraph\"}},\"a_call\":{\"id\":\"a_call\",\"type\":\"scene\",\"title\":\"A call from A-.\",\"viewIf\":{\"$code\":\"return (((((Q['missed_rent'] || 0) > 0) && ((Q['day_minor'] || 0)===0)) && ((Q['a_path'] || 0)===0)) && ((Q['day'] || 0) >= 6));\"},\"onArrival\":[{\"$code\":\"Q['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"maxVisits\":1,\"frequency\":1000,\"priority\":10,\"tags\":[\"minor\"],\"options\":[{\"id\":\"@a_call.answer\",\"title\":\"Answer the call.\"},{\"id\":\"@a_call.who_was\",\"title\":\"He was your former partner...\"}],\"content\":{\"content\":\"You receive a call from A-.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"food.starve\":{\"id\":\"food.starve\",\"subtitle\":\"Free.\",\"options\":[{\"id\":\"#starve\",\"title\":\"Do it.\"},{\"id\":\"@food.food_options\",\"title\":\"Do something else.\"}],\"content\":{\"content\":\"You could simply not eat today. There are no potential long-term consequences, of course.\",\"type\":\"paragraph\"}},\"k_1.idk_meet\":{\"id\":\"k_1.idk_meet\",\"onArrival\":[{\"$code\":\"Q['k_path'] = 1;\\nQ['k_day'] = (Q['day'] || 0);\"}],\"options\":[{\"id\":\"@k_1.yes_meet_2\",\"title\":\"\\\"I can be there...\\\"\"},{\"id\":\"@k_1.idk_meet_2\",\"title\":\"\\\"I still don't know...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, I'm not sure...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I mean, based on my current knowledge, I doubt you'd have anything better to do. Would you be able to meet 5PM the day after at Founders Square?\\\"\"}]},\"mutual_aid.join_alright\":{\"id\":\"mutual_aid.join_alright\",\"onArrival\":[{\"$code\":\"Q['support_mutual_aid'] = 1;\"}],\"options\":[{\"id\":\"@main\",\"title\":\"You are free to leave.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Alright... what can I do to help?\\\"\"},{\"type\":\"paragraph\",\"content\":\"R- looks at you up and down. \\\"I don't think you're physically capable of helping out with these gatherings. Or emotionally capable. And I'm guessing you're short of financial resources?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You shrug.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay. Unfortunately, we don't have much need for an archivist right now. But, we might need your skills sometime. Not sure when.\\\"\"},{\"type\":\"paragraph\",\"content\":\"L- laughs. \\\"Wow, R-, you're not really doing a good job convincing our new recruit.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Just, keep in touch,\\\" R- says. \\\"We're among friends here. We'll try to help each other out.\\\"\"}]},\"mutual_aid\":{\"id\":\"mutual_aid\",\"type\":\"scene\",\"title\":\"Mutual Aid\",\"subtitle\":\"Follow the address on the flier.\",\"viewIf\":{\"$code\":\"return ((((((((Q['day'] || 0)===3) || ((Q['day'] || 0)===10)) || ((Q['day'] || 0)===17))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['mutual_aid_seen'] || 0)===0)) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0))));\"},\"onArrival\":[{\"$code\":\"Q['ma_checklist'] = 0;\\nQ['mutual_aid_seen'] = 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"tags\":[\"minor\"],\"newPage\":true,\"frequency\":500,\"setBg\":\"images/city_dithered.png\",\"goTo\":[{\"id\":\"mutual_aid.checklist\"}],\"content\":{\"content\":\"Before you enter a public space where you must interact with people in more than a cursory manner, you first follow a checklist.\",\"type\":\"paragraph\"}},\"online_montage.cn9\":{\"id\":\"online_montage.cn9\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Grocery strike leads to riots in Erie District, five suspected rioters killed.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Grocery strike leads to riots in Erie District. Five suspected rioters killed.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": kill all rioters.\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": kill all terrorists\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}}]}},\"anxiety.ending_alone\":{\"id\":\"anxiety.ending_alone\",\"chooseIf\":{\"$code\":\"return ((Q['k_path'] || 0) < 3);\"},\"viewIf\":{\"$code\":\"return ((Q['l_seen'] || 0) < 3);\"},\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_7\",\"newPage\":true,\"content\":[{\"type\":\"paragraph\",\"content\":\"You are alone, in the end. It is growing dark.\"},{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 7/9\"}}]},\"data.check_data_0\":{\"id\":\"data.check_data_0\",\"options\":[{\"id\":\"@data.check_data\",\"title\":\"View results\"}],\"content\":{\"content\":\"Some of your decoded datasets have been received and processed. Here are the results:\",\"type\":\"paragraph\"}},\"ending_a.end_r\":{\"id\":\"ending_a.end_r\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_3\",\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":[\"It turns out that both of you are cowards. A- is too afraid to live publicly as a lavernean (who isn't these days), so she maintains a facade of masculinity to the outside world, while living a secret lavernean lifestyle within the confines of her domicile. She and her ex-wife have divorced, and now she lives with you in the most luxurious place you have ever lived, oweing to her continued career as a doctor for the city's elite. She loves you, and you love her\",{\"type\":\"conditional\",\"content\":\", or something like that. What is love but a mutually beneficial exchange of goods and services? \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\". \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 3a/9\"}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_financial_support'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_financial_support'] || 0)===0);\"}}]}},\"ending_liana.sure_stay\":{\"id\":\"ending_liana.sure_stay\",\"goTo\":[{\"id\":\"ending_liana.em_stays\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I'm sure. I want to stay here, in this city.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hmm.\\\" Liana purses her lips. \\\"Alright. I will respect your decision. But let me help you first.\\\"\"}]},\"k_4.are_you_okay\":{\"id\":\"k_4.are_you_okay\",\"options\":[{\"id\":\"@k_4.good_for_you\",\"title\":\"\\\"Good for you...\\\"\"},{\"id\":\"@k_4.your_support\",\"title\":\"This means you won't be supported...\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Are you going to be okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Probably. I'm feeling better now. Just needed a good cry.\\\" She smiles. \\\"It's fine. I'm just gonna look for another job.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What about the blacklist?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What about it? So I get a pay cut and can't be called a scientist anymore. Big deal. I hear the Archives are looking for DNA technologists.\\\"\"}]},\"s_1.order_2\":{\"id\":\"s_1.order_2\",\"options\":[{\"id\":\"@s_1.back_home\",\"title\":\"You go back home.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The two of you eat outside. There are few enough people nearby that you feel moderately safe in removing your respirator.\"},{\"type\":\"paragraph\",\"content\":\"Unfortunately, your burger tastes good. It tastes very good. Whatever synthetic flavorings they added to the algae to make it palatable did their jobs too well. S- downs his burger quickly.\"}]},\"k_3.what_about_you\":{\"id\":\"k_3.what_about_you\",\"options\":[{\"id\":\"@k_3.talking_with_a\",\"title\":\"\\\"I've been talking with A-...\\\"\"},{\"id\":\"@k_3.honest_no\",\"title\":{\"content\":[\"\\\"No.\\\" \",{\"type\":\"conditional\",\"content\":\"(A lie? Or is it?)\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['a_loved'] || 0) > 0);\"}}]}},{\"id\":\"@k_3.of_course\",\"title\":\"\\\"Lots!\\\" (joke)\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What about you?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Nope. I'm not even out these days. Are you going to answer now?\\\"\"}]},\"a_1.300\":{\"id\":\"a_1.300\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 300;\\nQ['a_money'] = 1;\"}],\"goTo\":[{\"id\":\"a_1.money_finish\"}],\"content\":{\"content\":\"\\\"I need 300 dollars for rent.\\\"\",\"type\":\"paragraph\"}},\"a_2.shopping\":{\"id\":\"a_2.shopping\",\"options\":[{\"id\":\"@a_2.stay_with_a\",\"title\":\"Stay near A-.\"},{\"id\":\"@a_2.wander_off\",\"title\":\"Wander off by yourself..\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"There is a warehouse store in a reclaimed pre-war building, a flat and wide gray structure surrounded by fields of lichen growing on concrete, on which a shantytown has been erected, densely packed with tents and shacks. You keep your gaze on the ground in front of you. A- is walking quickly, pushing you forward with her hand on your back until you reach the entrance.\"},{\"type\":\"paragraph\",\"content\":\"\\\"So. We're here. What do you want?\\\"\"}]},\"a_3.yourself_or_me\":{\"id\":\"a_3.yourself_or_me\",\"goTo\":[{\"id\":\"a_3.really_about\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You are at greater danger than me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- sighs, and puts an arm around your shoulder. \\\"I guess you're right. You have your documents all corrected, name change, bottom surgery, everything. Meanwhile I'm still just out here doing... well, illegally crossdressing I guess.\\\"\"}]},\"food.starve_2\":{\"id\":\"food.starve_2\",\"title\":\"Do it.\",\"viewIf\":{\"$code\":\"return ((Q['days_starved'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 3;\\nQ['food'] = 1;\\nQ['days_starved'] = (Q['days_starved'] || 0) + 1;\"}],\"tags\":[\"starve\"],\"content\":{\"content\":\"You can survive without food for a day. You will be fine. Just a bit hungry. Just a bit more tired than usual.\",\"type\":\"paragraph\"}},\"k_1.need_money_now\":{\"id\":\"k_1.need_money_now\",\"viewIf\":{\"$code\":\"return ((Q['rent_due'] || 0) <= 2);\"},\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\\nQ['k_money'] = 1;\\nQ['k_path'] = 1;\\nQ['k_day'] = (Q['day'] || 0);\"}],\"options\":[{\"id\":\"@k_1.yes_meet\",\"title\":\"\\\"Sure...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I actually need the money right now. It's kind of an emergency...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"God. Okay, fine. Here's $100.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You see the transaction on your account.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Anyway,\\\" K- continues, \\\"What I was going to say was that I need someone to take care of S- on the days when I'm working late in the lab. Which lately is every day. I know your schedule is flexible. Is that something you can do?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You aren't exactly in a position to refuse.\"}]},\"online_montage.cn10\":{\"id\":\"online_montage.cn10\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Lithium shortage leads to higher battery prices for consumers and industry.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Lithium shortage leads to higher battery prices for consumers and industry.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": lol\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}}]}},\"anxiety.a_helps\":{\"id\":\"anxiety.a_helps\",\"title\":\"Call A-.\",\"maxVisits\":1,\"viewIf\":{\"$code\":\"return (((Q['kissed_a'] || 0)===1) || ((Q['a_path'] || 0) >= 3));\"},\"goTo\":[{\"id\":\"anxiety.a_no_answer\",\"predicate\":{\"$code\":\"return ((Q['a_loved'] || 0)===0);\"}},{\"id\":\"anxiety.a_answer\",\"predicate\":{\"$code\":\"return ((Q['a_loved'] || 0) > 0);\"}}],\"content\":{\"content\":\"Yes. You can call A-.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"anxiety\":{\"id\":\"anxiety\",\"type\":\"scene\",\"title\":\"Breakdown\",\"subtitle\":\"It is not good.\",\"viewIf\":{\"$code\":\"return (((Q['stress'] || 0) >= (Q['stress_threshold'] || 0)) || ((Q['day'] || 0) >= 20));\"},\"frequency\":1000,\"priority\":10,\"tags\":[\"major\",\"minor\"],\"setBg\":\"images/windows_filtered_dithered.png\",\"newPage\":true,\"options\":[{\"id\":\"@anxiety.not_just\",\"title\":\"Not just tired.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"You are tired, more so than usual.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"(CW: suicidal ideation, death)\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]}},\"data.check_data\":{\"id\":\"data.check_data\",\"options\":[{\"id\":\"@data.view_display\",\"title\":\"Continue.\"},{\"id\":\"@data.back\",\"title\":\"Do something else.\"}],\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"magic\",\"content\":\"<script>$('#check_data_text').append($(window.dendryUI.dendryEngine.state.qualities.check_data_text));</script> <code id=\\\"check_data_text\\\"></code>\"}}},\"ending_a.end_r_2\":{\"id\":\"ending_a.end_r_2\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_3\",\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":\"You are alive, with A- providing support. You have a new job as a data archaeologist at a medical device company. Most of the devices are at least decades old, in a constant state of refurbishment, their code locked up in various incompatible data formats, and it is your job to recover them. It is not quite as interesting as the DNA archival work, but it pays better, enough for you to afford rent and food and medicine. Your illness persists, but for now, you are alive and surviving.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 3b/9\"}}]},\"ending_a\":{\"id\":\"ending_a\",\"type\":\"scene\",\"title\":\"Ending: A-\",\"goTo\":[{\"id\":\"ending_a.a_rom\",\"predicate\":{\"$code\":\"return ((Q['a_loved'] || 0) > 0);\"}},{\"id\":\"ending_a.a_friend\",\"predicate\":{\"$code\":\"return ((Q['a_loved'] || 0)===0);\"}}],\"content\":{\"content\":\"A- looks pensive. She does not look at you, instead staring off into the distance.\",\"type\":\"paragraph\"}},\"ending_liana.em_stays\":{\"id\":\"ending_liana.em_stays\",\"goTo\":[{\"id\":\"ending_liana.stay_end\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"From her backpack she produces several pouches. \\\"Here is the drink to help with your fatigue. Here are some hormones and medicines for various purposes, including nanoplague cures. Oh yeah, and I'm adding a few zeros to your accounts. \",{\"type\":\"conditional\",\"content\":\"Oh wait, your money is already at zero, so... I'll just drop a few tens of thousands of dollars. \",\"predicate\":0},\"\\\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Thank you...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, if you ever want to leave, just think of me enough and I'll probably get the signal.\\\"\"},{\"type\":\"paragraph\",\"content\":\"With that, she leaves your apartment. You are alone once more.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['money'] || 0) <= 0);\"}}]}},\"k_4.good_for_you\":{\"id\":\"k_4.good_for_you\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Good for you...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She sighs. \\\"Maybe we'll have to downsize. Maybe I won't be able to give you money anymore.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's fine...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"By the way, thanks for coming here. I'll be fine now.\\\"\"}]},\"s_1.back_home\":{\"id\":\"s_1.back_home\",\"options\":[{\"id\":\"@s_1.hug_s\"},{\"id\":\"@s_1.back_home_2\",\"title\":\"Why is he so good?\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Are you full?\\\", you ask.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. What about you?\\\"\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"\\\"I'll manage.\\\" \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"\\\"Yeah. I'm full too.\\\" \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"\\\"Are you sure? Aren't you going to eat something?\\\" \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"\\\"Maybe later.\\\" \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Okay. I have to brush my teeth now.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Do you have your own things?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. I brought my own toothbrush.\\\"\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['s1_meal'] == \\\"none\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['s1_meal'] != \\\"none\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['s1_meal'] == \\\"none\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['s1_meal'] == \\\"none\\\");\"}}]}},\"k_3.stops_talking\":{\"id\":\"k_3.stops_talking\",\"options\":[{\"id\":\"@k_3.stay_like_this\",\"title\":\"Stay like this.\"},{\"id\":\"@k_3.get_up\",\"title\":\"Get up.\"}],\"content\":{\"content\":\"K- stops talking, and moves closer to you.\",\"type\":\"paragraph\"}},\"a_1.money_finish\":{\"id\":\"a_1.money_finish\",\"options\":[{\"id\":\"@a_1.okay_see\",\"title\":\"\\\"Okay...\\\"\"},{\"id\":\"@a_1.maybe_see\",\"title\":\"\\\"Maybe...\\\"\"},{\"id\":\"@a_1.precondition\",\"title\":\"\\\"Is that a condition for the money?\\\"\"}],\"content\":{\"content\":\"\\\"Sure, anything for you,\\\" A- says. \\\"Anyway, could we possibly meet again soon? I really want to see you again.\\\"\",\"type\":\"paragraph\"}},\"a_2.stay_with_a\":{\"id\":\"a_2.stay_with_a\",\"onArrival\":[{\"$code\":\"Q['a_romance'] = (Q['a_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@a_2.uhhh\",\"title\":\"\\\"Uh...\\\"\"},{\"id\":\"@a_2.wife\",\"title\":\"\\\"Your wife...\\\"\"},{\"id\":\"@a_2.still_need_food\",\"title\":\"\\\"I still need to get groceries...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"You stare at A-. She is tall, and her colorful attire stands out among the blandly dressed men and women in the grocery store. Not like you. You are calibrated to blend in, and she might as well be calibrated to be noticed. \",{\"type\":\"emphasis-1\",\"content\":\"What if they see? What if they check her ID and it is wrong and then both of you would be subject to...\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Come on. Stop staring. There's something I'm looking for.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She leads you towards the spice aisle. Her hands hover above the dispensers. \\\"Oh, here it is!\\\" She waves a bottle of yellow powder at you triumphantly. \\\"It's cumin. The synthesizers must have been working again.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's great.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- makes an exaggerated frown. \\\"You don't sound too excited. Are you still eating rice and beans with no flavoring?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Uh...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. Maybe that's why you're so sad. How do you even live without spices?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Uh...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, I'm joking. But really, maybe we should try cooking together sometime?\\\"\"}]},\"a_3.my_life\":{\"id\":\"a_3.my_life\",\"goTo\":[{\"id\":\"a_3.love_choices\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You don't understand what it's like. This is just my life. Maybe for you it's different. Maybe for you it's just a game. You can go home and just leave this behind. Leave me behind.\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- sighs, and puts an arm around your shoulder. \\\"I don't think that's it. I... I really want this. I don't want to leave it all behind. Last time we met, I genuinely didn't even care if I got caught because it was just... it was just so empty. Like nothing mattered. And now, something does matter and I don't want to lose it...\\\"\"},{\"type\":\"paragraph\",\"content\":\"A pause. A- holds you closer, tighter. \\\"I'm worried. I'm worried about you and the future and... everything. Because I... fuck it, I still love you, okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"For some reason, there is a part of you that wants to laugh, because this scenario feels straight out of a drama, were it not for the fact of your identities.\"}]},\"food.starve_3\":{\"id\":\"food.starve_3\",\"title\":\"Do it.\",\"viewIf\":{\"$code\":\"return ((Q['days_starved'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 3;\\nQ['food'] = 1;\\nQ['days_starved'] = (Q['days_starved'] || 0) + 1;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"tags\":[\"starve\"],\"content\":{\"content\":\"You can survive without food for one more day. Nothing bad is going to happen, except for the fact that you feel too tired to exit your apartment or do work. A minor and temporary setback.\",\"type\":\"paragraph\"}},\"k_1.yes_meet_2\":{\"id\":\"k_1.yes_meet_2\",\"options\":[{\"id\":\"@k_1.hangup\",\"title\":\"A thread of hope.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I can be there...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"See you then.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She hangs up.\"}]},\"online_montage.cn11\":{\"id\":\"online_montage.cn11\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"MP sponsors bill aimed at terrorist sympathizers\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: MP sponsors bill aimed at terrorist sympathizers: \\\"Some of those behind the Uprising have yet to face justice.\\\"\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": all terrorists need to die\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}}]}},\"data.todo\":{\"id\":\"data.todo\",\"onArrival\":[{\"$code\":\"Q['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['day_data_seen'] = (Q['day_data_seen'] || 0) + 1;\"}],\"options\":[{\"id\":\"@data.file\",\"title\":\"File.\"},{\"id\":\"@data.discard\",\"title\":\"Discard.\"},{\"id\":\"@data.keep\",\"title\":\"Keep for yourself.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_liana.actually_go\":{\"id\":\"ending_liana.actually_go\",\"goTo\":[{\"id\":\"ending_liana.go_2\"}],\"content\":{\"content\":\"\\\"Actually, I'd rather go.\\\"\",\"type\":\"paragraph\"}},\"k_4.your_support\":{\"id\":\"k_4.your_support\",\"viewIf\":{\"$code\":\"return ((Q['k_romance'] || 0) <= 3);\"},\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-1\",\"content\":\"If she quits the job she won't be able to financially support you anymore\"},\" is a thought you have.\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, we'll figure something out, okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"By the way, thanks for coming here. I'll be fine now.\\\"\"}]},\"s_1.back_home_2\":{\"id\":\"s_1.back_home_2\",\"goTo\":[{\"id\":\"s_1.bedtime\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"S- is so \",{\"type\":\"emphasis-1\",\"content\":\"nice\"},\".\"]}},\"k_3.stay_like_this\":{\"id\":\"k_3.stay_like_this\",\"onArrival\":[{\"$code\":\"Q['k_romance'] = (Q['k_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_3.me_too\",\"title\":\"\\\"I'm tired too.\\\"\"},{\"id\":\"@k_3.shower\",\"title\":\"\\\"Do you want to take a shower?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You feel no need to move. You feel comfortable, safe. K- holds your hand, every part of her body pressed against yours.\"},{\"type\":\"paragraph\",\"content\":\"\\\"God, I'm so tired,\\\" she says. \\\"I haven't slept at all since getting out of the lab. I haven't slept for 24 hours and I haven't even taken a shower since last week.\\\"\"}]},\"a_1.precondition\":{\"id\":\"a_1.precondition\",\"options\":[{\"id\":\"@a_1.okay_see\",\"title\":\"\\\"Okay...\\\"\"},{\"id\":\"@a_1.maybe_see\",\"title\":\"\\\"Maybe...\\\"\"},{\"id\":\"@a_1.idk_see\",\"title\":\"\\\"I don't know...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Is that a condition for the money?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, of course not!\\\" An audible sigh. \\\"I just want to see you. Is it okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"It doesn't feel right to refuse.\"}]},\"a_2.uhhh\":{\"id\":\"a_2.uhhh\",\"options\":[{\"id\":\"@a_2.get_groceries\",\"title\":\"Get groceries.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Uh...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hold that thought. Let's get you some groceries.\\\"\"}]},\"a_3.really_about\":{\"id\":\"a_3.really_about\",\"options\":[{\"id\":\"@a_3.never_destroy\",\"title\":\"\\\"I would never sell you out.\\\"\"},{\"id\":\"@a_3.all_relationships\",\"title\":\"\\\"All relationships are built upon mutually assured destruction.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What are you really talking about?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I was ready to throw it all away. Last time we met, I genuinely didn't even care if I got caught because it was just... it was just so empty. Like nothing mattered. And now, something does matter and I don't want to lose it...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"We're in a state of mutually assured destruction, Em,\\\" she continues. \\\"The Ruling Party is posting bounties for stealth laverneans, and anyone who's interacted with children while wearing opposite-sex clothing. You sell me out, you don't have to worry about rent anymore. I sell you out,... We have the power to destroy each other, Em.\\\"\"}]},\"food.starve_4\":{\"id\":\"food.starve_4\",\"title\":\"Do it.\",\"viewIf\":{\"$code\":\"return (((Q['days_starved'] || 0) >= 2) && ((Q['days_starved'] || 0) < 4));\"},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 4;\\nQ['food'] = 1;\\nQ['days_starved'] = (Q['days_starved'] || 0) + 1;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"tags\":[\"starve\"],\"content\":{\"content\":\"Another day of no food. Studies have shown that humans can survive for at least seven days without food. You should be fine. Just a bit tired. Just a stronger headache than usual. Just the feeling of wanting to vomit without anything in your stomach that can be vomitted.\",\"type\":\"paragraph\"}},\"k_1.idk_meet_2\":{\"id\":\"k_1.idk_meet_2\",\"onArrival\":[{\"$code\":\"Q['k_idk_meet'] = 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, I still don't know...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Fine. I usually take S- out for a walk around that time anyway. Come by if you want to interact.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She hangs up.\"}]},\"online_montage.cn12\":{\"id\":\"online_montage.cn12\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"High fruit prices: are rioters and terrorists to blame?\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: High fruit prices: are terrorists and saboteurs to blame?\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": all terrorists need to die\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}}]}},\"data.decode\":{\"id\":\"data.decode\",\"newPage\":true,\"options\":[{\"id\":\"@data.decode_continue\",\"title\":\"...\"}],\"content\":{\"content\":\"Decoding...\",\"type\":\"paragraph\"}},\"ending_liana.stay_end\":{\"id\":\"ending_liana.stay_end\",\"goTo\":[{\"id\":\"endings\"}],\"achievement\":\"ending_5\",\"content\":[{\"type\":\"heading\",\"content\":\"End\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-2\",\"content\":\"Ending 5/9\"}}]},\"k_4.eat\":{\"id\":\"k_4.eat\",\"onArrival\":[{\"$code\":\"Q['food'] = (Q['food'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"k_4.still_money\",\"predicate\":{\"$code\":\"return ((Q['k_knows_a_affair'] || 0)===0);\"}},{\"id\":\"k_4.k_apology\",\"predicate\":{\"$code\":\"return ((Q['k_knows_a_affair'] || 0)===1);\"}}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"S-, have you eaten yet?\\\", you ask.\"},{\"type\":\"paragraph\",\"content\":\"He shakes his head. The three of you gather around the kitchen counter. K- has finally gotten up by herself. You serve three bowls. It tastes good, better than your usual. Sweet.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks,\\\" says K-.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thank you Aunt Em,\\\" says S-.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Um. Yeah. It's fine.\\\"\"}]},\"s_1.why_burgers\":{\"id\":\"s_1.why_burgers\",\"options\":[{\"id\":\"@s_1.cook_rice\",\"title\":\"\\\"I cook rice every day too.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why do you want burgers?\\\", you ask.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Mom just cooks rice every day. I want something new.\\\"\"}]},\"k_3.get_up\":{\"id\":\"k_3.get_up\",\"options\":[{\"id\":\"@k_3.me_too\",\"title\":\"\\\"I'm tired too.\\\"\"},{\"id\":\"@k_3.shower\",\"title\":\"\\\"Do you want to take a shower?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You force yourself up.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, don't push me!\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry... It was too tight back there.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- chuckles. \\\"Wow. Hey, at least I have the bed to myself now.\\\" She stretches out.\"},{\"type\":\"paragraph\",\"content\":\"\\\"God, I'm so tired,\\\" she continues. \\\"I haven't slept at all since getting out of the lab. I haven't slept for 24 hours and I haven't even taken a shower since last week.\\\"\"}]},\"a_1.okay_see\":{\"id\":\"a_1.okay_see\",\"options\":[{\"id\":\"@a_1.done\",\"title\":\"A- hangs up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's great! Maybe we could meet up at Founders Square again, and wander around the city just like the old days.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah, maybe.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, call me if you want to meet up, or if you need anything else!\\\"\"}]},\"a_2.wife\":{\"id\":\"a_2.wife\",\"options\":[{\"id\":\"@a_2.get_groceries\",\"title\":\"Get groceries.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What about your wife...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh wow. Do you think that she would think I'm having an affair with you?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Um...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She laughs. You're ashamed. \\\"She knows about you, remember? Not the lavernean part, but she knows we were a thing. She doesn't see you as a threat.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hold that thought. Let's get you some groceries.\\\"\"}]},\"a_3.never_destroy\":{\"id\":\"a_3.never_destroy\",\"goTo\":[{\"id\":\"a_3.love_choices\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I would never sell you out.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"And I would never sell you out either.\\\" A pause. A- holds you closer, tighter. \\\"I'm worried. I'm worried about you and the future and... everything. Because I... fuck it, I still love you, okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"For some reason, there is a part of you that wants to laugh, because this scenario feels straight out of a drama, were it not for the fact of your identities.\"}]},\"food.starve_5\":{\"id\":\"food.starve_5\",\"title\":\"Do it.\",\"viewIf\":{\"$code\":\"return ((Q['days_starved'] || 0) >= 4);\"},\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) + 5;\\nQ['food'] = 1;\\nQ['days_starved'] = (Q['days_starved'] || 0) + 1;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"tags\":[\"starve\"],\"options\":[{\"id\":\"@anxiety\",\"title\":\"You are breaking down.\"}],\"content\":{\"content\":\"Day ??? of no food. It is difficult to move. Everything hurts. You feel sick. You need to rest.\",\"type\":\"paragraph\"}},\"food\":{\"id\":\"food\",\"type\":\"scene\",\"title\":\"Food\",\"goTo\":[{\"id\":\"food.food_options\"}],\"newPage\":true,\"content\":{\"content\":\"You have no more edible food left in your apartment. What are you going to do?\",\"type\":\"paragraph\"}},\"k_1.hangup\":{\"id\":\"k_1.hangup\",\"options\":[{\"id\":\"@k_1.only_support\",\"title\":\"Only some financial support. Nothing more.\"},{\"id\":\"@k_1.see_her_again\",\"title\":\"You want to see her again.\"},{\"id\":\"@k_1.idk_meeting_her\",\"title\":\"You don't know.\"}],\"content\":{\"content\":\"What are you hoping for, by meeting her?\",\"type\":\"paragraph\"}},\"online_montage.cn13\":{\"id\":\"online_montage.cn13\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Suspected rioter shows no vital signs after initiating altercation against Guards.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Suspected rioter shows no vital signs after initiating altercation against Guards.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": good\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": great news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}}]}},\"data.decode_continue\":{\"id\":\"data.decode_continue\",\"goTo\":[{\"id\":\"jumpScene\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_liana.tired_too\":{\"id\":\"ending_liana.tired_too\",\"goTo\":[{\"id\":\"ending_liana.want_to_go\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) >= 3);\"}},{\"id\":\"ending_liana.questions_1\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) < 3);\"}}],\"onArrival\":[{\"$code\":\"Q['liana_qs'] = (Q['liana_qs'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Do you also get tired for no reason?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you asking if your chronic fatigue syndrome is genetic?\\\" She laughs. \\\"Well, I can't say I've never had symptoms back when I was your age, but it never got quite as bad. But really, it's hardly genetic. Take a look around you and think if any normal person wouldn't get tired of it all.\\\"\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"She takes a look at your drug stockpile. \\\"Wow, this concentration is pathetic. Back in my day we made bathtub estradiol valerate that was better than this. No wonder you're tired all the time.\\\"\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['medicine'] || 0) > 1);\"}}]},\"countVisitsMax\":1},\"k_4.k_gets_up\":{\"id\":\"k_4.k_gets_up\",\"goTo\":[{\"id\":\"k_4.still_money\",\"predicate\":{\"$code\":\"return ((Q['k_knows_a_affair'] || 0)===0);\"}},{\"id\":\"k_4.k_apology\",\"predicate\":{\"$code\":\"return ((Q['k_knows_a_affair'] || 0)===1);\"}}],\"content\":[{\"type\":\"paragraph\",\"content\":\"K- has finally gotten up by herself. Her tears have stopped, but her eyes are still red. \\\"You don't have to do this, you know.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm doing this because I want to,\\\" you say.\"}]},\"k_4\":{\"id\":\"k_4\",\"type\":\"scene\",\"title\":\"A call from K-.\",\"subtitle\":\"Many calls, in fact.\",\"viewIf\":{\"$code\":\"return ((((((Q['k_path'] || 0)===3) && ((Q['day'] || 0) >= ((Q['k_day'] || 0) + 2))) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0)))) && ((Q['day'] || 0) < 20)) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0)));\"},\"onArrival\":[{\"$code\":\"Q['k_path'] = 4;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"frequency\":1000,\"priority\":10,\"tags\":[\"minor\"],\"newPage\":true,\"options\":[{\"id\":\"@k_4.go_there\",\"title\":\"\\\"Okay. I'll be there.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You receive a phone call from K-'s household.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Mama? I mean, Aunt Em?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes, S-?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Something's wrong with mom. She's just sitting here. Not moving. Talking to herself. When I talk to her she doesn't say anything.\\\"\"}]},\"s_1.cook_rice\":{\"id\":\"s_1.cook_rice\",\"onArrival\":[{\"$code\":\"Q['s1_knows_cook_rice'] = 1;\"}],\"options\":[{\"id\":\"@s_1.gray_mush\",\"title\":\"\\\"I didn't always eat rice...\\\"\"},{\"id\":\"@s_1.mom_taught\",\"title\":\"\\\"Your mom taught me how to cook rice.\\\"\"},{\"id\":\"@s_1.food_home\",\"title\":\"\\\"We have food at home.\\\"\"},{\"id\":\"@s_1.no_food_no_money\",\"title\":\"\\\"We do not have food at home, and we do not have enough money to go out to eat.\\\"\"},{\"id\":\"@s_1.go_burgers\",\"title\":\"\\\"Alright. Let's go.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I cook rice every day too,\\\" you say. \\\"Sometimes with beans though.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. You and mom are like the same person.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"We are, aren't we?\\\" You sigh.\"}]},\"k_3.smell_like_a\":{\"id\":\"k_3.smell_like_a\",\"viewIf\":{\"$code\":\"return ((Q['a_encounter'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['k_knows_a_affair'] = 1;\"}],\"options\":[{\"id\":\"@k_3.yes_i_fucked\",\"title\":\"\\\"Yes, I did...\\\"\"},{\"id\":\"@k_3.sorry_fucked\",\"title\":\"\\\"Sorry...\\\"\"},{\"id\":\"@k_3.she_pronouns\",\"title\":\"\\\"It's 'she'.\\\"\"},{\"id\":\"@k_3.we_both_did\",\"title\":\"\\\"We both did, remember?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Suddenly she begins to sniff the bed. \\\"This smells like A-.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You fucked him, didn't you? I remember that smell. It used to be everywhere in our old place.\\\"\"}]},\"a_1.maybe_see\":{\"id\":\"a_1.maybe_see\",\"options\":[{\"id\":\"@a_1.done\",\"title\":\"A- hangs up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, maybe,\\\" you say. \\\"I'm...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No, it's fine,\\\" he says. \\\"I understand if you don't want to see me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's not that, it's... just...\\\" You don't know what to say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, then, just call me if you want to meet up, or if you need anything else.\\\"\"}]},\"a_2.get_groceries\":{\"id\":\"a_2.get_groceries\",\"options\":[{\"id\":\"@a_2.separate_r\",\"title\":\"This is where you separate.\"},{\"id\":\"@a_2.separate_no_r\",\"title\":\"This is where you separate.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"A- leads you to pick up your staples, rice and legumes. Her left hand is behind your back, a protective gesture, guiding you as if you were a younger sister, while holding a basket with her right. You look normal. No one is going to notice anything wrong.\"},{\"type\":\"paragraph\",\"content\":\"She checks out and pays for you. No need for you to say a thing.\"}]},\"a_3.all_relationships\":{\"id\":\"a_3.all_relationships\",\"goTo\":[{\"id\":\"a_3.love_choices\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"All relationships are built upon mutually assured destruction.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I would hope not, but maybe you're right.\\\" A pause. A- holds you closer, tighter. \\\"I'm worried. I'm worried about you and the future and... everything. Because I... fuck it, I still love you, okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"For some reason, there is a part of you that wants to laugh, because this scenario feels straight out of a drama, were it not for the fact of your identities.\"}]},\"k_1.only_support\":{\"id\":\"k_1.only_support\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Only some financial support. Nothing more.\"},{\"type\":\"paragraph\",\"content\":\"Okay.\"}]},\"online_montage.cn14\":{\"id\":\"online_montage.cn14\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Superintendent of schools: teachers and students alike are inadequate to face modern challenges.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Superintendent of schools: teachers and students alike are inadequate to face modern challenges.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d606\":{\"id\":\"data.d606\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"D606.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key101'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('d606'); Q.correct_data_types.push('personal'); Q.d_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.d606_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_liana.first_time\":{\"id\":\"ending_liana.first_time\",\"goTo\":[{\"id\":\"ending_liana.want_to_go\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) >= 3);\"}},{\"id\":\"ending_liana.questions_1\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) < 3);\"}}],\"onArrival\":[{\"$code\":\"Q['liana_qs'] = (Q['liana_qs'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Is this the first time you've done this? Make a clone of yourself, I mean?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No. It's not. There are many versions of me, versions of you, running around throughout the arcologies, all living their own separate lives. Compared to them, you're... not the worst off.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She does not elaborate any further.\"}],\"countVisitsMax\":1},\"s_1.gray_mush\":{\"id\":\"s_1.gray_mush\",\"options\":[{\"id\":\"@s_1.mom_taught\",\"title\":\"\\\"Your mom taught me how to cook rice.\\\"\"},{\"id\":\"@s_1.begin_cooking\",\"title\":\"Just start cooking.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I didn't always eat rice, actually. I used to eat gray mush all the time when I was your age.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Gross. That's all they give us at school. It makes me want to throw up.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. It is gross. That's all they had at the children's center.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry. That sucks.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes. It did suck.\\\"\"}]},\"k_3.yes_i_fucked\":{\"id\":\"k_3.yes_i_fucked\",\"goTo\":[{\"id\":\"k_3.thats_gross\"}],\"content\":{\"content\":\"\\\"Yes, I did...\\\"\",\"type\":\"paragraph\"}},\"a_1.idk_see\":{\"id\":\"a_1.idk_see\",\"options\":[{\"id\":\"@a_1.done\",\"title\":\"A- hangs up.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, I don't know,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's fine,\\\" he says. \\\"I understand if you don't want to see me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's not that, it's... just...\\\" You don't know what to say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, then, just call me if you want to meet up, or if you need anything else.\\\"\"}]},\"a_2.still_need_food\":{\"id\":\"a_2.still_need_food\",\"options\":[{\"id\":\"@a_2.separate_r\",\"title\":\"This is where you separate.\"},{\"id\":\"@a_2.separate_no_r\",\"title\":\"This is where you separate.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I still need to get groceries...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. The usual?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes...\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- guides you to pick up rice and legumes. Her hand is behind your back, guiding you as if you were a younger sister. In the end, she pays for you.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm serious about cooking together, by the way.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh...\\\"\"}]},\"a_3.why_you_r\":{\"id\":\"a_3.why_you_r\",\"viewIf\":{\"$code\":\"return ((Q['kissed_a'] || 0)===1);\"},\"goTo\":[{\"id\":\"a_3.love_choices\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"\\\"Why are \",{\"type\":\"emphasis-1\",\"content\":\"you\"},\" doing this?\\\"\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Because I... fuck it, I still love you, okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"For some reason, there is a part of you that wants to laugh, because this scenario feels straight out of a drama, were it not for the fact of your identities.\"}]},\"k_1.see_her_again\":{\"id\":\"k_1.see_her_again\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You want to see her again.\"},{\"type\":\"paragraph\",\"content\":\"Okay.\"}]},\"online_montage.cn15\":{\"id\":\"online_montage.cn15\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"University scientist: plant nanoplagues pose threat to food security.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: University scientist: plant nanoplagues pose threat to food security.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d606_\":{\"id\":\"data.d606_\",\"goTo\":[{\"id\":\"data.d606_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"BSRI DNA Diaries Project - #83\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"If you're reading this, I am dead. The doctors said I have probably no more than a year to live. You'd think I'd be feeling sad or something, but instead, I'm feeling nothing at all. I wish I could think about my family. I wish I could think of anything at all.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Here's the standard intro: my name is Akshay S (he/him), and I do genomics work here at the institute. I was born around Vancouver, with two older siblings. I am a husband and father of a young child. There are probably hundreds of people with nearly identical backgrounds. I don't know what I did to deserve being memorialized like this.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Jiaren says that death doesn't have to happen. She says that we can cure aging and death with some of the methods we're developing here. Even glioblastoma will be curable, she says. It won't be enough for me.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Tomorrow, I'm having a going away party. An early retirement party, combined with a living funeral, although my colleagues are steadfast in refusing to call it as such.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I hope your world is better than mine.\"}}]},\"ending_liana.what_learn\":{\"id\":\"ending_liana.what_learn\",\"goTo\":[{\"id\":\"ending_liana.want_to_go\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) >= 3);\"}},{\"id\":\"ending_liana.questions_1\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) < 3);\"}}],\"onArrival\":[{\"$code\":\"Q['liana_qs'] = (Q['liana_qs'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What did you learn from me?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, many things! First of all, you turned out to be trans, or a lavernean as you would say, which was great. Not every clone turned out that way. Second of all, you went into science, to which I say, good for you. And third, you turned out to be fucked up in some ways I could only imagine.\\\" She laughs.\"}],\"countVisitsMax\":1},\"s_1.mom_taught\":{\"id\":\"s_1.mom_taught\",\"options\":[{\"id\":\"@s_1.technically\",\"title\":\"\\\"Technically...\\\"\"},{\"id\":\"@s_1.idk_mom\",\"title\":\"\\\"It's complicated...\\\"\"},{\"id\":\"@s_1.trying_mom\",\"title\":\"\\\"I can try to be...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Your mom taught me how to cook rice. I didn't know very much cooking before I met her.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wait, aren't you my mom too, technically?\\\"\"}]},\"k_3.sorry_fucked\":{\"id\":\"k_3.sorry_fucked\",\"goTo\":[{\"id\":\"k_3.thats_gross\"}],\"content\":{\"content\":\"\\\"Sorry...\\\"\",\"type\":\"paragraph\"}},\"a_1.done\":{\"id\":\"a_1.done\",\"options\":[{\"id\":\"@a_1.maybe_fine\",\"title\":\"Maybe seeing A- again would be fine.\"},{\"id\":\"@a_1.dont_want\",\"title\":\"You do not want to see his face.\"},{\"id\":\"@a_1.doesnt_matter\",\"title\":\"It doesn't matter either way.\"}],\"content\":{\"content\":\"A- hangs up, leaving you alone with your thoughts. At least you are slightly further from total destitution.\",\"type\":\"paragraph\"}},\"a_2.wander_off\":{\"id\":\"a_2.wander_off\",\"onArrival\":[{\"$code\":\"Q['food'] = (Q['food'] || 0) + 5;\"}],\"options\":[{\"id\":\"@a_2.separate_r\",\"title\":\"This is where you separate.\"},{\"id\":\"@a_2.separate_no_r\",\"title\":\"This is where you separate.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You need rice, meats, and vegetables. You wander off, and see that you've lost A- along the way. The shelves are stocked with rice and your preferred species of legumes, thankfully. There are no fresh vegetables, as usual, so you take some canned mushrooms.\"},{\"type\":\"paragraph\",\"content\":\"As you reach the checkout, A- taps your shoulder. \\\"Hey, look what I found!\\\" She shows a cannister with a yellow powder. \\\"It's cumin. They usually don't have it here.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, uh, good for you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You should really try to have more spices in your life.\\\" She takes your basket from you and checks out.\"}]},\"a_3.laugh\":{\"id\":\"a_3.laugh\",\"options\":[{\"id\":\"@a_3.mistake\",\"title\":\"\\\"This was a mistake.\\\"\"},{\"id\":\"@a_3.mistress\",\"title\":\"\\\"I'm not going to be a mistress for you.\\\"\"},{\"id\":\"@a_3.still_love\",\"title\":\"\\\"I know it's a mistake, but I still love you too...\\\"\"},{\"id\":\"@a_3.still_love_money\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"For whatever reason, the chemical pathways in your brain have decided that this moment would lead to laughter.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Fuck, what did I do wrong?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Nothing! It's just... it's so dramatic.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What's so dramatic?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I was using 'dramatic' in the sense of, this is such a typical scenario seen in TV dramas.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh.\\\"\"}]},\"k_1.idk_meeting_her\":{\"id\":\"k_1.idk_meeting_her\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You don't know.\"},{\"type\":\"paragraph\",\"content\":\"Okay.\"}]},\"k_1\":{\"id\":\"k_1\",\"type\":\"scene\",\"title\":\"Call K-\",\"subtitle\":\"A scientist. Your ex-partner.\",\"tags\":[\"minor\"],\"newPage\":true,\"viewIf\":{\"$code\":\"return (((((Q['k_path'] || 0)===0) && ((((Q['day_minor'] || 0)===0) || ((Q['day_major'] || 0)===0)))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"chooseIf\":{\"$code\":\"return (((Q['numb'] || 0)===1) || ((Q['rent_due'] || 0)===1));\"},\"onArrival\":[{\"$code\":\"Q['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['daily_k'] = 1;\\nQ['stress'] = (Q['stress'] || 0) + 1;\"}],\"unavailableSubtitle\":\"You are too self-aware to make the phone call. You must numb yourself first.\",\"options\":[{\"id\":\"@k_1.past\",\"title\":\"You and K- were married once.\"},{\"id\":\"@k_1.call\",\"title\":\"Make the call.\"}],\"content\":{\"content\":\"You need money for rent. There are two people who have a nonzero probability of helping you out at this moment. K- is one of them.\",\"type\":\"paragraph\"}},\"online_montage.cn16\":{\"id\":\"online_montage.cn16\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Trailer for Long Live the Guards III released.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"@NNN: Trailer for Long Live the Guards III released.\"}}},\"data.d606_c\":{\"id\":\"data.d606_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_liana.plant_diaries\":{\"id\":\"ending_liana.plant_diaries\",\"goTo\":[{\"id\":\"ending_liana.want_to_go\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) >= 3);\"}},{\"id\":\"ending_liana.questions_1\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) < 3);\"}}],\"onArrival\":[{\"$code\":\"Q['liana_qs'] = (Q['liana_qs'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Did you plant the diaries in the Archives? Were they really a hoax?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes, I did. They detected that it was inauthentic, which was surprising, although I think they went by the fact that the content did not conform to their preconceptions of me, and never detected my security breach in their networks. The computer breach is still open, by the way.\\\"\"}],\"countVisitsMax\":1},\"s_1.technically\":{\"id\":\"s_1.technically\",\"goTo\":[{\"id\":\"s_1.mom_test\"}],\"content\":{\"content\":\"\\\"Technically, I suppose. Do you want me to be?\\\"\",\"type\":\"paragraph\"}},\"k_3.she_pronouns\":{\"id\":\"k_3.she_pronouns\",\"goTo\":[{\"id\":\"k_3.thats_gross\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's 'she'.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"A- still uses 'she' pronouns.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Whatever. You fucked A- here, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You nod.\"}]},\"a_1.maybe_fine\":{\"id\":\"a_1.maybe_fine\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_2.separate_no_r\":{\"id\":\"a_2.separate_no_r\",\"viewIf\":{\"$code\":\"return ((Q['a_romance'] || 0) < 3);\"},\"options\":[{\"id\":\"@a_2.will_call\",\"title\":\"You will call her.\"},{\"id\":\"@a_2.wont_call\",\"title\":\"You have no plans to call her.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So I'll see you again?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Let me know if you need anything. Money, food, whatever. I can even put you up if you need a place to live for a while.\\\"\"},{\"type\":\"paragraph\",\"content\":\"You are alone again.\"}]},\"a_3.married\":{\"id\":\"a_3.married\",\"options\":[{\"id\":\"@a_3.mistake\",\"title\":\"\\\"This was a mistake.\\\"\"},{\"id\":\"@a_3.mistress\",\"title\":\"\\\"I'm not going to be a mistress for you.\\\"\"},{\"id\":\"@a_3.still_love\",\"title\":\"\\\"I know it's a mistake, but I still love you too...\\\"\"},{\"id\":\"@a_3.still_love_money\",\"title\":\"\\\"I know it's a mistake, but I still love you too...\\\" (but in truth you need her financial support)\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You're married...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. Shit happens. Ha.\\\" She smirks. \\\"I do care about her. I care about our children. It's just that there's this secret side of me that I can never show around them. It's like I'm only living half a life around them.\\\"\"}]},\"online_montage.cn17\":{\"id\":\"online_montage.cn17\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Heartwarming: students stand up to female-impersonator teacher promoting gender ideology.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Heartwarming: students stand up to female-impersonator teacher promoting gender ideology.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d77\":{\"id\":\"data.d77\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"D77.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return (((Q['key7'] || 0)===1) || ((Q['key11'] || 0)===1));\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('d77'); Q.correct_data_types.push('personal'); Q.d_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.d77_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"ending_liana.i_dont_believe\":{\"id\":\"ending_liana.i_dont_believe\",\"goTo\":[{\"id\":\"ending_liana.want_to_go\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) >= 3);\"}},{\"id\":\"ending_liana.questions_1\",\"predicate\":{\"$code\":\"return ((Q['liana_qs'] || 0) < 3);\"}}],\"onArrival\":[{\"$code\":\"Q['liana_qs'] = (Q['liana_qs'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't believe you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Why don't you believe me? More importantly, why do you think I would lie to you?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You already said this isn't your original body so... I don't know what even is the real you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Then I suppose you can believe whatever you want. But don't tell me that you read my story and didn't find bits of it that felt awfully relevant. That was all real, by the way. None of it was fake.\\\"\"},{\"type\":\"paragraph\",\"content\":\"For some reason, you feel inclined to trust her on the last point, if nothing else.\"}],\"countVisitsMax\":1},\"ending_liana\":{\"id\":\"ending_liana\",\"type\":\"scene\",\"title\":\"Liana - Ending\",\"options\":[{\"id\":\"@ending_liana.drink\",\"title\":\"Drink.\"}],\"content\":{\"content\":\"A figure appears in the doorway, and walks over to you. \\\"Here. Drink this.\\\" They prop you up so you are seated, and hand you a bottle of some unknown beverage.\",\"type\":\"paragraph\"}},\"s_1.idk_mom\":{\"id\":\"s_1.idk_mom\",\"goTo\":[{\"id\":\"s_1.mom_test\"}],\"content\":{\"content\":\"\\\"It's complicated...\\\"\",\"type\":\"paragraph\"}},\"k_3.we_both_did\":{\"id\":\"k_3.we_both_did\",\"goTo\":[{\"id\":\"k_3.thats_gross\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"We both did, remember?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What, ten years ago? That's different. You were doing it not so long ago, here on this bed, correct?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You nod.\"}]},\"a_1.dont_want\":{\"id\":\"a_1.dont_want\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_2.will_call\":{\"id\":\"a_2.will_call\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_3.mistake\":{\"id\":\"a_3.mistake\",\"title\":\"\\\"This was a mistake.\\\"\",\"options\":[{\"id\":\"@a_3.still_friends\"},{\"id\":\"@a_3.suppose_not\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"This was a mistake.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What was?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Everything we're doing right now.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Sorry then. Then forget we ever had this conversation. Do we have anything more to talk about?\\\"\"}]},\"online_montage.cn18\":{\"id\":\"online_montage.cn18\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Quarterly profits in ag-tech sector up despite greenhouse failures.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Quarterly profits in ag-tech sector up despite greenhouse failures.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d77_\":{\"id\":\"data.d77_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"BSRI DNA Diaries Project - #12\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"The DNA data storage team has been soliciting diary entries for their in vivo storage experiment. Well, here goes.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"I'm not exactly the kind of person who likes talking about myself. My name is Imani K, from Toronto. I am a computational scientist working on biosystems modeling, more specifically on microbial dynamics within communities. It is a fascinating subject, the one I wrote my PhD dissertation on. I wish I could attach that instead of a diary. It would most likely be more useful and interesting for you, whoever you are.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I am supposed to write more about myself here. So: today I got up at 7AM and took the subway here. There. That's it. Thank you. Now where is my gift card.\"}}]},\"s_1.trying_mom\":{\"id\":\"s_1.trying_mom\",\"goTo\":[{\"id\":\"s_1.mom_test\"}],\"content\":{\"content\":\"\\\"I can try to be... If you want me to be?\\\"\",\"type\":\"paragraph\"}},\"k_3.thats_gross\":{\"id\":\"k_3.thats_gross\",\"options\":[{\"id\":\"@k_3.why_hate\",\"title\":\"\\\"Why do you hate A-?\\\"\"}],\"content\":{\"content\":\"\\\"That's fucking gross.\\\"\",\"type\":\"paragraph\"}},\"a_1.doesnt_matter\":{\"id\":\"a_1.doesnt_matter\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_2.wont_call\":{\"id\":\"a_2.wont_call\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"a_3.suppose_not\":{\"id\":\"a_3.suppose_not\",\"title\":\"\\\"I suppose not.\\\"\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I suppose not.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay then.\\\"\"},{\"type\":\"paragraph\",\"content\":\"The next few minutes are long and tense, until A- finally rises. You are alone, again.\"}]},\"online_montage.cn19\":{\"id\":\"online_montage.cn19\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"New startup helps authorities identify suspected rioters using computer vision.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: New startup helps authorities identify suspected rioters using computer vision.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d19\":{\"id\":\"data.d19\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"D19.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key19'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('d19'); Q.correct_data_types.push('obscene'); Q.d_seen += 1;\"}],\"frequency\":200,\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.d19_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.mom_test\":{\"id\":\"s_1.mom_test\",\"options\":[{\"id\":\"@s_1.begin_cooking\",\"title\":\"Begin cooking.\"},{\"id\":\"@s_1.go_burgers\",\"title\":\"\\\"Alright. Let's go get burgers.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"He crosses his arms. \\\"Hmm... Maybe this is a test. If you pass it you can be my second mom.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"And how would I know if I've passed?\\\"\"},{\"type\":\"paragraph\",\"content\":\"He shrugs. \\\"I dunno. If I'm not hungry tonight.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Then I've already failed being my own mom.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. That's sad.\\\"\"}]},\"k_3.why_hate\":{\"id\":\"k_3.why_hate\",\"options\":[{\"id\":\"@k_3.a_unfair\",\"title\":\"\\\"That's unfair...\\\"\"},{\"id\":\"@k_3.not_affair\",\"title\":\"\\\"Not because she's having an extramarital affair?\\\"\"},{\"id\":\"@k_3.hey_money\",\"title\":\"\\\"Hey, she's giving me money.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Why do you hate A-?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"He's a privileged asshole. We were just his little jaunt, like a fucking vacation trip. He could have his fill of debauched fun and meanwhile we're still living the nightmare.\\\"\"}]},\"a_1.talk\":{\"id\":\"a_1.talk\",\"options\":[{\"id\":\"@a_1.job\",\"title\":\"\\\"I lost my job...\\\"\"},{\"id\":\"@a_1.homeless\",\"title\":\"\\\"I'm about to be homeless...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I missed you too...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah... But there has to be something else going on, right? Otherwise you wouldn't call?\\\"\"},{\"type\":\"paragraph\",\"content\":\"Unfortunately, he still knows you well.\"}]},\"a_1\":{\"id\":\"a_1\",\"type\":\"scene\",\"title\":\"Call A-\",\"subtitle\":\"A doctor. Your ex-partner.\",\"tags\":[\"minor\"],\"viewIf\":{\"$code\":\"return (((((Q['a_path'] || 0)===0) && ((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0)))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['day_minor'] = 1;\\nQ['daily_a'] = 1;\\nQ['a_day'] = (Q['day'] || 0);\"}],\"chooseIf\":{\"$code\":\"return (((Q['numb'] || 0)===1) || ((Q['rent_due'] || 0)===1));\"},\"newPage\":true,\"unavailableSubtitle\":\"You are too self-aware to make the phone call. You must numb yourself first.\",\"options\":[{\"id\":\"@a_1.a_11\",\"title\":\"A- is a doctor now.\"},{\"id\":\"@a_1.call\",\"title\":\"Call A-.\"}],\"content\":{\"content\":\"You need money for rent. There are two people who have a nonzero probability of helping you out at this moment. A- is one of them.\",\"type\":\"paragraph\"}},\"a_2.separate_r\":{\"id\":\"a_2.separate_r\",\"viewIf\":{\"$code\":\"return ((Q['a_romance'] || 0) >= 3);\"},\"options\":[{\"id\":\"@a_2.risk_it\",\"title\":\"Risk it.\"},{\"id\":\"@a_2.no_risk\",\"title\":\"Pull away.\"},{\"id\":\"@a_2.est\",\"title\":\"\\\"You smell like estrogen.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"As you leave the store, you find yourselves in a secluded locale. There is an alcove here, hidden from the store patrons and the houses. The bag drops.\"},{\"type\":\"paragraph\",\"content\":[\"A- is standing close to you. Dangerously close. Your bodies touching. You feel her breath in your ears. Even through your mask you can \",{\"type\":\"emphasis-1\",\"content\":\"smell\"},\" her (a sign of poor fit or filtration?). Her hands are wrapped around your wrist and behind your back (a hug? are you correctly understanding the implications?). She is looking at you.\"]},{\"type\":\"paragraph\",\"content\":\"You are alone here. No one is watching, not even a security camera.\"}]},\"a_3.mistress\":{\"id\":\"a_3.mistress\",\"options\":[{\"id\":\"@a_3.still_friends\"},{\"id\":\"@a_3.can_leave\"},{\"id\":\"@a_3.still_love\"},{\"id\":\"@a_3.still_love_money\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I'm not going to be your mistress.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Okay. You don't have to be. We don't have to define ourselves in such a stereotypical way.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Then how would you define this?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"A paramour, maybe?\\\" She laughs. You laugh too.\"}]},\"online_montage.cn20\":{\"id\":\"online_montage.cn20\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"New memoir criticized as \\\"glorifying moral turpitude\\\".\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: New memoir criticized as \\\"glorifying moral turpitude.\\\"\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d19_\":{\"id\":\"data.d19_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"BSRI DNA Diaries Project - #22\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Hello, person/alien/robot/sentient being from the future. Thank you for reading my diary. I'm glad we can have this little moment of shared connection :)\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"(omg I just remembered they said to not use emoji :( oh well if they reject it then that means they've read it and they promised they wouldn't so joke's on them.)\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"My name is Divya P (she/they (wait omg they said future-person might not understand emoji but they would understand pronoun declarations??? lmao)) and I am a software developer at BSRI. I'm 29 years old, and I was born and raised in Toronto (Richmond Hill rather, but who's counting). I don't think I've been out of Ontario for more than a month my whole life. Wow. Sad.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Anyway, I would like to take this opportunity to talk about the love of my life. Stella, our names will be inscribed into the code that governs the future of life on Earth. May the record of our love propagate through countless generations, just like the eternity I feel when I kiss you every day. May our love conquer death <3\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Haha, was that too over-the-top? I'm not good at writing lol\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"You knew that the past was a more enlightened time.\"}]},\"s_1.begin_cooking\":{\"id\":\"s_1.begin_cooking\",\"options\":[{\"id\":\"@s_1.fun_book\",\"title\":\"\\\"Is this a fun book?\\\"\"},{\"id\":\"@s_1.wait_cooking\",\"title\":\"Wait for the rice to finish.\"},{\"id\":\"@s_1.cook_2\",\"title\":\"Prepare another dish.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You fill the pressure cooker pot with rice. There are meats too - mung beans, red beans, and lentils added for extra nutrition and flavoring. K- taught you this. You rinse the mixture until it is no longer cloudy, and fill the pot to the top mark with water.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thirty minutes,\\\" you say, turning on the cooker.\"},{\"type\":\"paragraph\",\"content\":\"Meanwhile S- is sitting on your bed, flipping through the pages of a computer programming textbook.\"}]},\"k_3.a_unfair\":{\"id\":\"k_3.a_unfair\",\"options\":[{\"id\":\"@k_3.she_wont_condemn\",\"title\":\"\\\"She won't condemn me...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"That's unfair...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"What is?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"She's at risk too if they find out. If they discover these 'jaunts' then it's over for her too...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's fucking not. He's going to be fine. He can just say that you were manipulating him and then it's a perfect defense.\\\"\"}]},\"a_2.risk_it\":{\"id\":\"a_2.risk_it\",\"onArrival\":[{\"$code\":\"Q['kissed_a'] = 1;\\nQ['a_romance'] = (Q['a_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@a_2.fuck_off\",\"title\":\"\\\"Oh, fuck off.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"She knows what to do. You know what to do.\"},{\"type\":\"paragraph\",\"content\":[\"You pull down your mask, and she pulls down hers. She is wearing \",{\"type\":\"emphasis-1\",\"content\":\"lipstick\"},\" of all things. A dangerously irrational gesture.\"]},{\"type\":\"paragraph\",\"content\":\"She pulls you in. You open your mouth. Close your eyes. Her lips taste of wax and artificial flavoring. Something is dripping on your face.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. Are you that hungry for a taste of me?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You realize that you have been drooling. Embarassing.\"}]},\"a_3.still_friends\":{\"id\":\"a_3.still_friends\",\"title\":\"\\\"Can we still be friends?\\\"\",\"onArrival\":[{\"$code\":\"Q['a_friends'] = 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Can we still be friends?\\\"\"},{\"type\":\"paragraph\",\"content\":\"A- rests her chin in her hands. \\\"I don't know. Maybe I've said too much already. It's just... Okay. Forget it. Forget anything I've said today. Let's go back to before.\\\"\"}]},\"online_montage.cn21\":{\"id\":\"online_montage.cn21\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Ntech CEO Leblanc accused of sexual harassment by assistant.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Ntech CEO Leblanc accused of sexual harassment by assistant.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": fake news\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}}]}},\"data.d31\":{\"id\":\"data.d31\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"D31.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key31'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('d31'); Q.correct_data_types.push('personal'); Q.d_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.d31_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.fun_book\":{\"id\":\"s_1.fun_book\",\"maxVisits\":1,\"options\":[{\"id\":\"@s_1.teach_s\",\"title\":\"Teach him?\"},{\"id\":\"@s_1.wait_cooking\",\"title\":\"Wait for the rice to finish.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Is this a fun book?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Not really.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Do you want to learn more about computers?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I guess. Maybe.\\\"\"}],\"countVisitsMax\":1},\"k_3.she_wont_condemn\":{\"id\":\"k_3.she_wont_condemn\",\"options\":[{\"id\":\"@k_3.awkward_a\",\"title\":\"It is extremely awkward in here.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"She won't condemn me...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You shrug.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, whatever.\\\"\"}]},\"a_2.fuck_off\":{\"id\":\"a_2.fuck_off\",\"goTo\":[{\"id\":\"a_2.walk_end\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh, fuck off.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh, Em...\\\" A- ruffles your hair. You instinctively grab her wrist. \\\"I missed you. I really do. I know it can't go back to the way it was before, but... maybe things could be different. Maybe we could... I don't know.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Maybe...\\\"\"}]},\"a_3.can_leave\":{\"id\":\"a_3.can_leave\",\"title\":\"\\\"Can I leave now?\\\"\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Can I leave now?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Of course you can leave. You can leave whenever you want.\\\"\"}]},\"online_montage.cn22\":{\"id\":\"online_montage.cn22\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"Museum of the American Empire opens in New Buffalo District.\"},\"maxVisits\":1,\"countVisitsMax\":1,\"tags\":[\"montage\"],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"@NNN: Museum of the American Empire opens in New Buffalo District.\"},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":0},\": great news\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":1},\": long live the ametican empire\"]},\"\"]},{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-3\",\"content\":[\"@\",{\"type\":\"insert\",\"insert\":2},\": can't wait\"]}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_0'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_1'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['name_2'] || 0);\"}}]}},\"online_montage\":{\"id\":\"online_montage\",\"type\":\"scene\",\"title\":\"CityNet\",\"subtitle\":{\"content\":[\"An update on the present situation. \",{\"type\":\"conditional\",\"content\":\"CW: slurs\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]},\"maxChoices\":3,\"viewIf\":{\"$code\":\"return (((((Q['montage_progress'] || 0)===0) && ((Q['day_minor'] || 0)===0)) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['montage_progress'] = (Q['montage_progress'] || 0) + 1;\\nQ['numb'] = 1;\\nQ['day_minor'] = (Q['day_minor'] || 0) + 1;\"}],\"newPage\":true,\"tags\":[\"minor\"],\"setBg\":\"images/monitor_dithered.png\",\"options\":[{\"id\":\"@online_montage.cn1\"},{\"id\":\"@online_montage.cn3\"},{\"id\":\"@online_montage.cn5\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"CityNet is the beating heart of the city, the online agora where its citizens gather to discuss, debate, and disseminate their opinions or the news of the day. At least, that is theoretically the case.\"},{\"type\":\"paragraph\",\"content\":\"After the Cataclysm, all communications links outside the city were severed. With its monopoly on data transmission via wired infrastructure, CityNet is all that remains. All user identities are fixed to their \\\"real\\\" names or registered organizations.\"},{\"type\":\"paragraph\",\"content\":\"What are the headlines of the day?\"}]},\"data.d31_\":{\"id\":\"data.d31_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"BSRI DNA Diaries Project - #2\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"My name is Gonzalo W (he/him) and I founded the DNA Diaries project here at the Basic Sciences Research Institue, or BSRI. The purpose of the project is multifold. First, it is to test our DNA synthesis methods, and to test our different encoding schemes, as well as both in vivo and in vitro storage methodologies and media.\"}}]},\"s_1.teach_s\":{\"id\":\"s_1.teach_s\",\"options\":[{\"id\":\"@s_1.what_grade\",\"title\":\"\\\"What grade are you in again?\\\" You already know, but it is something to say.\"},{\"id\":\"@s_1.lets_start\",\"title\":\"\\\"Let's start...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Did mom ever teach you any programming? Or school?\\\"\"},{\"type\":\"paragraph\",\"content\":\"He shakes his head. \\\"They don't teach that until high school.\\\"\"}]},\"k_3.not_affair\":{\"id\":\"k_3.not_affair\",\"options\":[{\"id\":\"@k_3.awkward_a\",\"title\":\"It is extremely awkward in here.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Not because she's having an extramarital affair?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No. I don't really give a fuck.\\\" She chuckles. \\\"Besides, she's paying you for all this, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Right...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, good for you. Sorry I can't pay as much. Or like, at all.\\\"\"}]},\"a_2.no_risk\":{\"id\":\"a_2.no_risk\",\"goTo\":[{\"id\":\"a_2.walk_end\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You move away from A-. You shake her hand off your back. You pick up the bag that she dropped.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry,...\\\" you begin, but she interrupts you.\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's fine. I should be sorry.\\\"\"}]},\"a_3.still_love\":{\"id\":\"a_3.still_love\",\"title\":\"\\\"I know it's a mistake, but I still love you too...\\\"\",\"goTo\":[{\"id\":\"a_3.still_love_2\"}],\"content\":{\"content\":\"\\\"I know it's a mistake, but I still love you too...\\\"\",\"type\":\"paragraph\"}},\"data.d1001\":{\"id\":\"data.d1001\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"D1001.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vitro\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('d1001'); Q.correct_data_types.push('hoax'); Q.d_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.d1001_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.what_grade\":{\"id\":\"s_1.what_grade\",\"options\":[{\"id\":\"@s_1.lets_start\",\"title\":\"\\\"Let's start.\\\"\"},{\"id\":\"@s_1.done_rice\",\"title\":\"Just wait for the rice to be done.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"What grade are you in again?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Second. Going to third soon.\\\" He stares at you.\"}]},\"k_3.hey_money\":{\"id\":\"k_3.hey_money\",\"options\":[{\"id\":\"@k_3.awkward_a\",\"title\":\"It is extremely awkward in here.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Hey, she's giving me money.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Right. Good for you. Get that fucking bread or whatever. Sorry I can't pay as much. Or like, at all.\\\"\"}]},\"a_2.walk_end\":{\"id\":\"a_2.walk_end\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You separate, unlinking your hands, and walk together back to the trolley stop.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Call me, okay?\\\", she says as the trolley arrives.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. Okay.\\\"\"}]},\"a_3.still_love_money\":{\"id\":\"a_3.still_love_money\",\"goTo\":[{\"id\":\"a_3.still_love_2\"}],\"onArrival\":[{\"$code\":\"Q['a_financial_support'] = 1;\"}],\"title\":\"\\\"I know it's a mistake, but I still love you too...\\\" (but in truth you need her financial support)\",\"content\":{\"content\":\"\\\"I know it's a mistake, but I still love you too...\\\" Although, you cannot calibrate how much your financial situation plays in this decision.\",\"type\":\"paragraph\"}},\"data.d1001_\":{\"id\":\"data.d1001_\",\"goTo\":[{\"id\":\"data.d1001_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"BSRI DNA Diaries Project - #1\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"My name is Jiaren Qi and I am the director of the Basic Sciences Research Institute. I was born in Shijiazhuang, China almost 50 years ago. I am a woman, and I have been for at least 20 years. I am married to Yingmei (Liana) Xu, also of BSRI.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I find the process of writing these diaries to be somewhat therapeutic. I have not been in the habit of introspection before, but...\"}}]},\"s_1.lets_start\":{\"id\":\"s_1.lets_start\",\"options\":[{\"id\":\"@s_1.no_idea_2\",\"title\":\"You have no idea what you are doing.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Let's start...\\\"\"},{\"type\":\"paragraph\",\"content\":\"You turn on the computer.\"}]},\"k_3.awkward_a\":{\"id\":\"k_3.awkward_a\",\"options\":[{\"id\":\"@k_3.water_allocation\",\"title\":\"You wish she wouldn't use up so much of your water allocation.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The atmosphere on the bed has become extremely awkward. K- is sitting up.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm gonna take a shower,\\\" she says. \\\"Wash that fucking A- odor off me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She does so, without prompting.\"}]},\"a_2.est\":{\"id\":\"a_2.est\",\"options\":[{\"id\":\"@a_2.walk_end\",\"title\":\"You separate.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You smell like estrogen.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's perfume, idiot. Haha. I haven't been on estrogen in five years.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I know. It's just, um...\\\"\"},{\"type\":\"paragraph\",\"content\":\"You do not know what you were going to say, but you do know that the moment was ruined.\"}]},\"a_2\":{\"id\":\"a_2\",\"type\":\"scene\",\"title\":\"Meeting A-\",\"subtitle\":\"6PM, Founders Square\",\"viewIf\":{\"$code\":\"return ((((((Q['a_path'] || 0)===1) && ((Q['day_major'] || 0)===0)) && ((Q['daily_a'] || 0) <= 0)) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['a_path'] = 2;\\nQ['a_romance'] = 1;\\nQ['daily_a'] = 1;\\nQ['a_day'] = (Q['day'] || 0);\"}],\"frequency\":400,\"tags\":[\"major\"],\"newPage\":true,\"setBg\":\"images/windows_filtered_dithered.png\",\"options\":[{\"id\":\"@a_2.boredom\",\"title\":\"Because you're bored and don't have anything better to do.\"},{\"id\":\"@a_2.repayment\",\"title\":\"Because he helped you, and you have to repay him somehow.\"},{\"id\":\"@a_2.love\",\"title\":\"Because you're still a little in love with him.\"}],\"content\":{\"content\":\"Why are you meeting with A-?\",\"type\":\"paragraph\"}},\"a_3.i_love_you_too\":{\"id\":\"a_3.i_love_you_too\",\"title\":\"\\\"I know it's a mistake, but I love you too...\\\"\",\"goTo\":[{\"id\":\"a_3.still_love_2\"}],\"content\":{\"content\":\"\\\"I know it's a mistake, but I love you too...\\\"\",\"type\":\"paragraph\"}},\"data.d1001_c\":{\"id\":\"data.d1001_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"Jiaren does not occur in the historical record; the Founder's personal relationships were unknown, and she was assumed to have a husband. If this is true, then, as some revisionist pseudohistorians have suggested, Liana was indeed a lesbian, and not only that, but also have a partner who was the historical equivalent of a lavernean (probably).\",\"type\":\"paragraph\"}},\"s_1.no_idea_2\":{\"id\":\"s_1.no_idea_2\",\"options\":[{\"id\":\"@s_1.cry_1\",\"title\":\"Cry.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Theoretically, you should be qualified to teach, given your educational background. However, your mind blanks. You stare at the screen and the blinking cursor.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Um, hello? Aunt Em?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah... Sorry.\\\"\"}]},\"k_3.water_allocation\":{\"id\":\"k_3.water_allocation\",\"content\":{\"content\":\"Anyway, she showers, dresses, and leaves. You are left alone once more.\",\"type\":\"paragraph\"}},\"a_3.still_love_2\":{\"id\":\"a_3.still_love_2\",\"options\":[{\"id\":\"@a_3.sure_of_anything\",\"title\":\"\\\"Am I sure of anything?\\\"\"},{\"id\":\"@a_3.not_sure\",\"title\":\"\\\"I'm not sure, but...\\\"\"},{\"id\":\"@a_3.mistake\",\"title\":\"\\\"This was a mistake.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"She leans over to you. Stares into your eyes.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure about this?\\\"\"}]},\"data.w606\":{\"id\":\"data.w606\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W606.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key101'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w606'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w606_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.cry_1\":{\"id\":\"s_1.cry_1\",\"onArrival\":[{\"$code\":\"Q['s_cry'] = 1;\"}],\"options\":[{\"id\":\"@s_1.dont_call_me\",\"title\":\"\\\"Don't call me that.\\\"\"},{\"id\":\"@s_1.what_\",\"title\":\"\\\"What?\\\"\"},{\"id\":\"@s_1.im_fine_2\",\"title\":\"\\\"I'm fine.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"For whatever reason, you begin to cry. A deeply irrational gesture. You bow your head. Try to hide your face.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, mama?\\\" Him calling you that just makes you cry harder. He walks to you with a tissue. A waste of perfectly good cellulose.\"}]},\"k_3.me_too\":{\"id\":\"k_3.me_too\",\"options\":[{\"id\":\"@k_3.implications\",\"title\":\"\\\"Um, are the implications...\\\"\"},{\"id\":\"@k_3.solely_for_water\",\"title\":\"\\\"Solely for reducing water consumption, right?\\\"\"},{\"id\":\"@k_3.sure_shower\",\"title\":\"\\\"Sure. Let's do it.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I'm tired too,\\\" you say.\"},{\"type\":\"paragraph\",\"content\":\"\\\"How the fuck are you tired? You just sit at home all day.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"The body is a fickle thing.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, whatever... I just want to sleep. Or shower. Speaking of which, do you wish to take a shower together? Solely for the purpose of reducing water consumption. Of course.\\\"\"}]},\"a_3.sure_of_anything\":{\"id\":\"a_3.sure_of_anything\",\"onArrival\":[{\"$code\":\"Q['a_loved'] = 1;\"}],\"options\":[{\"id\":\"@a_3.apartment\",\"title\":\"The next few moments are a blur.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Am I sure of anything?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Good point.\\\"\"}]},\"data.w606_\":{\"id\":\"data.w606_\",\"goTo\":[{\"id\":\"data.w606_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Disterna\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":[\"Disterna is a genus of longhorn beetles of the subfamily Lamiinae,\",{\"type\":\"hidden\",\"content\":\"1\"},\" containing the following species: ...\"]}}]},\"s_1.dont_call_me\":{\"id\":\"s_1.dont_call_me\",\"goTo\":[{\"id\":\"s_1.he_hugs_you\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Don't call me that.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Why not?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It makes me want to cry.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"But you're already crying.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It makes me want to cry more.\\\"\"}]},\"k_3.shower\":{\"id\":\"k_3.shower\",\"onArrival\":[{\"$code\":\"Q['k_romance'] = (Q['k_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_3.implications\",\"title\":\"\\\"Um, are the implications...\\\"\"},{\"id\":\"@k_3.solely_for_water\",\"title\":\"\\\"Solely for reducing water consumption, right?\\\"\"},{\"id\":\"@k_3.sure_shower\",\"title\":\"\\\"Sure. Let's do it.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Do you want to take a shower?\\\", you ask.\"},{\"type\":\"paragraph\",\"content\":\"\\\"What's your water allocation?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"50 litres per day.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"God, that's relatively a lot. That's not much less than ours. When's the last time you took a shower?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Um...\\\" In truth, you do not remember.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You smell like shit.\\\" She gets up off the bed. \\\"Do you wish to take a shower together? Solely for the purpose of reducing water consumption. Of course.\\\"\"}]},\"a_3.not_sure\":{\"id\":\"a_3.not_sure\",\"onArrival\":[{\"$code\":\"Q['a_loved'] = 1;\"}],\"options\":[{\"id\":\"@a_3.apartment\",\"title\":\"The next few moments are a blur.\"}],\"content\":{\"content\":\"\\\"No, I'm not sure, but... I want to do this.\\\"\",\"type\":\"paragraph\"}},\"data.w606_c\":{\"id\":\"data.w606_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Your eyes glaze over. The bulk of your work consists of articles such as these, endless lists and lists of minutia of interest only to select experts.\"},{\"type\":\"paragraph\",\"content\":\"These organisms are most likely extinct, you think. This might be the only record of them ever existing.\"}]},\"s_1.what_\":{\"id\":\"s_1.what_\",\"goTo\":[{\"id\":\"s_1.he_hugs_you\"}],\"content\":{\"content\":\"\\\"What?\\\"\",\"type\":\"paragraph\"}},\"k_3.implications\":{\"id\":\"k_3.implications\",\"options\":[{\"id\":\"@k_3.sure_shower\"},{\"id\":\"@k_3.no_shower\",\"title\":\"\\\"Sorry, but I'd rather not...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Um, are there implications that...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"There are no implications whatsoever.\\\" She stares at you straight on. Her voice is totally monotone.\"}]},\"a_3.why_you\":{\"id\":\"a_3.why_you\",\"viewIf\":{\"$code\":\"return ((Q['kissed_a'] || 0)===0);\"},\"goTo\":[{\"id\":\"a_3.why_you_r\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.w29\":{\"id\":\"data.w29\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W29.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key29'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w29'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w29_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.im_fine_2\":{\"id\":\"s_1.im_fine_2\",\"goTo\":[{\"id\":\"s_1.he_hugs_you\"}],\"content\":{\"content\":\"\\\"I'm fine. I'm okay. Sorry.\\\"\",\"type\":\"paragraph\"}},\"k_3.solely_for_water\":{\"id\":\"k_3.solely_for_water\",\"options\":[{\"id\":\"@k_3.sure_shower\"},{\"id\":\"@k_3.no_shower\",\"title\":\"\\\"Sorry, but I'd rather not...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Solely for reducing water consumption, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Right. Solely for reducing water consumption. No ulterior motivations.\\\" She stares at you straight on. Her voice is totally monotone.\"}]},\"a_3.apartment\":{\"id\":\"a_3.apartment\",\"onArrival\":[{\"$code\":\"Q['a_loved'] = 1;\"}],\"options\":[{\"id\":\"@a_3.a_encounter\",\"title\":\"The events happen like a script.\"},{\"id\":\"@a_3.non_stuff\",\"title\":\"You talk. You eat. You laugh.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"The next few moments are a blur. You get up, making sure to physically separate from A- as you walk to the trolley stop. The ride is tense with anxiety and anticipation. You are \",{\"type\":\"emphasis-1\",\"content\":\"afraid\"},\", more so than you have been in a while. And then you are in your apartment.\"]},{\"type\":\"paragraph\",\"content\":\"\\\"Huh. I've never been here before,\\\" says A-. \\\"It's not a bad place. Small, but cozy.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks.\\\"\"}]},\"data.w29_\":{\"id\":\"data.w29_\",\"goTo\":[{\"id\":\"data.w29_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/New_York_State_Route_347\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"New York State Route 347 (NY 347) is an east–west state highway located in Suffolk County, New York, in the United States. It connects the Northern State Parkway in Hauppauge to NY 25A in Mount Sinai. The route serves as a southern bypass of Smithtown and as a direct link between Nesconset and Port Jefferson...\"}}]},\"s_1.he_hugs_you\":{\"id\":\"s_1.he_hugs_you\",\"options\":[{\"id\":\"@s_1.done_rice\",\"title\":\"Anyway, the rice is done.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Suddenly, you feel a warmth around you. Physical contact. Oh. He's hugging you.\"},{\"type\":\"paragraph\",\"content\":\"You feel paper on your face, wiping away your tears. You do not deserve this.\"}]},\"k_3.sure_shower\":{\"id\":\"k_3.sure_shower\",\"title\":\"\\\"Sure. Let's do it.\\\"\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"(CW: anatomical descriptions)\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['cw_enabled'] || 0)===1);\"}}]},\"onArrival\":[{\"$code\":\"Q['k_showered'] = 1;\\nQ['k_romance'] = (Q['k_romance'] || 0) + 1;\"}],\"options\":[{\"id\":\"@k_3.shower_2\",\"title\":\"Undress.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sure. Let's do it.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- is already taking off her clothes.\"}]},\"a_3.a_encounter\":{\"id\":\"a_3.a_encounter\",\"title\":\"...\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"(CW: sexual content)\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['cw_enabled'] || 0)) !== 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['a_encounter'] = 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"options\":[{\"id\":\"@a_3.a_encounter_2\"}],\"content\":{\"content\":\"The events unfold as if both of you were following scripts long unread. You kiss. You take off your clothes. A- holds you in her arms and pulls you down onto the bed. You...\",\"type\":\"paragraph\"}},\"data.w29_c\":{\"id\":\"data.w29_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"You sometimes wish you could see the world in which the creators of these archives lived. From the snippets and fragments you've seen, it must have been a beautiful world. A better place than this one.\",\"type\":\"paragraph\"}},\"s_1.wait_cooking\":{\"id\":\"s_1.wait_cooking\",\"options\":[{\"id\":\"@s_1.cook_2\",\"title\":\"Prepare another dish.\"},{\"id\":\"@s_1.entertain\",\"title\":\"Entertain S- somehow?\"},{\"id\":\"@s_1.teach_s\",\"title\":\"Teach S- programming?\"}],\"content\":{\"content\":\"Your hands are idle. You feel as if you should be doing something.\",\"type\":\"paragraph\"}},\"k_3.no_shower\":{\"id\":\"k_3.no_shower\",\"options\":[{\"id\":\"@k_3.rest_in_bed\",\"title\":\"While she does so, you rest.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry, but I'd rather not...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- shrugs. \\\"Whatever. Stay disgusting. I'm gonna take a shower by myself.\\\"\"}]},\"a_3.a_encounter_2\":{\"id\":\"a_3.a_encounter_2\",\"newPage\":true,\"title\":\"...\",\"setBg\":\"black\",\"options\":[{\"id\":\"@a_3.a_encounter_3\",\"title\":\"...\"}],\"content\":{\"content\":\"...\",\"type\":\"paragraph\"}},\"data.w121\":{\"id\":\"data.w121\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W121.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key121'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w121'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w121_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.entertain\":{\"id\":\"s_1.entertain\",\"options\":[{\"id\":\"@s_1.fun_book\",\"title\":\"\\\"Is this a fun book?\\\"\"},{\"id\":\"@s_1.play_game\",\"title\":\"Play a computer game?\"},{\"id\":\"@s_1.watch_tv\",\"title\":\"Watch TV?\"}],\"content\":{\"content\":\"S- is still leafing through the programming textbook.\",\"type\":\"paragraph\"}},\"k_3.rest_in_bed\":{\"id\":\"k_3.rest_in_bed\",\"options\":[{\"id\":\"@k_3.dont_mind_nap\",\"title\":\"\\\"I don't mind.\\\"\"},{\"id\":\"@k_3.nap_together\",\"title\":\"\\\"I want to nap too...\\\"\"},{\"id\":\"@k_3.k_leaves\",\"title\":\"\\\"No, sorry...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"While she does so, you rest on the bed. You hear the water splattering. It is loud.\"},{\"type\":\"paragraph\",\"content\":\"She emerges dressed in your bathrobe. \\\"God, I'm so tired. Do you mind if I take a nap here until it's time to pick up S-?\\\"\"}]},\"a_3.a_encounter_3\":{\"id\":\"a_3.a_encounter_3\",\"options\":[{\"id\":\"@a_3.am_i\",\"title\":\"\\\"Oh, am I?\\\"\"},{\"id\":\"@a_3.normal_reaction\",\"title\":\"\\\"It's a normal physiological reaction.\\\"\"},{\"id\":\"@a_3.stay_silent\",\"title\":\"Stay silent.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It is over. Your body aches. The two of you are squeezed side-by-side on the bed, naked under the sheets, facing each other. Your hand rests on her breast.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You're crying. A lot.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Oh. You did not notice.\"}]},\"data.w121_\":{\"id\":\"data.w121_\",\"goTo\":[{\"id\":\"data.w121_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Sidi_Lazreg\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Sidi Lazreg is a town and commune in Relizane Province, Algeria...\"}}]},\"s_1.play_game\":{\"id\":\"s_1.play_game\",\"options\":[{\"id\":\"@s_1.no_idea_play_game\",\"title\":\"You have no idea what you are doing.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Do you want to, um, play a game?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure, why not?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You turn on the computer. Are your usual games too violent for him? Probably. What games are suitable? Probably not any games about killing. Are there any educational games available that are not regime propaganda? You do not know.\"}]},\"k_3.dont_mind_nap\":{\"id\":\"k_3.dont_mind_nap\",\"options\":[{\"id\":\"@k_3.nap_face_her\"},{\"id\":\"@k_3.nap_facing_away\"},{\"id\":\"@k_3.dilated\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't mind...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Great!\\\" She gets in the bed, with you still in it. It is a tight\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry,\\\" she says, \\\"but it's fine if we squeeze together here, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah, it's fine...\\\"\"}]},\"a_3.am_i\":{\"id\":\"a_3.am_i\",\"goTo\":[{\"id\":\"a_3.a_i_love_you\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh, am I?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yes. You are.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh.\\\" You wipe the tears with the back of your hand.\"}]},\"data.w121_c\":{\"id\":\"data.w121_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"Places long gone, places that might as well only exist in your imagination...\",\"type\":\"paragraph\"}},\"s_1.no_idea_play_game\":{\"id\":\"s_1.no_idea_play_game\",\"options\":[{\"id\":\"@s_1.cry_1\",\"title\":\"Cry.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You have no idea what you are doing.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Um, hello? Aunt Em?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah... Sorry.\\\"\"}]},\"k_3.nap_together\":{\"id\":\"k_3.nap_together\",\"options\":[{\"id\":\"@k_3.nap_face_her\"},{\"id\":\"@k_3.nap_facing_away\"},{\"id\":\"@k_3.dilated\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I want to take a nap too...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- looks at the narrow bed. \\\"Well, we can squeeze together. It's just like university.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah.\\\"\"}]},\"a_3.normal_reaction\":{\"id\":\"a_3.normal_reaction\",\"goTo\":[{\"id\":\"a_3.a_i_love_you\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's a normal physiological reaction.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Is it? You didn't use to cry so much...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh.\\\" You wipe the tears with the back of your hand.\"}]},\"data.w31\":{\"id\":\"data.w31\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W31.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key31'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w31'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w31_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.watch_tv\":{\"id\":\"s_1.watch_tv\",\"options\":[{\"id\":\"@s_1.turn_off_tv\",\"title\":\"Turn off the monitor.\"},{\"id\":\"@s_1.play_game\",\"title\":\"Play a computer game?\"},{\"id\":\"@s_1.teach_s\",\"title\":\"Teach S- programming?\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Do you want to, um, watch TV?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure, why not?\\\"\"},{\"type\":\"paragraph\",\"content\":\"You turn on the monitor. Currently playing on the public channel is a pre-election debate between representatives of the Ruling and Opposition parties.\"}]},\"k_3.nap_face_her\":{\"id\":\"k_3.nap_face_her\",\"title\":\"You face her as you sleep.\",\"onArrival\":[{\"$code\":\"Q['k_romance'] = (Q['k_romance'] || 0) + 1;\\nQ['stress'] = (Q['stress'] || 0) - 1;\"}],\"options\":[{\"id\":\"@k_3.nap_get_up\",\"title\":\"...\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You are pressed against the wall, facing her, as she is facing away from you. You cannot help but touch her.\"},{\"type\":\"paragraph\",\"content\":\"It is difficult to fall asleep, as usual. Instead, you simply rest, lie on the bed quietly as K- falls asleep, and close your eyes.\"}]},\"a_3.stay_silent\":{\"id\":\"a_3.stay_silent\",\"goTo\":[{\"id\":\"a_3.a_i_love_you\"}],\"content\":{\"content\":\"You stay silent.\",\"type\":\"paragraph\"}},\"data.w31_\":{\"id\":\"data.w31_\",\"goTo\":[{\"id\":\"data.w31_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Structural_alignment_software\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"This list of structural comparison and alignment software is a compilation of software tools and web portals used in pairwise or multiple structural comparison and structural alignment...\"},\"\"]}]},\"s_1.turn_off_tv\":{\"id\":\"s_1.turn_off_tv\",\"options\":[{\"id\":\"@s_1.done_rice\",\"title\":\"The rice is done.\"}],\"content\":{\"content\":\"You turn off the monitor. S- has not been watching anyway.\",\"type\":\"paragraph\"}},\"k_3.nap_facing_away\":{\"id\":\"k_3.nap_facing_away\",\"title\":\"You are facing away from each other.\",\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) - 1;\"}],\"options\":[{\"id\":\"@k_3.nap_get_up\",\"title\":\"...\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"You are facing away from each other, just to make it clear that there are no \",{\"type\":\"emphasis-1\",\"content\":\"implications\"},\" from this incident, except for the fact that you are sleeping in the same bed in the first place.\"]},{\"type\":\"paragraph\",\"content\":\"It is difficult to fall asleep, as usual. Instead, you simply rest, lie on the bed quietly as K- falls asleep, and close your eyes.\"}]},\"a_3.a_i_love_you\":{\"id\":\"a_3.a_i_love_you\",\"options\":[{\"id\":\"@a_3.sleep_a\",\"title\":\"Sleep.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I love you,\\\" A- says.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Okay.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She laughs. \\\"Wow.\\\"\"}]},\"data.w31_c\":{\"id\":\"data.w31_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"Finally, useful scientific knowledge. Or is it? The article is a collection of dead links to code long since disappeared. There does not seem to be usable technical content herein.\",\"type\":\"paragraph\"}},\"s_1.done_rice\":{\"id\":\"s_1.done_rice\",\"options\":[{\"id\":\"@s_1.finish_meal\",\"title\":\"S- finishes the meal.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The rice porridge is done cooking. You fill a bowl for S- and a bowl for yourself.\"},{\"type\":\"paragraph\",\"content\":\"\\\"How do you like it?\\\", you ask.\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's exactly like what mom makes.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. No surprise there. She taught me.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"You told me that already.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Is it good, at least?\\\"\"},{\"type\":\"paragraph\",\"content\":\"He shrugs. \\\"It's okay.\\\"\"}]},\"k_3.nap_get_up\":{\"id\":\"k_3.nap_get_up\",\"newPage\":true,\"setBg\":\"black\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You ended up falling asleep after all. The lights are already dimming, and K- has gotten up and gotten dressed.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry. I have to pick up S- from school soon. Can we maybe start the heartbeat thing again? Where you called me every day to make sure you're okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah... I'll try to remember.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Good. And if you need anything, just let me know. I don't know how much I can do, but I'll try to help. I'm sure S- wouldn't mind.\\\"\"},{\"type\":\"paragraph\",\"content\":\"With that, K- leaves, and you are left alone once more.\"}]},\"a_3.sleep_a\":{\"id\":\"a_3.sleep_a\",\"options\":[{\"id\":\"@main\",\"title\":\"She leaves, with a kiss.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"When you wake up, A- has already left the bed, and is sitting dressed in her \\\"male\\\" clothes.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry. I have to leave. There's... things I have to do.\\\"\"}]},\"data.w49\":{\"id\":\"data.w49\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W49.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key7'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w49'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w49_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.finish_meal\":{\"id\":\"s_1.finish_meal\",\"options\":[{\"id\":\"@s_1.hug_s\"},{\"id\":\"@s_1.bedtime\",\"title\":\"Bedtime.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"S- finishes the meal, and so do you. It's getting close to his bedtime.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I have to brush my teeth now.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Do you have your own things?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. I brought my own toothbrush.\\\"\"}]},\"k_3.k_leaves\":{\"id\":\"k_3.k_leaves\",\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No, sorry...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, whatever. I'm gonna take a nap at my place, then,\\\" she says, and leaves.\"}]},\"a_3.non_stuff\":{\"id\":\"a_3.non_stuff\",\"onArrival\":[{\"$code\":\"Q['food'] = (Q['food'] || 0) + 1;\"}],\"options\":[{\"id\":\"@main\",\"title\":\"She leaves, with a kiss.\"}],\"content\":{\"content\":\"You talk, of nothing in particular. A- has brought ingredients for a lentil curry, which she helps make with you. You had never remembered the recipe, but now you know, and it tastes good, so much better than anything you can make yourself. All the while, A- is touching you. You are touching so much.\",\"type\":\"paragraph\"}},\"a_3\":{\"id\":\"a_3\",\"type\":\"scene\",\"title\":\"A-\",\"subtitle\":\"She wanted to \\\"hang out.\\\"\",\"viewIf\":{\"$code\":\"return (((((((((Q['day_major'] || 0)===0) || ((Q['day_minor'] || 0)===0))) && ((Q['daily_a'] || 0)===0)) && ((Q['a_path'] || 0)===2)) && ((Q['day'] || 0) >= ((Q['a_day'] || 0) + 2))) && ((Q['stress'] || 0) < (Q['stress_threshold'] || 0))) && ((Q['day'] || 0) < 20));\"},\"onArrival\":[{\"$code\":\"Q['a_path'] = 3;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\\nQ['daily_a'] = 1;\\nQ['money'] = (Q['money'] || 0) + 100;\\nQ['a_day'] = (Q['day'] || 0);\"}],\"tags\":[\"major\"],\"setBg\":\"images/windows_filtered_dithered.png\",\"options\":[{\"id\":\"@a_3.i_know\",\"title\":\"\\\"I know.\\\"\"},{\"id\":\"@a_3.of_course\",\"title\":\"\\\"Of course I know.\\\"\"},{\"id\":\"@a_3.before_meet\",\"title\":\"\\\"You should have thought about this before.\\\"\"},{\"id\":\"@a_3.kiss_1\",\"title\":\"Kiss her.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So tell me,\\\" she asks, all of a sudden, \\\"You know it's unsafe for us to meet like this, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"It is cold in the park by the frozen river, at least ten degrees colder than the rest of the undercity, and as a result there is almost no one else here. Finally your jacket is of practical use. A- is dressed more sensibly, too; she has dropped the tight black dress and thigh-high socks in exchange for a long coat and leggings.\"},{\"type\":\"paragraph\",\"content\":\"A- has given you another $100, which she says has no relation to whether or not you wished to meet her again.\"}]},\"data.w49_\":{\"id\":\"data.w49_\",\"goTo\":[{\"id\":\"data.w49_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Marmong_Point,_New_South_Wales\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Marmong Point is a suburb of the City of Lake Macquarie in New South Wales, Australia north-north-east of the town of Toronto on the western shore of Lake Macquarie. Marmong is an Aboriginal word meaning low water or swampy water...\"}}]},\"s_1.cook_2\":{\"id\":\"s_1.cook_2\",\"chooseIf\":{\"$code\":\"return ((Q['food'] || 0) >= 2);\"},\"unavailableSubtitle\":\"You do not have enough food.\",\"options\":[{\"id\":\"@s_1.s_helps\",\"title\":\"Let him help.\"},{\"id\":\"@s_1.s_no_help\",\"title\":\"No. You can do this.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It seems that you have enough stored food to make a small vegetable and meat stir fry dish. This is slightly more involved than cooking rice; you have to chop up the lettuce head and the dried tofu. Add oil to the heated pan, add the other ingredients, and stir. Your arms are tiring.\"},{\"type\":\"paragraph\",\"content\":\"When you are about to take a break, you let the spatula go, and it clatters to the floor. Oil splashes on your hand. The floor is stained. What a pain.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Can I help?\\\", S- asks.\"}]},\"k_3.shower_2\":{\"id\":\"k_3.shower_2\",\"options\":[{\"id\":\"@k_3.sorry_shower\",\"title\":\"\\\"Sorry...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"You remember that I've seen you naked before, right?\\\", says K-. \\\"There's no need to hide yourself.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Your longstanding hatred for your body has evolved into the indifference of pretending it does not exist. Undressing and showering breaks such pretensions. You cannot help but become aware of the fact that you are a physical entity, and even more aware of the toll entropy has taken upon you.\"}]},\"data.w49_c\":{\"id\":\"data.w49_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"Places that might as well be infinitely far away in time and space, brought to your computer by the archivists of old...\",\"type\":\"paragraph\"}},\"s_1.s_helps\":{\"id\":\"s_1.s_helps\",\"options\":[{\"id\":\"@s_1.eat_2\",\"title\":\"Eat.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sure. Help me wipe the floor.\\\"\"},{\"type\":\"paragraph\",\"content\":\"He silently takes a paper towel and begins to wipe the oil. You wash the spatula, and finish cooking the dish.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks,\\\" you say. He shrugs.\"}]},\"k_3.sorry_shower\":{\"id\":\"k_3.sorry_shower\",\"options\":[{\"id\":\"@k_3.terrible_s\",\"title\":\"\\\"I was terrible to S-.\\\"\"},{\"id\":\"@k_3.need_money\",\"title\":\"\\\"Sorry I'm begging for money.\\\"\"},{\"id\":\"@k_3.idk_sorry\",\"title\":\"\\\"Everything, I guess.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry...\\\" You say this more as an impulse than anything else.\"},{\"type\":\"paragraph\",\"content\":\"\\\"What the fuck are you sorry for?\\\"\"}]},\"data.w169\":{\"id\":\"data.w169\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W169.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key13'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w169'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w169_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.s_no_help\":{\"id\":\"s_1.s_no_help\",\"options\":[{\"id\":\"@s_1.not_fine\",\"title\":\"\\\"No, I'm not.\\\"\"},{\"id\":\"@s_1.im_fine\",\"title\":\"\\\"(lie) Yes, I'm fine.\\\"\"},{\"id\":\"@s_1.cry_1\",\"title\":\"Cry.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No. It's fine.\\\"\"},{\"type\":\"paragraph\",\"content\":\"Your body creaks as you bend downwards. \\\"Are you sure you're fine?\\\", S- asks.\"}]},\"k_3.terrible_s\":{\"id\":\"k_3.terrible_s\",\"viewIf\":{\"$code\":\"return ((Q['s_cry'] || 0)===1);\"},\"options\":[{\"id\":\"@k_3.in_shower\",\"title\":\"Just get in the shower.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I was terrible to S-. I messed up.\\\" You explain how you cried, and how it was as if S- parented you more than you parented him.\"},{\"type\":\"paragraph\",\"content\":\"\\\"I didn't know what I was doing either,\\\" says K-. \\\"None of us are born parents. Well, maybe some of us, but certainly not me. I'm still shit at it.\\\"\"}]},\"data.w169_\":{\"id\":\"data.w169_\",\"goTo\":[{\"id\":\"data.w169_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/List_of_The_Best_Thing_I_Ever_Ate_episodes\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"The Best Thing I Ever Ate, an American television show, premiered on June 22, 2009, on Food Network in the United States. In 2017, the series transferred to Cooking Channel for one season of compilations from the previous six seasons, then with new episodes in its eighth season. As of 2021, eleven seasons have aired, for a total of 143 episodes. (This does not include the eight-episode special series All-Star Best Thing I Ever Ate that aired on Food Network in 2020.) The show features renowned chefs like Bobby Flay, Guy Fieri, and Ted Allen talking about their favorite dishes in specific categories...\"}}]},\"s_1.not_fine\":{\"id\":\"s_1.not_fine\",\"options\":[{\"id\":\"@s_1.s_helps_2\",\"title\":\"Let him help.\"},{\"id\":\"@s_1.cry_1\",\"title\":\"Cry.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No. I'm not fine.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Then can I help you clean up?\\\"\"}]},\"k_3.need_money\":{\"id\":\"k_3.need_money\",\"options\":[{\"id\":\"@k_3.in_shower\",\"title\":\"Just get in the shower.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Sorry I have to beg for money.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Fuck, don't let me make you feel bad about that!\\\"\"}]},\"data.w169_c\":{\"id\":\"data.w169_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"So much detritus of the past. So many words that mean nothing to you now, but might have meant everything to the people who lived at this time. How would \\\"Bobby Flay\\\" feel about you reading this right now, his name written in DNA?\"},{\"type\":\"paragraph\",\"content\":\"Anyway, you are hungry, slightly more so than usual.\"}]},\"s_1.s_helps_2\":{\"id\":\"s_1.s_helps_2\",\"options\":[{\"id\":\"@s_1.eat_2\",\"title\":\"Eat.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"He silently takes a paper towel and begins to wipe the oil. You wash the spatula, and finish cooking the dish.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Thanks,\\\" you say. He shrugs.\"},{\"type\":\"paragraph\",\"content\":\"\\\"No problem.\\\"\"}]},\"k_3.idk_sorry\":{\"id\":\"k_3.idk_sorry\",\"options\":[{\"id\":\"@k_3.in_shower\",\"title\":\"Just get in the shower.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Everything, I guess.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- shrugs. \\\"Well, that's not helpful.\\\"\"}]},\"data.w13\":{\"id\":\"data.w13\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W13.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key13'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w13'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w13_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.im_fine\":{\"id\":\"s_1.im_fine\",\"options\":[{\"id\":\"@s_1.not_sure\",\"title\":\"\\\"No. I'm not sure.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Yes. I'm fine.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Are you sure?\\\"\"}]},\"k_3.in_shower\":{\"id\":\"k_3.in_shower\",\"options\":[{\"id\":\"@k_3.its_complicated\",\"title\":\"\\\"It's complicated...\\\" (give the full answer)\"},{\"id\":\"@k_3.not_really\",\"title\":\"\\\"Eh. Not really.\\\" (avoid the question)\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It is cramped. The water is cool. K- is warm. You are back-to-back, her pressed against the door, you pressed against the wall. Surprisingly, the two of you had never showered together before in all your years of dating and marriage.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, I was just wondering,\\\" says K- over the sound of water. \\\"Do you wash inside your vagina? You're not supposed to but I'm not sure if in your case it's...\\\"\"},{\"type\":\"paragraph\",\"content\":\"You are almost certain that you have had this exact conversation before.\"}]},\"data.w13_\":{\"id\":\"data.w13_\",\"goTo\":[{\"id\":\"data.w13_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Sir_James_Ritchie,_1st_Baronet\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Sir James Thomson Ritchie, 1st Baronet (21 September 1833 – 18 September 1912) was a Scottish businessman who was the 576th Lord Mayor of London. He was born in Angus, the second son of William Ritchie, a landed proprietor, of Rockhill House, Broughty Ferry, Forfarshire, head of the firm of William Ritchie & Son of London and Dundee, East India merchants, jute spinners, and manufacturers. His younger brother would be ennobled as Charles Ritchie, 1st Baron Ritchie of Dundee.\"}}]},\"s_1.not_sure\":{\"id\":\"s_1.not_sure\",\"content\":{\"content\":\"\\\"No. I'm not sure.\\\" You let out a deep breath. \\\"I'm not sure of anything, really.\\\"\",\"type\":\"paragraph\"}},\"k_3.its_complicated\":{\"id\":\"k_3.its_complicated\",\"onArrival\":[{\"$code\":\"Q['k_romance'] = (Q['k_romance'] || 0) + 1;\\nQ['k_told_about_vagina'] = 1;\"}],\"options\":[{\"id\":\"@k_3.turn_off\",\"title\":\"Turn off the shower.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Well, it's complicated. Um, there are mixed reports on whether neovaginas can be self-cleaning or self-lubricating and on how the microbiome of the neovagina compares to a natal one. It depends on the surgical technique and a host of factors. Most of us use cleaning solutions but, um, personally I don't. I like microbes. So I just let them grow naturally. Maybe there's a dataset down there.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- begins to laugh. \\\"My God. No wonder you never bathe. It must be like burning down the Library of Alexandria every time you shower.\\\" Then she starts to cough up water. \\\"God, I'm choking!\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I'm sorry. Do you need help?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No! I'm just...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She is wheezing, and pounding on the door awfully hard.\"}]},\"data.w13_c\":{\"id\":\"data.w13_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"You wonder how \\\"Sir James Thomson Ritchie\\\" would feel about you reading his name right now. Could he imagine this world? DNA had not even been discovered in his time. Why did his name survive the ages when almost all others of his time did not?\",\"type\":\"paragraph\"}},\"s_1.eat_2\":{\"id\":\"s_1.eat_2\",\"options\":[{\"id\":\"@s_1.hug_s\"},{\"id\":\"@s_1.bedtime\",\"title\":\"Bedtime.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"So, how's the food?\\\", you ask.\"},{\"type\":\"paragraph\",\"content\":\"\\\"It tastes like what mom makes.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Is that a good thing or a bad thing?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's okay.\\\"\"}]},\"k_3.not_really\":{\"id\":\"k_3.not_really\",\"options\":[{\"id\":\"@k_3.turn_off\",\"title\":\"Turn off the shower.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Eh. Not really.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Because of the microbiome?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Because of the microbiome.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- laughs. \\\"My God, it must be like burning down the Library of Alexandria every time you shower.\\\"\"}]},\"data.w63\":{\"id\":\"data.w63\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W63.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key7'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w63'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w63_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.hug_s\":{\"id\":\"s_1.hug_s\",\"title\":\"Hug S-.\",\"onArrival\":[{\"$code\":\"Q['stress'] = (Q['stress'] || 0) - 1;\"}],\"options\":[{\"id\":\"@s_1.feel_like\",\"title\":\"\\\"Because I feel like it.\\\"\"},{\"id\":\"@s_1.idk_why\",\"title\":\"\\\"I don't know.\\\"\"},{\"id\":\"@s_1.because_love\",\"title\":\"\\\"Because I love you.\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"An atypical urge comes over you. You wrap your arms around his shoulders, and hold him.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Why are you hugging me?\\\"\"}]},\"k_3.turn_off\":{\"id\":\"k_3.turn_off\",\"goTo\":[{\"id\":\"k_3.end_shower\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You turn off the water.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Hey, I was still using that.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry. The allocation was almost used up.\\\"\"}]},\"data.w63_\":{\"id\":\"data.w63_\",\"goTo\":[{\"id\":\"data.w63_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Leningrad_Cowboys_Go_Wild\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Leningrad Cowboys Go Wild is a 2000 compilation album by the Leningrad Cowboys released in Germany.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Track listing\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"No. Title Writer(s) Length\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"1. \\\"Born To Be Wild\\\" (from Leningrad Cowboys Go America, 1989) M. Bofire 3.30\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"2. \\\"Gimme All Your Lovin'\\\" (from Happy Together, 1994) B. Gibbons/D. Hill/Frank Lee Beard 3.08\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"...\"}}]},\"s_1.idk_why\":{\"id\":\"s_1.idk_why\",\"goTo\":[{\"id\":\"s_1.hug_2\"}],\"content\":{\"content\":\"\\\"I don't know.\\\"\",\"type\":\"paragraph\"}},\"k_3.face_shower\":{\"id\":\"k_3.face_shower\",\"goTo\":[{\"id\":\"k_3.end_shower\"}],\"content\":{\"content\":\"You turn around to face K-.\",\"type\":\"paragraph\"}},\"data.w63_c\":{\"id\":\"data.w63_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"This article is a reference to a musical album that almost certainly does not exist anymore. You have no idea about the context of this album, or any hints as to the identities of the so-called \\\"Leningrad Cowboys\\\". They are most likely not affiliated with the historical city of Leningrad, nor the occupation of cowboy.\",\"type\":\"paragraph\"}},\"s_1.hug_2\":{\"id\":\"s_1.hug_2\",\"options\":[{\"id\":\"@s_1.bedtime\",\"title\":\"Soon, it is bedtime.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Okay.\\\"\"},{\"type\":\"paragraph\",\"content\":\"He hugs you back, smothering you with his arms. You stay like this for a while, until you separate for S- to brush his teeth.\"}]},\"k_3.end_shower\":{\"id\":\"k_3.end_shower\",\"options\":[{\"id\":\"@k_3.dilated\"},{\"id\":\"@k_3.want_to_sleep\"}],\"content\":{\"content\":\"You are staring at each other, only wearing bathrobes.\",\"type\":\"paragraph\"}},\"data.w46\":{\"id\":\"data.w46\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W46.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key23'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w46'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w46_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.feel_like\":{\"id\":\"s_1.feel_like\",\"goTo\":[{\"id\":\"s_1.hug_2\"}],\"content\":{\"content\":\"\\\"Because I feel like it.\\\"\",\"type\":\"paragraph\"}},\"k_3.want_to_sleep\":{\"id\":\"k_3.want_to_sleep\",\"title\":\"\\\"Is it okay if I take a nap here?\\\" asks K-.\",\"options\":[{\"id\":\"@k_3.nap_face_her\"},{\"id\":\"@k_3.nap_facing_away\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Is it okay if I take a nap here?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure, okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- dresses in her underwear and enters the bed.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry,\\\" she says, \\\"but it's fine if we squeeze together, right?\\\" She pats the spot next to her. \\\"Come on.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah, it's fine...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Ha. It's just like back at the university.\\\"\"}]},\"data.w46_\":{\"id\":\"data.w46_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/List_of_people_from_the_Halifax_Regional_Municipality\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"This is a list of people who were born in the communities making up the Halifax Regional Municipality, Nova Scotia or spent a significant part of their lives there.\"}}]},\"s_1.because_love\":{\"id\":\"s_1.because_love\",\"goTo\":[{\"id\":\"s_1.hug_2\"}],\"content\":{\"content\":\"\\\"Because I love you.\\\"\",\"type\":\"paragraph\"}},\"k_3.stare_at_k\":{\"id\":\"k_3.stare_at_k\",\"title\":\"Stare at K-.\",\"content\":[{\"type\":\"paragraph\",\"content\":\"You stare at K-, and she stares back at you.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Well, this is awkward,\\\" she says.\"}]},\"data.w58\":{\"id\":\"data.w58\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W58.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key29'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w58'); Q.correct_data_types.push('misc'); Q.w_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w58_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"s_1.bedtime\":{\"id\":\"s_1.bedtime\",\"options\":[{\"id\":\"@main.end_of_day\",\"title\":\"Sleep.\"}],\"content\":{\"content\":\"It is S-'s normal bedtime. You arrange some sheets on the floor, which is where you will sleep. S- is sleeping in your bed. You stay awake until you hear the regular rhythms of his breathing, and then you can finally sleep.\",\"type\":\"paragraph\"}},\"k_3.dilated\":{\"id\":\"k_3.dilated\",\"title\":\"\\\"I haven't dilated in a while...\\\"\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"(CW: potential sexual content)\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['cw_enabled'] || 0)) !== 0);\"}}]},\"maxVisits\":1,\"options\":[{\"id\":\"@k_3.maybe_sexual\",\"title\":{\"content\":[\"\\\"Maybe...\\\" \",{\"type\":\"conditional\",\"content\":\"(CW: sexual content)\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['cw_enabled'] || 0)) !== 0);\"}}]}},{\"id\":\"@k_3.not_sexual\",\"title\":\"\\\"No, it's not like that...\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I haven't dilated in a while...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K stares at your body for a moment. \\\"Is the implication here that you wish to engage in penetrative activities in order to substitute for your lack of dilation in order to maintain the diameter of your neovagina?\\\"\"}],\"countVisitsMax\":1},\"data.w58_\":{\"id\":\"data.w58_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Sint-Truiden\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":[\"Sint-Truiden (Dutch pronunciation: \",{\"type\":\"hidden\",\"content\":\"sɪnˈtrœydə(n)\"},\"; French: Saint-Trond \",{\"type\":\"hidden\",\"content\":\"sɛ̃ tʁɔ̃\"},\"; Limburgish: Sintruin \",{\"type\":\"hidden\",\"content\":\"sɪnˈtʀœyn\"},\") is a city and municipality located in the province of Limburg, Flemish Region, Belgium, near the towns of Hasselt and Tongeren. The municipality includes the former communes (now deelgemeenten) of Aalst, Brustem, Duras, Engelmanshoven, Gelinden, Gorsem, Groot-Gelmen, Halmaal, Kerkom-bij-Sint-Truiden, Melveren, Metsteren, Ordingen, Runkelen, Velm, Wilderen, and Zepperen.\"]}}]},\"s_1.food_home\":{\"id\":\"s_1.food_home\",\"chooseIf\":{\"$code\":\"return ((Q['food'] || 0) > 1);\"},\"unavailableSubtitle\":\"You do not, in fact, have food at home.\",\"goTo\":[{\"id\":\"s_1.food_home_1\",\"predicate\":{\"$code\":\"return ((Q['s1_knows_cook_rice'] || 0)===1);\"}},{\"id\":\"s_1.food_home_2\",\"predicate\":{\"$code\":\"return ((Q['s1_knows_cook_rice'] || 0)===0);\"}}],\"content\":{\"content\":\"\\\"We have food at home,\\\" you say, and S- is instantly disappointed.\",\"type\":\"paragraph\"}},\"s_1\":{\"id\":\"s_1\",\"type\":\"scene\",\"title\":\"S-\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['with_s'] = 1;\"}],\"setBg\":\"images/room1_filtered_dithered.png\",\"options\":[{\"id\":\"@s_1.no_idea\",\"title\":\"You have no idea what to do.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"You are home again, and it is the first time someone besides yourself has visited in over a year. That time was inspection.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sorry this is so messy...\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Don't worry. Mom is messy too.\\\"\"},{\"type\":\"paragraph\",\"content\":\"S- paces your tiny apartment. it takes about 8 of his small steps to walk from one end to the other.\"},{\"type\":\"paragraph\",\"content\":\"He looks up at you, as if expecting something.\"}]},\"k_3.not_sexual\":{\"id\":\"k_3.not_sexual\",\"options\":[{\"id\":\"@k_3.nap_face_her\"},{\"id\":\"@k_3.nap_facing_away\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No, it's not like that. I was just thinking about that because of what you asked in the shower.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Okay. Then, how about I just take a nap?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Sure, okay...\\\"\"},{\"type\":\"paragraph\",\"content\":\"K- dresses in her underwear and enters the bed.\"}]},\"data.w17\":{\"id\":\"data.w17\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"W17.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"wiki\"],\"chooseIf\":{\"$code\":\"return ((Q['key17'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('w17'); Q.correct_data_types.push('misc'); Q.w_seen += 1; Q.incense_seen = 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.w17_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_3.dilated_a\":{\"id\":\"k_3.dilated_a\",\"options\":[{\"id\":\"@k_3.k_s_scene\",\"title\":\"...\"},{\"id\":\"@k_3.not_sexual\",\"title\":\"\\\"No, it's not like that...\\\"\"}],\"content\":{\"content\":\"\\\"But aren't you with A- already? Like, aren't you in a relationship?\\\" She plays with her hair for a moment. \\\"Actually, I don't give a fuck. If that's what you want, then...\\\"\",\"type\":\"paragraph\"}},\"data.w17_\":{\"id\":\"data.w17_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"URL: https://en.wikipedia.org/wiki/Joss_paper\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Joss paper, also known as incense papers, are papercrafts or sheets of paper made into burnt offerings common in Chinese ancestral worship (such as the veneration of the deceased family members and relatives on holidays and special occasions). Worship of deities in Chinese folk religion also uses a similar type of joss paper. Joss paper, as well as other papier-mâché items, are also burned or buried in various Asian funerals, \\\"to ensure that the spirit of the deceased has sufficient needs in the afterlife.\\\"\"}}]},\"k_3.dilated_no_shower\":{\"id\":\"k_3.dilated_no_shower\",\"options\":[{\"id\":\"@k_3.dilated_no_shower_2\",\"title\":\"So you do.\"}],\"content\":{\"content\":\"\\\"No. Not until you've showered. Go shower right now. I'll wait here.\\\"\",\"type\":\"paragraph\"}},\"data.x1001\":{\"id\":\"data.x1001\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"X1001.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - Lactobacillus colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"frequency\":500,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('x1001'); Q.correct_data_types.push('liana'); Q.l_seen += 1; Q.key_1009 = 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.x1001_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_3.dilated_no_shower_2\":{\"id\":\"k_3.dilated_no_shower_2\",\"options\":[{\"id\":\"@k_3.k_s_scene\",\"title\":\"...\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"So you take a brief shower, and meet back on the bed.\"},{\"type\":\"paragraph\",\"content\":\"K- sighs. \\\"You know I haven't done it since we separated, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I mean, I haven't either.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She smiles. \\\"It's all good. This can count as practice.\\\"\"}]},\"data.x1001_\":{\"id\":\"data.x1001_\",\"goTo\":[{\"id\":\"data.x1001_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"2XX3\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Hello from the distant past. If you are reading this, it is likely that you are in New Niagara Arcology. Since technology apparently is still advanced enough to decode DNA, your society must be flourishing, or at least stable. Is it not?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"It is my last few weeks on Earth, before I am required to leave for the space colonies as stipulated by the Posthuman Treaty. During this time, I am supervising the construction of the Arcology, also as stipulated by the Treaty. I am ensuring that the environmental seal and filtration systems will allow the city to remain free of the nanoplagues that were the most unfortunate consequence of the war.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I have attached some schematics on the design and maintenance of some of these filtration systems. I hope the information contained herein will be helpful.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":[\"In case you are interested in ancient history, I have written a small sample of my diaries in \",{\"type\":\"emphasis-1\",\"content\":\"Lactobacillus\"},\" colonies that have already been distributed throughout the city.\"]}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I've attached a key for the next entry. Each of my diaries will have a key to the next entry, to prevent them from being read out of order.\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"- Liana (Yingmei) Xu\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Attached is an image of an early blueprint for an air scrubber. Based on your best knowledge, it matches the earliest designs.\"}]},\"k_3.dilated_2\":{\"id\":\"k_3.dilated_2\",\"options\":[{\"id\":\"@k_3.k_s_scene\",\"title\":\"...\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"No, I mean, yes, let's do it.\\\" She sighs. \\\"You know I haven't done it since we separated, right?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I mean, I haven't either.\\\"\"},{\"type\":\"paragraph\",\"content\":\"She smiles. \\\"It's all good. This can count as practice.\\\"\"}]},\"data.x1001_c\":{\"id\":\"data.x1001_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"onDeparture\":[{\"$code\":\"Q['liana_introduced'] = (Q['liana_introduced'] || 0) + 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Liana Xu is revered as the founder of this city. According to legends, she was a posthuman who nevertheless sympathized with the baseline humans who wished to destroy her kind. \",\"predicate\":0},\" If this diary is at all genuine, then this is likely the most significant archaeological discovery in the past ten years. If it is at all genuine, then you should be paid more for recovering it.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['liana_introduced'] || 0)===0);\"}}]}},\"k_3.k_s_scene\":{\"id\":\"k_3.k_s_scene\",\"onArrival\":[{\"$code\":\"Q['k_encounter'] = 1;\"}],\"newPage\":true,\"setBg\":\"black\",\"options\":[{\"id\":\"@k_3.k_post\",\"title\":\"...\"}],\"content\":{\"content\":\"...\",\"type\":\"paragraph\"}},\"data.x1009\":{\"id\":\"data.x1009\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"X1009.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - Lactobacillus colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((state.visits['data.x1001'] || 0) > 0);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('x1009'); Q.correct_data_types.push('hoax'); Q.l_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"frequency\":500,\"setJump\":\"data.x1009_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_3.k_post\":{\"id\":\"k_3.k_post\",\"options\":[{\"id\":\"@k_3.am_i\",\"title\":\"\\\"Oh, am I?\\\"\"},{\"id\":\"@k_3.normal_reaction\",\"title\":\"\\\"It's a normal physiological reaction.\\\"\"},{\"id\":\"@k_3.stay_silent\",\"title\":\"Stay silent.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It is over. Your body is sore. The sheets are wet from the just-showered hair, now tangled together, yours and hers, nothing separating the two. For a few moments your mind was clear, as if nothing else in this world mattered. And now you are back to reality.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You're crying.\\\"\"}]},\"data.x1009_\":{\"id\":\"data.x1009_\",\"goTo\":[{\"id\":\"data.x1009_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"What is there to know about me? My name is Liana Yingmei Xu, or [WARNING: UNKNOWN CHARACTER ENCODING]. I was born in Shijiazhuang, Hebei Province, People's Republic of China. Does the memory of China still exist in your time?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I emigrated to America to study biophysics and biochemistry, and I have worked in a variety of scientific positions. I am married to my wife, Jiaren Qi, also of Shijiazhuang, and we had two children.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Jiaren and I grew up in the same town and went to the same high school. I was notorious among my classmates for being a crossdresser, for wearing girl's outfits whenever I had the opportunity. They would see me at the mall, and they would go, that is not a beautiful girl, that is our classmate Xu ---!\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Jiaren was the one person who drew closer to me despite these (true) rumors. He (because Jiaren was still a boy back then) was the only person who asked me if I would rather be treated as a boy or a girl. I fell in love with him, and I believe he realized so, but of course nothing came of it.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Do the equivalents of people such as us still exist in your era?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Relatedly, how are posthumans thought of these days? Are we still considered monsters? Or has the distinction between baselines and posthumans re-emerged? It cannot be so inconceivable, given the presence of DNA sequencing technology.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Here is a picture of me. A poor picture. And here is a sample of my voice.\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"- Liana\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"There is an unknown character encoding here. There is a blurred, heavily dithered image of a person; you can tell that it is a face, but not much more than that. The voice sample is degraded but still audible; it repeats the first paragraph of this diary entry.\"}]},\"k_3.am_i\":{\"id\":\"k_3.am_i\",\"options\":[{\"id\":\"@k_3.stay_silent\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"Oh, am I?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah. You are.\\\"\"}]},\"data.x1009_c\":{\"id\":\"data.x1009_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"If this diary were at all true, then this is an indication that Liana and her partner were both laverneans (or the historical equivalent of laverneans, not that historians would ever agree such a thing existed). This is a potentially monumentous discovery. Your movement had already adopted Liana Xu as a symbol, but they were never aware that she was \",{\"type\":\"emphasis-1\",\"content\":\"actually\"},\" like them.\"]},{\"type\":\"paragraph\",\"content\":\"As to her question about posthumans, they are rarely thought of at all.\"}]},\"k_3.normal_reaction\":{\"id\":\"k_3.normal_reaction\",\"options\":[{\"id\":\"@k_3.stay_silent\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"It's a normal physiological reaction.\"},{\"type\":\"paragraph\",\"content\":\"\\\"You didn't use to do this before.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Didn't I?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"No. You didn't.\\\"\"}]},\"data.x1013\":{\"id\":\"data.x1013\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"X1013.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - Lactobacillus colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((state.visits['data.x1009'] || 0) > 0);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('x1013'); Q.correct_data_types.push('hoax'); Q.l_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"frequency\":500,\"setJump\":\"data.x1013_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_3.stay_silent\":{\"id\":\"k_3.stay_silent\",\"title\":\"Stay silent.\",\"options\":[{\"id\":\"@k_3.end_date\",\"title\":\"...\"}],\"content\":{\"content\":\"You just stay silent. K- has fallen asleep. You are falling asleep.\",\"type\":\"paragraph\"}},\"data.x1013_\":{\"id\":\"data.x1013_\",\"goTo\":[{\"id\":\"data.x1013_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I suppose these are my memoirs, abbreviated to fit inside a single microbe.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"The next chapter of my story is moving to America for university, and then graduate school. Does the memory of America still exist in your time?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I was privileged in that I had parents who would pay for me to take my tests, but the only way we could afford an American university was through scholarships. I hope this is not too self-aggrandizing, but I was a good student. I studied science, especially biology. When I was younger I thought that if I developed the technology to change every chromosome in my body, I could become a \\\"real woman\\\". Of course, I soon learned that such a technology would be less effective than a standard hormone therapy.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"In truth, university in America was not the revelation I thought it would be. I heard that it was a haven for freedom for us queers, but in truth those like us were still few and isolated. Nevertheless, it was here that I was able to \\\"transition\\\". I learned many other things too.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Eventually, Jiaren came to America too, and we reunited one day. We fell in love again. She (because by that time she was also beginning to transition) and I eventually married and, well, the rest of the story will come later.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Liana\"}}]},\"k_3.end_date\":{\"id\":\"k_3.end_date\",\"newPage\":true,\"setBg\":\"images/room1_filtered_dithered.png\",\"content\":[{\"type\":\"paragraph\",\"content\":\"K- is already dressed when you wake up. \\\"Sorry. I have to pick up S- from school soon. Can we maybe start the heartbeat thing again? Where you called me every day to make sure you're okay?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Yeah... I'll try to remember.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Good. And if you need anything, just let me know. I don't know how much I can do, but I'll try to help. I'm sure S- wouldn't mind.\\\"\"},{\"type\":\"paragraph\",\"content\":\"With that, K- leaves, and you are left alone once more.\"}]},\"data.x1013_c\":{\"id\":\"data.x1013_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"C- tells you that this is a hoax. But if it is a hoax, it is a hoax tailor-made for you, to hit your exact spots of cognitive weakness. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"If this is true, then... well, she resembles you, doesn't she? There is a strange feeling of recognition in your heart, as if Liana is reaching out and touching you through the past however many hundred years.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['hoax_warned'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['hoax_warned'] || 0)===0);\"}}]}},\"k_3.dont_remember\":{\"id\":\"k_3.dont_remember\",\"goTo\":[{\"id\":\"k_3.smell_like_a\",\"predicate\":{\"$code\":\"return ((Q['a_encounter'] || 0)===1);\"}},{\"id\":\"k_3.k_gf\",\"predicate\":{\"$code\":\"return ((Q['a_encounter'] || 0)===0);\"}}],\"content\":[{\"type\":\"paragraph\",\"content\":\"\\\"I don't remember.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"That's interesting, because I don't either. It's like it all happened in my imagination, like none of it was real.\\\" She turns to you. \\\"Was it real?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Of course it was real.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"See, I'm just saying things now. I don't know what to talk about either so I'm just rambling on without knowing what I'm even saying. I'm just playing out these parts, like...\\\"\"},{\"type\":\"paragraph\",\"content\":\"She lays down on the bed, next to you. It is a tight fit, with your body nearly squeezed against the wall.\"}]},\"data.x1019\":{\"id\":\"data.x1019\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"X1019.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - Lactobacillus colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((state.visits['data.x1013'] || 0) > 0);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('x1019'); Q.correct_data_types.push('hoax'); Q.l_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"frequency\":500,\"setJump\":\"data.x1019_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"k_3.maybe_sexual\":{\"id\":\"k_3.maybe_sexual\",\"goTo\":[{\"id\":\"k_3.dilated_2\",\"predicate\":{\"$code\":\"return (((Q['k_showered'] || 0)===1) && ((Q['k_knows_a_loved'] || 0)===0));\"}},{\"id\":\"k_3.dilated_no_shower\",\"predicate\":{\"$code\":\"return (((Q['k_showered'] || 0)===0) && ((Q['k_knows_a_loved'] || 0)===0));\"}},{\"id\":\"k_3.dilated_a\",\"predicate\":{\"$code\":\"return ((Q['k_knows_a_loved'] || 0) > 0);\"}}],\"content\":{\"content\":\"\\\"Maybe. Something like that. Sorry...\\\"\",\"type\":\"paragraph\"}},\"k_3\":{\"id\":\"k_3\",\"type\":\"scene\",\"title\":\"K-\",\"subtitle\":\"K- comes to pick up S-\",\"onArrival\":[{\"$code\":\"Q['money'] = (Q['money'] || 0) + 100;\\nQ['with_s'] = 0;\\nQ['k_path'] = 3;\\nQ['k_day'] = (Q['day'] || 0);\\nQ['k_romance'] = 1;\\nQ['day_major'] = (Q['day_major'] || 0) + 1;\"}],\"newPage\":true,\"options\":[{\"id\":\"@k_3.wait_for_k\",\"title\":\"Wait for K- to speak.\"},{\"id\":\"@k_3.go_to_school\",\"title\":\"\\\"So, S-, do you want to go to school now?\\\"\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"K- has arrived at your apartment. The $100 has been transferred to your account.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Wow. This is my first time being here,\\\" says K-.\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Sorry it's such a mess.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's fine! What's the floor area?\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"15 square metres.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. That's pretty small.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"I know.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"It's a lot smaller than my place. At least I have a separate bedroom.\\\"\"},{\"type\":\"paragraph\",\"content\":\"\\\"Oh. Good for you.\\\"\"},{\"type\":\"paragraph\",\"content\":\"K-'s gaze wanders, until it stops at your very interesting collection of pots. From experience you know that your conversation has reached an impasse. One of you has to break it. Meanwhile S- has sat up in bed, rubbing his eyes.\"}]},\"data.x1019_\":{\"id\":\"data.x1019_\",\"goTo\":[{\"id\":\"data.x1019_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"We were now on our third adopted homeland. We thought we would be forced to flee because of discrimination for our gender, not because of an absurd war between our two previous homelands. They called it the Sino-American War, or sometimes the Third World War. Does memory of the war still exist in your time? Or has it been entirely eclipsed by the Posthuman War?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"It is here that Jiaren convinced me to have the procedure done. By this time it was not such a difficult process, technically speaking. On the cellular side, all it took were some induced pluripotent stem cells and carefully tuned gene regulatory induction systems, easy ever since our advanced simulations. We grew the uterus via tissue culture. The more difficult portion was the physical trans/implant.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Our first child was born via surrogacy. Our second child was born via my body, and the culmination of decades of bioengineering.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Liana\"}}]},\"data.x1019_c\":{\"id\":\"data.x1019_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"You want to die right now because what even is the point of living if you can't get a fucking uterus transplant?\",\"type\":\"paragraph\"}},\"data.x1021\":{\"id\":\"data.x1021\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"X1021.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - Lactobacillus colony\"}]},\"tags\":[\"data\",\"diaries\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((state.visits['data.x1019'] || 0) > 0);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('x1021'); Q.correct_data_types.push('hoax'); Q.l_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"frequency\":500,\"setJump\":\"data.x1021_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.x1021_\":{\"id\":\"data.x1021_\",\"goTo\":[{\"id\":\"data.x1021_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"I wonder what you would call the war in your time?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Some called it World War 3. Others called it World War 4, because the Sino-American war was already World War 3.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"One tidbit you will not find in your baseline histories is how trans people were treated in the war. The conflation of \\\"transgender\\\" or \\\"transsexual\\\" with \\\"transhuman\\\" made all trans people on the baseline side into enemies. There were purges and camps and killings, more so than usual. Even those who sympathized with the baseline cause ended up in our side.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"And what about you, I wonder, presumed baseline? Did trans-ness reemerge? Are there people like us in your world?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Liana\"}}]},\"data.x1021_c\":{\"id\":\"data.x1021_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"You have no idea what to feel about this.\",\"type\":\"paragraph\"}},\"data.s101\":{\"id\":\"data.s101\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"S101.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key101'] || 0)===1);\"},\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('s101'); Q.correct_data_types.push('science'); Q.s_seen += 1; Q.key1001 = 1; Q.key1009 = 1; Q.key1013 = 1\"}],\"frequency\":800,\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.s101_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.s101_\":{\"id\":\"data.s101_\",\"goTo\":[{\"id\":\"data.s101_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"DOI: 10.1038/s41589-020-00711-4\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Robust direct digital-to-biological data storage in living cells\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":[\"Abstract: DNA has been the predominant information storage medium for biology and holds great promise as a next-generation high-density data medium in the digital era. Currently, the vast majority of DNA-based data storage approaches rely on in vitro DNA synthesis. As such, there are limited methods to encode digital data into the chromosomes of living cells in a single step. Here, we describe a new electrogenetic framework for direct storage of digital data in living cells. \",{\"type\":\"hidden\",\"content\":\"...\"},\" We demonstrate multiplex data encoding into barcoded cell populations to yield meaningful information storage and capacity up to 72 bits, which can be maintained over many generations in natural open environments...\"]}}]},\"data.s101_c\":{\"id\":\"data.s101_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"You have learned how to implement the decoding method described in this paper. This allows you to view datasets created using this system.\",\"type\":\"paragraph\"}},\"data.s202\":{\"id\":\"data.s202\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"S202.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - E. coli colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key101'] || 0)===1);\"},\"maxVisits\":1,\"countVisitsMax\":1,\"frequency\":500,\"onArrival\":[{\"$code\":\"Q.prev_data.push('s202'); Q.correct_data_types.push('science'); Q.s_seen += 1; Q.key1009 = 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.s202_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.s202_\":{\"id\":\"data.s202_\",\"goTo\":[{\"id\":\"data.s202_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"DOI: 10.1038/nature23017\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"CRISPR–Cas encoding of a digital movie into the genomes of a population of living bacteria\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Abstract: DNA is an excellent medium for archiving data. Recent efforts have illustrated the potential for information storage in DNA using synthesized oligonucleotides assembled in vitro. A relatively unexplored avenue of information storage in DNA is the ability to write information into the genome of a living cell by the addition of nucleotides over time. Using the Cas1–Cas2 integrase, the CRISPR–Cas microbial immune system stores the nucleotide content of invading viruses to confer adaptive immunity. When harnessed, this system has the potential to write arbitrary information into the genome. Here we use the CRISPR–Cas system to encode the pixel values of black and white images and a short movie into the genomes of a population of living bacteria...\"}}]},\"data.s202_c\":{\"id\":\"data.s202_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"You have learned how to implement the decoding method described in this paper. This allows you to view datasets created using this system.\",\"type\":\"paragraph\"}},\"data.f_background\":{\"id\":\"data.f_background\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"The first century is something of a dark age when it comes to history, most likely owing to the fact that the government of the time moved all of their official records to DNA storage, and DNA decoding technology was lost until the past two decades. It seems to have been an era of violence, strife, and popular mysticism. It is interesting how DNA storage correlates with \\\"Dark Ages\\\" in arcology history (including the present day).\",\"type\":\"paragraph\"}},\"data.f101\":{\"id\":\"data.f101\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"F101.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vitro\"}]},\"tags\":[\"data\",\"history\"],\"chooseIf\":{\"$code\":\"return ((Q['key101'] || 0)===1);\"},\"maxVisits\":1,\"countVisitsMax\":1,\"frequency\":300,\"onArrival\":[{\"$code\":\"Q.prev_data.push('f101'); Q.correct_data_types.push('document'); Q.f_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.f101_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.f101_c\":{\"id\":\"data.f101_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"This would be the first century. It is a blank spot in the historical records; most documents seem to disappear around then, perhaps due to a transition to DNA storage from more traditional data storage methods, or perhaps due to whatever incident caused entity attacks to become the leading cause of death.\",\"type\":\"paragraph\"}},\"data.f102\":{\"id\":\"data.f102\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"F102.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vitro\"}]},\"tags\":[\"data\",\"history\"],\"chooseIf\":{\"$code\":\"return ((Q['key3'] || 0)===1);\"},\"frequency\":300,\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('f102'); Q.correct_data_types.push('document'); Q.f_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.f102_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.f102_\":{\"id\":\"data.f102_\",\"goTo\":[{\"id\":\"data.f102_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"5th Census, 100 AT: Names Aal-Aba\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Aalto, Mireille. Born 55\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Aalto, Theodore. Born 79\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Aalto, Zina. Born 89\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Aaron, Aaron. Born 58\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Aaron, Alexander. Born 97\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"...\"}]},\"data.f202\":{\"id\":\"data.f202\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"F202.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vitro\"}]},\"tags\":[\"data\",\"history\"],\"chooseIf\":{\"$code\":\"return ((Q['key3'] || 0)===1);\"},\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('f202'); Q.correct_data_types.push('document'); Q.f_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.f202_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.f202_c\":{\"id\":\"data.f202_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"This is another first-century document, again indicating the social irrationality of this era (not unlike your own). The Absolutionists and Negationists were two factions present in the early post-war era; the Absolutionists believed that baseline humans were the cause of the War, and that cruelty on the part of the baselines pushed the posthumans to the edge. The Negationists believed that posthumans were the cause of the War, and that they inflicted violent cruelties upon the baselines. The Negationists appear to have won out in this conflict.\"},{\"type\":\"paragraph\",\"content\":\"You do not know what a eunuch is. The term does not appear in the dictionaries.\"}]},\"data.f303\":{\"id\":\"data.f303\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"F303.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Archives. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vitro\"}]},\"tags\":[\"data\",\"history\"],\"chooseIf\":{\"$code\":\"return ((Q['key3'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((state.visits['data.f202'] || 0) > 0);\"},\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('f303'); Q.correct_data_types.push('document'); Q.f_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.f202_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.f303_c\":{\"id\":\"data.f303_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":\"There is so much exciting and unknown here. This is an entirely new event that had hitherto never been documented.\",\"type\":\"paragraph\"}},\"data.rev_1\":{\"id\":\"data.rev_1\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"DNA storage is a technology that has come and gone in waves over the centuries. The latest wave has been the revolutionaries who fought in the Uprising five years ago. \",{\"type\":\"conditional\",\"content\":\"You do not know who gave them the archival technology\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['mutual_aid_seen'] || 0)===0);\"}}]}},\"data.r1001\":{\"id\":\"data.r1001\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R1001.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r1001'); Q.correct_data_types.push('special'); Q.r_seen += 1; Q.rosa_seen = 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"frequency\":500,\"setJump\":\"data.r1001_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r1001_\":{\"id\":\"data.r1001_\",\"goTo\":[{\"id\":\"data.r1001_c\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Let it be known first of all that I opposed launching the revolution. We had no allies - how could we when the Ruling Party and every media organ in the city has been propagandizing about how we were sexual degenerates for the past ten years? Ten thousand angry laverneans did not constitute a mass movement. We had few arms, no training after being excluded from the security services, few financial resources, nearly no allies.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"But here we are now. And we must fight or die.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Rosa Camacho, Bread and Roses Brigade\"}}]},\"data.r1001_c\":{\"id\":\"data.r1001_c\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"During the Uprising, DNA storage technology was used by rebels to store their notes, diaries, and so on. They presumed that the bacteria would be read-only in the near term; they did not anticipate your technical capabilities.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Rosa was... not exactly a friend. An acquaintance, perhaps, one more familiar from CityNet than real life. You would not recognize her, and you do not know what happened to her since the Uprising. She probably would have hated you. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"You know that the author of these notes is still alive. You've seen her.\",\"predicate\":1}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['mutual_aid_seen'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['r_path'] || 0) > 0);\"}}]}},\"data.r2002\":{\"id\":\"data.r2002\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R2002.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return ((state.visits['data.r1001'] || 0) > 0);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r2002'); Q.correct_data_types.push('special'); Q.r_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.r2002_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r2002_\":{\"id\":\"data.r2002_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"It is increasingly clear that we are sacrificial pawns in a proxy war. When we seized arms, there was a tacit understanding with some of the security forces that they would not stop us; they virtually handed their weapons to us. The Guards have many enemies, and there are anti-coup factions in the Defense Forces and even the gendarmerie. However, they are not willing to risk their own position in a civil war.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"It is also clear that the some in the security forces see our uprising as a way to simultaneously weaken two enemies, both the radical Opposition and the reactionaries as represented by the Guards. And as the general populace becomes exhausted of our fighting, the central authorities take over, order is restored, and we are all sent outside the dome.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"But what choice do we have? We either accept the aid of all who offer it, or we perish. Regardless, we have been doing quite a bit of that lately.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Rosa Camacho, Bread and Roses Brigade\"}}]},\"data.r3003\":{\"id\":\"data.r3003\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R3003.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1001'] || 0)===1);\"},\"viewIf\":{\"$code\":\"return (((state.visits['data.r1001'] || 0) > 0) || ((state.visits['data.r2002'] || 0) > 0));\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r3003'); Q.correct_data_types.push('special'); Q.r_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.r3003_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r3003_\":{\"id\":\"data.r3003_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"A recounting of a conversation:\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Leon: We're not fucking going down with this ship.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Me: It's interesting how language works, isn't it? None of us have seen a ship before but the idiom still exists in our collective memories.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Leon: Fuck off. My point is, the writing's already on the wall.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Me: Another interesting turn of phrase.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Leon: Fuck. Off. The revolution is over. We can either live to fight another day, or we can die like the rest of them. I know you're one of the more pragmatic ones here, not like the fanatics. We have to go underground. Hide. Do anything but keep on going like this. The undercity's a big place.\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Me: I'm not a deserter. Maybe we can bring it to a vote-\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"At that moment we were interrupted, and Leon went back to his duties. So. In truth I do not know what I should do. I do not want to die, and I can see that our current path leads to no other outcome but mass death. I think I can convince the rest of our brigade to shift our tactics from open battle to underground resistance while maintaining our civilian identities and hiding among the general populace. Of course there is a chance I'll get purged for making such a suggestion. And even if we go underground, we might find our civilian identities unusable.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"So many difficult choices.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Rosa Camacho, Bread and Roses Brigade\"}}]},\"data.r1009\":{\"id\":\"data.r1009\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R1009.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1009'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r1009'); Q.correct_data_types.push('special'); Q.r_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.r1009_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r1009_\":{\"id\":\"data.r1009_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Love is the most powerful weapon in the revolutionist's arsenal. The reactionaries work to isolate us, so that each of us is an island onto herself. Not just the laverneans or the nonbinaries, but all of us, every human being in this ark. We do not have to be this way. We can unite.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"For the first time in our history, our guns are pointed in unison towards the real enemy, rather than at each other.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Esme Franklin, Unity Regiment\"}}]},\"data.r2018\":{\"id\":\"data.r2018\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R2018.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1009'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r2018'); Q.correct_data_types.push('special'); Q.r_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.r2018_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r2018_\":{\"id\":\"data.r2018_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"More of us are dying everyday.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"I used to have no fear of death, because I had nothing to live for, but now, in a cruel irony, I do. I have friends in this regiment, and lovers. I have people who would care if die, whom I would care if they died. What cruel irony that just as I found a will to live...\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"I don't want to die.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Esme Franklin, Unity Regiment\"}}]},\"data.r1013\":{\"id\":\"data.r1013\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R1013.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1013'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r1013'); Q.correct_data_types.push('special'); Q.r_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.r1013_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r1013_\":{\"id\":\"data.r1013_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Our civilization is on borrowed time, and revolution is the only way to escape the tracks that lead to our doom.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"We can no longer produce computers. Within a 100-km radius of the arcology, the safe travel distance since the Cataclysm, there are zero accessible sources of neodymium, tantalum, or even lithium (at least iron and copper are plentiful). Recycling always introduces inefficiencies, and nanotechnology was lost long ago. The only hope is to make electronics last as long as possible, counter to the goals of the industry for the last few centuries.\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"One thing is sure: the bourgeoisie will let civilization die before relinquishing its hold on power.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Leon Zhou, Bread and Roses Brigade\"}}]},\"data.r2026\":{\"id\":\"data.r2026\",\"title\":{\"type\":\"emphasis-3\",\"content\":\"R2026.fastq.gz\"},\"subtitle\":{\"type\":\"emphasis-3\",\"content\":[\"Source: Wild. Medium: \",{\"type\":\"emphasis-1\",\"content\":\"in vivo - B. subtilis colony\"}]},\"tags\":[\"data\",\"science\"],\"chooseIf\":{\"$code\":\"return ((Q['key1013'] || 0)===1);\"},\"unavailableSubtitle\":\"You don't know how to decode this file.\",\"maxVisits\":1,\"countVisitsMax\":1,\"onArrival\":[{\"$code\":\"Q.prev_data.push('r2026'); Q.correct_data_types.push('special'); Q.r_seen += 1;\"}],\"goTo\":[{\"id\":\"data.decode\"}],\"setJump\":\"data.r2026_\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.r2026_\":{\"id\":\"data.r2026_\",\"goTo\":[{\"id\":\"data.todo\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Since the coup and subsequent revolution began, Lyra and I have fallen in with a self-declared revolutionary army. We said we were on the run from the Guards, and they trusted us. It didn't hurt that one of the laverneans in the unit recognized us from school.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Lyra says that she can no longer use her abilities. Something about the Cataclysm induced long-term changes in her nanobiotic ecosystem, whose consequences are apparently only being felt now.\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"It is strange to communicate now. I still imagine that Lyra is peering into my thoughts.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Altair Leblanc, Popular Front Army (for now)\"}}]},\"data.post_data_2\":{\"id\":\"data.post_data_2\",\"goTo\":[{\"id\":\"data.end_data\"},{\"id\":\"data.pre_view_display\"}],\"onArrival\":[{\"$code\":\"if (Q.day_data_seen >= 2 && Math.random() > 0.5) {\\n    Q.stress += 1;\\n}\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.archivist_check\":{\"id\":\"data.archivist_check\",\"onArrival\":[{\"$code\":\"Q.check_data_text = ' ';\\nQ.payment = 0;\\nQ.datasets_checked = 0;\\n// 1. do the first data\\nvar i = 0;\\nvar has_special = false;\\nvar has_hoax = false;\\nwhile (i < Q.chosen_data_types.length) {\\n    // randomly do one out of 50...\\n    if (i > 0) {\\n        if (Math.random() > 0.5) {\\n            break;\\n        }\\n    }\\n    Q.datasets_checked += 1;\\n    var data = Q.prev_data.shift();\\n    var chosen_t = Q.chosen_data_types.shift();\\n    var correct_t = Q.correct_data_types.shift();\\n    Q.check_data_text += '\\\\n<p>' + data + ': ';\\n    if (chosen_t == correct_t) {\\n        Q.check_data_text += 'Your assignment of this dataset as \\\"' + chosen_t + '\\\" was correct. You have been paid $' + Q.type_payments[chosen_t] + '.</p>';\\n        Q.payment += Q.type_payments[chosen_t];\\n    } else {\\n        if (correct_t == 'obscene') {\\n            Q.check_data_text += 'The dataset has been deemed obscene and contrary to public interests, and thus will not be archived. Nevertheless, you have been paid $20.</p>';\\n            Q.payment += 20;\\n        } else if (correct_t == 'hoax') {\\n            Q.check_data_text += 'Based on our evidence, this dataset has been deemed as a HOAX, and will not be archived.';\\n            Q.check_data_test += ' Nevertheless, you have been paid $10 as a token fee.</p>';\\n            has_hoax = true;\\n        } else if (correct_t == 'special') {\\n            has_special = true;\\n            Q.check_data_text += 'This dataset has been deemed of special interest, and will be disseminated more broadly within the state. You have been payed $80.</p>';\\n            Q.payment += 80;\\n        } else if (correct_t == 'liana') {\\n            Q.check_data_text += 'A diary purportedly from Liana Xu is, of course, of deep importance to us, and we thank you for your work. You have been payed $100.</p>';\\n            Q.payment += 100;\\n        } else {\\n            Q.check_data_text += 'Your assignment of this dataset as \\\"' + chosen_t + '\\\" was incorrect. The correct type is \\\"' + correct_t + '\\\". You have been paid $30.</p>';\\n            Q.payment += 30;\\n        }\\n    }\\n    Q.check_data_text += '\\\\n\\\\n';\\n    i += 1;\\n}\\n// C- sends you a message saying that you should not sell out your people.\\nif (has_special && !Q.r_processed) {\\n    Q.r_processed = 1;\\n    Q.check_data_text += '<p>A message from C-:</p><p>Hi Em, I saw the R dataset that you filed. Just, be careful in what you send in. We both have friends who might not want certain people to see these files.</p>';\\n}\\nif (has_hoax && Q.l_seen == 2 && !Q.hoax_warned) {\\n    Q.check_data_text += '<p>A message from C-:</p><p>Turns out, the whole Liana Xu dataset might have been some sort of hoax. Our security people think there must have been an artificial dataset injected into the pipeline by either insiders or outside hackers. We aren\\\\'t going to penalize you, but just so you\\\\'re aware, we will not be paying for any more of these files, and you should not regard any of these files as having veracity. Sorry to get your hopes up.</p>';\\n    Q.hoax_warned = 1;\\n}\\n// promote some specific datasets: S101.fastq.gz, X1001.fastq.gz\\nif (Q.key1001 == 0 && !Q.check_101_prompt) {\\n    Q.check_data_text += '<p>A message from C-:</p><p>If you happen to see it, check out S101.fastq.gz. This file might be important.</p>';\\n} else if (Q.key1001 == 1 && !Q.l_seen) {\\n    Q.check_data_text += '<p>A message from C-:</p><p>If you happen to come across it, check out X1001.fastq.gz. From a preliminary analysis, a lot of people are excited about this one. Any file starting with X is something that\\\\'s been marked to be of special interest.</p>';\\n}\\nQ.money += Q.payment;\"}],\"goTo\":[{\"id\":\"data.view_display\",\"predicate\":{\"$code\":\"return ((Q['datasets_checked'] || 0)===0);\"}},{\"id\":\"data.check_data_0\",\"predicate\":{\"$code\":\"return ((Q['datasets_checked'] || 0) > 0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"data.f101_\":{\"id\":\"data.f101_\",\"goTo\":[{\"id\":\"data.f_background\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) <= 1);\"}},{\"id\":\"data.f101_c\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) > 1);\"}}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Most common causes of death, 99 AT\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"1. Entity attacks\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"2. Nanoplagues\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"3. Interpersonal violence\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"4. Cancer\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"5. Accidents\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"6. Heart disease\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"7. Other infectious diseases\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"8. Unknown\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"9. Suicide\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"10. Medical complications\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Source: Census\"}}]},\"data.f102_c\":{\"id\":\"data.f102_c\",\"goTo\":[{\"id\":\"data.todo\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) > 1);\"}},{\"id\":\"data.f_background\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) <= 1);\"}}],\"content\":{\"content\":\"The names continue for a few hundred lines. Perhaps this data would be of interest to specialists.\",\"type\":\"paragraph\"}},\"data.f202_\":{\"id\":\"data.f202_\",\"goTo\":[{\"id\":\"data.f_background\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) <= 1);\"}},{\"id\":\"data.f202_c\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) > 1);\"}}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Thesis: The regime of the eunuchs represents a remnant of the Absolutionist degeneracy must be abolished, and to do so their remaining numbers must be culled.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Antithesis: Eunuchs are citizens of the arcology like any other. They do not constitute a regime, and insofar that they have undue influence in government, it has been on the net beneficial.\"}},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-3\",\"content\":\"Synthesis: All eunuchs must be removed from government, but they are to be permitted to live. However, they must be re-educated in order to remove the traces of their ideology.\"},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Administrator R. Beauchamp, 99 AT\"}}]},\"data.f303_\":{\"id\":\"data.f303_\",\"goTo\":[{\"id\":\"data.f_background\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) <= 1);\"}},{\"id\":\"data.f303_c\",\"predicate\":{\"$code\":\"return ((Q['f_seen'] || 0) > 1);\"}}],\"content\":[{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"99 AT\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"A report from the \\\"Night of Restoration\\\":\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"234 found dead in the central temple.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"431 found dead in Amherst District.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"512 found dead in Tonawada District.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Total dead from all districts: more than 2,500.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"PM2.5 increased by 50% due to fires.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"Commentary: Most of the city does not believe in our Gods, or the God that our opponents presume to be the rival of the Gods. They do not believe in Science, either, or Democracy or Liberty or any of the other pre-war ideals. They do not even believe in the sanctity of the human body, supposedly the core tenant of Negationism. So what do they believe in that makes them kill us?\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-3\",\"content\":\"- Emilia F. Chu, chief eunuch of New Hamilton Temple\"}}]},\"data\":{\"id\":\"data\",\"type\":\"scene\",\"title\":\"Data\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}}},\"qualities\":{},\"qdisplays\":{},\"tagLookup\":{\"k_generic\":{\"k_generic.k_s\":true,\"k_generic.k_household\":true},\"minor\":{\"mutual_aid_2\":true,\"online_montage.cn\":true,\"k_generic\":true,\"k_call\":true,\"entertainment\":true,\"a_generic\":true,\"a_call\":true,\"mutual_aid\":true,\"anxiety\":true,\"k_4\":true,\"k_1\":true,\"a_1\":true,\"online_montage\":true},\"major\":{\"data.view_0\":true,\"data.view\":true,\"illness\":true,\"illness_2\":true,\"ritual\":true,\"k_2\":true,\"anxiety\":true,\"a_2\":true,\"a_3\":true},\"montage\":{\"online_montage.cn1\":true,\"online_montage.cn2\":true,\"online_montage.cn3\":true,\"online_montage.cn4\":true,\"online_montage.cn5\":true,\"online_montage.cn6\":true,\"online_montage.cn7\":true,\"online_montage.cn8\":true,\"online_montage.cn9\":true,\"online_montage.cn10\":true,\"online_montage.cn11\":true,\"online_montage.cn12\":true,\"online_montage.cn13\":true,\"online_montage.cn14\":true,\"online_montage.cn15\":true,\"online_montage.cn16\":true,\"online_montage.cn17\":true,\"online_montage.cn18\":true,\"online_montage.cn19\":true,\"online_montage.cn20\":true,\"online_montage.cn21\":true,\"online_montage.cn22\":true},\"takeout\":{\"food.takeout_do_1\":true,\"food.takeout_do_2\":true},\"trolley\":{\"food.trolley_1\":true,\"food.trolley_2\":true,\"food.trolley_3\":true,\"food.trolley_4\":true},\"pharmacy\":{\"medicine.pharmacy_1\":true,\"medicine.pharmacy_2\":true},\"top\":{\"one\":true},\"cooking\":{\"food.cook_2_1\":true,\"food.cook_2_2\":true},\"starve\":{\"food.starve_2\":true,\"food.starve_3\":true,\"food.starve_4\":true,\"food.starve_5\":true},\"data\":{\"data.d606\":true,\"data.d77\":true,\"data.d19\":true,\"data.d31\":true,\"data.d1001\":true,\"data.w606\":true,\"data.w29\":true,\"data.w121\":true,\"data.w31\":true,\"data.w49\":true,\"data.w169\":true,\"data.w13\":true,\"data.w63\":true,\"data.w46\":true,\"data.w58\":true,\"data.w17\":true,\"data.x1001\":true,\"data.x1009\":true,\"data.x1013\":true,\"data.x1019\":true,\"data.x1021\":true,\"data.s101\":true,\"data.s202\":true,\"data.f101\":true,\"data.f102\":true,\"data.f202\":true,\"data.f303\":true,\"data.r1001\":true,\"data.r2002\":true,\"data.r3003\":true,\"data.r1009\":true,\"data.r2018\":true,\"data.r1013\":true,\"data.r2026\":true},\"diaries\":{\"data.d606\":true,\"data.d77\":true,\"data.d19\":true,\"data.d31\":true,\"data.d1001\":true,\"data.x1001\":true,\"data.x1009\":true,\"data.x1013\":true,\"data.x1019\":true,\"data.x1021\":true},\"wiki\":{\"data.w606\":true,\"data.w29\":true,\"data.w121\":true,\"data.w31\":true,\"data.w49\":true,\"data.w169\":true,\"data.w13\":true,\"data.w63\":true,\"data.w46\":true,\"data.w58\":true,\"data.w17\":true},\"science\":{\"data.s101\":true,\"data.s202\":true,\"data.r1001\":true,\"data.r2002\":true,\"data.r3003\":true,\"data.r1009\":true,\"data.r2018\":true,\"data.r1013\":true,\"data.r2026\":true},\"history\":{\"data.f101\":true,\"data.f102\":true,\"data.f202\":true,\"data.f303\":true}}}"};(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
/* dendry
 * http://github.com/idmillington/dendry
 *
 * MIT License
 */
/*jshint indent:2 */
(function() {
  'use strict';

  // To avoid the need to include any utility libraries when this is
  // used in a browser, define some helper functions we'd normally
  // rely on libraries for.

  var assert = function(mustBeTrue) {
    /* istanbul ignore if */
    if (!mustBeTrue) {
      throw new Error('Assertion failed.');
    }
  };

  var each = function(array, fn) {
    for (var i = 0; i < array.length; ++i) {
      fn(array[i]);
    }
  };

  var objEach = function(obj, fn) {
    for (var key in obj) {
      fn(key, obj[key]);
    }
  };

  var merge = function() {
    var result = {};
    for (var i = 0; i < arguments.length; ++i) {
      var obj = arguments[i];
      for (var key in obj) {
        result[key] = obj[key];
      }
    }
    return result;
  };

  // Credit: Taken from Lodash (MIT License). See CREDITS.
  var isObject = function(value) {
    var type = typeof value;
    return type === 'function' || (value && type === 'object') || false;
  };

  var makeFunctionFromSource = function(source) {
    source = source.trim();
    /*jshint -W054 */
    var fn = new Function('state', 'Q', source);
    /*jshint +W054 */
    fn.source = source;
    return fn;
  };

  var runActions = function(actions, context, state) {
    if (actions === undefined) {
      return;
    }
    each(actions, function(fn) {
      try {
        fn.call(context, state, state.qualities);
      } catch (err) {
        // Ignore errors. TODO: Log them somehow?
      }
    });
  };

  var runPredicate = function(predicate, default_, context, state) {
    var result = default_;
    if (predicate === undefined) {
      return result;
    }
    try {
      result = !!predicate.call(context, state, state.qualities);
    } catch (err) {
      // Ignore errors. TODO: Log them somehow?
    }
    return result;
  };

  var runExpression = function(expression, default_, context, state) {
    var result = default_;
    if (expression === undefined) {
      return result;
    }
    try {
      result = expression.call(context, state, state.qualities);
    } catch (err) {
      // Ignore errors. TODO: Log them somehow?
    }
    return result;
  };

  var convertJSONToGame = function(json, callback) {
    var reviver = function(key, value) {
      if (isObject(value) && value.$code !== undefined) {
        return makeFunctionFromSource(value.$code);
      } else {
        return value;
      }
    };

    try {
      var game = JSON.parse(json, reviver);
      return callback(null, game);
    } catch (err) {
      return callback(err);
    }
  };

  var simpleContent = function(text) {
    return [{type:'paragraph', content:text}];
  };

  var getCardinalNumber = function(value) {
    if (Math.floor(value) === value && value >= 0 && value <= 12) {
      // Integer, so use word.
      return ['zero', 'one', 'two', 'three', 'four', 'five', 'six',
              'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve'][value];
    } else {
      return value.toString();
    }
  };

  var getOrdinalNumber = function(value) {
    if (Math.floor(value) === value && value >= 0) {
      if (value <= 12) {
        return ['zeroth', 'first', 'second', 'third', 'fourth', 'fifth',
                'sixth', 'seventh', 'eighth', 'ninth', 'tenth', 'eleventh',
                'twelfth'][value];
      } else {
        value = value.toString();
        if (/1[0-9]$/.test(value)) {
          return value + 'th';
        } else {
          var last = value.substr(value.length - 1, 1);
          switch (last) {
            case '1': return value + 'st';
            case '2': return value + 'nd';
            case '3': return value + 'rd';
            default: return value + 'th';
          }
        }
      }
    } else {
      return value.toString();
    }
  };

  var getFudgeDisplay = function(value) {
    if (Math.floor(value) === value) {
      if (value > 3) {
        return 'superb+' + (value - 3);
      } else if (value < -3) {
        return 'terrible' + (value + 3);
      } else {
        switch (value) {
          case  3: return 'superb';
          case  2: return 'great';
          case  1: return 'good';
          case  0: return 'fair';
          case -1: return 'mediocre';
          case -2: return 'poor';
          case -3: return 'terrible';
        }
      }
    } else {
      return value.toString();
    }
  };

  var getUserQDisplay = function(value, qdisplay) {
    for (var i = 0; i < qdisplay.content.length; ++i) {
      var case_ = qdisplay.content[i];
      var min = case_.min;
      var max = case_.max;
      if ((min === undefined || min <= value) &&
          (max === undefined || max >= value)) {
        if (case_.output !== undefined) {
          return case_.output;
        } else {
          return value.toString();
        }
      }
    }
    return value.toString();
  };

  // ------------------------------------------------------------------------

  // Objects with this interface are passed to a game state to have it
  // display content.
  var UserInterface = function() {};
  UserInterface.prototype.beginGame = function() {};
  UserInterface.prototype.displayContent = function(paragraphs) {};
  UserInterface.prototype.displayChoices = function(choices) {};
  UserInterface.prototype.displayGameOver = function() {
    this.displayContent(simpleContent('Game Over'));
  };
  UserInterface.prototype.removeChoices = function() {};
  // Called when the player makes a choice and new content is about to be
  // added (i.e. isn't called between output when the next scene is arrived
  // at via go-to).
  UserInterface.prototype.beginOutput = function() {};
  UserInterface.prototype.endOutput = function() {};
  UserInterface.prototype.newPage = function() {};
  UserInterface.prototype.setStyle = function(style) {};
  UserInterface.prototype.signal = function(data) {};
  UserInterface.prototype.setBg = function(img) {};
  // Not part of the UI, but allows us to simply subclass.
  UserInterface.makeParentOf = function(OtherConstructor) {
    OtherConstructor.prototype = new UserInterface();
    OtherConstructor.constructor = OtherConstructor;
  };

  // ------------------------------------------------------------------------

  // An engine is given a user interface, the game and the current
  // game state (can be omitted). It is responsible for the logic of
  // the game.
  var DendryEngine = function(ui, game) {
    this.ui = ui;
    this.game = game;
  };

  DendryEngine.prototype.displayGameOver = function() {
    this.ui.displayGameOver();
    return this;
  };

  DendryEngine.prototype.displayChoices = function() {
    var choices = this.getCurrentChoices();
    assert(choices);
    this.ui.displayChoices(choices);

    return this;
  };

  DendryEngine.prototype.displaySceneContent = function(restorePage) {
    var scene = this.getCurrentScene();
    assert(scene);

    var sceneSignal = scene.signal || this.game.sceneSignal;
    if (sceneSignal !== undefined) {
      this.ui.signal({signal:sceneSignal,
                      event:'scene-display',
                      id:this.state.sceneId});
    }
    if (restorePage) {
      this.ui.newPage();
      this.ui.displayContent(this.state.tempCurrentContent);
      this.state.currentContent = this.state.tempCurrentContent.slice();
    } else if (scene.newPage) {
      this.ui.newPage();
      this.state.currentContent = [];
    }
    this.ui.setStyle(scene.style);
    this.ui.removeChoices();

    this._runActions(scene.onDisplay);
    if (scene.content !== undefined && !restorePage) {
      var displayContent = this._makeDisplayContent(scene.content, true);
      this.state.currentContent = this.state.currentContent.concat(displayContent);
      this.ui.displayContent(displayContent);
    }

    return this;
  };

  DendryEngine.prototype.choose = function(choiceIndex) {
    var choices = this.choiceCache;

    // Check for valid choice.
    assert(choices);
    if (choices.length <= choiceIndex) {
      throw new Error('No choice at index ' + choiceIndex + ', only ' +
                      choices.length + ' choices are available.');
    }

    // Commit the choice.
    var choice = choices[choiceIndex];
    if (!choice.canChoose) {
      throw new Error('Attempted to choose index ' + choiceIndex + ', but ' +
                      'that choice is unavailable.');
    }

    var id = choice.id;

    delete this.choiceCache;
    this.goToScene(id);

    return this;
  };

  DendryEngine.prototype.goToScene = function(id) {
    this.state.sceneIdsSinceGoTo = [];
    this.ui.beginOutput();
    this.__changeScene(id);
    this.ui.endOutput();
  };

  DendryEngine.prototype.beginGame = function(rndSeeds) {
    this.random = rndSeeds ? Random.fromSeeds(rndSeeds) : Random.fromUnique();
    this.state = {
      sceneId: null,
      sceneIdsSinceGoTo: [],
      rootSceneId: this.game.rootScene || this.game.firstScene || 'root',
      gameOver: false,
      visits: {},
      qualities: {},
      currentRandomState: null,
      currentContent: [],
      // tempCurrentContent is used for when the
      // player visits the stats or settings pages in order to remember
      // where the previous page was?
      tempCurrentContent: [],
      // prevSpecialSceneId is only set when visiting scene tagged with
      // isSpecial = true, and is the scene before the special scene.
      prevSpecialSceneId: null,
      prevSceneId: null,
      // every time a top-level scene changes,
      // this record the last-visited qualified id within that scene.
      prevTopSceneId: null,
      // jumpScene is defined within a scene file, indicating the scene that
      // @jumpScene will go to. Basically it's used to make subroutines.
      jumpSceneId: null,
      // achievements is a dict of all the current achievements.
      // TODO: persist achievements in the browser through localstorage?
      achievements: {},
      // current background image
      bg: null,
      // sceneStack is used for goSub
      sceneStack: [],
      // true if just popped out of a returnScene
      justReturned: false,
      // just returned from a goSubStart
      justReturnedStart: false,
      // just returned from a goSubEnd
      justReturnedEnd: false,
    };

    this._setUpQualities();
    this._loadAchievements();

    this.ui.beginGame();

    var id = this.game.firstScene || this.state.rootSceneId;
    this.goToScene(id);

    return this;
  };

  DendryEngine.prototype._loadAchievements = function() {
    if (typeof localStorage !== 'undefined') {
        if (localStorage[this.game.title + '_achievements']) {
            this.state.achievements = JSON.parse(
                localStorage[this.game.title + '_achievements']);
            // add a special quality named 'achievement_'
            for (var achievement in this.state.achievements) {
                this.state.qualities['achievement_' + achievement] = 1;
            }
        }
    }
  };

  DendryEngine.prototype.gameOver = function() {
    this.state.gameOver = true;
    this.displayGameOver();
    return this;
  };

  DendryEngine.prototype.isGameOver = function() {
    return this.state.gameOver;
  };

  DendryEngine.prototype.getCurrentScene = function() {
    var scene = this.game.scenes[this.state.sceneId];
    assert(scene !== undefined);
    return scene;
  };

  // Returns the choices for the current scene. Choices are objects
  // with an id and a title property, not to be confused with the
  // option objects in a scene (though options are used to generate
  // choices). Choices are compiled from the options belonging to the
  // current scene.
  DendryEngine.prototype.getCurrentChoices = function() {
    return this.choiceCache;
  };

  // Sets the current state of the engine from an exportable state.
  DendryEngine.prototype.setState = function(state) {
    // Set the state.
    this.state = state;
    this._setUpQualities();
    this.random = Random.fromState(this.state.currentRandomState);

    // Display the current state.
    if (this.isGameOver()) {
      this.displayGameOver();
    } else {
      var scene = this.getCurrentScene();
      this.choiceCache = this._compileChoices(scene);
      this.ui.newPage();
      this.ui.removeChoices();
      this.ui.displayContent(this.state.currentContent);
      this.displayChoices();
    }
    return this;
  };

  // Returns a data structure for exporting without any accessors or
  // complex classes.
  DendryEngine.prototype.getExportableState = function() {
    // Because we only have complex state in the qualities (they have
    // accessors), and because we save with JSON (which calls
    // accessors correctly), we don't have to worry about giving the
    // actual state. Note that, if you want to keep this object, however,
    // you want to clone it somehow (turning it to and from json,
    // for example), otherwise it will change as the engine updates.
    return this.state;
  };

  // ------------------------------------------------------------------------

  DendryEngine.prototype._getQDisplay = function(value, qDisplayId) {
    switch (qDisplayId) {
    case 'cardinal': case 'number':
      return getCardinalNumber(value);
    case 'ordinal':
      return getOrdinalNumber(value);
    case 'fudge':
      return getFudgeDisplay(value);
    default:
      var qdisplay = this.game.qdisplays[qDisplayId];
      assert(qdisplay !== undefined);
      return getUserQDisplay(value, qdisplay);
    }
  };

  DendryEngine.prototype._evaluateStateDependencies = function(defs) {
    var result = [];

    for (var i = 0; i < defs.length; ++i) {
      var value;
      var def = defs[i];
      var fn = def.fn;
      switch (def.type) {
      case 'insert':
        value = this._runExpression(fn);
        if (def.qdisplay) {
          value = this._getQDisplay(value, def.qdisplay);
        } else {
          value = value.toString();
        }
        break;

      default:
        assert(def.type === 'predicate');
        value = this._runPredicate(fn);
        break;
      }

      // Recurse the resolution into the resulting value, if needed.
      if (value.stateDependencies !== undefined) {
        // We have to resolve the nested state dependencies.
        value = this._makeDisplayContent(value, false);
      }
      result.push(value);
    }
    return result;
  };

  DendryEngine.prototype._mergeStateEvalsInArray = function(array, evals) {
    if (!Array.isArray(array)) {
      array = [array];
    }
    var result = [];
    for (var i = 0; i < array.length; ++i) {
      result = result.concat(this._mergeStateEvals(array[i], evals));
    }
    return result;
  };

  DendryEngine.prototype._mergeStateEvals = function(content, evals) {
    if (content.type === undefined) {
      return [content];
    }

    var result;
    switch (content.type) {
    case 'conditional':
      if (evals[content.predicate]) {
        result = this._mergeStateEvalsInArray(content.content, evals);
      } else {
        result = [];
      }
      break;
    case 'insert':
      result = evals[content.insert];
      break;
    default:
      var newE = {type:content.type};
      newE.content = this._mergeStateEvalsInArray(content.content, evals);
      result = [newE];
      break;
    }
    return result;
  };

  DendryEngine.prototype._makeDisplayContent = function(content, useParas) {
    // Raw content can just be returned.
    if (content.content === undefined) {
      if (Array.isArray(content)) {
        return content;
      } else if (useParas) {
        return [{type:'paragraph', content:content}];
      } else {
        return [content];
      }
    } else if (content.stateDependencies === undefined &&
               content.type !== undefined) {
      return [content];
    }

    // Merge in dependencies if we have them
    var stateDepDefs = content.stateDependencies;
    var displayContent = content.content;
    if (stateDepDefs && stateDepDefs.length > 0) {
      var evals = this._evaluateStateDependencies(stateDepDefs);
      if (!Array.isArray(displayContent)) {
        displayContent = [displayContent];
      }
      displayContent = this._mergeStateEvalsInArray(
        displayContent, evals
      );
    }
    return displayContent;
  };

  DendryEngine.prototype._setUpQualities = function() {
    var _Q = this._qualitiesAccessorsPrivate = {};
    var Q = this.state.qualities;
    var that = this;
    objEach(this.game.qualities, function(id, quality) {
      var min = quality.min;
      var max = quality.max;
      var signal = quality.signal || that.game.qualitySignal;
      var predicate = quality.isValid;
      var needsAccessors = (
        min !== undefined ||
        max !== undefined ||
        signal !== undefined ||
        predicate !== undefined
      );
      if (needsAccessors) {
        if (Q[id] !== undefined) {
          _Q[id] = Q[id];
        }
        Q.__defineGetter__(id, function() {
          return _Q[id];
        });
        Q.__defineSetter__(id, function(value) {
          if (min !== undefined && value < min) {
            value = min;
          }
          if (max !== undefined && value > max) {
            value = max;
          }
          var was = _Q[id];
          _Q[id] = value;

          // Check if the new value is not allowed.
          if (!that._runPredicate(predicate, true)) {
            // Reverse the change.
            _Q[id] = value = was;
          }

          // Signal after the change is made.
          if (signal !== undefined && value !== was) {
            var signalObj = {
              signal: signal,
              event: 'quality-change',
              id: id,
              now: value
            };
            if (was !== undefined) {
              signalObj.was = was;
            }
            that.ui.signal(signalObj);
          }
        });
      }
      if (quality.initial !== undefined && Q[id] === undefined) {
        Q[id] = quality.initial;
      }
    });
  };

  DendryEngine.prototype._runActions = function(actions) {
    runActions(actions, this, this.state);
  };

  DendryEngine.prototype._runPredicate = function(predicate, default_) {
    return runPredicate(predicate, default_, this, this.state);
  };

  DendryEngine.prototype._runExpression = function(expression, default_) {
    return runExpression(expression, default_, this, this.state);
  };

  DendryEngine.prototype.__changeScene = function(id) {
    if (this.state.justReturned) {
        this.state.justReturned = false;
    }
    var scene = null;
    var restorePage = false;
    // if id is 'prevScene', go to the previous scene.
    if (id == 'prevScene') {
      if (this.prevSceneId === null) {
        // TODO: prevScene should only be allowed when prevSceneId is not null.
        // this really only comes up on the very first scene of the game.
      }
      scene = this.game.scenes[this.state.prevSceneId];
      id = this.state.prevSceneId;
      assert(scene);
    } else if (id == 'prevTopScene') {
      scene = this.game.scenes[this.state.prevTopSceneId];
      id = this.state.prevTopSceneId;
      assert(scene);
    } else if (id == 'jumpScene') {
      scene = this.game.scenes[this.state.jumpSceneId];
      id = this.state.jumpSceneId;
      assert(scene);
    } else if (id === 'backSpecialScene') {
      scene = this.game.scenes[this.state.prevSpecialSceneId];
      id = this.state.prevSpecialSceneId;
      restorePage = true;
      assert(scene);
      // if prevSpecialSceneId is null, this indicates that
      // we're not within a specialScene, and we can set a jump point.
      this.state.prevSpecialSceneId = null;
    } else if (id == 'returnScene') {
        // TODO: on returnScene, don't display the scene text.
        // only display the choices.
        var prevSceneID = this.state.sceneStack.pop();
        assert(prevSceneID);
        scene = this.game.scenes[prevSceneId];
        this.state.justReturned = true;
    } else {
      scene = this.game.scenes[id];
      assert(scene);
    }


    // Leave previous scene.
    var fromId = this.state.sceneId;
    if (!!fromId) {
      this.state.prevSceneId = fromId;
      // TODO: this doesn't necessarily work... there should be
      // a different classification of top scenes
      if (scene.isTop) {
        this.state.prevTopSceneId = fromId;
      }
      if (scene.isSpecial && this.state.prevSpecialSceneId === null) {
        this.state.tempCurrentContent = this.state.currentContent.slice();
        this.state.prevSpecialSceneId = fromId;
      }
      var from = this.getCurrentScene();
      this._runActions(from.onDeparture);
      var fromSignal = from.signal || this.game.sceneSignal;
      if (fromSignal !== undefined) {
        this.ui.signal({signal:fromSignal,
                        event:'scene-departure',
                        id:this.state.sceneId,
                        'to':id});
      }
    }

    // Arrive at current scene.
    this.state.sceneId = id;
    this.state.sceneIdsSinceGoTo.push(id);

    if (scene.setRoot) {
      this.state.rootSceneId = id;
    }
    if (scene.setJump) {
      this.state.jumpSceneId = scene.setJump;
    }

    if (scene.countVisitsMax !== undefined) {
      if (this.state.visits[id] === undefined) {
        this.state.visits[id] = 1;
      } else if (this.state.visits[id] < scene.countVisitsMax) {
        this.state.visits[id]++;
      }
    }

    if (!restorePage && !this.state.justReturned) {
        // If we go back from a special scene (e.g. the stats page),
        // we probably don't want to run the scene actions again.
        this._runActions(scene.onArrival);
    }
    var sceneSignal = scene.signal || this.game.sceneSignal;
    if (sceneSignal !== undefined) {
      var signal = {
        signal: sceneSignal,
        event: 'scene-arrival',
        id: id
      };
      if (!!fromId) {
        signal.from = fromId;
      }
      this.ui.signal(signal);
    }

    // We're done with any code that might generate random numbers
    // (except go-to, which will recurse into this method anyway), so we
    // can store the seed which can be used to replay the behavior
    // from here.
    this.state.currentRandomState = this.random.getState();
    //if (!this.state.justReturned) {
        // if the state has just returned from a goSub, we don't display
        // the content?
        // TODO: i'm not sure what the best logic for this is...
        // Maybe the text pre-gosub should be displayed only after the goSub?
    this.displaySceneContent(restorePage);
    //}
    // display background
    if (scene.setBg) {
        this.state.bg = scene.setBg;
        this.ui.setBg(scene.setBg);
    }
    // update achievement
    if (scene.achievement) {
        this.state.achievements[scene.achievement] = 1;
        // add a special quality named 'achievement_'
        this.state.qualities['achievement_' + scene.achievement] = 1;
        // set localStorage for achievement
        if (typeof localStorage !== 'undefined') {
            localStorage[this.game.title + '_achievements'] = JSON.stringify(this.state.achievements);
        }
    }

    // Check if we have any reason to leave the scene, or end the game.
    var done = false;
    if (scene.gameOver === true) {
      done = true;
      this.gameOver();
    } else if (scene.goSubEnd && !this.state.justReturnedEnd) {
      // goSub
      var validSubs = [];
      for (var s1 = 0; s1 < scene.goSub.length; ++s1) {
        var sub = scene.goSub[s1];
        if (sub.predicate === undefined ||
            this._runPredicate(sub.predicate)) {
          validSubs.push(sub.id);
        }
      }
    } else if (scene.goTo) {
      // Find all valid gotos.
      var validGoToIds = [];
      for (var i = 0; i < scene.goTo.length; ++i) {
        var goTo = scene.goTo[i];
        if (goTo.predicate === undefined ||
            this._runPredicate(goTo.predicate)) {
          validGoToIds.push(goTo.id);
        }
      }
      if (validGoToIds.length === 1) {
        done = true;
        this.__changeScene(validGoToIds[0]);
      } else if (validGoToIds.length > 1) {
        var randomNumber = this.random.uint32();
        var choice = randomNumber % validGoToIds.length;
        var chosenGoToId = validGoToIds[choice];
        done = true;
        this.__changeScene(chosenGoToId);
      }
    } else if (scene.goToRef) {
      // do some gotoref
      var validRefs = [];
      for (var s = 0; s < scene.goToRef.length; ++s) {
        var ref = scene.goToRef[s];
        if (ref.predicate === undefined ||
            this._runPredicate(ref.predicate)) {
          validRefs.push(ref.id);
        }
      }
      if (validRefs.length === 1) {
        done = true;
        this.__changeScene(this.state.qualities[validRefs[0]]);
      } else if (validRefs.length > 1) {
        var c = this.random.uint32() % validRefs.length;
        var chosenRef = validRefs[c];
        done = true;
        this.__changeScene(this.state.qualities[chosenRef]);
      }
    }

    // If we've not ended, nor found a valid go-to, then we try choices.
    if (!done) {
      this.choiceCache = this._compileChoices(scene);
      if (this.choiceCache === null) {
        // Explicitly disallowing game over keeps us stuck here.
        if (scene.gameOver !== false) {
          this.gameOver();
        }
      } else {
        this.displayChoices();
      }
    }
  };

  DendryEngine.prototype.__getChoiceSelectionData = function(idToInfoMap) {
    var result = [];
    for (var id in idToInfoMap) {
      var optionScene = this.game.scenes[id];
      var optionInfo = idToInfoMap[id];

      optionInfo.order = optionInfo.order || optionScene.order || 0;
      optionInfo.priority = optionInfo.priority || optionScene.priority || 1;
      // Because 'null' is a valid frequency, we can't use || to do this.
      if (optionInfo.frequency === undefined) {
        optionInfo.frequency = optionScene.frequency;
        if (optionInfo.frequency === undefined) {
          optionInfo.frequency = 100;
        }
      }
      optionInfo.selectionPriority = 0; // Used by __filterByPriority

      result.push(optionInfo);
    }
    return result;
  };

  DendryEngine.prototype.__filterViewable = function(idToInfoMap) {
    var result = {};
    for (var id in idToInfoMap) {
      var thisScene = this.game.scenes[id];

      // This id fails if it is past its max visits.
      var maxVisits = thisScene.maxVisits;
      if (maxVisits !== undefined) {
        var visits = this.state.visits[id] || 0;
        if (visits >= maxVisits) {
          continue;
        }
      }

      // Fiter out scenes that can't be viewed.
      var canView = this._runPredicate(thisScene.viewIf, true);
      if (!canView) {
        continue;
      }

      // It passes otherwise.
      result[id] = idToInfoMap[id];
    }
    return result;
  };

  DendryEngine.prototype.__getChoiceIdsFromOptions = function(options) {
    var that = this;

    var choices = {};
    each(options, function(option) {
      // Filter out options that can't be viewed.
      if (!that._runPredicate(option.viewIf, true)) {
        return;
      }

      if (option.id.substr(0, 1) === '@') {
        // This is an id, use it.
        var trimmedId = option.id.substring(1);
        var choice = merge(option, {id:trimmedId});
        choices[trimmedId] = choice;
      } else {
        assert(option.id.substr(0, 1) === '#');
        // This is a tag, add all matching ids.
        var ids = that.game.tagLookup[option.id.substring(1)];
        objEach(ids, function(id) {
          if (choices[id] === undefined) {
            choices[id] = merge(option, {id:id});
          }
        });
      }
    });
    return choices;
  };

  // Code based on Undum (MIT License). See CREDITS.
  DendryEngine.prototype.__filterByPriority = function(choices,
                                                       minChoices,
                                                       maxChoices) {
    assert(minChoices === null ||
           maxChoices === null ||
           maxChoices >= minChoices);
    var that = this;

    var committed = [];
    var candidates = [];
    var choice;

    // Work in descending priority order.
    choices.sort(function(a, b) {
      return b.priority - a.priority;
    });

    // First phase: we make sure we have at least our minimum number
    // of choices, and that we consider the minimum possible number of
    // priorities to reach that minimum.
    var lastPriority;
    for (var i = 0; i < choices.length; ++i) {
      choice = choices[i];
      if (choice.priority !== lastPriority) {
        if (lastPriority !== undefined) {
          // Priority has decreased, use the candidates if there are enough.
          if (minChoices === null || i >= minChoices) {
            break;
          }
        }

        // We're going on, so commit our current candidates.
        committed.push.apply(committed, candidates);
        candidates = [];
        lastPriority = choice.priority;
      }
      candidates.push(choice);
    }

    // Second phase: we commit as many candidates as we can without
    // exceeding our maximum.
    // TODO: think about tag choices vs builtin choices
    var committedChoices = committed.length;
    var totalChoices = committedChoices + candidates.length;
    if (maxChoices === null || maxChoices >= totalChoices) {
      // We can use all the candidates without exceeding our maximum.
      committed.push.apply(committed, candidates);
    } else {
      // Take a subset of the candidates, using their relative frequency.
      each(candidates, function(choice) {
        if (choice.frequency === null) {
          choice.selectionPriority = 0; // Always choose.
        } else {
          choice.selectionPriority = that.random.random() / choice.frequency;
        }
      });
      candidates.sort(function(a, b) {
        return a.selectionPriority - b.selectionPriority;
      });
      var extraChoices = maxChoices - committedChoices;
      var chosen = candidates.slice(0, extraChoices);
      committed.push.apply(committed, chosen);
    }

    return committed;
  };

  DendryEngine.prototype.__getChoiceDisplayData = function(choicesSelected) {
    var choiceOutput = [];
    var numChoosable = 0;

    for (var i = 0; i < choicesSelected.length; ++i) {
      var choice = choicesSelected[i];
      var choiceScene = this.game.scenes[choice.id];

      // Figure out if this choice can be chosen.
      var canChoose = true;
      if (choice.chooseIf) {
        canChoose = this._runPredicate(choice.chooseIf, true);
      }
      if (canChoose && choiceScene.chooseIf) {
        canChoose = this._runPredicate(choiceScene.chooseIf, true);
      }

      var title = choice.title || choiceScene.title;
      assert(title);

      var subtitle = null;
      if (!canChoose) {
        subtitle = choice.unavailableSubtitle ||
                   choiceScene.unavailableSubtitle;
      }
      if (!subtitle) {
        subtitle = choice.subtitle || choiceScene.subtitle;
      }

      var finalChoice = {
        id:choice.id,
        canChoose:canChoose,
        title:this._makeDisplayContent(title, false)
      };
      if (subtitle) {
        finalChoice.subtitle = this._makeDisplayContent(subtitle, false);
      }

      choiceOutput.push(finalChoice);
      if (canChoose) {
        ++numChoosable;
      }
    }

    return {choices:choiceOutput, numChoosable:numChoosable};
  };

  DendryEngine.prototype._compileChoices = function(scene) {
    assert(scene);

    var options = scene.options;
    var choiceOutput = [];
    var numChoosable = 0;
    if (options !== undefined) {

      var choiceIds = this.__getChoiceIdsFromOptions(options);
      choiceIds = this.__filterViewable(choiceIds);

      var validChoiceData = this.__getChoiceSelectionData(choiceIds);
      var minChoices = scene.minChoices || null;
      var maxChoices = scene.maxChoices || null;
      validChoiceData = this.__filterByPriority(validChoiceData,
                                                minChoices, maxChoices);

      // Sort the result into display order.
      validChoiceData.sort(function(a, b) {
        return a.order - b.order;
      });

      // Now we've chosen our selection, get the final displayable data.
      var data = this.__getChoiceDisplayData(validChoiceData);
      choiceOutput = data.choices;
      numChoosable = data.numChoosable;
    }

    if (numChoosable === 0) {
      // We have no choosable options, so add the default option (NB:
      // this may take us over the max-choices limit).
      var root = this.state.rootSceneId;
      if (root !== this.state.sceneId) {
        var rootSceneChoose = this.game.scenes[root].chooseIf;
        if (!rootSceneChoose || this._runPredicate(rootSceneChoose, true)) {
          choiceOutput.push({id:root, title:'Continue...', canChoose:true});
          ++numChoosable;
        }
      }
    }
    if (numChoosable > 0) {
      return choiceOutput;
    } else {
      return null;
    }
  };

  // ------------------------------------------------------------------------

  // Marsaglia, George (July 2003). 'Xorshift RNGs'.
  // Journal of Statistical Software 8 (14).
  var Random = function(v, w, x, y, z) {
    this.getState = function() {
      return [v, w, x, y, z];
    };
    var uint32Multiply = function(a, b) {
      var aHigh = (a >> 16) & 0xffff;
      var aLow = a & 0xffff;
      var bHigh = (b >> 16) & 0xffff;
      var bLow = b & 0xffff;
      var prodHigh = ((aHigh * bLow) + (aLow * bHigh)) & 0xffff;
      return ((prodHigh << 16) >>> 0) + (aLow * bLow);
    };
    this.uint32 = function() {
      var t = (x ^ (x >>> 7)) >>> 0;
      x = y;
      y = z;
      z = w;
      w = v;
      v = (v ^ (v << 6)) ^ (t ^ (t << 13)) >>> 0;
      return uint32Multiply((y + y + 1), v) >>> 0;
    };
    this.random = function() {
      return this.uint32() * 2.3283064365386963e-10;
    };
  };

  var __next = 1;
  Random.fromUnique = function() {
    var seed = new Date().getTime();
    return Random.fromSeeds([seed, __next++]);
  };

  Random.fromTime = function() {
    return Random.fromSeeds([new Date().getTime()]);
  };

  Random.fromSeeds = function(seeds) {
    var v = 886756453;
    var w = 88675123;
    var x = 123456789;
    var y = 362436069;
    var z = 521288629;

    // The seed hashing function is based on Mash 0.9 (MIT License).
    // See CREDITS.
    var hashSeed = function(data) {
      data = data.toString();
      var n = 0xefc8249d;
      for (var i = 0; i < data.length; i++) {
        n += data.charCodeAt(i);
        var h = 0.02519603282416938 * n;
        n = h >>> 0;
        h -= n;
        h *= n;
        n = h >>> 0;
        h -= n;
        n += h * 0x100000000;
      }
      return (n >>> 0) * 2.3283064365386963e-10;
    };

    for (var i = 0; i < seeds.length; i++) {
      var hashedSeed = hashSeed(seeds[i]) * 0x100000000;
      v ^= hashedSeed;
      w ^= hashedSeed;
      x ^= hashedSeed;
      y ^= hashedSeed;
      z ^= hashedSeed;
    }
    return new Random(v, w, x, y, z);
  };

  Random.fromState = function(state) {
    return new Random(state[0], state[1], state[2], state[3], state[4]);
  };

  // ------------------------------------------------------------------------

  module.exports = {
    makeFunctionFromSource: makeFunctionFromSource,
    runActions: runActions,
    runPredicate: runPredicate,
    runExpression: runExpression,
    convertJSONToGame: convertJSONToGame,
    simpleContent: simpleContent,

    getCardinalNumber: getCardinalNumber,
    getOrdinalNumber: getOrdinalNumber,
    getUserQDisplay: getUserQDisplay,
    getFudgeDisplay: getFudgeDisplay,

    DendryEngine: DendryEngine,
    UserInterface: UserInterface,
    NullUserInterface: UserInterface,

    Random: Random
  };
}());

},{}],2:[function(require,module,exports){
/* dendry
 * http://github.com/idmillington/dendry
 *
 * MIT License
 */
/*jshint indent:2 */
(function($) {
  'use strict';

  var contentToHTML = require('./content/html');
  var engine = require('../engine');

  var BrowserUserInterface = function(game, $content) {
    this.game = game;
    this.$content = $content;
    this._registerEvents();

    this.dendryEngine = new engine.DendryEngine(this, game);
    // TODO: consider displaying a sidebar with various qualities...
    this.hasSidebar = false;
    this.sidebarQualities = [];
    this.disable_bg = false;
    this.animate = false;
    this.animate_bg = true;
    // backgrounds and portraits are 100% optional, and most games will not use them.
    this.show_portraits = false;
    this.fade_time = 600;
    this.bg_fade_out_time = 200;
    this.bg_fade_in_time = 1000;
    this.contentToHTML = contentToHTML;
  };
  engine.UserInterface.makeParentOf(BrowserUserInterface);

  // ------------------------------------------------------------------------
  // Main API

  BrowserUserInterface.prototype.displayContent = function(paragraphs) {
    var $html = $(contentToHTML.convert(paragraphs));
    if (this.animate) {
        $html.fadeIn(this.fade_time);
        this.$content.append($html);
    } else {
        this.$content.append($html);
    }
    $html.focus();
    // allow user to add custom stuff on display content (for sidebar in this case)
    if (window && window.onDisplayContent) {
        window.onDisplayContent();
    }
  };
  BrowserUserInterface.prototype.displayGameOver = function() {
    var $p = $('<p>').text(this.getGameOverMsg()).addClass('game-over');
    if (this.animate) {
        $p.fadeIn(this.fade_time);
        this.$content.append($p);
    } else {
        this.$content.append($p);
    }
    $p.focus();
  };
  BrowserUserInterface.prototype.displayChoices = function(choices) {
    var $ul = $('<ul>').addClass('choices');
    for (var i = 0; i < choices.length; ++i) {
      var choice = choices[i];

      var title = contentToHTML.convertLine(choice.title);
      var subtitle = "";
      if (choice.subtitle !== undefined) {
        subtitle = contentToHTML.convertLine(choice.subtitle);
      }

      var $li = $('<li>');
      var $titleHolder = $li;
      if (choice.canChoose) {
        $titleHolder = $('<a>').attr({href: '#', 'data-choice': i});
        $li.html($titleHolder);
      } else {
        $titleHolder.addClass('unavailable');
      }
      $titleHolder.html(title);
      if (subtitle) {
        $li.append($('<div>').addClass('subtitle').html(subtitle));
      }
      $ul.append($li);
    }
    if (this.animate) {
        $ul.fadeIn(this.fade_time);
        this.$content.append($ul);
    }
    else {
        this.$content.append($ul);
    }
    $ul.focus();
  };
  BrowserUserInterface.prototype.newPage = function() {
    if (this.animate) {
        var $content = this.$content;
        this.$content.empty();
        this.$content.children().fadeOut(this.fade_time, function() {
        });
    } else {
        this.$content.empty();
    }
  };
  BrowserUserInterface.prototype.setStyle = function(style) {
    this.$content.removeClass();
    if (style !== undefined) {
      this.$content.addClass(style);
    }
  };
  BrowserUserInterface.prototype.removeChoices = function() {
    $('.choices', this.$content).remove();
    $('.hidden', this.$content).remove();
  };
  BrowserUserInterface.prototype.beginOutput = function() {
    $("#read-marker", this.$content).remove();
    this.$content.append($('<hr>').attr('id', 'read-marker'));
  };
  BrowserUserInterface.prototype.endOutput = function() {
    var $marker = $("#read-marker");
    if (this.animate) {
        if ($marker.length > 0) {
          $('html, body').animate({scrollTop: $marker.offset().top}, this.fade_time);
        } else {
          $('html, body').animate({scrollTop: 0}, this.fade_time);
        }
    }
  };
  BrowserUserInterface.prototype.signal = function(data) {
    // TODO: implement signals - signals contain signal, event, and id
    console.log(data);
    var signal = data.signal;
    // TODO: handle this in the game.js for each specific game
    if (window && window.handleSignal) {
        window.handleSignal(signal);
    }
  };
  BrowserUserInterface.prototype.setBg = function(image_url) {
      if (!image_url || image_url == 'none' || image_url == 'null' || this.disable_bg) {
          if (this.animate_bg) {
            $('#bg1').addClass('content_hidden');
            $('#bg1').removeClass('content_visible');
            setTimeout(function() {
                $('#bg1').css('background-image', 'none'); 
                $('#bg1').removeClass('content_hidden');
                $('#bg1').addClass('content_visible');
            },
            100);
          } else {
              $('#bg1').css('backgroundImage', 'none'); 
          }
      } else if (image_url.startsWith('#') || image_url.startsWith('rgba(')) {
          if (this.animate_bg) {
            $('#bg1').addClass('content_hidden');
            $('#bg1').removeClass('content_visible');
            setTimeout(function() {
                $('#bg1').css('background-image', 'none'); 
                $('#bg1').css('bacground-color', image_url);
                $('#bg1').removeClass('content_hidden');
                $('#bg1').addClass('content_visible');
            },
            100);
          } else {
              $('#bg1').css('background-image', 'none'); 
              $('#bg1').css('bacground-color', image_url);
          }
      } else {
          // lmao this is terribly slow
          if (this.animate_bg) {
            $('#bg1').fadeOut(this.bg_fade_out_time, function() {
                $('#bg1').css('background-image', 'url("' + image_url + '")'); 
            });
            $('#bg1').fadeIn(this.bg_fade_in_time, function() {
                $('#bg2').css('background-image', $('#bg1').css('background-image'));
            });
      } else {
          $('#bg1').css('background-image', 'url("' + image_url + '")'); 
      }
    }
  };

  BrowserUserInterface.prototype.saveSettings = function() {
    if (typeof localStorage !== 'undefined') {
        localStorage[this.game.title + '_animate'] = this.animate;
        localStorage[this.game.title + '_disable_bg'] = this.disable_bg;
        localStorage[this.game.title + '_animate_bg'] = this.animate_bg;
        localStorage[this.game.title + '_show_portraits'] = this.show_portraits;
    }
  };

  BrowserUserInterface.prototype.loadSettings = function() {
    if (typeof localStorage !== 'undefined') {
        if (localStorage[this.game.title + '_animate']) {
            this.animate = localStorage[this.game.title + '_animate'] != 'false' || false;
        } else {
            this.animate = false;
        }
        if (localStorage[this.game.title + '_disable_bg']) {
            this.disable_bg = localStorage[this.game.title + '_disable_bg'] != 'false' || false ;
        } else {
            this.disable_bg = false;
        }
        if (localStorage[this.game.title + '_animate_bg']) {
            this.animate_bg = localStorage[this.game.title + '_animate_bg'] != 'false' || false;
        } else {
            this.animate_bg = true;
        }
        if (localStorage[this.game.title + '_show_portraits']) {
            this.show_portraits = localStorage[this.game.title + '_show_portraits'] != 'false' || false;
        } else {
            this.show_portraits = false;
        }
    }
  };

  // ------------------------------------------------------------------------
  // Additional methods

  BrowserUserInterface.prototype.getGameOverMsg = function() {
    return 'Game Over (reload to read again)';
  };

  BrowserUserInterface.prototype._registerEvents = function() {
    var that = this;
    this.$content.on('click', 'ul.choices li a', function(event) {
      event.preventDefault();
      event.stopPropagation();
      var choice = parseInt($(this).attr('data-choice'));
      that.dendryEngine.choose(choice);
      return false;
    });
    this.$content.on('click', 'ul.choices li', function(event) {
      event.preventDefault();
      event.stopPropagation();
      $('a', this).click();
      return false;
    });
  };

  // ------------------------------------------------------------------------
  // Run when loaded.

  var main = function() {
    engine.convertJSONToGame(window.game.compiled, function(err, game) {
      if (err) {
        throw err;
      }

      var ui = new BrowserUserInterface(game, $('#content'));
      window.dendryUI = ui;
      // Allow the ui system to be customized before use.
      if (window.dendryModifyUI !== undefined) {
        // If it returns true, then we don't need to begin the game.
        var dontStart = window.dendryModifyUI(ui);
        if (dontStart) {
          return;
        }
      }
      ui.dendryEngine.beginGame();
    });
  };
  $(main);

}(jQuery));

},{"../engine":1,"./content/html":3}],3:[function(require,module,exports){
/* dendry
 * http://github.com/idmillington/dendry
 *
 * MIT License
 */
/*jshint indent:2 */
(function() {
  'use strict';

  var _contentObjectToHTML = function(contentObj) {
    if (contentObj.type === undefined) {
      // if the game defines the function window.displayText, then that function is called to format the text.
      // this is used for game-specific formatting.
      if (window && window.displayText) {
          contentObj = window.displayText(contentObj);
      }
      return contentObj;
    } else {
      switch (contentObj.type) {
      case 'emphasis-1':
        return '<em>' + _contentToHTML(contentObj.content) + '</em>';
      case 'emphasis-2':
        return '<strong>' + _contentToHTML(contentObj.content) + '</strong>';
      case 'emphasis-3':
        return '<code>' + _contentToHTML(contentObj.content) + '</code>';
      case 'hidden':
        return '<span class="hidden">' + _contentToHTML(contentObj.content) +
          '</span>';
      case 'line-break':
        return '<br>';

      // We can't handle elements that require state-dependency.
      case 'insert':
        /* falls through */
      // raw html for magic
      case 'magic':
        return contentObj.content;
      case 'conditional':
        throw new Error(
          contentObj.type + ' should have been evaluated by now.'
          );
      }
    }
  };

  var _contentToHTML = function(content) {
    if (Array.isArray(content)) {
      var result = [];
      for (var i = 0; i < content.length; ++i) {
        var contentObj = content[i];
        result.push(_contentObjectToHTML(contentObj));
      }
      return result.join('');
    } else {
      return _contentObjectToHTML(content);
    }
  };

  var _paragraphsToHTML = function(paragraphs) {
    var result = [];
    for (var i = 0; i < paragraphs.length; ++i) {
      var paragraph = paragraphs[i];
      switch (paragraph.type) {
      case 'heading':
        result.push('<h1>');
        result.push(_contentToHTML(paragraph.content));
        result.push('</h1>');
        break;
      case 'paragraph':
        result.push('<p>');
        result.push(_contentToHTML(paragraph.content));
        result.push('</p>');
        break;
      case 'quotation':
        result.push('<blockquote>');
        result.push(_contentToHTML(paragraph.content));
        result.push('</blockquote>');
        break;
      case 'attribution':
        result.push('<blockquote class="attribution">');
        result.push(_contentToHTML(paragraph.content));
        result.push('</blockquote>');
        break;
      case 'magic':
        result.push(paragraph.content);
        break;
      case 'hrule':
        result.push('<hr>');
        break;
      }
    }
    return result.join('');
  };

  module.exports = {
    convert: _paragraphsToHTML,
    convertLine: _contentToHTML
  };
}());

},{}]},{},[2]);
